/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.internal;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.core.Tcf;

public class Startup {
    static final AtomicBoolean STARTED = new AtomicBoolean(false);

    static {
        if (Protocol.getEventQueue() != null) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    Startup.setStarted(true);
                }
            });
        }
    }

    public static final void setStarted(boolean started) {
        block3: {
            STARTED.set(started);
            if (Protocol.getEventQueue() != null) {
                try {
                    Protocol.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (STARTED.get()) {
                                Tcf.start();
                            } else {
                                Tcf.stop();
                            }
                        }
                    });
                }
                catch (IllegalStateException e) {
                    if (!STARTED.get() && "TCF event dispatcher has shut down".equals(e.getLocalizedMessage())) break block3;
                    throw e;
                }
            }
        }
    }

    public static final boolean isStarted() {
        return STARTED.get();
    }
}

