/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.va.internal;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.va.internal.Binding;
import org.osgi.framework.Bundle;

public class BindingExtensionPointManager
extends AbstractExtensionPointManager<Binding> {
    BindingExtensionPointManager() {
    }

    public static BindingExtensionPointManager getInstance() {
        return LazyInstance.instance;
    }

    protected String getExtensionPointId() {
        return "org.eclipse.tcf.te.tcf.core.valueaddBindings";
    }

    protected String getConfigurationElementName() {
        return "binding";
    }

    protected ExecutableExtensionProxy<Binding> doCreateExtensionProxy(IConfigurationElement element) throws CoreException {
        return new ExecutableExtensionProxy<Binding>(element){

            public Binding newInstance() {
                Binding instance = new Binding();
                try {
                    instance.setInitializationData(this.getConfigurationElement(), null, null);
                }
                catch (CoreException e) {
                    Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                    Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                }
                return instance;
            }
        };
    }

    public Binding[] getApplicableBindings(IPeer peer) {
        Assert.isNotNull((Object)peer);
        ArrayList<Binding> applicable = new ArrayList<Binding>();
        Binding[] bindingArray = this.getBindings();
        int n = bindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Binding binding = bindingArray[n2];
            Expression enablement = binding.getEnablement();
            boolean isApplicable = false;
            if (enablement != null) {
                if (peer != null) {
                    EvaluationContext evalContext = new EvaluationContext(null, (Object)peer);
                    evalContext.addVariable("peer", (Object)peer);
                    evalContext.setAllowPluginActivation(true);
                    try {
                        isApplicable = enablement.evaluate((IEvaluationContext)evalContext).equals(EvaluationResult.TRUE);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                        Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)status);
                    }
                } else {
                    isApplicable = false;
                }
            }
            if (isApplicable) {
                applicable.add(binding);
            }
            ++n2;
        }
        return applicable.toArray(new Binding[applicable.size()]);
    }

    public Binding[] getBindings() {
        ArrayList<Binding> contributions = new ArrayList<Binding>();
        Collection bindings = this.getExtensions().values();
        for (ExecutableExtensionProxy binding : bindings) {
            Binding instance = (Binding)((Object)binding.getInstance());
            if (instance == null || contributions.contains((Object)instance)) continue;
            contributions.add(instance);
        }
        return contributions.toArray(new Binding[contributions.size()]);
    }

    public Binding getBinding(String id) {
        Binding contribution = null;
        if (this.getExtensions().containsKey(id)) {
            ExecutableExtensionProxy proxy = (ExecutableExtensionProxy)this.getExtensions().get(id);
            contribution = (Binding)((Object)proxy.getInstance());
        }
        return contribution;
    }

    private static class LazyInstance {
        public static BindingExtensionPointManager instance = new BindingExtensionPointManager();

        private LazyInstance() {
        }
    }
}

