/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFFileSystemException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.Operation;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class OpCommitAttr
extends Operation {
    FSTreeNode node;
    IFileSystem.FileAttrs attrs;

    public OpCommitAttr(FSTreeNode node, IFileSystem.FileAttrs attrs) {
        this.node = node;
        this.attrs = attrs;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block8: {
            IChannel channel = null;
            try {
                try {
                    channel = OpCommitAttr.openChannel(this.node.peerNode.getPeer());
                    if (channel == null) break block8;
                    IFileSystem service = Operation.getBlockingFileSystem(channel);
                    if (service != null) {
                        final TCFFileSystemException[] errors = new TCFFileSystemException[1];
                        String path = this.node.getLocation(true);
                        service.setstat(path, this.attrs, new IFileSystem.DoneSetStat(){

                            public void doneSetStat(IToken token, IFileSystem.FileSystemException error) {
                                if (error == null) {
                                    OpCommitAttr.this.node.setAttributes(OpCommitAttr.this.attrs);
                                } else {
                                    errors[0] = OpCommitAttr.this.newTCFException(error);
                                }
                            }
                        });
                        if (errors[0] != null) {
                            throw errors[0];
                        }
                        break block8;
                    }
                    String message = NLS.bind((String)Messages.Operation_NoFileSystemError, (Object)this.node.peerNode.getPeerId());
                    throw new TCFFileSystemException(message);
                }
                catch (TCFException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                if (channel != null) {
                    Tcf.getChannelManager().closeChannel(channel);
                }
            }
        }
    }
}

