/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.core.utils.Ancestor;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.concurrent.BlockingCallProxy;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IConfirmCallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFChannelException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFFileSystemException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.PersistenceManager;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class Operation
extends Ancestor<FSTreeNode>
implements IOperation {
    protected boolean yes2All = false;
    protected IProgressMonitor monitor = new NullProgressMonitor();

    protected TCFFileSystemException newTCFException(IFileSystem.FileSystemException error) {
        String message = null;
        if (error instanceof IErrorReport) {
            IErrorReport report = (IErrorReport)error;
            message = (String)report.getAttributes().get("Format");
        }
        return new TCFFileSystemException(message, (Throwable)error);
    }

    protected void cleanUpFolder(FSTreeNode node) {
        File file = CacheManager.getCacheFile(node);
        this.deleteFileChecked(file);
        FSTreeNode parent = node.getParent();
        if (parent != null) {
            parent.removeChild(node);
        }
    }

    protected void deleteFileChecked(final File file) {
        if (file.exists()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    if (!file.delete()) {
                        throw new Exception(NLS.bind((String)Messages.Operation_DeletingFileFailed, (Object)file.getAbsolutePath()));
                    }
                }

                public void handleException(Throwable exception) {
                }
            });
        }
    }

    protected void cleanUpFile(FSTreeNode node) {
        File file = CacheManager.getCacheFile(node);
        this.deleteFileChecked(file);
        PersistenceManager.getInstance().removeFileDigest(node.getLocationURI());
        FSTreeNode parent = node.getParent();
        if (parent != null) {
            parent.removeChild(node);
        }
    }

    public static IChannel openChannel(final IPeer peer) throws TCFChannelException {
        IChannelManager channelManager = Tcf.getChannelManager();
        channelManager = (IChannelManager)BlockingCallProxy.newInstance(IChannelManager.class, (Object)channelManager);
        final TCFChannelException[] errors = new TCFChannelException[1];
        final IChannel[] channels = new IChannel[1];
        channelManager.openChannel(peer, null, new IChannelManager.DoneOpenChannel(){

            public void doneOpenChannel(Throwable error, IChannel channel) {
                if (error != null) {
                    if (error instanceof ConnectException) {
                        String message = NLS.bind((String)Messages.Operation_NotResponding, (Object)peer.getID());
                        errors[0] = new TCFChannelException(message);
                    } else {
                        String message = NLS.bind((String)Messages.Operation_OpeningChannelFailureMessage, (Object)peer.getID(), (Object)error.getMessage());
                        errors[0] = new TCFChannelException(message, error);
                    }
                } else {
                    channels[0] = channel;
                }
            }
        });
        if (errors[0] != null) {
            throw errors[0];
        }
        return channels[0];
    }

    public static IFileSystem getBlockingFileSystem(final IChannel channel) {
        if (Protocol.isDispatchThread()) {
            IFileSystem service = (IFileSystem)channel.getRemoteService(IFileSystem.class);
            return (IFileSystem)BlockingCallProxy.newInstance(IFileSystem.class, (Object)service);
        }
        final IFileSystem[] service = new IFileSystem[1];
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                service[0] = Operation.getBlockingFileSystem(channel);
            }
        });
        return service[0];
    }

    protected int count(IFileSystem service, List<FSTreeNode> nodes) throws TCFFileSystemException, InterruptedException {
        int count = 0;
        for (FSTreeNode node : nodes) {
            if (node.isFile()) {
                ++count;
                continue;
            }
            if (!node.isDirectory()) continue;
            List<FSTreeNode> children = this.getChildren(node, service);
            count += this.count(service, children) + 1;
        }
        return count;
    }

    protected List<FSTreeNode> getChildren(FSTreeNode node, IFileSystem service) throws TCFFileSystemException, InterruptedException {
        if (node.childrenQueried) {
            return node.getChildren();
        }
        this.loadChildren(node, service);
        return this.getChildren(node, service);
    }

    public List<FSTreeNode> getChildren(FSTreeNode node) throws TCFException, InterruptedException {
        if (node.childrenQueried) {
            return node.getChildren();
        }
        IChannel channel = null;
        try {
            channel = Operation.openChannel(node.peerNode.getPeer());
            IFileSystem service = Operation.getBlockingFileSystem(channel);
            if (service != null) {
                List<FSTreeNode> list = this.getChildren(node, service);
                return list;
            }
            String message = NLS.bind((String)Messages.Operation_NoFileSystemError, (Object)node.peerNode.getPeerId());
            throw new TCFFileSystemException(message);
        }
        finally {
            if (channel != null) {
                Tcf.getChannelManager().closeChannel(channel);
            }
        }
    }

    protected void loadChildren(FSTreeNode node, IFileSystem service) throws TCFFileSystemException, InterruptedException {
        List<FSTreeNode> children = this.queryChildren(node, service);
        node.addChidren(children);
        node.queryDone();
    }

    protected List<FSTreeNode> queryChildren(final FSTreeNode node, IFileSystem service) throws TCFFileSystemException, InterruptedException {
        ArrayList<FSTreeNode> arrayList;
        if (this.monitor.isCanceled()) {
            throw new InterruptedException();
        }
        final TCFFileSystemException[] errors = new TCFFileSystemException[1];
        final IFileSystem.IFileHandle[] handles = new IFileSystem.IFileHandle[1];
        try {
            String dir = node.getLocation();
            service.opendir(dir, new IFileSystem.DoneOpen(){

                public void doneOpen(IToken token, IFileSystem.FileSystemException error, IFileSystem.IFileHandle handle) {
                    if (error != null) {
                        String message = NLS.bind((String)Messages.Operation_CannotOpenDir, (Object)node.name, (Object)error);
                        errors[0] = new TCFFileSystemException(message, (Throwable)error);
                    } else {
                        handles[0] = handle;
                    }
                }
            });
            if (errors[0] != null) {
                throw errors[0];
            }
            errors[0] = null;
            final ArrayList<FSTreeNode> children = new ArrayList<FSTreeNode>();
            final boolean[] eofs = new boolean[1];
            while (!eofs[0]) {
                service.readdir(handles[0], new IFileSystem.DoneReadDir(){

                    public void doneReadDir(IToken token, IFileSystem.FileSystemException error, IFileSystem.DirEntry[] entries, boolean eof) {
                        if (eof) {
                            eofs[0] = true;
                        }
                        if (error == null) {
                            if (entries != null && entries.length > 0) {
                                IFileSystem.DirEntry[] dirEntryArray = entries;
                                int n = entries.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IFileSystem.DirEntry entry = dirEntryArray[n2];
                                    FSTreeNode childNode = new FSTreeNode(node, entry, false);
                                    children.add(childNode);
                                    ++n2;
                                }
                            }
                        } else {
                            errors[0] = Operation.this.newTCFException(error);
                        }
                    }
                });
                if (errors[0] == null) continue;
                throw errors[0];
            }
            arrayList = children;
        }
        catch (Throwable throwable) {
            if (handles[0] != null) {
                service.close(handles[0], new IFileSystem.DoneClose(){

                    public void doneClose(IToken token, IFileSystem.FileSystemException error) {
                    }
                });
            }
            throw throwable;
        }
        if (handles[0] != null) {
            service.close(handles[0], new /* invalid duplicate definition of identical inner class */);
        }
        return arrayList;
    }

    protected void removeChild(final IFileSystem service, final FSTreeNode folder, final FSTreeNode child) throws TCFFileSystemException, InterruptedException {
        if (Protocol.isDispatchThread()) {
            if (!folder.childrenQueried) {
                this.loadChildren(folder, service);
            }
            folder.removeChild(child);
            child.setParent(null);
        } else {
            final TCFFileSystemException[] errors = new TCFFileSystemException[1];
            final InterruptedException[] iexs = new InterruptedException[1];
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Operation.this.removeChild(service, folder, child);
                    }
                    catch (TCFFileSystemException e) {
                        errors[0] = e;
                    }
                    catch (InterruptedException e) {
                        iexs[0] = e;
                    }
                }
            });
            if (errors[0] != null) {
                throw errors[0];
            }
            if (iexs[0] != null) {
                throw iexs[0];
            }
        }
    }

    protected FSTreeNode findChild(IFileSystem service, FSTreeNode folder, String name) throws TCFFileSystemException, InterruptedException {
        List<FSTreeNode> children = this.getChildren(folder, service);
        for (FSTreeNode child : children) {
            if (!child.name.equals(name)) continue;
            return child;
        }
        return null;
    }

    protected FSTreeNode createCopyDestination(IFileSystem service, FSTreeNode node, FSTreeNode dest) throws TCFFileSystemException, InterruptedException {
        FSTreeNode copy = (FSTreeNode)node.clone();
        String name = node.name;
        FSTreeNode possibleChild = this.findChild(service, dest, name);
        int n = 0;
        while (possibleChild != null) {
            name = n > 0 ? NLS.bind((String)Messages.Operation_CopyNOfFile, (Object)n, (Object)node.name) : NLS.bind((String)Messages.Operation_CopyOfFile, (Object)node.name);
            possibleChild = this.findChild(service, dest, name);
            ++n;
        }
        copy.name = name;
        this.addChild(service, dest, copy);
        return copy;
    }

    protected void mkdir(IFileSystem service, final FSTreeNode node) throws TCFFileSystemException {
        final TCFFileSystemException[] errors = new TCFFileSystemException[1];
        String path = node.getLocation(true);
        service.mkdir(path, node.attr, new IFileSystem.DoneMkDir(){

            public void doneMkDir(IToken token, IFileSystem.FileSystemException error) {
                if (error != null) {
                    String message = NLS.bind((String)Messages.Operation_CannotCreateDirectory, (Object[])new Object[]{node.name, error});
                    errors[0] = new TCFFileSystemException(message, (Throwable)error);
                }
            }
        });
        if (errors[0] != null) {
            throw errors[0];
        }
    }

    protected boolean confirmReplace(FSTreeNode node, IConfirmCallback confirmCallback) throws InterruptedException {
        if (confirmCallback == null) {
            return true;
        }
        if (this.yes2All) {
            return true;
        }
        int result = confirmCallback.confirms(node);
        switch (result) {
            case 0: {
                return true;
            }
            case 1: {
                this.yes2All = true;
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new InterruptedException();
    }

    protected void addChild(final IFileSystem service, final FSTreeNode folder, final FSTreeNode child) throws TCFFileSystemException, InterruptedException {
        if (Protocol.isDispatchThread()) {
            if (!folder.childrenQueried) {
                this.loadChildren(folder, service);
            }
            child.setParent(folder);
            folder.addChild(child);
        } else {
            final TCFFileSystemException[] errors = new TCFFileSystemException[1];
            final InterruptedException[] iexs = new InterruptedException[1];
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        Operation.this.addChild(service, folder, child);
                    }
                    catch (TCFFileSystemException e) {
                        errors[0] = e;
                    }
                    catch (InterruptedException e) {
                        iexs[0] = e;
                    }
                }
            });
            if (errors[0] != null) {
                throw errors[0];
            }
            if (iexs[0] != null) {
                throw iexs[0];
            }
        }
    }

    protected void removeFile(final FSTreeNode node, IFileSystem service) throws TCFFileSystemException, InterruptedException {
        if (this.monitor.isCanceled()) {
            throw new InterruptedException();
        }
        String path = node.getLocation(true);
        final TCFFileSystemException[] errors = new TCFFileSystemException[1];
        service.remove(path, new IFileSystem.DoneRemove(){

            public void doneRemove(IToken token, IFileSystem.FileSystemException error) {
                if (error == null) {
                    Operation.this.cleanUpFile(node);
                } else {
                    errors[0] = Operation.this.newTCFException(error);
                }
            }
        });
        if (errors[0] != null) {
            throw errors[0];
        }
    }

    protected void removeFolder(final FSTreeNode node, IFileSystem service) throws TCFFileSystemException, InterruptedException {
        if (this.monitor.isCanceled()) {
            throw new InterruptedException();
        }
        String path = node.getLocation(true);
        final TCFFileSystemException[] errors = new TCFFileSystemException[1];
        service.rmdir(path, new IFileSystem.DoneRemove(){

            public void doneRemove(IToken token, IFileSystem.FileSystemException error) {
                if (error == null) {
                    Operation.this.cleanUpFolder(node);
                } else {
                    errors[0] = Operation.this.newTCFException(error);
                }
            }
        });
        if (errors[0] != null) {
            throw errors[0];
        }
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.monitor = monitor;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public int getTotalWork() {
        return -1;
    }

    protected FSTreeNode getParent(FSTreeNode element) {
        return element.getParent();
    }
}

