/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.utils;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.CacheManager;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.FileState;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;

public class PersistenceManager {
    private static volatile PersistenceManager instance;
    Map<URI, FileState> digests;
    Map<URI, IContentType> resolved;
    Map<URI, URI> unresolved;
    Map<URI, Map<QualifiedName, String>> properties;
    private static final String PERSISTENT_FILE = "persistent.ini";

    public static PersistenceManager getInstance() {
        if (instance == null) {
            instance = new PersistenceManager();
        }
        return instance;
    }

    private PersistenceManager() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                IURIPersistenceService service = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                File location = CacheManager.getCacheRoot();
                File resolvedFile = new File(location, "resolved.ini");
                PersistenceManager.this.resolved = new HashMap<URI, IContentType>();
                if (resolvedFile.exists()) {
                    PersistenceManager.this.resolved = (Map)service.read(PersistenceManager.this.resolved, resolvedFile.getAbsoluteFile().toURI());
                }
                File unresolvedFile = new File(location, "unresolved.ini");
                PersistenceManager.this.unresolved = new HashMap<URI, URI>();
                if (unresolvedFile.exists()) {
                    PersistenceManager.this.unresolved = (Map)service.read(PersistenceManager.this.unresolved, unresolvedFile.getAbsoluteFile().toURI());
                }
                File digestFile = new File(location, "digests.ini");
                PersistenceManager.this.digests = new HashMap<URI, FileState>();
                if (digestFile.exists()) {
                    PersistenceManager.this.digests = (Map)service.read(PersistenceManager.this.digests, digestFile.getAbsoluteFile().toURI());
                }
                File persistentFile = new File(location, PersistenceManager.PERSISTENT_FILE);
                PersistenceManager.this.properties = new HashMap<URI, Map<QualifiedName, String>>();
                if (persistentFile.exists()) {
                    PersistenceManager.this.properties = (Map)service.read(PersistenceManager.this.properties, persistentFile.getAbsoluteFile().toURI());
                }
            }
        });
    }

    public boolean isUnresovled(FSTreeNode node) {
        return this.unresolved.get(node.getLocationURI()) != null;
    }

    public IContentType getResolved(FSTreeNode node) {
        return this.resolved.get(node.getLocationURI());
    }

    public void addResovled(FSTreeNode node, IContentType contentType) {
        this.resolved.put(node.getLocationURI(), contentType);
    }

    public void addUnresolved(FSTreeNode node) {
        this.unresolved.put(node.getLocationURI(), node.getLocationURI());
    }

    public void setFileDigest(URI uri, FileState digest) {
        this.digests.put(uri, digest);
    }

    public void removeFileDigest(URI uri) {
        this.digests.remove(uri);
    }

    public FileState getFileDigest(FSTreeNode node) {
        URI uri = node.getLocationURI();
        FileState digest = this.digests.get(uri);
        if (digest == null) {
            digest = new FileState(node);
            this.digests.put(uri, digest);
        }
        digest.setNode(node);
        return digest;
    }

    public Map<QualifiedName, String> getPersistentProperties(FSTreeNode node) {
        Map<Object, String> nodeProperties = this.properties.get(node.getLocationURI());
        if (nodeProperties == null) {
            nodeProperties = Collections.synchronizedMap(new HashMap());
            this.properties.put(node.getLocationURI(), nodeProperties);
        }
        return nodeProperties;
    }

    public void dispose() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                IURIPersistenceService service = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                File location = CacheManager.getCacheRoot();
                File resolvedFile = new File(location, "resolved.ini");
                service.write(PersistenceManager.this.resolved, resolvedFile.getAbsoluteFile().toURI());
                File unresolvedFile = new File(location, "unresolved.ini");
                service.write(PersistenceManager.this.unresolved, unresolvedFile.getAbsoluteFile().toURI());
                File digestFile = new File(location, "digests.ini");
                service.write(PersistenceManager.this.digests, digestFile.getAbsoluteFile().toURI());
                File persistentFile = new File(location, PersistenceManager.PERSISTENT_FILE);
                service.write(PersistenceManager.this.properties, persistentFile.getAbsoluteFile().toURI());
            }
        });
    }

    public static final boolean needsDisposal() {
        return instance != null;
    }
}

