/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.model;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.model.ITreeNodeModel;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;

public final class FSModel
implements ITreeNodeModel {
    static final String FSMODEL_KEY = String.valueOf(CorePlugin.getUniqueIdentifier()) + ".file.system";
    private FSTreeNode root;
    private IPeerModel peerNode;

    public static FSModel getFSModel(final IPeerModel peerModel) {
        if (peerModel != null) {
            if (Protocol.isDispatchThread()) {
                FSModel model = (FSModel)peerModel.getProperty(FSMODEL_KEY);
                if (model == null) {
                    model = new FSModel(peerModel);
                    peerModel.setProperty(FSMODEL_KEY, (Object)model);
                }
                return model;
            }
            final FSModel[] result = new FSModel[1];
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    result[0] = FSModel.getFSModel(peerModel);
                }
            });
            return result[0];
        }
        return null;
    }

    private FSModel(IPeerModel peerNode) {
        this.peerNode = peerNode;
    }

    @Override
    public FSTreeNode getRoot() {
        if (this.root == null) {
            this.root = this.createRoot();
        }
        return this.root;
    }

    FSTreeNode createRoot() {
        if (Protocol.isDispatchThread()) {
            return FSModel.createRootNode(this.peerNode);
        }
        final AtomicReference ref = new AtomicReference();
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                ref.set(FSModel.this.createRoot());
            }
        });
        return (FSTreeNode)ref.get();
    }

    public static FSTreeNode createRootNode(IPeerModel peerNode) {
        FSTreeNode node = new FSTreeNode();
        node.type = "FSRootNode";
        node.peerNode = peerNode;
        node.name = Messages.FSTreeNodeContentProvider_rootNode_label;
        return node;
    }

    public static FSTreeNode createFileNode(String name, FSTreeNode folder) {
        return FSModel.createTreeNode(name, "FSFileNode", folder);
    }

    public static FSTreeNode createFolderNode(String name, FSTreeNode folder) {
        return FSModel.createTreeNode(name, "FSDirNode", folder);
    }

    private static FSTreeNode createTreeNode(String name, String type, FSTreeNode folder) {
        FSTreeNode node = new FSTreeNode();
        node.name = name;
        node.parent = folder;
        node.peerNode = folder.peerNode;
        node.type = type;
        return node;
    }
}

