/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.autosave;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.NullOpExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpParsePath;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpUpload;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations.UiExecutor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class SaveAllListener
implements IExecutionListener {
    List<FSTreeNode> fDirtyNodes = new ArrayList<FSTreeNode>();

    public void postExecuteSuccess(String commandId, Object returnValue) {
        if (!this.fDirtyNodes.isEmpty()) {
            if (UIPlugin.isAutoSaving()) {
                FSTreeNode[] nodes = this.fDirtyNodes.toArray(new FSTreeNode[this.fDirtyNodes.size()]);
                UiExecutor executor = new UiExecutor();
                executor.execute((IOperation)new OpUpload(nodes));
            } else {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void handleException(Throwable e) {
                    }

                    public void run() throws Exception {
                        for (FSTreeNode dirtyNode : SaveAllListener.this.fDirtyNodes) {
                            dirtyNode.refresh();
                        }
                    }
                });
            }
        }
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        IEditorPart[] editors;
        this.fDirtyNodes.clear();
        IWorkbenchPage page = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage();
        IEditorPart[] iEditorPartArray = editors = page.getDirtyEditors();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart editor = iEditorPartArray[n2];
            IEditorInput input = editor.getEditorInput();
            FSTreeNode node = null;
            if (input instanceof IURIEditorInput) {
                IURIEditorInput fileInput = (IURIEditorInput)input;
                URI uri = fileInput.getURI();
                try {
                    IFileStore store = EFS.getStore((URI)uri);
                    File localFile = store.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor());
                    if (localFile != null) {
                        OpParsePath parser = new OpParsePath(localFile.getCanonicalPath());
                        new NullOpExecutor().execute((IOperation)parser);
                        node = parser.getResult();
                        if (node != null) {
                            this.fDirtyNodes.add(node);
                        }
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    public void notHandled(String commandId, NotHandledException exception) {
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
    }
}

