/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.internal.adapters;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.launch.core.internal.adapters.StepContextAdapter;

public class AdapterFactory
implements IAdapterFactory {
    Map<ILaunch, IStepContext> adapters = new HashMap<ILaunch, IStepContext>();
    private static final Class<?>[] CLASSES = new Class[]{IStepContext.class};

    public AdapterFactory() {
        final ILaunchListener listener = new ILaunchListener(){

            public void launchRemoved(ILaunch launch) {
                IStepContext adapter = AdapterFactory.this.adapters.remove(launch);
                if (adapter instanceof IDisposable) {
                    ((IDisposable)adapter).dispose();
                }
            }

            public void launchChanged(ILaunch launch) {
                IStepContext adapter = AdapterFactory.this.adapters.remove(launch);
                if (adapter instanceof IDisposable) {
                    ((IDisposable)adapter).dispose();
                }
            }

            public void launchAdded(ILaunch launch) {
            }
        };
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DebugPlugin.getDefault().getLaunchManager().addLaunchListener(listener);
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof ILaunch && IStepContext.class.equals((Object)adapterType)) {
            IStepContext adapter = this.adapters.get(adaptableObject);
            if (adapter == null) {
                adapter = new StepContextAdapter((ILaunch)adaptableObject);
                this.adapters.put((ILaunch)adaptableObject, adapter);
            }
            return adapter;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return CLASSES;
    }
}

