/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.callbacks;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.RefreshDoneGetChildren;
import org.eclipse.tcf.te.tcf.processes.core.model.ProcessTreeNode;

public class RefreshDoneMonitorCallback
extends Callback {
    List<ProcessTreeNode> newNodes;
    ProcessTreeNode parentNode;
    Queue<ProcessTreeNode> queue;
    ICallback callback;
    ISysMonitor service;
    IChannel channel;

    public RefreshDoneMonitorCallback(List<ProcessTreeNode> newNodes, ProcessTreeNode parentNode, Queue<ProcessTreeNode> queue, ICallback callback, ISysMonitor service, IChannel channel) {
        this.newNodes = newNodes;
        this.parentNode = parentNode;
        this.queue = queue;
        this.callback = callback;
        this.service = service;
        this.channel = channel;
    }

    protected void internalDone(Object caller, IStatus status) {
        this.parentNode.queryDone();
        this.removeDead();
        for (ProcessTreeNode node : this.parentNode.getChildren()) {
            if (!node.childrenQueried || node.childrenQueryRunning) continue;
            this.queue.offer(node);
        }
        if (this.queue.isEmpty()) {
            if (this.callback != null) {
                this.callback.done(caller, status);
            }
        } else {
            ProcessTreeNode node;
            node = this.queue.poll();
            this.service.getChildren(node.id, (ISysMonitor.DoneGetChildren)new RefreshDoneGetChildren(this.callback, this.queue, this.channel, this.service, node));
        }
    }

    private void removeDead() {
        ArrayList<ProcessTreeNode> dead = new ArrayList<ProcessTreeNode>();
        for (ProcessTreeNode node : this.parentNode.getChildren()) {
            int index = this.searchInList(node, this.newNodes);
            if (index != -1) continue;
            dead.add(node);
        }
        for (ProcessTreeNode node : dead) {
            this.parentNode.removeChild(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int searchInList(ProcessTreeNode childNode, List<ProcessTreeNode> list) {
        List<ProcessTreeNode> list2 = list;
        synchronized (list2) {
            int i = 0;
            while (i < list.size()) {
                ProcessTreeNode node = list.get(i);
                if (childNode.id.equals(node.id)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
    }
}

