/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.editor.sections;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.editor.controls.InfoSectionPeerIdControl;
import org.eclipse.tcf.te.tcf.ui.editor.controls.InfoSectionPeerNameControl;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class GeneralInformationSection
extends AbstractSection {
    private InfoSectionPeerIdControl idControl = null;
    private InfoSectionPeerNameControl nameControl = null;
    private Text linkState = null;
    private Label linkStateImage = null;
    IPeerModel od;
    final IPropertiesContainer odc = new PropertiesContainer();
    final IPropertiesContainer wc = new PropertiesContainer();

    public GeneralInformationSection(IManagedForm form, Composite parent) {
        super(form, parent, 128);
        this.createClient(this.getSection(), form.getToolkit());
    }

    public void dispose() {
        if (this.idControl != null) {
            this.idControl.dispose();
            this.idControl = null;
        }
        if (this.nameControl != null) {
            this.nameControl.dispose();
            this.nameControl = null;
        }
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (InfoSectionPeerIdControl.class.equals((Object)adapter)) {
            return this.idControl;
        }
        if (InfoSectionPeerNameControl.class.equals((Object)adapter)) {
            return this.nameControl;
        }
        return super.getAdapter(adapter);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.GeneralInformationSection_title);
        section.setDescription(Messages.GeneralInformationSection_description);
        section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite client = this.createClientContainer((Composite)section, 2, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        this.nameControl = new InfoSectionPeerNameControl(this);
        this.nameControl.setFormToolkit(toolkit);
        this.nameControl.setParentControlIsInnerPanel(true);
        this.nameControl.setupPanel(client);
        this.idControl = new InfoSectionPeerIdControl(this);
        this.idControl.setFormToolkit(toolkit);
        this.idControl.setParentControlIsInnerPanel(true);
        this.idControl.setupPanel(client);
        Label label = new Label(client, 256);
        label.setText(Messages.GeneralInformationSection_state);
        GridData layoutData = new GridData(16384, 128, false, false);
        layoutData.verticalIndent = 4;
        label.setLayoutData((Object)layoutData);
        Composite panel = new Composite(client, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        panel.setLayout((Layout)new GridLayout(2, false));
        layoutData = new GridData(4, 0x1000000, true, false);
        if (this.nameControl.getControlDecoration() != null) {
            layoutData.horizontalIndent = FieldDecorationRegistry.getDefault().getMaximumDecorationWidth() / 2;
        }
        panel.setLayoutData((Object)layoutData);
        this.linkStateImage = new Label(panel, 256);
        layoutData = new GridData(0x1000000, 128, false, false);
        layoutData.verticalIndent = 1;
        layoutData.widthHint = 10;
        this.linkStateImage.setLayoutData((Object)layoutData);
        this.linkState = new Text(panel, 74);
        layoutData = new GridData(4, 0x1000000, true, false);
        layoutData.heightHint = SWTControlUtil.convertHeightInCharsToPixels((Control)this.linkState, (int)2);
        this.linkState.setLayoutData((Object)layoutData);
        this.updateEnablement();
        this.setIsUpdating(false);
    }

    public void setActive(boolean active) {
        Object node;
        if (active && this.getManagedForm().getContainer() instanceof AbstractEditorPage && !((AbstractEditorPage)this.getManagedForm().getContainer()).isDirty() && (node = ((AbstractEditorPage)this.getManagedForm().getContainer()).getEditorInputNode()) instanceof IPeerModel) {
            this.setupData((IPeerModel)node);
        }
    }

    public void setupData(final IPeerModel node) {
        this.od = node;
        this.odc.clearProperties();
        this.wc.clearProperties();
        if (node == null) {
            return;
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                GeneralInformationSection.this.odc.setProperty("state", node.getProperty("state"));
                GeneralInformationSection.this.odc.setProperty("ID", node.getPeer().getAttributes().get("ID"));
                GeneralInformationSection.this.odc.setProperty("Name", node.getPeer().getAttributes().get("Name"));
                GeneralInformationSection.this.wc.setProperties(GeneralInformationSection.this.odc.getProperties());
            }
        });
        if (this.idControl != null) {
            this.idControl.setEditFieldControlText(this.wc.getStringProperty("ID"));
        }
        if (this.nameControl != null) {
            this.nameControl.setEditFieldControlText(this.wc.getStringProperty("Name"));
        }
        if (this.linkState != null && this.linkStateImage != null) {
            String state = this.wc.getStringProperty("state");
            this.linkState.setText(Messages.getString("GeneralInformationSection_state_" + (state != null ? state.replace('-', '_') : "_1")));
            switch (this.wc.getIntProperty("state")) {
                case 0: {
                    this.linkStateImage.setImage(UIPlugin.getImage("GoldOverlay"));
                    break;
                }
                case 1: {
                    this.linkStateImage.setImage(UIPlugin.getImage("GreenOverlay"));
                    break;
                }
                case 2: {
                    this.linkStateImage.setImage(UIPlugin.getImage("RedOverlay"));
                    break;
                }
                case 3: {
                    this.linkStateImage.setImage(UIPlugin.getImage("RedXOverlay"));
                    break;
                }
                default: {
                    this.linkStateImage.setImage(UIPlugin.getImage("GreyOverlay"));
                }
            }
        }
        this.updateEnablement();
    }

    public void extractData(final IPeerModel node) {
        if (node == null) {
            return;
        }
        if (this.idControl != null) {
            this.wc.setProperty("ID", (Object)this.idControl.getEditFieldControlText());
        }
        if (this.nameControl != null) {
            this.wc.setProperty("Name", (Object)this.nameControl.getEditFieldControlText());
        }
        if (!this.odc.getStringProperty("Name").equals(this.wc.getStringProperty("Name"))) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    IPeer oldPeer = node.getPeer();
                    HashMap<String, String> attributes = new HashMap<String, String>(oldPeer.getAttributes());
                    attributes.put("Name", GeneralInformationSection.this.wc.getStringProperty("Name"));
                    attributes.remove("URI.transient");
                    PeerRedirector newPeer = oldPeer instanceof PeerRedirector ? new PeerRedirector(((PeerRedirector)oldPeer).getParent(), attributes) : new TransientPeer(attributes);
                    boolean changed = node.setChangeEventsEnabled(false);
                    node.setProperty("instance", (Object)newPeer);
                    if (changed) {
                        node.setChangeEventsEnabled(true);
                    }
                }
            });
        }
    }

    public boolean isValid() {
        if (!this.isUpdating()) {
            return true;
        }
        boolean valid = super.isValid();
        if (this.idControl != null) {
            valid &= this.idControl.isValid();
            this.setMessage(this.idControl.getMessage(), this.idControl.getMessageType());
        }
        if (this.nameControl != null) {
            valid &= this.nameControl.isValid();
            if (this.nameControl.getMessageType() > this.getMessageType()) {
                this.setMessage(this.nameControl.getMessage(), this.nameControl.getMessageType());
            }
        }
        return valid;
    }

    public void commit(boolean onSave) {
        boolean needsSaving = this.isDirty();
        super.commit(onSave);
        if (!onSave || !needsSaving) {
            return;
        }
        String oldName = this.odc.getStringProperty("Name");
        this.extractData(this.od);
        if (!oldName.equals(this.wc.getStringProperty("Name"))) {
            try {
                IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                if (uRIPersistenceService == null) {
                    throw new IOException("Persistence service instance unavailable.");
                }
                HashMap<String, String> oldData = new HashMap<String, String>();
                for (String key : this.odc.getProperties().keySet()) {
                    oldData.put(key, this.odc.getStringProperty(key));
                }
                uRIPersistenceService.delete((Object)new TransientPeer(oldData), null);
                uRIPersistenceService.write((Object)this.od.getPeer(), null);
            }
            catch (IOException iOException) {}
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    GeneralInformationSection.this.od.fireChangeEvent("properties", null, (Object)GeneralInformationSection.this.od.getProperties());
                }
            });
        }
    }

    public void dataChanged(TypedEvent e) {
        String value;
        if (!this.isUpdating()) {
            return;
        }
        boolean isDirty = false;
        if (this.idControl != null) {
            String id = this.idControl.getEditFieldControlText();
            isDirty = "".equals(id) ? (isDirty |= (value = this.odc.getStringProperty("ID")) != null && !"".equals(value.trim())) : (isDirty |= !this.odc.isProperty("ID", (Object)id));
        }
        if (this.nameControl != null) {
            String name = this.nameControl.getEditFieldControlText();
            isDirty = "".equals(name) ? (isDirty |= (value = this.odc.getStringProperty("Name")) != null && !"".equals(value.trim())) : (isDirty |= !this.odc.isProperty("Name", (Object)name));
        }
        this.markDirty(isDirty);
    }

    protected void updateEnablement() {
        final Object input = this.getManagedForm().getInput();
        if (this.idControl != null) {
            SWTControlUtil.setEnabled((Control)this.idControl.getEditFieldControl(), (boolean)false);
        }
        if (this.nameControl != null) {
            final AtomicBoolean isStatic = new AtomicBoolean();
            final AtomicBoolean isRemote = new AtomicBoolean();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (input instanceof IPeerModel) {
                        String value = (String)((IPeerModel)input).getPeer().getAttributes().get("static.transient");
                        isStatic.set(value != null && Boolean.parseBoolean(value.trim()));
                        value = (String)((IPeerModel)input).getPeer().getAttributes().get("remote.transient");
                        isRemote.set(value != null && Boolean.parseBoolean(value.trim()));
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            SWTControlUtil.setEnabled((Control)this.nameControl.getEditFieldControl(), (isStatic.get() && !isRemote.get() ? 1 : 0) != 0);
        }
    }
}

