/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.jface.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.ui.swt.activator.UIPlugin;
import org.eclipse.ui.PlatformUI;

public class CustomTitleAreaDialog
extends TitleAreaDialog
implements IMessageProvider {
    protected static final int comboHistoryLength = 10;
    private String contextHelpId = null;
    private IDialogSettings dialogSettings;
    private String message;
    private int messageType;
    private String errorMessage;
    private String title;
    private String defaultMessage;
    private int defaultMessageType;

    public CustomTitleAreaDialog(Shell parent) {
        this(parent, null);
    }

    public CustomTitleAreaDialog(Shell parent, String contextHelpId) {
        super(parent);
        this.initializeDialogSettings();
        this.setContextHelpId(contextHelpId);
    }

    protected void setContextHelpId(String contextHelpId) {
        this.contextHelpId = contextHelpId;
        this.setHelpAvailable(contextHelpId != null);
    }

    protected void initializeDialogSettings() {
        IDialogSettings settings = this.doGetDialogSettingsToInitialize();
        Assert.isNotNull((Object)settings);
        IDialogSettings section = settings.getSection(this.getDialogSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getDialogSettingsSectionName());
        }
        this.setDialogSettings(section);
    }

    protected IDialogSettings doGetDialogSettingsToInitialize() {
        return UIPlugin.getDefault().getDialogSettings();
    }

    public String getDialogSettingsSectionName() {
        return "CustomTitleAreaDialog";
    }

    public void create() {
        super.create();
        if (this.isMessageSet()) {
            if (this.errorMessage != null) {
                super.setErrorMessage(this.errorMessage);
            } else {
                super.setMessage(this.message, this.messageType);
            }
        } else if (this.defaultMessage != null) {
            super.setMessage(this.defaultMessage, this.defaultMessageType);
        }
        if (this.title != null) {
            super.setTitle(this.title);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Control control;
        if (this.contextHelpId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.contextHelpId);
        }
        if ((control = super.createDialogArea(parent)) instanceof Composite) {
            this.configureDialogAreaControl((Composite)control);
        }
        return control;
    }

    protected void configureDialogAreaControl(Composite composite) {
        Assert.isNotNull((Object)composite);
        Layout layout = composite.getLayout();
        if (layout == null || layout instanceof GridLayout) {
            composite.setLayout((Layout)new GridLayout());
        }
    }

    public IDialogSettings getDialogSettings() {
        if (this.dialogSettings == null) {
            this.initializeDialogSettings();
        }
        return this.dialogSettings;
    }

    public void setDialogSettings(IDialogSettings dialogSettings) {
        this.dialogSettings = dialogSettings;
    }

    protected String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected void addToHistory(List<String> history, String newEntry) {
        Assert.isNotNull((Object)newEntry);
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 10) {
            history.remove(10);
        }
    }

    protected void saveWidgetValues() {
    }

    protected void restoreWidgetValues() {
    }

    protected void okPressed() {
        this.saveWidgetValues();
        super.okPressed();
    }

    protected void dispose() {
        this.dialogSettings = null;
        this.message = null;
        this.messageType = 0;
        this.errorMessage = null;
        this.title = null;
        this.defaultMessage = null;
        this.defaultMessageType = 0;
    }

    public boolean close() {
        this.dispose();
        return super.close();
    }

    public void setButtonEnabled(int buttonId, boolean enabled) {
        Button button = this.getButton(buttonId);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    public void setDialogTitle(String title) {
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.getShell().setText(title);
        }
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
        super.setTitle(newTitle);
    }

    public void setDefaultMessage(String message, int type) {
        this.defaultMessage = message;
        this.defaultMessageType = type;
        if (!this.isMessageSet() && this.getContents() != null) {
            super.setMessage(this.defaultMessage, this.defaultMessageType);
        }
    }

    public void setMessage(String newMessage, int newType) {
        this.message = newMessage;
        this.messageType = newType;
        if (this.getContents() != null) {
            super.setMessage(this.message != null ? this.message : this.defaultMessage, this.message != null ? this.messageType : this.defaultMessageType);
        }
    }

    public void setErrorMessage(String newErrorMessage) {
        this.errorMessage = newErrorMessage;
        super.setErrorMessage(newErrorMessage);
    }

    public String getMessage() {
        return this.errorMessage != null ? this.errorMessage : this.message;
    }

    public int getMessageType() {
        return this.errorMessage != null ? 3 : this.messageType;
    }

    public boolean isMessageSet() {
        return this.errorMessage != null || this.message != null;
    }
}

