/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.activator;

import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.runtime.tracing.TraceHandler;
import org.eclipse.tcf.te.ui.jface.images.AbstractImageDescriptor;
import org.eclipse.tcf.te.ui.trees.ViewerStateManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UIPlugin
extends AbstractUIPlugin {
    private static UIPlugin plugin;
    private static volatile TraceHandler traceHandler;
    Image[] pendingImages;

    private void loadPendingImages() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                InputStream is = null;
                try {
                    URL url = UIPlugin.getDefault().getBundle().getEntry("icons/elcl16/pending.gif");
                    if (url != null) {
                        is = url.openStream();
                        ImageData[] imageDatas = new ImageLoader().load(is);
                        UIPlugin.this.pendingImages = new Image[imageDatas.length];
                        Display display = PlatformUI.getWorkbench().getDisplay();
                        int i = 0;
                        while (i < imageDatas.length) {
                            UIPlugin.this.pendingImages[i] = new Image((Device)display, imageDatas[i]);
                            ++i;
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        });
    }

    public static UIPlugin getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (UIPlugin.getDefault() != null && UIPlugin.getDefault().getBundle() != null) {
            return UIPlugin.getDefault().getBundle().getSymbolicName();
        }
        return "org.eclipse.tcf.te.ui";
    }

    public static TraceHandler getTraceHandler() {
        if (traceHandler == null) {
            traceHandler = new TraceHandler(UIPlugin.getUniqueIdentifier());
        }
        return traceHandler;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.loadPendingImages();
        ViewerStateManager.getInstance().loadViewerStates();
    }

    public void stop(BundleContext context) throws Exception {
        ViewerStateManager.getInstance().storeViewerStates();
        if (this.pendingImages != null && this.pendingImages.length > 0) {
            Image[] imageArray = this.pendingImages;
            int n = this.pendingImages.length;
            int n2 = 0;
            while (n2 < n) {
                Image img = imageArray[n2];
                img.dispose();
                ++n2;
            }
        }
        this.pendingImages = null;
        plugin = null;
        traceHandler = null;
        super.stop(context);
    }

    public Image[] getPendingImages() {
        return this.pendingImages;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        URL url = UIPlugin.getDefault().getBundle().getEntry("icons/wizban/newtarget_wiz.gif");
        registry.put("NewTargetWizard", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/dlcl16/newtarget_wiz.gif");
        registry.put("NewTargetWizard_disabled", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/elcl16/newtarget_wiz.gif");
        registry.put("NewTargetWizard_enabled", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/dlcl16/filter_ps.gif");
        registry.put("ViewerFilterConfig_disabled", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/elcl16/filter_ps.gif");
        registry.put("ViewerFilterConfig_enabled", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/elcl16/collapseall.gif");
        registry.put("ViewerCollapseAll_enabled", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/gold_ovr.gif");
        registry.put("GoldOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/green_ovr.gif");
        registry.put("GreenOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/grey_ovr.gif");
        registry.put("GreyOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/red_ovr.gif");
        registry.put("RedOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/redX_ovr.gif");
        registry.put("RedXOverlay", ImageDescriptor.createFromURL((URL)url));
        url = UIPlugin.getDefault().getBundle().getEntry("icons/ovr16/busy.gif");
        registry.put("BusyOverlay", ImageDescriptor.createFromURL((URL)url));
    }

    public static Image getImage(String key) {
        return UIPlugin.getDefault().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return UIPlugin.getDefault().getImageRegistry().getDescriptor(key);
    }

    public static Image getSharedImage(AbstractImageDescriptor descriptor) {
        String imageKey;
        ImageRegistry registry = UIPlugin.getDefault().getImageRegistry();
        Image image = registry.get(imageKey = descriptor.getDecriptorKey());
        if (image == null) {
            registry.put(imageKey, (ImageDescriptor)descriptor);
            image = registry.get(imageKey);
        }
        return image;
    }
}

