/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.internal.utils;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.tcf.te.ui.internal.utils.StringMatcher;

public class TablePatternFilter
extends ViewerFilter {
    private static final String ALL = "*";
    protected StringMatcher matcher = null;
    protected ILabelProvider labelProvider;

    public TablePatternFilter(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.match(this.labelProvider.getText(element));
    }

    public void setPattern(String newPattern) {
        if (newPattern == null || newPattern.trim().length() == 0) {
            this.matcher = new StringMatcher(ALL, true, false);
        } else {
            String patternString = ALL + newPattern + ALL;
            this.matcher = new StringMatcher(patternString, true, false);
        }
    }

    public boolean match(String input) {
        if (input == null) {
            return false;
        }
        return this.matcher == null || this.matcher.match(input);
    }
}

