/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.internal.utils;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.ui.interfaces.ISearchCallback;
import org.eclipse.tcf.te.ui.internal.utils.SearchEngine;
import org.eclipse.tcf.te.ui.jface.dialogs.CustomTitleAreaDialog;
import org.eclipse.tcf.te.ui.nls.Messages;

public class TreeViewerSearchDialog
extends CustomTitleAreaDialog
implements SelectionListener,
ISearchCallback {
    private static final int SEARCH_ID = 31;
    private Text fSearchField;
    private Button fBtnDepth;
    private Button fBtnBreadth;
    private Button fBtnCase;
    private Button fBtnWrap;
    private Button fBtnMatch;
    private Button fBtnBackward;
    private ProgressMonitorPart fPmPart;
    SearchEngine fSearcher;
    TreeViewer fViewer;

    public TreeViewerSearchDialog(TreeViewer viewer) {
        this(viewer, false);
    }

    protected TreeViewerSearchDialog(TreeViewer viewer, boolean depthFirst) {
        super(viewer.getTree().getShell());
        this.setShellStyle(2144);
        this.fViewer = viewer;
        this.fSearcher = SearchEngine.getSearchEngine(this.fViewer);
        this.fSearcher.setDepthFirst(depthFirst);
        this.fViewer.getTree().addSelectionListener((SelectionListener)this);
        this.setTitle(Messages.TreeViewerSearchDialog_DialogTitleMessage);
    }

    public boolean close() {
        this.fViewer.getTree().removeSelectionListener((SelectionListener)this);
        return super.close();
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 31: {
                this.searchButtonPressed();
                break;
            }
            case 12: {
                this.closePressed();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected void closePressed() {
        this.fSearcher.endSearch();
        this.setReturnCode(0);
        this.close();
    }

    private void searchButtonPressed() {
        this.fSearcher.getMatcher().setMatchTarget(this.fSearchField.getText().trim());
        this.getButton(31).setEnabled(false);
        this.fSearcher.startSearch(this, this.fPmPart);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.TreeViewerSearchDialog_DialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 31, Messages.TreeViewerSearchDialog_BtnSearchText, true);
        this.createButton(parent, 12, Messages.TreeViewerSearchDialog_BtnCloseText, false);
        this.getButton(31).setEnabled(false);
    }

    @Override
    public void searchDone(IStatus status, TreePath path) {
        Button btn = this.getButton(31);
        if (btn != null && !btn.isDisposed()) {
            btn.setEnabled(true);
            btn.setFocus();
        }
        if (status.isOK()) {
            if (path == null) {
                if (this.fSearcher.isWrap()) {
                    if (this.fSearcher.getLastResult() == null) {
                        this.setErrorMessage(Messages.TreeViewerSearchDialog_NoSuchNode);
                    }
                } else {
                    this.setErrorMessage(Messages.TreeViewerSearchDialog_NoSuchNode);
                }
            } else {
                this.setMessage(null);
            }
        } else {
            this.setMessage(null);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridLayout glayout = new GridLayout(2, false);
        glayout.marginHeight = 10;
        glayout.marginWidth = 10;
        glayout.verticalSpacing = 10;
        glayout.horizontalSpacing = 10;
        container.setLayout((Layout)glayout);
        container.setLayoutData((Object)new GridData(768));
        Label label = new Label(container, 0);
        label.setText(Messages.TreeViewerSearchDialog_LblCancelText);
        this.fSearchField = new Text(container, 2052);
        this.fSearchField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fSearchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TreeViewerSearchDialog.this.updateSearchButton();
                TreeViewerSearchDialog.this.fSearcher.resetPath();
            }
        });
        Group group = new Group(container, 16);
        group.setText(Messages.TreeViewerSearchDialog_SearchAlgorithm);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout(2, false));
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeViewerSearchDialog.this.optionChecked(e);
            }
        };
        this.fBtnBreadth = new Button((Composite)group, 16);
        this.fBtnBreadth.setText(Messages.TreeViewerSearchDialog_BreadthFirst);
        this.fBtnBreadth.setSelection(!this.fSearcher.isDepthFirst());
        this.fBtnBreadth.addSelectionListener((SelectionListener)l);
        this.fBtnBreadth.setLayoutData((Object)new GridData());
        this.fBtnDepth = new Button((Composite)group, 16);
        this.fBtnDepth.setText(Messages.TreeViewerSearchDialog_DepthFirst);
        this.fBtnDepth.setSelection(this.fSearcher.isDepthFirst());
        this.fBtnDepth.addSelectionListener((SelectionListener)l);
        this.fBtnDepth.setLayoutData((Object)new GridData());
        group = new Group(container, 16);
        group.setText(Messages.TreeViewerSearchDialog_GrpOptionsText);
        data = new GridData(4, 0x1000000, true, false);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        group.setLayout((Layout)new GridLayout(4, false));
        this.fBtnCase = new Button((Composite)group, 32);
        this.fBtnCase.setText(Messages.TreeViewerSearchDialog_BtnCaseText);
        this.fBtnCase.addSelectionListener((SelectionListener)l);
        this.fBtnMatch = new Button((Composite)group, 32);
        this.fBtnMatch.setText(Messages.TreeViewerSearchDialog_BtnPreciseText);
        this.fBtnMatch.addSelectionListener((SelectionListener)l);
        this.fBtnWrap = new Button((Composite)group, 32);
        this.fBtnWrap.setText(Messages.TreeViewerSearchDialog_BtnWrapText);
        this.fBtnWrap.addSelectionListener((SelectionListener)l);
        this.fBtnBackward = new Button((Composite)group, 32);
        this.fBtnBackward.setText(Messages.TreeViewerSearchDialog_BtnBackText);
        this.fBtnBackward.addSelectionListener((SelectionListener)l);
        this.fBtnBackward.setVisible(this.fSearcher.isDepthFirst());
        this.fPmPart = new ProgressMonitorPart(container, null, true);
        data = new GridData(256);
        data.horizontalSpan = 2;
        this.fPmPart.setLayoutData((Object)data);
        this.fPmPart.setVisible(false);
        return composite;
    }

    void optionChecked(SelectionEvent e) {
        Object src = e.getSource();
        if (src == this.fBtnCase) {
            this.fSearcher.getMatcher().setCaseSensitive(this.fBtnCase.getSelection());
        } else if (src == this.fBtnWrap) {
            this.fSearcher.setWrap(this.fBtnWrap.getSelection());
        } else if (src == this.fBtnMatch) {
            this.fSearcher.getMatcher().setMatchPrecise(this.fBtnMatch.getSelection());
        } else if (src == this.fBtnBackward) {
            this.fSearcher.endSearch();
            this.fSearcher.setStartPath(this.fSearcher.getLastResult());
            this.fSearcher.setForeward(!this.fBtnBackward.getSelection());
        } else if (src == this.fBtnDepth || src == this.fBtnBreadth) {
            if (src == this.fBtnDepth) {
                this.fBtnDepth.setSelection(true);
                this.fBtnBreadth.setSelection(false);
            } else if (src == this.fBtnBreadth) {
                this.fBtnBreadth.setSelection(true);
                this.fBtnDepth.setSelection(false);
            }
            this.fSearcher.endSearch();
            boolean selection = this.fBtnDepth.getSelection();
            this.fSearcher.setDepthFirst(selection);
            this.fBtnBackward.setVisible(selection);
            this.fSearcher.resetPath();
            this.fSearcher.setForeward(!this.fBtnBackward.getSelection());
        }
    }

    void updateSearchButton() {
        String txt = this.fSearchField.getText();
        boolean valid = txt != null && txt.trim().length() > 0;
        this.getButton(31).setEnabled(valid);
    }

    public void setStartPath(TreePath rootPath) {
        this.fSearcher.setStartPath(rootPath);
        String text = this.fSearcher.getMatcher().getElementText(rootPath.getLastSegment());
        this.setDefaultMessage(NLS.bind((String)Messages.TreeViewerSearchDialog_DialogPromptMessage, (Object)text), 0);
    }

    public void widgetSelected(SelectionEvent e) {
        this.fSearcher.endSearch();
        ISelection sel = this.fViewer.getSelection();
        if (sel == null || sel.isEmpty()) {
            this.fSearcher.resetPath();
        } else {
            TreeSelection iss = (TreeSelection)sel;
            TreePath[] paths = iss.getPaths();
            if (paths == null || paths.length == 0) {
                this.fSearcher.resetPath();
            } else {
                this.fSearcher.setStartPath(paths[0]);
            }
        }
        this.fSearcher.setLastResult(null);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

