/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.utils;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.tcf.te.ui.internal.utils.QuickFilter;
import org.eclipse.tcf.te.ui.internal.utils.SearchEngine;
import org.eclipse.tcf.te.ui.internal.utils.TreeViewerSearchDialog;

public class TreeViewerUtil {
    private static QuickFilter getQuickFilter(TreeViewer viewer) {
        QuickFilter filter = (QuickFilter)((Object)viewer.getData("quick.filter"));
        if (filter == null) {
            filter = new QuickFilter(viewer);
            viewer.setData("quick.filter", (Object)filter);
        }
        return filter;
    }

    public static void doReset(TreeViewer viewer) {
        if (TreeViewerUtil.getQuickFilter(viewer).isFiltering()) {
            TreeViewerUtil.getQuickFilter(viewer).resetViewer();
        }
    }

    public static void doFilter(TreeViewer viewer) {
        TreePath rootPath = TreeViewerUtil.getSelectedPath(viewer);
        Object root = TreeViewerUtil.getFilterRoot(viewer, rootPath);
        if (root == viewer.getInput() || viewer.getExpandedState(root)) {
            TreeViewerUtil.getQuickFilter(viewer).showFilterPopup(root);
        }
    }

    public static void doSearch(TreeViewer viewer) {
        TreePath rootPath = TreeViewerUtil.getSelectedPath(viewer);
        if (rootPath == null) {
            rootPath = new TreePath(new Object[]{viewer.getInput()});
        }
        TreeViewerSearchDialog dialog = new TreeViewerSearchDialog(viewer);
        dialog.setStartPath(rootPath);
        dialog.open();
    }

    public static void doSearchNext(TreeViewer viewer) {
        SearchEngine.getSearchEngine(viewer).startSearch(null, null);
    }

    private static Object getFilterRoot(TreeViewer viewer, TreePath rootPath) {
        if (rootPath != null) {
            if (!TreeViewerUtil.isEligibleRoot(rootPath, viewer)) {
                if ((rootPath = rootPath.getParentPath()).getSegmentCount() == 0) {
                    viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                } else {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)rootPath), true);
                }
            }
            if (rootPath.getSegmentCount() == 0) {
                viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                return viewer.getInput();
            }
            return rootPath;
        }
        viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        return viewer.getInput();
    }

    private static boolean isEligibleRoot(TreePath root, TreeViewer viewer) {
        Object rootElement;
        ITreeContentProvider contentProvider;
        Object[] children;
        if (viewer.getExpandedState((Object)root) && (children = (contentProvider = (ITreeContentProvider)viewer.getContentProvider()).getChildren(rootElement = root.getLastSegment())) != null && children.length > 0) {
            ViewerFilter[] filters = viewer.getFilters();
            if (filters != null && filters.length > 0) {
                ViewerFilter[] viewerFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewerFilter filter = viewerFilterArray[n2];
                    if ((children = filter.filter((Viewer)viewer, rootElement, children)) == null || children.length == 0) break;
                    ++n2;
                }
            }
            return children != null && children.length > 0;
        }
        return false;
    }

    private static TreePath getSelectedPath(TreeViewer viewer) {
        TreeSelection treeSelection;
        TreePath[] paths;
        ISelection selection = viewer.getSelection();
        if (selection instanceof TreeSelection && (paths = (treeSelection = (TreeSelection)selection).getPaths()) != null && paths.length > 0) {
            return paths[0];
        }
        return null;
    }
}

