/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.wizards.newWizard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.interfaces.IUIConstants;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.tcf.te.ui.wizards.newWizard.NewWizardContentProvider;
import org.eclipse.tcf.te.ui.wizards.newWizard.NewWizardNode;
import org.eclipse.tcf.te.ui.wizards.newWizard.NewWizardRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ITriggerPoint;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.dialogs.WizardPatternFilter;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class NewWizardSelectionPage
extends WizardPage {
    private static final String EXPANDED_CATEGORIES_SETTINGS_ID = "filteredTree.expandedCatogryIds";
    private static final String SELECTED_WIZARD_DESCRIPTOR_SETTINGS_ID = "filteredTree.selectedWizardDescriptorId";
    private static final String[] DEFAULT_EXPANDED_CATEGORY_IDS = new String[]{"org.eclipse.tcf.te.ui.newWizards.category.general"};
    private NewWizardRegistry wizardRegistry;
    private FilteredTree filteredTree;
    private PatternFilter filteredTreeFilter;
    private IWizardDescriptor selectedWizardDescriptor;
    private final Map<IWizardDescriptor, IWizardNode> wizardNodes = new HashMap<IWizardDescriptor, IWizardNode>();
    private IWorkbench workbench;
    private IStructuredSelection selection;

    public NewWizardSelectionPage(NewWizardRegistry wizardRegistry) {
        super(NewWizardSelectionPage.class.getSimpleName());
        this.setTitle(this.getDefaultTitle());
        this.setDescription(this.getDefaultDescription());
        Assert.isNotNull((Object)((Object)wizardRegistry));
        this.wizardRegistry = wizardRegistry;
    }

    protected String getDefaultTitle() {
        return Messages.NewWizardSelectionPage_title;
    }

    protected String getDefaultDescription() {
        return Messages.NewWizardSelectionPage_description;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText(Messages.NewWizardSelectionPage_wizards);
        label.setLayoutData((Object)new GridData(768));
        this.filteredTreeFilter = new WizardPatternFilter();
        this.filteredTree = new FilteredTree(composite, 2820, this.filteredTreeFilter, true);
        this.filteredTree.setBackground(parent.getDisplay().getSystemColor(22));
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 325;
        layoutData.widthHint = 450;
        this.filteredTree.setLayoutData((Object)layoutData);
        TreeViewer treeViewer = this.filteredTree.getViewer();
        treeViewer.setContentProvider((IContentProvider)new NewWizardContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        treeViewer.setComparator((ViewerComparator)new NewWizardViewerComparator());
        treeViewer.addFilter((ViewerFilter)new NewWizardViewerFilter());
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NewWizardSelectionPage.this.onSelectionChanged();
            }
        });
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    TreeViewer viewer;
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    Object element = selection.getFirstElement();
                    if (element instanceof IWizardDescriptor) {
                        if (NewWizardSelectionPage.this.canFlipToNextPage()) {
                            NewWizardSelectionPage.this.getWizard().getContainer().showPage(NewWizardSelectionPage.this.getNextPage());
                        }
                    } else if (event.getViewer() instanceof TreeViewer && (viewer = (TreeViewer)event.getViewer()).isExpandable(element)) {
                        viewer.setExpandedState(element, !viewer.getExpandedState(element));
                    }
                }
            }
        });
        treeViewer.setInput((Object)this.wizardRegistry);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.restoreWidgetValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IUIConstants.HELP_NEW_WIZARD_SELECTION_PAGE);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    protected void onSelectionChanged() {
        IWizardContainer container;
        if (this.filteredTree.getViewer().getSelection() instanceof IStructuredSelection) {
            IStructuredSelection filteredTreeSelection = (IStructuredSelection)this.filteredTree.getViewer().getSelection();
            if (filteredTreeSelection.getFirstElement() instanceof IWizardDescriptor) {
                this.selectedWizardDescriptor = (IWizardDescriptor)filteredTreeSelection.getFirstElement();
                if (this.selectedWizardDescriptor.getDescription() != null && !"".equals(this.selectedWizardDescriptor.getDescription())) {
                    this.setDescription(this.selectedWizardDescriptor.getDescription());
                } else if (!this.getDefaultDescription().equals(this.getDescription())) {
                    this.setDescription(this.getDefaultDescription());
                }
            } else {
                this.selectedWizardDescriptor = null;
            }
            if (this.selectedWizardDescriptor != null && !this.wizardNodes.containsKey(this.selectedWizardDescriptor)) {
                this.wizardNodes.put(this.selectedWizardDescriptor, new NewWizardNode(this, this.selectedWizardDescriptor));
            }
        }
        if ((container = this.getContainer()) != null && container.getCurrentPage() != null) {
            container.updateWindowTitle();
            container.updateTitleBar();
            container.updateButtons();
        }
    }

    public IWizardPage getNextPage() {
        IWizardNode selectedNode;
        ITriggerPoint triggerPoint = this.workbench.getActivitySupport().getTriggerPointManager().getTriggerPoint("org.eclipse.ui.newWizards");
        if ((triggerPoint == null || WorkbenchActivityHelper.allowUseOf((ITriggerPoint)triggerPoint, (Object)this.getSelectedNode())) && (selectedNode = this.getSelectedNode()) != null) {
            boolean isCreated = selectedNode.isContentCreated();
            IWizard wizard = selectedNode.getWizard();
            if (wizard != null) {
                if (!isCreated) {
                    wizard.addPages();
                }
                return wizard.getStartingPage();
            }
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        if (this.selectedWizardDescriptor != null && this.selectedWizardDescriptor.hasPages()) {
            return super.canFlipToNextPage();
        }
        return false;
    }

    public boolean canFinishEarly() {
        return this.selectedWizardDescriptor != null && this.selectedWizardDescriptor.canFinishEarly();
    }

    public IWizardNode getSelectedNode() {
        IWizardNode node = null;
        if (this.selectedWizardDescriptor != null) {
            node = this.wizardNodes.get(this.selectedWizardDescriptor);
        }
        return node;
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName;
        IDialogSettings settings = super.getDialogSettings();
        if (settings == null) {
            settings = UIPlugin.getDefault().getDialogSettings();
        }
        if (settings.getSection(sectionName = ((Object)((Object)this)).getClass().getName()) == null) {
            settings.addNewSection(sectionName);
        }
        settings = settings.getSection(sectionName);
        return settings;
    }

    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            IWizardDescriptor descriptor;
            String selectedWizardDescriptorId;
            String[] expandedCategories = settings.getArray(EXPANDED_CATEGORIES_SETTINGS_ID);
            if (expandedCategories == null) {
                expandedCategories = DEFAULT_EXPANDED_CATEGORY_IDS;
            }
            if (expandedCategories != null) {
                ArrayList<IWizardCategory> expanded = new ArrayList<IWizardCategory>();
                String[] stringArray = expandedCategories;
                int n = expandedCategories.length;
                int n2 = 0;
                while (n2 < n) {
                    IWizardCategory category;
                    String expandedCategorie = stringArray[n2];
                    String categoryId = expandedCategorie;
                    if (categoryId != null && !"".equals(categoryId.trim()) && (category = this.wizardRegistry.findCategory(categoryId)) != null && !expanded.contains(category)) {
                        expanded.add(category);
                    }
                    ++n2;
                }
                if (expanded.size() > 0) {
                    this.filteredTree.getViewer().setExpandedElements(expanded.toArray());
                }
            }
            if ((selectedWizardDescriptorId = settings.get(SELECTED_WIZARD_DESCRIPTOR_SETTINGS_ID)) != null && !"".equals(selectedWizardDescriptorId.trim()) && (descriptor = this.wizardRegistry.findWizard(selectedWizardDescriptorId)) != null) {
                this.filteredTree.getViewer().setSelection((ISelection)new StructuredSelection((Object)descriptor), true);
            }
        }
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            Object[] expanded;
            ArrayList<String> expandedCategories = new ArrayList<String>();
            Object[] objectArray = expanded = this.filteredTree.getViewer().getVisibleExpandedElements();
            int n = expanded.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IWizardCategory) {
                    expandedCategories.add(((IWizardCategory)element).getId());
                }
                ++n2;
            }
            settings.put(EXPANDED_CATEGORIES_SETTINGS_ID, expandedCategories.toArray(new String[expandedCategories.size()]));
            if (this.selectedWizardDescriptor != null) {
                settings.put(SELECTED_WIZARD_DESCRIPTOR_SETTINGS_ID, this.selectedWizardDescriptor.getId());
            } else {
                settings.put(SELECTED_WIZARD_DESCRIPTOR_SETTINGS_ID, "");
            }
        }
    }

    static class NewWizardViewerComparator
    extends ViewerComparator {
        NewWizardViewerComparator() {
        }

        public boolean isSorterProperty(Object element, String property) {
            return property.equals("org.eclipse.jface.text");
        }
    }

    static class NewWizardViewerFilter
    extends ViewerFilter {
        NewWizardViewerFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            block5: {
                IConfigurationElement configElement;
                IConfigurationElement[] children;
                if (element instanceof WorkbenchWizardElement && (children = (configElement = ((WorkbenchWizardElement)element).getConfigurationElement()).getChildren("enablement")) != null && children.length > 0) {
                    try {
                        Expression expression = ExpressionConverter.getDefault().perform(children[0]);
                        if (expression != null) {
                            StructuredSelection selection = new StructuredSelection(element);
                            EvaluationContext evalContext = new EvaluationContext(null, (Object)selection);
                            evalContext.addVariable("selection", (Object)selection);
                            evalContext.setAllowPluginActivation(true);
                            if (!expression.evaluate((IEvaluationContext)evalContext).equals(EvaluationResult.TRUE)) {
                                return false;
                            }
                        }
                    }
                    catch (CoreException e) {
                        if (!Platform.inDebugMode()) break block5;
                        Status status = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.NewWizardViewerFilter_error_evaluationFailed, (Object)e.getLocalizedMessage()), (Throwable)e);
                        UIPlugin.getDefault().getLog().log((IStatus)status);
                    }
                }
            }
            return true;
        }
    }
}

