/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic.actions;

import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.graphic.actions.BaseRevisionGraphAction;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.operation.OpenRemoteFileOperation;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPart;

public class OpenFileWithAction
extends BaseRevisionGraphAction {
    public static final String OpenFileWithAction_ID = "OpenFileWith";
    protected String editorId;
    protected boolean allowsMultiple;

    public OpenFileWithAction(IWorkbenchPart part) {
        this(part, "org.eclipse.ui.DefaultTextEditor", true);
    }

    public OpenFileWithAction(IWorkbenchPart part, String editorId, boolean allowsMultiple) {
        super(part);
        this.editorId = editorId;
        this.allowsMultiple = allowsMultiple;
        this.setId(OpenFileWithAction_ID);
    }

    protected boolean calculateEnabled() {
        if (this.allowsMultiple) {
            return this.getSelectedEditParts(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER).length > 0;
        }
        return this.isEnable(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER, 1);
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        IEditorDescriptor descriptor = SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().findEditor(this.editorId);
        this.setImageDescriptor(descriptor == null ? null : descriptor.getImageDescriptor());
    }

    public void run() {
        IRepositoryResource[] resources = BaseRevisionGraphAction.convertToResources(this.getSelectedEditParts(BaseRevisionGraphAction.NOT_DELETED_ACTION_FILTER));
        IRepositoryFile[] files = new IRepositoryFile[resources.length];
        int i = 0;
        while (i < resources.length) {
            files[i] = (IRepositoryFile)resources[i];
            ++i;
        }
        this.runOperation((IActionOperation)new OpenRemoteFileOperation(files, 3, this.editorId));
    }
}

