/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.preferences;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.ULocale;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.team.svn.core.operation.local.DiffViewerSettings;
import org.eclipse.team.svn.ui.preferences.SVNTeamDiffViewerPage;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public final class SVNTeamPreferences {
    public static final String DECORATION_BASE = "preference.decoration.";
    public static final String REPOSITORY_BASE = "preference.repository.";
    public static final String SYNCHRONIZE_BASE = "preference.synchronize.";
    public static final String HISTORY_BASE = "preference.history.";
    public static final String DATE_FORMAT_BASE = "preference.dateFormat.";
    public static final String PROMPT_BASE = "preference.prompt.";
    public static final String PROPERTIES_BASE = "preference.properties.";
    public static final String LOCKS_BASE = "preference.locks.";
    public static final String MAILREPORTER_BASE = "preference.mailreporter.";
    public static final String COMMENT_TEMPLATES_BASE = "preference.templates";
    public static final String COMMIT_DIALOG_BASE = "preference.commitDialog.";
    public static final String MERGE_BASE = "preference.merge.";
    public static final String CHECKOUT_BASE = "preference.checkout.";
    public static final String CONSOLE_BASE = "preference.console.";
    public static final String CORE_BASE = "preference.core.";
    public static final String AUTO_PROPERTIES_BASE = "preference.autoproperties";
    public static final String CUSTOM_PROPERTIES_BASE = "preference.customproperties";
    public static final String BEHAVIOUR_BASE = "preference.";
    public static final String BEHAVIOUR_COMMIT_SELECT_NEW_RESOURCES_NAME = "resourceSelection.selectNew";
    public static final String BEHAVIOUR_DO_NOT_SELECT_MISSING_RESOURCES_NAME = "resourceSelection.dontSelectMissing";
    public static final String BEHAVIOUR_DO_NOT_SELECT_EXTERNALS_NAME = "resourceSelection.treatExternalAsLocal";
    public static final String BEHAVIOUR_SHOW_SELECTED_RESOURCES_IN_SYNC_PANE_NAME = "resourceSelection.showResourcesInSyncPane";
    public static final String BEHAVIOUR_ENABLE_AUTO_SHARE_NAME = "share.enableAuto";
    public static final String BEHAVIOUR_COMPUTE_KEYWORDS_NAME = "keywords.computeValues";
    public static final String BEHAVIOUR_CASE_INSENSITIVE_TABLE_SORTING_NAME = "sorting.case.insensitive";
    public static final String BEHAVIOUR_IGNORE_EXTERNALS_NAME = "externals.ignore";
    public static final boolean BEHAVIOUR_CASE_INSENSITIVE_TABLE_SORTING_DEFAULT = true;
    public static final boolean BEHAVIOUR_COMPUTE_KEYWORDS_DEFAULT = true;
    public static final boolean BEHAVIOUR_ENABLE_AUTO_SHARE_DEFAULT = true;
    public static final boolean BEHAVIOUR_DO_NOT_SELECT_EXTERNAL_DEFAULT = true;
    public static final boolean BEHAVIOUR_SHOW_SELECTED_RESOURCES_IN_SYNC_PANE_DEFAULT = false;
    public static final boolean BEHAVIOUR_COMMIT_SELECT_NEW_RESOURCES_DEFAULT = true;
    public static final boolean BEHAVIOUR_DO_NOT_SELECT_MISSING_RESOURCES_NAME_DEFAULT = true;
    public static final boolean BEHAVIOUR_IGNORE_EXTERNALS_DEFAULT = false;
    public static final String CONSOLE_AUTOSHOW_TYPE_NAME = "autoshow";
    public static final String CONSOLE_HYPERLINKS_ENABLED_NAME = "hyperlinksEnabled";
    public static final String CONSOLE_FONT_NAME = "font";
    public static final String CONSOLE_WRAP_ENABLED_NAME = "wrapEnabled";
    public static final String CONSOLE_WRAP_WIDTH_NAME = "wrapWidth";
    public static final String CONSOLE_LIMIT_ENABLED_NAME = "limitEnabled";
    public static final String CONSOLE_LIMIT_VALUE_NAME = "limitRange";
    public static final String CORE_SVNCONNECTOR_NAME = "svnconnector";
    public static final String CORE_SVNCONNECTOR_DEFAULT = "org.eclipse.team.svn.connector.svnkit16";
    public static final String CONSOLE_ERR_COLOR_NAME = "error";
    public static final String CONSOLE_WRN_COLOR_NAME = "warning";
    public static final String CONSOLE_OK_COLOR_NAME = "ok";
    public static final String CONSOLE_CMD_COLOR_NAME = "command";
    public static final int CONSOLE_AUTOSHOW_TYPE_NEVER = 0;
    public static final int CONSOLE_AUTOSHOW_TYPE_ALWAYS = 1;
    public static final int CONSOLE_AUTOSHOW_TYPE_ERROR = 2;
    public static final int CONSOLE_AUTOSHOW_TYPE_WARNING_ERROR = 3;
    public static final int CONSOLE_AUTOSHOW_TYPE_DEFAULT = 0;
    public static final boolean CONSOLE_HYPERLINKS_ENABLED_DEFAULT = true;
    public static final boolean CONSOLE_WRAP_ENABLED_DEFAULT = false;
    public static final int CONSOLE_WRAP_WIDTH_DEFAULT = 80;
    public static final boolean CONSOLE_LIMIT_ENABLED_DEFAULT = true;
    public static final int CONSOLE_LIMIT_VALUE_DEFAULT = 500000;
    public static final RGB CONSOLE_ERR_COLOR_DEFAULT = new RGB(255, 0, 0);
    public static final RGB CONSOLE_WRN_COLOR_DEFAULT = new RGB(128, 0, 0);
    public static final RGB CONSOLE_OK_COLOR_DEFAULT = new RGB(0, 0, 255);
    public static final RGB CONSOLE_CMD_COLOR_DEFAULT = new RGB(0, 0, 0);
    public static final String MAILREPORTER_ENABLED_NAME = "enabled";
    public static final String MAILREPORTER_ERRORS_ENABLED_NAME = "errorsEnabled";
    public static final boolean MAILREPORTER_ENABLED_DEFAULT = true;
    public static final boolean MAILREPORTER_ERRORS_ENABLED_DEFAULT = true;
    public static final String MERGE_USE_JAVAHL_NAME = "useJavaHL";
    public static final String MERGE_INCLUDE_MERGED_NAME = "includeMerged";
    public static final boolean MERGE_USE_JAVAHL_DEFAULT = false;
    public static final boolean MERGE_INCLUDE_MERGED_DEFAULT = false;
    public static final String CHECKOUT_USE_DOT_PROJECT_NAME = "useDotProject";
    public static final String CHECKOUT_RESPECT_PROJECT_STRUCTURE_NAME = "respectProjectStructure";
    public static final boolean CHECKOUT_USE_DOT_PROJECT_DEFAULT = true;
    public static final boolean CHECKOUT_RESPECT_PROJECT_STRUCTURE_DEFAULT = false;
    public static final String HISTORY_PAGE_SIZE_NAME = "pageSize";
    public static final String HISTORY_PAGING_ENABLE_NAME = "pagingEnable";
    public static final String HISTORY_SHOW_MULTILINE_COMMENT_NAME = "multilineComment";
    public static final String HISTORY_SHOW_AFFECTED_PATHS_NAME = "affectedPaths";
    public static final String HISTORY_GROUPING_TYPE_NAME = "groupingType";
    public static final String HISTORY_REVISION_MODE_NAME = "revisionMode";
    public static final String HISTORY_HIERARCHICAL_LAYOUT = "hierarchicalLayout";
    public static final String HISTORY_COMPARE_MODE = "compareMode";
    public static final String HISTORY_CONNECT_TO_COMPARE_WITH_NAME = "connectToCompareWith";
    public static final int HISTORY_GROUPING_TYPE_NONE = 0;
    public static final int HISTORY_GROUPING_TYPE_DATE = 1;
    public static final int HISTORY_REVISION_MODE_BOTH = 0;
    public static final int HISTORY_REVISION_MODE_REMOTE = 1;
    public static final int HISTORY_REVISION_MODE_LOCAL = 2;
    public static final int HISTORY_PAGE_SIZE_DEFAULT = 25;
    public static final int HISTORY_GROUPING_TYPE_DEFAULT = 0;
    public static final int HISTORY_REVISION_MODE_DEFAULT = 1;
    public static final boolean HISTORY_PAGING_ENABLE_DEFAULT = true;
    public static final boolean HISTORY_SHOW_MULTILINE_COMMENT_DEFAULT = true;
    public static final boolean HISTORY_SHOW_AFFECTED_PATHS_DEFAULT = true;
    public static final boolean HISTORY_HIERARCHICAL_LAYOUT_DEFAULT = true;
    public static final boolean HISTORY_COMPARE_MODE_DEFAULT = false;
    public static final boolean HISTORY_CONNECT_TO_COMPARE_WITH_DEFAULT = true;
    public static final String DATE_FORMAT_NAME = "dateFormat";
    public static final String DATE_FORMAT_CUSTOM_NAME = "dateFormatCustom";
    public static final int DATE_FORMAT_MODE_SHORT = 0;
    public static final int DATE_FORMAT_MODE_MEDIUM = 1;
    public static final int DATE_FORMAT_MODE_LONG = 2;
    public static final int DATE_FORMAT_MODE_CUSTOM = 3;
    public static final int DATE_FORMAT_DEFAULT = 0;
    public static final String DATE_FORMAT_CUSTOM_DEFAULT = "";
    public static final String CONSULT_CHANGE_SETS_IN_COMMIT = "consultChangeSetsInCommit";
    public static final String CONSULT_CHANGE_SETS_IN_COMMIT_ALWAYS = "always";
    public static final String CONSULT_CHANGE_SETS_IN_COMMIT_NEVER = "never";
    public static final String CONSULT_CHANGE_SETS_IN_COMMIT_PROMPT = "prompt";
    public static final String CONSULT_CHANGE_SETS_IN_COMMIT_DEFAULT = "never";
    public static final String PROPERTY_LINK_WITH_EDITOR_NAME = "linkWithEditor";
    public static final boolean PROPERTY_LINK_WITH_EDITOR_DEFAULT = false;
    public static final String LOCKS_LINK_WITH_EDITOR_NAME = "locksLinkWithEditor";
    public static final boolean LOCKS_LINK_WITH_EDITOR_DEFAULT = false;
    public static final String ENABLE_MODEL_SYNC_NAME = "enableModelSync";
    public static final boolean ENABLE_MODEL_SYNC_DEFAULT = true;
    public static final String REPOSITORY_SHOW_BROWSER_NAME = "repositoryBrowser";
    public static final boolean REPOSITORY_SHOW_BROWSER_DEFAULT = true;
    public static final String REPOSITORY_FORCE_EXTERNALS_FREEZE_NAME = "forceExternalsFreeze";
    public static final boolean REPOSITORY_FORCE_EXTERNALS_FREEZE_DEFAULT = true;
    public static final String REPOSITORY_HEAD_NAME = "head";
    public static final String REPOSITORY_BRANCHES_NAME = "branches";
    public static final String REPOSITORY_TAGS_NAME = "tags";
    public static final String REPOSITORY_SHOW_EXTERNALS_NAME = "showExternals";
    public static final String REPOSITORY_SIMPLE_SHARE_NAME = "simpleShare";
    public static final String REPOSITORY_HEAD_DEFAULT = "trunk";
    public static final String REPOSITORY_BRANCHES_DEFAULT = "branches";
    public static final String REPOSITORY_TAGS_DEFAULT = "tags";
    public static final boolean REPOSITORY_SHOW_EXTERNALS_DEFAULT = true;
    public static final boolean REPOSITORY_SIMPLE_SHARE_DEFAULT = true;
    public static final String BRANCH_TAG_CREATION_MODE = "branchTagCreationMode";
    public static final int CREATION_MODE_ASIS = 0;
    public static final int CREATION_MODE_CHECKREVISION = 1;
    public static final int CREATION_MODE_DOUPDATE = 2;
    public static final int CREATION_MODE_REPOSITORY = 3;
    public static final String BRANCH_TAG_CONSIDER_STRUCTURE_NAME = "tagConsideringProjectStructure";
    public static final boolean BRANCH_TAG_CONSIDER_STRUCTURE_DEFAULT = true;
    public static final String DECORATION_FORMAT_FILE_NAME = "format.file";
    public static final String DECORATION_FORMAT_FOLDER_NAME = "format.folder";
    public static final String DECORATION_FORMAT_PROJECT_NAME = "format.project";
    public static final String DECORATION_FORMAT_FILE_DEFAULT = "{outgoing_flag} {name} {revision}";
    public static final String DECORATION_FORMAT_FOLDER_DEFAULT = "{outgoing_flag} {name} {revision}";
    public static final String DECORATION_FORMAT_PROJECT_DEFAULT = "{outgoing_flag} {name} {revision} [{location_label}{root_prefix}: {first_branchOrTag_child}]";
    public static final String DECORATION_FLAG_OUTGOING_NAME = "flag.outgoing";
    public static final String DECORATION_FLAG_ADDED_NAME = "flag.added";
    public static final String DECORATION_FLAG_OUTGOING_DEFAULT = ">";
    public static final String DECORATION_FLAG_ADDED_DEFAULT = "*";
    public static final String DECORATION_TRUNK_PREFIX_NAME = "trunk.branch";
    public static final String DECORATION_BRANCH_PREFIX_NAME = "prefix.branch";
    public static final String DECORATION_TAG_PREFIX_NAME = "prefix.tag";
    public static final String DECORATION_TRUNK_PREFIX_DEFAULT = ", Trunk";
    public static final String DECORATION_BRANCH_PREFIX_DEFAULT = ", Branch";
    public static final String DECORATION_TAG_PREFIX_DEFAULT = ", Tag";
    public static final String DECORATION_ICON_CONFLICTED_NAME = "icon.conflicted";
    public static final String DECORATION_ICON_MODIFIED_NAME = "icon.modified";
    public static final String DECORATION_ICON_REMOTE_NAME = "icon.remote";
    public static final String DECORATION_ICON_ADDED_NAME = "icon.added";
    public static final String DECORATION_ICON_NEW_NAME = "icon.new";
    public static final String DECORATION_ICON_LOCKED_NAME = "icon.locked";
    public static final String DECORATION_ICON_NEEDS_LOCK_NAME = "icon.needslock";
    public static final String DECORATION_ICON_SWITCHED_NAME = "icon.switched";
    public static final boolean DECORATION_ICON_CONFLICTED_DEFAULT = true;
    public static final boolean DECORATION_ICON_MODIFIED_DEFAULT = false;
    public static final boolean DECORATION_ICON_REMOTE_DEFAULT = true;
    public static final boolean DECORATION_ICON_ADDED_DEFAULT = true;
    public static final boolean DECORATION_ICON_NEW_DEFAULT = true;
    public static final boolean DECORATION_ICON_LOCKED_DEFAULT = true;
    public static final boolean DECORATION_ICON_NEEDS_LOCK_DEFAULT = false;
    public static final boolean DECORATION_ICON_SWITCHED_DEFAULT = true;
    public static final String DECORATION_COMPUTE_DEEP_NAME = "compute.deep";
    public static final String DECORATION_PRECISE_ENABLEMENTS_NAME = "precise.enablements";
    public static final String DECORATION_ENABLE_CACHE_NAME = "enable.cache";
    public static final String DECORATION_ENABLE_PERSISTENT_SSH_NAME = "enable.persistent.ssh";
    public static final boolean DECORATION_COMPUTE_DEEP_DEFAULT = true;
    public static final boolean DECORATION_PRECISE_ENABLEMENTS_DEFAULT = false;
    public static final boolean DECORATION_ENABLE_CACHE_DEFAULT = true;
    public static final boolean DECORATION_ENABLE_PERSISTENT_SSH_DEFAULT = true;
    public static final String DECORATION_USE_FONT_COLORS_DECOR_NAME = "use.fontdecor";
    public static final boolean DECORATION_USE_FONT_COLORS_DECOR_DEFAULT = false;
    public static final String NAME_OF_OUTGOING_FOREGROUND_COLOR = "outgoing_change_foreground_color";
    public static final String NAME_OF_OUTGOING_BACKGROUND_COLOR = "outgoing_change_background_color";
    public static final String NAME_OF_OUTGOING_FONT = "outgoing_change_font";
    public static final String NAME_OF_IGNORED_FOREGROUND_COLOR = "ignored_resource_foreground_color";
    public static final String NAME_OF_IGNORED_BACKGROUND_COLOR = "ignored_resource_background_color";
    public static final String NAME_OF_IGNORED_FONT = "ignored_resource_font";
    public static final String NAME_OF_NOT_RELATED_NODES_FOREGROUND_COLOR = "not_related_nodes_foreground_color";
    public static final String NAME_OF_NOT_RELATED_NODES_BACKGROUND_COLOR = "not_related_nodes_background_color";
    public static final String NAME_OF_NOT_RELATED_NODES_FONT = "not_related_nodes_font";
    public static final String NAME_OF_STRUCTURE_NODES_FOREGROUND_COLOR = "structure_nodes_foreground_color";
    public static final String NAME_OF_STRUCTURE_NODES_BACKGROUND_COLOR = "structure_nodes_background_color";
    public static final String NAME_OF_STRUCTURE_NODES_FONT = "structure_nodes_font";
    public static final String NAME_OF_MERGED_REVISIONS_FOREGROUND_COLOR = "merged_revision_foreground_color";
    public static final String COMMENT_TEMPLATES_LIST_NAME = "comment.templates";
    public static final String COMMENT_TEMPLATES_LIST_ENABLED_NAME = "comment.templates.enabled";
    public static final String COMMENT_LOG_TEMPLATES_ENABLED_NAME = "comment.logTemplates.enabled";
    public static final String COMMENT_SAVED_COMMENTS_COUNT_NAME = "savedCommentsCount";
    public static final String COMMENT_SAVED_PATHS_COUNT_NAME = "savedPathsCount";
    public static final String COMMENT_USE_SHIFT_ENTER_NAME = "useShiftEnter";
    public static final String COMMENT_TEMPLATES_LIST_DEFAULT = "";
    public static final boolean COMMENT_TEMPLATES_LIST_ENABLED_DEFAULT = true;
    public static final boolean COMMENT_LOG_TEMPLATES_ENABLED_DEFAULT = true;
    public static final int COMMENT_SAVED_COMMENTS_COUNT_DEFAULT = 10;
    public static final int COMMENT_SAVED_PATHS_COUNT_DEFAULT = 10;
    public static final boolean COMMENT_USE_SHIFT_ENTER_DEFAULT = false;
    public static final String COMMIT_DIALOG_WEIGHT_NAME = "CommitPanel.weight";
    public static final String COMMIT_DIALOG_KEEP_LOCKS = "CommitPanel.keepLocks";
    public static final int COMMIT_DIALOG_WEIGHT_DEFAULT = 50;
    public static final String LOCK_DIALOG_WEIGHT_NAME = "LockResourcesPanel.weight";
    public static final int LOCK_DIALOG_WEIGHT_DEFAULT = 50;
    public static final String FORCE_TEXT_MIME_NAME = "forceTextMime";
    public static final boolean FORCE_TEXT_MIME_DEFAULT = true;
    public static final String AUTO_PROPERTIES_LIST_NAME = "autoproperties";
    public static final String AUTO_PROPERTIES_LIST_DEFAULT = "";
    public static final String CUSTOM_PROPERTIES_LIST_NAME = "customproperties";
    public static final String CUSTOM_PROPERTIES_LIST_DEFAULT = "";
    public static final String DIFF_VIEWER_BASE = "preference.diffViewer.";
    public static final String DIFF_VIEWER_RESOURCES_SPECIFIC_PARAMETERS = "resources.specific.parameters";
    public static final String FIRST_STARTUP = "firstStartup";

    public static DateFormat getDateFormat(IPreferenceStore store) {
        int formatMode = SVNTeamPreferences.getDateFormatInt(store, DATE_FORMAT_NAME);
        DateFormat dateTimeFormat = null;
        switch (formatMode) {
            case 0: {
                dateTimeFormat = DateFormat.getDateTimeInstance((int)3, (int)3, (ULocale)ULocale.getDefault());
                break;
            }
            case 1: {
                dateTimeFormat = DateFormat.getDateTimeInstance((int)2, (int)2, (ULocale)ULocale.getDefault());
                break;
            }
            case 2: {
                dateTimeFormat = DateFormat.getDateTimeInstance((int)1, (int)1, (ULocale)ULocale.getDefault());
                break;
            }
            case 3: {
                dateTimeFormat = new SimpleDateFormat(SVNTeamPreferences.getDateFormatString(store, DATE_FORMAT_CUSTOM_NAME), ULocale.getDefault());
                break;
            }
            default: {
                dateTimeFormat = DateFormat.getDateTimeInstance((int)3, (int)3, (ULocale)ULocale.getDefault());
            }
        }
        return dateTimeFormat;
    }

    public static void setDefaultValues(IPreferenceStore store) {
        SVNTeamPreferences.setDefaultRepositoryValues(store);
        SVNTeamPreferences.setDefaultDecorationValues(store);
        SVNTeamPreferences.setDefaultPerformanceValues(store);
        SVNTeamPreferences.setDefaultSynchronizeValues(store);
        SVNTeamPreferences.setDefaultMailReporterValues(store);
        SVNTeamPreferences.setDefaultHistoryValues(store);
        SVNTeamPreferences.setDefaultDateFormatValues(store);
        SVNTeamPreferences.setDefaultPromptValues(store);
        SVNTeamPreferences.setDefaultPropertiesValues(store);
        SVNTeamPreferences.setDefaultCommentTemplatesValues(store);
        SVNTeamPreferences.setDefaultBehaviourValues(store);
        SVNTeamPreferences.setDefaultMergeValues(store);
        SVNTeamPreferences.setDefaultCheckoutValues(store);
        SVNTeamPreferences.setDefaultConsoleValues(store);
        SVNTeamPreferences.setDefaultCoreValues(store);
        SVNTeamPreferences.setDefaultCommitDialogValues(store);
        SVNTeamPreferences.setDefaultLockDialogValues(store);
        SVNTeamPreferences.setDefaultAutoPropertiesValues(store);
        SVNTeamPreferences.setDefaultCustomPropertiesValues(store);
        SVNTeamPreferences.setDefaultDiffViewerValues(store);
        store.setDefault(FIRST_STARTUP, true);
        store.setDefault(BRANCH_TAG_CREATION_MODE, 0);
    }

    public static void setDefaultAutoPropertiesValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullAutoPropertiesName(AUTO_PROPERTIES_LIST_NAME), "");
    }

    public static void setDefaultCustomPropertiesValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullCustomPropertiesName(CUSTOM_PROPERTIES_LIST_NAME), "");
    }

    public static void setDefaultDiffViewerValues(IPreferenceStore store) {
        DiffViewerSettings diffSettings = DiffViewerSettings.getDefaultDiffViewerSettings();
        SVNTeamDiffViewerPage.saveDiffViewerSettings(diffSettings, store, true);
    }

    public static void setDefaultCommitDialogValues(IPreferenceStore store) {
        store.setDefault(COMMIT_DIALOG_WEIGHT_NAME, 50);
        store.setDefault(COMMIT_DIALOG_KEEP_LOCKS, false);
    }

    public static void setDefaultLockDialogValues(IPreferenceStore store) {
        store.setDefault(LOCK_DIALOG_WEIGHT_NAME, 50);
    }

    public static void setDefaultCheckoutValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullCheckoutName(CHECKOUT_USE_DOT_PROJECT_NAME), true);
        store.setDefault(SVNTeamPreferences.fullCheckoutName(CHECKOUT_RESPECT_PROJECT_STRUCTURE_NAME), false);
    }

    public static void setDefaultMergeValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullMergeName(MERGE_USE_JAVAHL_NAME), false);
        store.setDefault(SVNTeamPreferences.fullMergeName(MERGE_INCLUDE_MERGED_NAME), false);
    }

    public static void setDefaultHistoryValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullHistoryName(HISTORY_CONNECT_TO_COMPARE_WITH_NAME), true);
        store.setDefault(SVNTeamPreferences.fullHistoryName(HISTORY_PAGE_SIZE_NAME), 25);
        store.setDefault(SVNTeamPreferences.fullHistoryName(HISTORY_PAGING_ENABLE_NAME), true);
        store.setDefault(SVNTeamPreferences.fullHistoryName(HISTORY_SHOW_MULTILINE_COMMENT_NAME), true);
        store.setDefault(SVNTeamPreferences.fullHistoryName(HISTORY_SHOW_AFFECTED_PATHS_NAME), true);
        store.setDefault(SVNTeamPreferences.fullHistoryName(HISTORY_GROUPING_TYPE_NAME), 0);
        store.setDefault(SVNTeamPreferences.fullHistoryName(HISTORY_REVISION_MODE_NAME), 1);
        store.setDefault(SVNTeamPreferences.fullHistoryName(HISTORY_HIERARCHICAL_LAYOUT), true);
        store.setDefault(SVNTeamPreferences.fullHistoryName(HISTORY_COMPARE_MODE), false);
    }

    public static void setDefaultDateFormatValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullDateFormatName(DATE_FORMAT_NAME), 0);
        store.setDefault(SVNTeamPreferences.fullDateFormatName(DATE_FORMAT_CUSTOM_NAME), "");
    }

    public static void setDefaultPromptValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullPromptName(CONSULT_CHANGE_SETS_IN_COMMIT), "never");
    }

    public static void setDefaultSynchronizeValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullSynchronizeName(ENABLE_MODEL_SYNC_NAME), true);
    }

    public static void setDefaultPropertiesValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullPropertiesName(FORCE_TEXT_MIME_NAME), true);
        store.setDefault(SVNTeamPreferences.fullPropertiesName(PROPERTY_LINK_WITH_EDITOR_NAME), false);
    }

    public static void setDefaultLocksValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullLocksName(LOCKS_LINK_WITH_EDITOR_NAME), false);
    }

    public static void setDefaultRepositoryValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullRepositoryName(REPOSITORY_HEAD_NAME), REPOSITORY_HEAD_DEFAULT);
        store.setDefault(SVNTeamPreferences.fullRepositoryName("branches"), "branches");
        store.setDefault(SVNTeamPreferences.fullRepositoryName("tags"), "tags");
        store.setDefault(SVNTeamPreferences.fullRepositoryName(REPOSITORY_SHOW_EXTERNALS_NAME), true);
        store.setDefault(SVNTeamPreferences.fullRepositoryName(REPOSITORY_SIMPLE_SHARE_NAME), true);
        store.setDefault(SVNTeamPreferences.fullRepositoryName(REPOSITORY_SHOW_BROWSER_NAME), true);
        store.setDefault(SVNTeamPreferences.fullRepositoryName(BRANCH_TAG_CONSIDER_STRUCTURE_NAME), true);
        store.setDefault(SVNTeamPreferences.fullRepositoryName(REPOSITORY_FORCE_EXTERNALS_FREEZE_NAME), true);
    }

    public static void setDefaultDecorationValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_FORMAT_FILE_NAME), "{outgoing_flag} {name} {revision}");
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_FORMAT_FOLDER_NAME), "{outgoing_flag} {name} {revision}");
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_FORMAT_PROJECT_NAME), DECORATION_FORMAT_PROJECT_DEFAULT);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_FLAG_OUTGOING_NAME), DECORATION_FLAG_OUTGOING_DEFAULT);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_FLAG_ADDED_NAME), DECORATION_FLAG_ADDED_DEFAULT);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_TRUNK_PREFIX_NAME), DECORATION_TRUNK_PREFIX_DEFAULT);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_BRANCH_PREFIX_NAME), DECORATION_BRANCH_PREFIX_DEFAULT);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_TAG_PREFIX_NAME), DECORATION_TAG_PREFIX_DEFAULT);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_CONFLICTED_NAME), true);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_MODIFIED_NAME), false);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_REMOTE_NAME), true);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_ADDED_NAME), true);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_NEW_NAME), true);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_LOCKED_NAME), true);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_NEEDS_LOCK_NAME), false);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_SWITCHED_NAME), true);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_USE_FONT_COLORS_DECOR_NAME), false);
    }

    public static void setDefaultPerformanceValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_COMPUTE_DEEP_NAME), true);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_PRECISE_ENABLEMENTS_NAME), false);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_ENABLE_CACHE_NAME), true);
        store.setDefault(SVNTeamPreferences.fullDecorationName(DECORATION_ENABLE_PERSISTENT_SSH_NAME), true);
    }

    public static void setDefaultMailReporterValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullMailReporterName(MAILREPORTER_ENABLED_NAME), true);
        store.setDefault(SVNTeamPreferences.fullMailReporterName(MAILREPORTER_ERRORS_ENABLED_NAME), true);
    }

    public static void setDefaultCommentTemplatesValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullCommentTemplatesName(COMMENT_TEMPLATES_LIST_NAME), "");
        store.setDefault(SVNTeamPreferences.fullCommentTemplatesName(COMMENT_TEMPLATES_LIST_ENABLED_NAME), true);
        store.setDefault(SVNTeamPreferences.fullCommentTemplatesName(COMMENT_LOG_TEMPLATES_ENABLED_NAME), true);
        store.setDefault(SVNTeamPreferences.fullCommentTemplatesName(COMMENT_SAVED_COMMENTS_COUNT_NAME), 10);
        store.setDefault(SVNTeamPreferences.fullCommentTemplatesName(COMMENT_SAVED_PATHS_COUNT_NAME), 10);
        store.setDefault(SVNTeamPreferences.fullCommentTemplatesName(COMMENT_USE_SHIFT_ENTER_NAME), false);
    }

    public static void setDefaultConsoleValues(final IPreferenceStore store) {
        UIMonitorUtility.getDisplay().asyncExec(new Runnable(){

            public void run() {
                PreferenceConverter.setDefault((IPreferenceStore)store, (String)SVNTeamPreferences.fullConsoleName(SVNTeamPreferences.CONSOLE_ERR_COLOR_NAME), (RGB)CONSOLE_ERR_COLOR_DEFAULT);
                PreferenceConverter.setDefault((IPreferenceStore)store, (String)SVNTeamPreferences.fullConsoleName(SVNTeamPreferences.CONSOLE_WRN_COLOR_NAME), (RGB)CONSOLE_WRN_COLOR_DEFAULT);
                PreferenceConverter.setDefault((IPreferenceStore)store, (String)SVNTeamPreferences.fullConsoleName(SVNTeamPreferences.CONSOLE_OK_COLOR_NAME), (RGB)CONSOLE_OK_COLOR_DEFAULT);
                PreferenceConverter.setDefault((IPreferenceStore)store, (String)SVNTeamPreferences.fullConsoleName(SVNTeamPreferences.CONSOLE_CMD_COLOR_NAME), (RGB)CONSOLE_CMD_COLOR_DEFAULT);
            }
        });
        store.setDefault(SVNTeamPreferences.fullConsoleName(CONSOLE_AUTOSHOW_TYPE_NAME), 0);
        store.setDefault(SVNTeamPreferences.fullConsoleName(CONSOLE_HYPERLINKS_ENABLED_NAME), true);
        store.setDefault(SVNTeamPreferences.fullConsoleName(CONSOLE_WRAP_ENABLED_NAME), false);
        store.setDefault(SVNTeamPreferences.fullConsoleName(CONSOLE_LIMIT_ENABLED_NAME), true);
        store.setDefault(SVNTeamPreferences.fullConsoleName(CONSOLE_WRAP_WIDTH_NAME), 80);
        store.setDefault(SVNTeamPreferences.fullConsoleName(CONSOLE_LIMIT_VALUE_NAME), 500000);
    }

    public static void setDefaultBehaviourValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_COMMIT_SELECT_NEW_RESOURCES_NAME), true);
        store.setDefault(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_DO_NOT_SELECT_MISSING_RESOURCES_NAME), true);
        store.setDefault(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_DO_NOT_SELECT_EXTERNALS_NAME), true);
        store.setDefault(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_SHOW_SELECTED_RESOURCES_IN_SYNC_PANE_NAME), false);
        store.setDefault(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_ENABLE_AUTO_SHARE_NAME), true);
        store.setDefault(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_COMPUTE_KEYWORDS_NAME), true);
        store.setDefault(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_CASE_INSENSITIVE_TABLE_SORTING_NAME), true);
        store.setDefault(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_IGNORE_EXTERNALS_NAME), false);
    }

    public static void setDefaultCoreValues(IPreferenceStore store) {
        store.setDefault(SVNTeamPreferences.fullCoreName(CORE_SVNCONNECTOR_NAME), CORE_SVNCONNECTOR_DEFAULT);
    }

    public static void resetToDefaultAutoPropsValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullAutoPropertiesName(AUTO_PROPERTIES_LIST_NAME), "");
    }

    public static void resetToDefaultCustomPropsValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullCustomPropertiesName(CUSTOM_PROPERTIES_LIST_NAME), "");
    }

    public static void resetToDefaultPropertiesValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullPropertiesName(FORCE_TEXT_MIME_NAME), true);
    }

    public static void resetToDefaultCoreValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullCoreName(CORE_SVNCONNECTOR_NAME), CORE_SVNCONNECTOR_DEFAULT);
    }

    public static void resetToDefaultHistoryValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullHistoryName(HISTORY_CONNECT_TO_COMPARE_WITH_NAME), true);
        store.setValue(SVNTeamPreferences.fullHistoryName(HISTORY_PAGE_SIZE_NAME), 25);
        store.setValue(SVNTeamPreferences.fullHistoryName(HISTORY_PAGING_ENABLE_NAME), true);
    }

    public static void resetToDefaultDateFormatValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullDateFormatName(DATE_FORMAT_NAME), 0);
        store.setValue(SVNTeamPreferences.fullDateFormatName(DATE_FORMAT_CUSTOM_NAME), "");
    }

    public static void resetToDefaultPromptValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullPromptName(CONSULT_CHANGE_SETS_IN_COMMIT), "never");
    }

    public static void resetToDefaultMailReporterValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullMailReporterName(MAILREPORTER_ENABLED_NAME), true);
        store.setValue(SVNTeamPreferences.fullMailReporterName(MAILREPORTER_ERRORS_ENABLED_NAME), true);
    }

    public static void resetToDefaultCheckoutValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullCheckoutName(CHECKOUT_USE_DOT_PROJECT_NAME), true);
        store.setValue(SVNTeamPreferences.fullCheckoutName(CHECKOUT_RESPECT_PROJECT_STRUCTURE_NAME), false);
    }

    public static void resetToDefaultMergeValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullMergeName(MERGE_USE_JAVAHL_NAME), false);
        store.setValue(SVNTeamPreferences.fullMergeName(MERGE_INCLUDE_MERGED_NAME), false);
    }

    public static void resetToDefaultBehaviourValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_COMMIT_SELECT_NEW_RESOURCES_NAME), true);
        store.setValue(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_DO_NOT_SELECT_MISSING_RESOURCES_NAME), true);
        store.setValue(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_DO_NOT_SELECT_EXTERNALS_NAME), true);
        store.setValue(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_SHOW_SELECTED_RESOURCES_IN_SYNC_PANE_NAME), false);
        store.setValue(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_ENABLE_AUTO_SHARE_NAME), true);
        store.setValue(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_COMPUTE_KEYWORDS_NAME), true);
        store.setValue(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_CASE_INSENSITIVE_TABLE_SORTING_NAME), true);
        store.setValue(SVNTeamPreferences.fullBehaviourName(BEHAVIOUR_IGNORE_EXTERNALS_NAME), false);
    }

    public static void resetToDefaultSynchronizeValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullSynchronizeName(ENABLE_MODEL_SYNC_NAME), true);
    }

    public static void resetToDefaultRepositoryValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullRepositoryName(REPOSITORY_HEAD_NAME), REPOSITORY_HEAD_DEFAULT);
        store.setValue(SVNTeamPreferences.fullRepositoryName("branches"), "branches");
        store.setValue(SVNTeamPreferences.fullRepositoryName("tags"), "tags");
        store.setValue(SVNTeamPreferences.fullRepositoryName(REPOSITORY_SIMPLE_SHARE_NAME), true);
        store.setValue(SVNTeamPreferences.fullRepositoryName(REPOSITORY_SHOW_BROWSER_NAME), true);
        store.setValue(SVNTeamPreferences.fullRepositoryName(BRANCH_TAG_CONSIDER_STRUCTURE_NAME), true);
        store.setValue(SVNTeamPreferences.fullRepositoryName(REPOSITORY_FORCE_EXTERNALS_FREEZE_NAME), true);
    }

    public static void resetToDefaultDecorationValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_FORMAT_FILE_NAME), "{outgoing_flag} {name} {revision}");
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_FORMAT_FOLDER_NAME), "{outgoing_flag} {name} {revision}");
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_FORMAT_PROJECT_NAME), DECORATION_FORMAT_PROJECT_DEFAULT);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_FLAG_OUTGOING_NAME), DECORATION_FLAG_OUTGOING_DEFAULT);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_FLAG_ADDED_NAME), DECORATION_FLAG_ADDED_DEFAULT);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_TRUNK_PREFIX_NAME), DECORATION_TRUNK_PREFIX_DEFAULT);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_BRANCH_PREFIX_NAME), DECORATION_BRANCH_PREFIX_DEFAULT);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_TAG_PREFIX_NAME), DECORATION_TAG_PREFIX_DEFAULT);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_CONFLICTED_NAME), true);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_MODIFIED_NAME), false);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_REMOTE_NAME), true);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_ADDED_NAME), true);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_NEW_NAME), true);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_LOCKED_NAME), true);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_NEEDS_LOCK_NAME), false);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_ICON_SWITCHED_NAME), true);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_USE_FONT_COLORS_DECOR_NAME), false);
    }

    public static void resetToDefaultPerformanceValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_COMPUTE_DEEP_NAME), true);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_PRECISE_ENABLEMENTS_NAME), false);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_ENABLE_CACHE_NAME), true);
        store.setValue(SVNTeamPreferences.fullDecorationName(DECORATION_ENABLE_PERSISTENT_SSH_NAME), true);
    }

    public static void resetToDefaultCommentTemplatesValues(IPreferenceStore store) {
        store.setValue(SVNTeamPreferences.fullCommentTemplatesName(COMMENT_TEMPLATES_LIST_NAME), "");
        store.setValue(SVNTeamPreferences.fullCommentTemplatesName(COMMENT_TEMPLATES_LIST_ENABLED_NAME), true);
        store.setValue(SVNTeamPreferences.fullCommentTemplatesName(COMMENT_LOG_TEMPLATES_ENABLED_NAME), true);
        store.setValue(SVNTeamPreferences.fullCommentTemplatesName(COMMENT_SAVED_COMMENTS_COUNT_NAME), 10);
        store.setValue(SVNTeamPreferences.fullCommentTemplatesName(COMMENT_SAVED_PATHS_COUNT_NAME), 10);
        store.setValue(SVNTeamPreferences.fullCommentTemplatesName(COMMENT_USE_SHIFT_ENTER_NAME), false);
    }

    public static void resetToDefaultConsoleValues(IPreferenceStore store) {
        SVNTeamPreferences.setConsoleRGB(store, CONSOLE_ERR_COLOR_NAME, CONSOLE_ERR_COLOR_DEFAULT);
        SVNTeamPreferences.setConsoleRGB(store, CONSOLE_WRN_COLOR_NAME, CONSOLE_WRN_COLOR_DEFAULT);
        SVNTeamPreferences.setConsoleRGB(store, CONSOLE_OK_COLOR_NAME, CONSOLE_OK_COLOR_DEFAULT);
        SVNTeamPreferences.setConsoleRGB(store, CONSOLE_CMD_COLOR_NAME, CONSOLE_CMD_COLOR_DEFAULT);
        store.setValue(SVNTeamPreferences.fullConsoleName(CONSOLE_AUTOSHOW_TYPE_NAME), 0);
        store.setValue(SVNTeamPreferences.fullConsoleName(CONSOLE_HYPERLINKS_ENABLED_NAME), true);
        store.setValue(SVNTeamPreferences.fullConsoleName(CONSOLE_WRAP_ENABLED_NAME), false);
        store.setValue(SVNTeamPreferences.fullConsoleName(CONSOLE_LIMIT_ENABLED_NAME), true);
        store.setValue(SVNTeamPreferences.fullConsoleName(CONSOLE_WRAP_WIDTH_NAME), 80);
        store.setValue(SVNTeamPreferences.fullConsoleName(CONSOLE_LIMIT_VALUE_NAME), 500000);
    }

    public static int getDialogInt(IPreferenceStore store, String name) {
        return store.getInt(name);
    }

    public static boolean getCheckoutBoolean(IPreferenceStore store, String shortName) {
        return store.getBoolean(SVNTeamPreferences.fullCheckoutName(shortName));
    }

    public static boolean getMergeBoolean(IPreferenceStore store, String shortName) {
        return store.getBoolean(SVNTeamPreferences.fullMergeName(shortName));
    }

    public static boolean getSynchronizeBoolean(IPreferenceStore store, String shortName) {
        return store.getBoolean(SVNTeamPreferences.fullSynchronizeName(shortName));
    }

    public static boolean getPropertiesBoolean(IPreferenceStore store, String shortName) {
        return store.getBoolean(SVNTeamPreferences.fullPropertiesName(shortName));
    }

    public static String getRepositoryString(IPreferenceStore store, String shortName) {
        return store.getString(SVNTeamPreferences.fullRepositoryName(shortName));
    }

    public static boolean getRepositoryBoolean(IPreferenceStore store, String shortName) {
        return store.getBoolean(SVNTeamPreferences.fullRepositoryName(shortName));
    }

    public static String getDecorationString(IPreferenceStore store, String shortName) {
        return store.getString(SVNTeamPreferences.fullDecorationName(shortName));
    }

    public static String fullDiffViewerName(String shortName) {
        return DIFF_VIEWER_BASE + shortName;
    }

    public static String getDiffViewerString(IPreferenceStore store, String shortName) {
        return store.getString(SVNTeamPreferences.fullDiffViewerName(shortName));
    }

    public static void setDiffViewerString(IPreferenceStore store, String shortName, String value, boolean isDefault) {
        if (isDefault) {
            store.setDefault(SVNTeamPreferences.fullDiffViewerName(shortName), value);
        } else {
            store.setValue(SVNTeamPreferences.fullDiffViewerName(shortName), value);
        }
    }

    public static boolean getDiffViewerBoolean(IPreferenceStore store, String shortName) {
        return store.getBoolean(SVNTeamPreferences.fullDiffViewerName(shortName));
    }

    public static void setDiffViewerBoolean(IPreferenceStore store, String shortName, boolean value, boolean isDefault) {
        if (isDefault) {
            store.setDefault(SVNTeamPreferences.fullDiffViewerName(shortName), value);
        } else {
            store.setValue(SVNTeamPreferences.fullDiffViewerName(shortName), value);
        }
    }

    public static int getHistoryInt(IPreferenceStore store, String shortName) {
        return store.getInt(SVNTeamPreferences.fullHistoryName(shortName));
    }

    public static boolean getHistoryBoolean(IPreferenceStore store, String shortName) {
        return store.getBoolean(SVNTeamPreferences.fullHistoryName(shortName));
    }

    public static int getDateFormatInt(IPreferenceStore store, String shortName) {
        return store.getInt(SVNTeamPreferences.fullDateFormatName(shortName));
    }

    public static String getDateFormatString(IPreferenceStore store, String shortName) {
        return store.getString(SVNTeamPreferences.fullDateFormatName(shortName));
    }

    public static String getConsultChangeSetsInCommit(IPreferenceStore store, String shortName) {
        return store.getString(SVNTeamPreferences.fullPromptName(shortName));
    }

    public static boolean getBehaviourBoolean(IPreferenceStore store, String shortName) {
        return store.getBoolean(SVNTeamPreferences.fullBehaviourName(shortName));
    }

    public static boolean getDecorationBoolean(IPreferenceStore store, String shortName) {
        return store.getBoolean(SVNTeamPreferences.fullDecorationName(shortName));
    }

    public static String getCommentTemplatesString(IPreferenceStore store, String shortName) {
        return store.getString(SVNTeamPreferences.fullCommentTemplatesName(shortName));
    }

    public static int getCommentTemplatesInt(IPreferenceStore store, String shortName) {
        return store.getInt(SVNTeamPreferences.fullCommentTemplatesName(shortName));
    }

    public static boolean getCommentTemplatesBoolean(IPreferenceStore store, String shortName) {
        return store.getBoolean(SVNTeamPreferences.fullCommentTemplatesName(shortName));
    }

    public static String getAutoPropertiesList(IPreferenceStore store, String shortName) {
        return store.getString(SVNTeamPreferences.fullAutoPropertiesName(shortName));
    }

    public static String getCustomPropertiesList(IPreferenceStore store, String shortName) {
        return store.getString(SVNTeamPreferences.fullCustomPropertiesName(shortName));
    }

    public static void setDialogInt(IPreferenceStore store, String name, int value) {
        store.setValue(name, value);
    }

    public static void setCheckoutBoolean(IPreferenceStore store, String shortName, boolean value) {
        store.setValue(SVNTeamPreferences.fullCheckoutName(shortName), value);
    }

    public static void setMergeBoolean(IPreferenceStore store, String shortName, boolean value) {
        store.setValue(SVNTeamPreferences.fullMergeName(shortName), value);
    }

    public static void setSynchronizeBoolean(IPreferenceStore store, String shortName, boolean value) {
        store.setValue(SVNTeamPreferences.fullSynchronizeName(shortName), value);
    }

    public static void setPropertiesBoolean(IPreferenceStore store, String shortName, boolean value) {
        store.setValue(SVNTeamPreferences.fullPropertiesName(shortName), value);
    }

    public static void setRepositoryString(IPreferenceStore store, String shortName, String value) {
        store.setValue(SVNTeamPreferences.fullRepositoryName(shortName), value);
    }

    public static void setRepositoryBoolean(IPreferenceStore store, String shortName, boolean value) {
        store.setValue(SVNTeamPreferences.fullRepositoryName(shortName), value);
    }

    public static void setDecorationString(IPreferenceStore store, String shortName, String value) {
        store.setValue(SVNTeamPreferences.fullDecorationName(shortName), value);
    }

    public static void setDecorationBoolean(IPreferenceStore store, String shortName, boolean value) {
        store.setValue(SVNTeamPreferences.fullDecorationName(shortName), value);
    }

    public static void setHistoryBoolean(IPreferenceStore store, String shortName, boolean value) {
        store.setValue(SVNTeamPreferences.fullHistoryName(shortName), value);
    }

    public static void setBehaviourBoolean(IPreferenceStore store, String shortName, boolean value) {
        store.setValue(SVNTeamPreferences.fullBehaviourName(shortName), value);
    }

    public static void setHistoryInt(IPreferenceStore store, String shortName, int value) {
        store.setValue(SVNTeamPreferences.fullHistoryName(shortName), value);
    }

    public static void setDateFormatInt(IPreferenceStore store, String shortName, int value) {
        store.setValue(SVNTeamPreferences.fullDateFormatName(shortName), value);
    }

    public static void setDateFormatString(IPreferenceStore store, String shortName, String value) {
        store.setValue(SVNTeamPreferences.fullDateFormatName(shortName), value);
    }

    public static void setConsultChangeSetsInCommit(IPreferenceStore store, String shortName, String value) {
        store.setValue(SVNTeamPreferences.fullPromptName(shortName), value);
    }

    public static boolean getMailReporterBoolean(IPreferenceStore store, String shortName) {
        return store.getBoolean(SVNTeamPreferences.fullMailReporterName(shortName));
    }

    public static void setMailReporterBoolean(IPreferenceStore store, String shortName, boolean value) {
        store.setValue(SVNTeamPreferences.fullMailReporterName(shortName), value);
    }

    public static void setCommentTemplatesInt(IPreferenceStore store, String shortName, int value) {
        store.setValue(SVNTeamPreferences.fullCommentTemplatesName(shortName), value);
    }

    public static void setCommentTemplatesString(IPreferenceStore store, String shortName, String value) {
        store.setValue(SVNTeamPreferences.fullCommentTemplatesName(shortName), value);
    }

    public static void setCommentTemplatesBoolean(IPreferenceStore store, String shortName, boolean value) {
        store.setValue(SVNTeamPreferences.fullCommentTemplatesName(shortName), value);
    }

    public static void setAutoPropertiesList(IPreferenceStore store, String shortName, String value) {
        store.setValue(SVNTeamPreferences.fullAutoPropertiesName(shortName), value);
    }

    public static void setCustomPropertiesList(IPreferenceStore store, String shortName, String value) {
        store.setValue(SVNTeamPreferences.fullCustomPropertiesName(shortName), value);
    }

    public static RGB getConsoleRGB(IPreferenceStore store, String shortName) {
        return PreferenceConverter.getColor((IPreferenceStore)store, (String)SVNTeamPreferences.fullConsoleName(shortName));
    }

    public static void setConsoleRGB(IPreferenceStore store, String shortName, RGB value) {
        PreferenceConverter.setValue((IPreferenceStore)store, (String)SVNTeamPreferences.fullConsoleName(shortName), (RGB)value);
    }

    public static int getConsoleInt(IPreferenceStore store, String shortName) {
        return store.getInt(SVNTeamPreferences.fullConsoleName(shortName));
    }

    public static void setConsoleInt(IPreferenceStore store, String shortName, int value) {
        store.setValue(SVNTeamPreferences.fullConsoleName(shortName), value);
    }

    public static boolean getConsoleBoolean(IPreferenceStore store, String shortName) {
        return store.getBoolean(SVNTeamPreferences.fullConsoleName(shortName));
    }

    public static void setConsoleBoolean(IPreferenceStore store, String shortName, boolean value) {
        store.setValue(SVNTeamPreferences.fullConsoleName(shortName), value);
    }

    public static String getCoreString(IPreferenceStore store, String shortName) {
        return store.getString(SVNTeamPreferences.fullCoreName(shortName));
    }

    public static void setCoreString(IPreferenceStore store, String shortName, String value) {
        store.setValue(SVNTeamPreferences.fullCoreName(shortName), value);
    }

    public static String fullCommitDialogName(String shortName) {
        return COMMIT_DIALOG_BASE + shortName;
    }

    public static String fullCheckoutName(String shortName) {
        return CHECKOUT_BASE + shortName;
    }

    public static String fullMergeName(String shortName) {
        return MERGE_BASE + shortName;
    }

    public static String fullDecorationName(String shortName) {
        return DECORATION_BASE + shortName;
    }

    public static String fullRepositoryName(String shortName) {
        return REPOSITORY_BASE + shortName;
    }

    public static String fullSynchronizeName(String shortName) {
        return SYNCHRONIZE_BASE + shortName;
    }

    public static String fullPropertiesName(String shortName) {
        return PROPERTIES_BASE + shortName;
    }

    public static String fullLocksName(String shortName) {
        return LOCKS_BASE + shortName;
    }

    public static String fullHistoryName(String shortName) {
        return HISTORY_BASE + shortName;
    }

    public static String fullDateFormatName(String shortName) {
        return DATE_FORMAT_BASE + shortName;
    }

    public static String fullPromptName(String shortName) {
        return PROMPT_BASE + shortName;
    }

    public static String fullBehaviourName(String shortName) {
        return BEHAVIOUR_BASE + shortName;
    }

    public static String fullMailReporterName(String shortName) {
        return MAILREPORTER_BASE + shortName;
    }

    public static String fullCommitSelectName(String shortName) {
        return COMMENT_TEMPLATES_BASE + shortName;
    }

    public static String fullCommentTemplatesName(String shortName) {
        return COMMENT_TEMPLATES_BASE + shortName;
    }

    public static String fullConsoleName(String shortName) {
        return CONSOLE_BASE + shortName;
    }

    public static String fullCoreName(String shortName) {
        return CORE_BASE + shortName;
    }

    public static String fullAutoPropertiesName(String shortName) {
        return AUTO_PROPERTIES_BASE + shortName;
    }

    public static String fullCustomPropertiesName(String shortName) {
        return CUSTOM_PROPERTIES_BASE + shortName;
    }

    private SVNTeamPreferences() {
    }
}

