/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.types.internal.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.uml2.types.TypesFactory;
import org.eclipse.uml2.types.TypesPackage;

public class TypesFactoryImpl
extends EFactoryImpl
implements TypesFactory {
    public static TypesFactory init() {
        try {
            TypesFactory theTypesFactory = (TypesFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/uml2/4.0.0/Types");
            if (theTypesFactory != null) {
                return theTypesFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new TypesFactoryImpl();
    }

    public EObject create(EClass eClass) {
        eClass.getClassifierID();
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 0: {
                return this.createBooleanFromString(eDataType, initialValue);
            }
            case 1: {
                return this.createIntegerFromString(eDataType, initialValue);
            }
            case 2: {
                return this.createRealFromString(eDataType, initialValue);
            }
            case 3: {
                return this.createStringFromString(eDataType, initialValue);
            }
            case 4: {
                return this.createUnlimitedNaturalFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 0: {
                return this.convertBooleanToString(eDataType, instanceValue);
            }
            case 1: {
                return this.convertIntegerToString(eDataType, instanceValue);
            }
            case 2: {
                return this.convertRealToString(eDataType, instanceValue);
            }
            case 3: {
                return this.convertStringToString(eDataType, instanceValue);
            }
            case 4: {
                return this.convertUnlimitedNaturalToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public Boolean createBooleanFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : Boolean.valueOf(initialValue);
    }

    public String convertBooleanToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Integer createIntegerFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : Integer.valueOf(initialValue);
    }

    public String convertIntegerToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public Double createRealFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : Double.valueOf(initialValue);
    }

    public String convertRealToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public String createStringFromString(EDataType eDataType, String initialValue) {
        return initialValue;
    }

    public String convertStringToString(EDataType eDataType, Object instanceValue) {
        return (String)instanceValue;
    }

    public Integer createUnlimitedNaturalFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : ("*".equals(initialValue) ? new Integer(-1) : Integer.valueOf(initialValue));
    }

    public String convertUnlimitedNaturalToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : ((Integer)instanceValue == -1 ? "*" : instanceValue.toString());
    }

    public TypesPackage getTypesPackage() {
        return (TypesPackage)this.getEPackage();
    }

    @Deprecated
    public static TypesPackage getPackage() {
        return TypesPackage.eINSTANCE;
    }
}

