/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.gef.part.AbstractComponentEditPart;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.requests.KeyRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.policies.DirectTextEditPolicy;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.property.GenericPropertyImpl;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.util.PropertyUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;

public final class DirectTextPropertyEditPolicy
extends DirectTextEditPolicy {
    public static final Object KEY = DirectTextPropertyEditPolicy.class;
    private final AbstractComponentInfo m_component;
    private final Property m_property;
    private static final String KEY_ALREADY_EDITED = "alreadyDirectEdited";

    public static void install(AbstractComponentEditPart editPart) {
        AbstractComponentInfo component = editPart.getComponent();
        DirectTextPropertyEditPolicy.install(editPart, component);
    }

    public static void install(final EditPart editPart, final AbstractComponentInfo component) {
        ExecutionUtils.runLog(new RunnableEx(){

            public void run() throws Exception {
                DirectTextPropertyEditPolicy.installEx(editPart, component);
            }
        });
    }

    private static void installEx(EditPart editPart, AbstractComponentInfo component) throws Exception {
        Property property;
        Property[] propertyArray = component.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property2 = propertyArray[n2];
            if (property2 instanceof GenericPropertyImpl) {
                GenericPropertyImpl genericProperty = (GenericPropertyImpl)property2;
                GenericPropertyDescription description = genericProperty.getDescription();
                if (genericProperty.getJavaInfo() == component && description != null && description.hasTrueTag("isText")) {
                    DirectTextPropertyEditPolicy policy = new DirectTextPropertyEditPolicy(component, property2);
                    editPart.installEditPolicy(KEY, policy);
                    return;
                }
            }
            ++n2;
        }
        String propertyPath = component.getDescription().getParameter("directEdit.property");
        if (propertyPath != null && (property = PropertyUtils.getByPath(component, propertyPath)) != null) {
            DirectTextPropertyEditPolicy policy = new DirectTextPropertyEditPolicy(component, property);
            editPart.installEditPolicy(policy);
            return;
        }
    }

    public DirectTextPropertyEditPolicy(AbstractComponentInfo component, Property property) {
        this.m_component = component;
        this.m_property = property;
    }

    protected String getText() {
        return ExecutionUtils.runObjectLog(new RunnableObjectEx<String>(){

            @Override
            public String runObject() throws Exception {
                return (String)DirectTextPropertyEditPolicy.this.m_property.getValue();
            }
        }, "");
    }

    protected void setText(final String text) {
        ExecutionUtils.runLog(new RunnableEx(){

            public void run() throws Exception {
                DirectTextPropertyEditPolicy.this.m_property.setValue(text);
            }
        });
    }

    protected Point getTextWidgetLocation(Rectangle hostBounds, Dimension textSize) {
        try {
            int y;
            int x;
            String horizontalAlignment;
            String insetsString = JavaInfoUtils.getParameter(this.m_component, "directEdit.location.insets");
            if (insetsString != null) {
                String[] insetsElements = StringUtils.split((String)insetsString);
                Assert.equals(4, insetsElements.length);
                hostBounds.y += Integer.parseInt(insetsElements[0]);
                hostBounds.x += Integer.parseInt(insetsElements[1]);
                hostBounds.height -= Integer.parseInt(insetsElements[2]);
                hostBounds.width -= Integer.parseInt(insetsElements[3]);
            }
            if ((horizontalAlignment = JavaInfoUtils.getParameter(this.m_component, "directEdit.location.horizontalAlignment")) == null || "center".equals(horizontalAlignment)) {
                x = hostBounds.getCenter().x - textSize.width / 2;
            } else if ("left".equals(horizontalAlignment)) {
                x = hostBounds.left();
            } else {
                throw new IllegalArgumentException("Unknown horizontal alignment: " + horizontalAlignment);
            }
            String verticalAlignment = JavaInfoUtils.getParameter(this.m_component, "directEdit.location.verticalAlignment");
            if (verticalAlignment == null || "center".equals(verticalAlignment)) {
                y = hostBounds.getCenter().y - textSize.height / 2;
            } else if ("top".equals(verticalAlignment)) {
                y = hostBounds.top();
            } else {
                throw new IllegalArgumentException("Unknown vertical alignment: " + verticalAlignment);
            }
            return new Point(x, y);
        }
        catch (Throwable e) {
            throw new Error("Direct edit location for " + this.m_component, e);
        }
    }

    public void activate() {
        super.activate();
        IPreferenceStore preferences = this.m_component.getDescription().getToolkit().getPreferences();
        if (preferences.getBoolean("general.directEditAfterAdd") && this.m_component.getArbitraryValue("manuallyCreatedComponent") == Boolean.TRUE && this.m_component.getArbitraryValue(KEY_ALREADY_EDITED) == null) {
            this.m_component.putArbitraryValue(KEY_ALREADY_EDITED, Boolean.TRUE);
            this.beginEdit();
        }
    }

    public void performRequest(Request request) {
        KeyRequest keyRequest;
        if (request instanceof KeyRequest && (keyRequest = (KeyRequest)request).isPressed() && keyRequest.getCharacter() == ' ') {
            this.beginEdit();
        }
        super.performRequest(request);
    }
}

