/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.model.ui;

import com.google.common.collect.Lists;
import com.jgoodies.forms.factories.FormFactory;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormRowInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.ModelMessages;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.DimensionsDialog;
import org.eclipse.wb.internal.swing.FormLayout.model.ui.RowEditDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RowsDialog
extends DimensionsDialog<FormRowInfo> {
    public RowsDialog(Shell parentShell, FormLayoutInfo layout) {
        super(parentShell, layout, RowsDialog.createRowsCopy(layout), layout.getMinimumSize().width);
    }

    private static List<FormRowInfo> createRowsCopy(final FormLayoutInfo layout) {
        final List rows = Lists.newArrayList();
        ExecutionUtils.runRethrow((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                for (FormRowInfo row : layout.getRows()) {
                    rows.add(row.copy());
                }
            }
        });
        return rows;
    }

    @Override
    protected void updateLayoutInfo(List<FormRowInfo> dimensions) throws Exception {
        this.m_layout.setRows(dimensions);
    }

    @Override
    protected String getDialogTitle() {
        return ModelMessages.RowsDialog_dialogTitle;
    }

    @Override
    protected String getDialogMessage() {
        return ModelMessages.RowsDialog_dialogMessage;
    }

    @Override
    protected String getViewerTitle() {
        return ModelMessages.RowsDialog_viewerTitle;
    }

    @Override
    protected String getMinimalErrorMessage(int minimumDimensions) {
        return MessageFormat.format(ModelMessages.RowsDialog_minimalErrorMesssage, minimumDimensions);
    }

    @Override
    protected boolean editSelectedDimension(List<FormRowInfo> dimensions, FormRowInfo column) {
        return new RowEditDialog(this.getShell(), dimensions, column).open() == 0;
    }

    @Override
    protected FormRowInfo createNewDimension() throws Exception {
        return new FormRowInfo(FormFactory.DEFAULT_ROWSPEC);
    }
}

