/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.widgets;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoPresentationDecorateText;
import org.eclipse.wb.internal.core.model.presentation.IObjectPresentation;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.XmlObjectPresentation;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.association.Associations;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;
import org.eclipse.wb.internal.xwt.model.widgets.AbstractPositionInfo;
import org.eclipse.wb.internal.xwt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;

public abstract class AbstractPositionCompositeInfo
extends CompositeInfo {
    private final String[] m_properties;
    private final AbstractPositionInfo[] m_positions;
    private final IObjectPresentation m_presentation = new XmlObjectPresentation((XmlObjectInfo)this){

        public List<ObjectInfo> getChildrenTree() throws Exception {
            List children = Lists.newArrayList((Iterable)super.getChildrenTree());
            Set positionedControls = Sets.newHashSet();
            int i = 0;
            while (i < AbstractPositionCompositeInfo.this.m_properties.length) {
                String property = AbstractPositionCompositeInfo.this.m_properties[i];
                ControlInfo control = AbstractPositionCompositeInfo.this.getControl(property);
                if (control != null && !positionedControls.contains((Object)control)) {
                    positionedControls.add(control);
                    children.remove((Object)control);
                    children.add(i, control);
                } else {
                    children.add(i, AbstractPositionCompositeInfo.this.m_positions[i]);
                }
                ++i;
            }
            return children;
        }
    };

    public AbstractPositionCompositeInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport, String[] properties) throws Exception {
        super(context, description, creationSupport);
        this.m_properties = properties;
        this.m_positions = new AbstractPositionInfo[this.m_properties.length];
        int i = 0;
        while (i < this.m_properties.length) {
            String method = this.m_properties[i];
            this.m_positions[i] = new AbstractPositionInfo(this, method);
            ++i;
        }
    }

    protected void initialize() throws Exception {
        super.initialize();
        this.addBroadcastListener(new ObjectInfoPresentationDecorateText(){

            public void invoke(ObjectInfo object, String[] text) throws Exception {
                if (object instanceof ControlInfo && object.getParent() == AbstractPositionCompositeInfo.this) {
                    String[] stringArray = AbstractPositionCompositeInfo.this.m_properties;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String method = stringArray[n2];
                        if (AbstractPositionCompositeInfo.this.getControl(method) == object) {
                            text[0] = String.valueOf(method) + " - " + text[0];
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    public final ControlInfo getControl(String property) {
        for (ControlInfo control : this.getChildrenControls()) {
            DocumentElement controlElement = control.getCreationSupport().getElement();
            String propertyTag = controlElement.getParent().getTag();
            if (!propertyTag.endsWith("." + property)) continue;
            return control;
        }
        return null;
    }

    public IObjectPresentation getPresentation() {
        return this.m_presentation;
    }

    public final void command_CREATE(ControlInfo control, String property) throws Exception {
        XmlObjectUtils.add((XmlObjectInfo)control, (Association)Associations.property((String)property), (XmlObjectInfo)this, null);
    }

    public final void command_MOVE(ControlInfo control, String property) throws Exception {
        ControlInfo nextControl = this.getNextControl(control, property);
        XmlObjectUtils.move((XmlObjectInfo)control, (Association)Associations.property((String)property), (XmlObjectInfo)this, (XmlObjectInfo)nextControl);
    }

    private ControlInfo getNextControl(ControlInfo movingControl, String property) {
        int index = ArrayUtils.indexOf((Object[])this.m_properties, (Object)property);
        Assert.isLegal((index >= 0 ? 1 : 0) != 0, (String)("Invalid position: " + property));
        int i = index + 1;
        while (i < this.m_properties.length) {
            String method = this.m_properties[i];
            ControlInfo propertyControl = this.getControl(method);
            if (propertyControl != null && propertyControl != movingControl) {
                return propertyControl;
            }
            ++i;
        }
        return null;
    }
}

