/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.ui.JavaScriptImageRegistry;
import org.eclipse.wst.jsdt.debug.internal.ui.eval.EvaluationManager;
import org.osgi.framework.BundleContext;

public class JavaScriptDebugUIPlugin
extends AbstractUIPlugin
implements IWorkbenchListener {
    public static final int INTERNAL_ERROR = 120;
    public static final String PLUGIN_ID = "org.eclipse.wst.jsdt.debug.ui";
    private static JavaScriptDebugUIPlugin plugin;
    private static ScopedPreferenceStore corestore;

    static {
        corestore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.wst.jsdt.debug.core");
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)this);
        EvaluationManager.getManager().start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext context) throws Exception {
        try {
            plugin = null;
            PlatformUI.getWorkbench().removeWorkbenchListener((IWorkbenchListener)this);
            EvaluationManager.getManager().stop();
            super.stop(context);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            JavaScriptImageRegistry.dispose();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        JavaScriptImageRegistry.dispose();
    }

    public static JavaScriptDebugUIPlugin getDefault() {
        return plugin;
    }

    public static void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public static void log(Throwable t) {
        JavaScriptDebugUIPlugin.log(JavaScriptDebugUIPlugin.newErrorStatus("Error logged from JavaScript Debug UI: ", t));
    }

    public static void logErrorMessage(String message) {
        JavaScriptDebugUIPlugin.log(JavaScriptDebugUIPlugin.newErrorStatus("Internal message logged from JavaScript Debug UI: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, PLUGIN_ID, 120, message, exception);
    }

    protected void closeEditors() throws PartInitException {
        IProject project = JavaScriptDebugPlugin.getExternalSourceProject((boolean)false);
        if (project != null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            ArrayList<IEditorReference> editors = new ArrayList<IEditorReference>(8);
            int l = 0;
            while (l < windows.length) {
                IWorkbenchPage[] pages = windows[l].getPages();
                int i = 0;
                while (i < pages.length) {
                    IEditorReference[] erefs = pages[i].getEditorReferences();
                    int j = 0;
                    while (j < erefs.length) {
                        IFile file = ResourceUtil.getFile((IEditorInput)erefs[j].getEditorInput());
                        if (file != null && project.equals((Object)file.getProject())) {
                            editors.add(erefs[j]);
                        }
                        ++j;
                    }
                    if (editors.size() > 0) {
                        pages[i].closeEditors(editors.toArray(new IEditorReference[editors.size()]), false);
                        editors.clear();
                    }
                    ++i;
                }
                ++l;
            }
        }
    }

    public boolean preShutdown(IWorkbench workbench, boolean forced) {
        try {
            this.closeEditors();
        }
        catch (PartInitException e) {
            JavaScriptDebugUIPlugin.log(e);
        }
        return true;
    }

    public void postShutdown(IWorkbench workbench) {
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IPreferenceStore getCorePreferenceStore() {
        return corestore;
    }
}

