/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.jvmmodel;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtend.core.dispatch.DispatchingSupport;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.jvmmodel.SyntheticNameClashResolver;
import org.eclipse.xtend.core.jvmmodel.XtendCompileStrategies;
import org.eclipse.xtend.core.xtend.CreateExtensionInfo;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.lib.Data;
import org.eclipse.xtend.lib.Property;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelInferrer;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Procedures;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class XtendJvmModelInferrer
implements IJvmModelInferrer {
    public static final String CREATE_INITIALIZER_PREFIX = "_init_";
    public static final String CREATE_CHACHE_VARIABLE_PREFIX = "_createCache_";
    @Inject
    protected TypesFactory typesFactory;
    @Inject
    private IJvmModelAssociator associator;
    @Inject
    private IXtendJvmAssociations associations;
    @Inject
    private DispatchingSupport dispatchingSupport;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private XtendCompileStrategies compileStrategies;
    @Inject
    private JvmTypesBuilder jvmTypesBuilder;
    @Inject
    private SyntheticNameClashResolver nameClashResolver;
    @Inject
    private JvmTypeExtensions typeExtensions;

    public void infer(@Nullable EObject xtendFile, IJvmDeclaredTypeAcceptor acceptor, boolean preIndexingPhase) {
        if (!(xtendFile instanceof XtendFile)) {
            return;
        }
        XtendFile xtendFile2 = (XtendFile)xtendFile;
        EList<XtendClass> classes = xtendFile2.getXtendClasses();
        for (final XtendClass xtendClass : classes) {
            if (Strings.isEmpty((String)xtendClass.getName())) continue;
            final JvmGenericType inferredJvmType = this.typesFactory.createJvmGenericType();
            inferredJvmType.setPackageName(xtendClass.getPackageName());
            inferredJvmType.setSimpleName(xtendClass.getName());
            this.associator.associatePrimary((EObject)xtendClass, (EObject)inferredJvmType);
            acceptor.accept((JvmDeclaredType)inferredJvmType).initializeLater((Procedures.Procedure1)new Procedures.Procedure1<JvmGenericType>(){

                public void apply(@Nullable JvmGenericType p) {
                    XtendJvmModelInferrer.this.initialize(xtendClass, inferredJvmType);
                }
            });
        }
    }

    protected void initialize(XtendClass source, JvmGenericType inferredJvmType) {
        inferredJvmType.setVisibility(JvmVisibility.PUBLIC);
        inferredJvmType.setAbstract(source.isAbstract());
        this.jvmTypesBuilder.translateAnnotationsTo(source.getAnnotations(), (JvmAnnotationTarget)inferredJvmType);
        boolean isDataObject = this.hasAnnotation(source, Data.class);
        JvmAnnotationType annotation = (JvmAnnotationType)this.typeReferences.findDeclaredType(SuppressWarnings.class, (Notifier)source);
        if (annotation != null && !this.hasAnnotation(source, SuppressWarnings.class)) {
            JvmAnnotationReference suppressWarnings = this.typesFactory.createJvmAnnotationReference();
            suppressWarnings.setAnnotation(annotation);
            JvmStringAnnotationValue annotationValue = this.typesFactory.createJvmStringAnnotationValue();
            annotationValue.getValues().add((Object)"all");
            suppressWarnings.getValues().add((Object)annotationValue);
            inferredJvmType.getAnnotations().add((Object)suppressWarnings);
        }
        if (source.getExtends() == null) {
            JvmTypeReference typeRefToObject = this.typeReferences.getTypeForName(Object.class, (Notifier)source, new JvmTypeReference[0]);
            if (typeRefToObject != null) {
                inferredJvmType.getSuperTypes().add((Object)typeRefToObject);
            }
        } else {
            inferredJvmType.getSuperTypes().add((Object)this.jvmTypesBuilder.cloneWithProxies(source.getExtends()));
        }
        for (JvmTypeReference intf : source.getImplements()) {
            inferredJvmType.getSuperTypes().add((Object)this.jvmTypesBuilder.cloneWithProxies(intf));
        }
        this.copyAndFixTypeParameters((List<JvmTypeParameter>)source.getTypeParameters(), (JvmTypeParameterDeclarator)inferredJvmType);
        if (!isDataObject) {
            this.addDefaultConstructor(source, inferredJvmType);
        }
        for (XtendMember member : source.getMembers()) {
            if (!(member instanceof XtendField) && (!(member instanceof XtendFunction) || ((XtendFunction)member).getName() == null) && !(member instanceof XtendConstructor)) continue;
            this.transform(member, inferredJvmType);
        }
        this.appendSyntheticDispatchMethods(source, inferredJvmType);
        this.computeInferredReturnTypes(inferredJvmType);
        this.jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)inferredJvmType, this.jvmTypesBuilder.getDocumentation((EObject)source));
        if (isDataObject) {
            this.addDataObjectMethods(source, inferredJvmType);
        }
        this.nameClashResolver.resolveNameClashes(inferredJvmType);
    }

    protected boolean hasAnnotation(XtendAnnotationTarget source, Class<?> class1) {
        for (XAnnotation anno : source.getAnnotations()) {
            if (anno == null || anno.getAnnotationType() == null || !class1.getName().equals(anno.getAnnotationType().getIdentifier())) continue;
            return true;
        }
        return false;
    }

    protected void addDataObjectMethods(XtendClass source, JvmGenericType inferredJvmType) {
        Iterable allFields = Iterables.filter(source.getMembers(), XtendField.class);
        final Iterable fields = Iterables.filter((Iterable)allFields, (Predicate)new Predicate<XtendField>(){

            public boolean apply(@Nullable XtendField theField) {
                return theField != null && !theField.isStatic();
            }
        });
        Iterable jvmFields = Iterables.filter((Iterable)inferredJvmType.getDeclaredFields(), (Predicate)new Predicate<JvmField>(){

            public boolean apply(@Nullable JvmField theField) {
                return theField != null && !theField.isStatic();
            }
        });
        final JvmConstructor superConstructor = this.getSuperConstructor(source);
        if (Iterables.isEmpty((Iterable)Iterables.filter(source.getMembers(), XtendConstructor.class))) {
            JvmConstructor constructor = this.jvmTypesBuilder.toConstructor((EObject)source, (Procedures.Procedure1)new Procedures.Procedure1<JvmConstructor>(){

                public void apply(final @Nullable JvmConstructor constructor) {
                    if (constructor == null) {
                        return;
                    }
                    LinkedHashSet names = Sets.newLinkedHashSet();
                    if (superConstructor != null) {
                        for (JvmFormalParameter f : superConstructor.getParameters()) {
                            constructor.getParameters().add((Object)((JvmFormalParameter)EcoreUtil2.cloneWithProxies((EObject)f)));
                            names.add(f.getSimpleName());
                        }
                    }
                    final HashMap namesToField = Maps.newHashMap();
                    for (XtendField f : fields) {
                        if (f.getInitialValue() != null || f.getName() == null) continue;
                        String name = f.getName();
                        int tries = 1;
                        while (!names.add(name)) {
                            name = String.valueOf(name) + tries++;
                        }
                        JvmFormalParameter parameter = XtendJvmModelInferrer.this.jvmTypesBuilder.toParameter((EObject)f, name, f.getType());
                        if (parameter != null) {
                            constructor.getParameters().add((Object)parameter);
                        }
                        namesToField.put(name, XtendJvmModelInferrer.this.associations.getJvmField(f));
                    }
                    XtendJvmModelInferrer.this.jvmTypesBuilder.setBody((JvmExecutable)constructor, (Procedures.Procedure1)new Procedures.Procedure1<ITreeAppendable>(){

                        public void apply(@Nullable ITreeAppendable appendable) {
                            if (appendable == null) {
                                return;
                            }
                            appendable.append((CharSequence)"super(");
                            if (superConstructor != null) {
                                EList parameters = superConstructor.getParameters();
                                Iterator iterator = parameters.iterator();
                                while (iterator.hasNext()) {
                                    JvmFormalParameter jvmFormalParameter = (JvmFormalParameter)iterator.next();
                                    appendable.append((CharSequence)jvmFormalParameter.getName());
                                    if (!iterator.hasNext()) continue;
                                    appendable.append((CharSequence)", ");
                                }
                            }
                            appendable.append((CharSequence)");");
                            int i = superConstructor != null ? superConstructor.getParameters().size() : 0;
                            while (i < constructor.getParameters().size()) {
                                JvmFormalParameter p = (JvmFormalParameter)constructor.getParameters().get(i);
                                JvmField jvmField = (JvmField)namesToField.get(p.getSimpleName());
                                appendable.newLine().append((CharSequence)"this.").append((CharSequence)jvmField.getSimpleName()).append((CharSequence)" = ").append((CharSequence)p.getName()).append((CharSequence)";");
                                ++i;
                            }
                        }
                    });
                }
            });
            this.typeExtensions.setSynthetic((JvmIdentifiableElement)constructor, true);
            inferredJvmType.getMembers().add((Object)constructor);
        }
        JvmField[] dataFields = (JvmField[])Iterables.toArray((Iterable)jvmFields, JvmField.class);
        JvmOperation hashCode = this.jvmTypesBuilder.toHashCodeMethod((EObject)source, superConstructor != null, dataFields);
        this.typeExtensions.setSynthetic((JvmIdentifiableElement)hashCode, true);
        if (hashCode != null && !this.hasMethod(source, hashCode.getSimpleName(), (List<? extends JvmFormalParameter>)hashCode.getParameters())) {
            inferredJvmType.getMembers().add((Object)hashCode);
        }
        JvmOperation equals = this.jvmTypesBuilder.toEqualsMethod((EObject)source, (JvmDeclaredType)inferredJvmType, superConstructor != null, dataFields);
        this.typeExtensions.setSynthetic((JvmIdentifiableElement)equals, true);
        if (equals != null && !this.hasMethod(source, equals.getSimpleName(), (List<? extends JvmFormalParameter>)equals.getParameters())) {
            inferredJvmType.getMembers().add((Object)equals);
        }
        JvmOperation toString = this.jvmTypesBuilder.toToStringMethod((EObject)source, (JvmDeclaredType)inferredJvmType);
        this.typeExtensions.setSynthetic((JvmIdentifiableElement)toString, true);
        if (toString != null && !this.hasMethod(source, toString.getSimpleName(), (List<? extends JvmFormalParameter>)toString.getParameters())) {
            inferredJvmType.getMembers().add((Object)toString);
        }
    }

    @Nullable
    protected JvmConstructor getSuperConstructor(XtendClass source) {
        Iterable constructors;
        JvmType type;
        JvmConstructor superConstructor = null;
        if (source.getExtends() != null && (type = source.getExtends().getType()) instanceof JvmGenericType && !Iterables.isEmpty((Iterable)(constructors = Iterables.filter((Iterable)((JvmGenericType)type).getMembers(), JvmConstructor.class)))) {
            superConstructor = (JvmConstructor)constructors.iterator().next();
        }
        return superConstructor;
    }

    protected void copyAndFixTypeParameters(List<JvmTypeParameter> typeParameters, JvmTypeParameterDeclarator target) {
        for (JvmTypeParameter typeParameter : typeParameters) {
            JvmTypeParameter clonedTypeParameter = (JvmTypeParameter)this.jvmTypesBuilder.cloneWithProxies((JvmIdentifiableElement)typeParameter);
            if (clonedTypeParameter == null) continue;
            target.getTypeParameters().add((Object)clonedTypeParameter);
            boolean upperBoundSeen = false;
            for (JvmTypeConstraint constraint : clonedTypeParameter.getConstraints()) {
                if (!(constraint instanceof JvmUpperBound)) continue;
                upperBoundSeen = true;
                break;
            }
            if (!upperBoundSeen) {
                JvmUpperBound upperBound = this.typesFactory.createJvmUpperBound();
                upperBound.setTypeReference(this.typeReferences.getTypeForName(Object.class, (Notifier)typeParameter, new JvmTypeReference[0]));
                clonedTypeParameter.getConstraints().add((Object)upperBound);
            }
            this.associator.associate((EObject)typeParameter, (EObject)clonedTypeParameter);
        }
    }

    protected void appendSyntheticDispatchMethods(XtendClass source, JvmGenericType target) {
        Multimap<Pair<String, Integer>, JvmOperation> methods = this.dispatchingSupport.getDispatchMethods(target);
        for (Pair key : methods.keySet()) {
            Collection operations = methods.get((Object)key);
            JvmOperation operation = this.deriveGenericDispatchOperationSignature(this.dispatchingSupport.sort(operations), target);
            if (operation == null) continue;
            operation.setSimpleName((String)key.getFirst());
        }
    }

    @Nullable
    protected JvmOperation deriveGenericDispatchOperationSignature(List<JvmOperation> sortedOperations, JvmGenericType target) {
        if (sortedOperations.isEmpty()) {
            return null;
        }
        Iterator<JvmOperation> iterator = sortedOperations.iterator();
        JvmOperation first = iterator.next();
        JvmOperation result = this.typesFactory.createJvmOperation();
        target.getMembers().add((Object)result);
        int i = 0;
        while (i < first.getParameters().size()) {
            JvmFormalParameter parameter = this.typesFactory.createJvmFormalParameter();
            result.getParameters().add((Object)parameter);
            parameter.setParameterType(this.getTypeProxy((EObject)parameter));
            JvmFormalParameter parameter2 = (JvmFormalParameter)first.getParameters().get(i);
            parameter.setName(parameter2.getName());
            ++i;
        }
        this.jvmTypesBuilder.setBody((JvmExecutable)result, this.compileStrategies.forDispatcher(result, sortedOperations));
        JvmVisibility commonVisibility = null;
        boolean isFirst = true;
        boolean allStatic = true;
        for (JvmOperation jvmOperation : sortedOperations) {
            Iterable xtendFunctions = Iterables.filter((Iterable)this.associations.getSourceElements((EObject)jvmOperation), XtendFunction.class);
            for (XtendFunction func : xtendFunctions) {
                JvmVisibility xtendVisibility;
                JvmVisibility jvmVisibility = xtendVisibility = func.eIsSet((EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__VISIBILITY) ? func.getVisibility() : null;
                if (isFirst) {
                    commonVisibility = xtendVisibility;
                    isFirst = false;
                } else if (commonVisibility != xtendVisibility) {
                    commonVisibility = null;
                }
                this.associator.associate((EObject)func, (EObject)result);
                if (func.isStatic()) continue;
                allStatic = false;
            }
            for (JvmTypeReference declaredException : jvmOperation.getExceptions()) {
                result.getExceptions().add((Object)this.jvmTypesBuilder.cloneWithProxies(declaredException));
            }
        }
        if (commonVisibility == null) {
            result.setVisibility(JvmVisibility.PUBLIC);
        } else {
            result.setVisibility(commonVisibility);
        }
        result.setStatic(allStatic);
        return result;
    }

    protected void addDefaultConstructor(XtendClass source, JvmGenericType target) {
        for (XtendMember member : source.getMembers()) {
            if (!(member instanceof XtendConstructor)) continue;
            return;
        }
        JvmConstructor constructor = this.typesFactory.createJvmConstructor();
        target.getMembers().add((Object)constructor);
        this.associator.associate((EObject)source, (EObject)constructor);
        constructor.setSimpleName(source.getName());
        constructor.setVisibility(JvmVisibility.PUBLIC);
        this.typeExtensions.setSynthetic((JvmIdentifiableElement)constructor, true);
    }

    protected void transform(XtendMember sourceMember, JvmGenericType container) {
        if (sourceMember instanceof XtendFunction) {
            this.transform((XtendFunction)sourceMember, container);
        } else if (sourceMember instanceof XtendField) {
            this.transform((XtendField)sourceMember, container);
        } else if (sourceMember instanceof XtendConstructor) {
            this.transform((XtendConstructor)sourceMember, container);
        } else {
            throw new IllegalArgumentException("Cannot transform " + Strings.notNull((Object)sourceMember) + " to a JvmMember");
        }
    }

    protected void transform(XtendFunction source, JvmGenericType container) {
        JvmOperation operation = this.typesFactory.createJvmOperation();
        operation.setAbstract(source.getExpression() == null);
        container.getMembers().add((Object)operation);
        this.associator.associatePrimary((EObject)source, (EObject)operation);
        String sourceName = source.getName();
        JvmVisibility visibility = source.getVisibility();
        if (source.isDispatch()) {
            if (!source.eIsSet((EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__VISIBILITY)) {
                visibility = JvmVisibility.PROTECTED;
            }
            sourceName = "_" + sourceName;
        }
        operation.setSimpleName(sourceName);
        operation.setVisibility(visibility);
        operation.setStatic(source.isStatic());
        for (XtendParameter parameter : source.getParameters()) {
            this.translateParameter((JvmExecutable)operation, parameter);
        }
        JvmTypeReference returnType = null;
        returnType = source.getReturnType() != null ? this.jvmTypesBuilder.cloneWithProxies(source.getReturnType()) : this.getTypeProxy((EObject)operation);
        operation.setReturnType(returnType);
        this.copyAndFixTypeParameters((List<JvmTypeParameter>)source.getTypeParameters(), (JvmTypeParameterDeclarator)operation);
        for (JvmTypeReference exception : source.getExceptions()) {
            operation.getExceptions().add((Object)this.jvmTypesBuilder.cloneWithProxies(exception));
        }
        this.jvmTypesBuilder.translateAnnotationsTo(source.getAnnotationInfo().getAnnotations(), (JvmAnnotationTarget)operation);
        CreateExtensionInfo createExtensionInfo = source.getCreateExtensionInfo();
        if (createExtensionInfo != null) {
            this.transformCreateExtension(source, createExtensionInfo, container, operation, returnType);
        } else {
            this.associator.associateLogicalContainer((EObject)source.getExpression(), (JvmIdentifiableElement)operation);
        }
        this.jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)operation, this.jvmTypesBuilder.getDocumentation((EObject)source));
    }

    protected void transformCreateExtension(XtendFunction source, CreateExtensionInfo createExtensionInfo, JvmGenericType container, JvmOperation operation, @Nullable JvmTypeReference returnType) {
        JvmTypeReference arrayList = this.typeReferences.getTypeForName(ArrayList.class, (Notifier)container, new JvmTypeReference[]{this.typeReferences.wildCard()});
        JvmTypeReference hashMap = this.typeReferences.getTypeForName(HashMap.class, (Notifier)container, new JvmTypeReference[]{arrayList, this.jvmTypesBuilder.cloneWithProxies(returnType)});
        JvmField cacheVar = this.jvmTypesBuilder.toField((EObject)source, CREATE_CHACHE_VARIABLE_PREFIX + source.getName(), hashMap);
        if (cacheVar != null) {
            cacheVar.setFinal(true);
            this.jvmTypesBuilder.setInitializer(cacheVar, this.compileStrategies.forCacheVariable(source));
            container.getMembers().add((Object)cacheVar);
            JvmOperation initializer = this.typesFactory.createJvmOperation();
            container.getMembers().add((Object)initializer);
            initializer.setSimpleName(CREATE_INITIALIZER_PREFIX + source.getName());
            initializer.setVisibility(JvmVisibility.PRIVATE);
            initializer.setReturnType(this.typeReferences.getTypeForName(Void.TYPE, (Notifier)source, new JvmTypeReference[0]));
            for (JvmTypeReference exception : source.getExceptions()) {
                initializer.getExceptions().add((Object)this.jvmTypesBuilder.cloneWithProxies(exception));
            }
            this.jvmTypesBuilder.setBody((JvmExecutable)operation, this.compileStrategies.forCacheMethod(createExtensionInfo, cacheVar, initializer));
            JvmFormalParameter jvmParam = this.typesFactory.createJvmFormalParameter();
            jvmParam.setName(createExtensionInfo.getName());
            jvmParam.setParameterType(this.getTypeProxy((EObject)createExtensionInfo.getCreateExpression()));
            initializer.getParameters().add((Object)jvmParam);
            this.associator.associate((EObject)createExtensionInfo, (EObject)jvmParam);
            for (XtendParameter parameter : source.getParameters()) {
                jvmParam = this.typesFactory.createJvmFormalParameter();
                jvmParam.setName(parameter.getName());
                jvmParam.setParameterType(this.jvmTypesBuilder.cloneWithProxies(parameter.getParameterType()));
                initializer.getParameters().add((Object)jvmParam);
                this.associator.associate((EObject)parameter, (EObject)jvmParam);
            }
            this.associator.associate((EObject)source, (EObject)initializer);
            this.associator.associateLogicalContainer((EObject)createExtensionInfo.getCreateExpression(), (JvmIdentifiableElement)operation);
            this.associator.associateLogicalContainer((EObject)source.getExpression(), (JvmIdentifiableElement)initializer);
        }
    }

    protected void translateParameter(JvmExecutable executable, XtendParameter parameter) {
        JvmFormalParameter jvmParam = this.typesFactory.createJvmFormalParameter();
        jvmParam.setName(parameter.getName());
        if (parameter.isVarArg()) {
            executable.setVarArgs(true);
            JvmGenericArrayTypeReference arrayType = this.typeReferences.createArrayType(this.jvmTypesBuilder.cloneWithProxies(parameter.getParameterType()));
            jvmParam.setParameterType((JvmTypeReference)arrayType);
        } else {
            jvmParam.setParameterType(this.jvmTypesBuilder.cloneWithProxies(parameter.getParameterType()));
        }
        this.associator.associate((EObject)parameter, (EObject)jvmParam);
        this.jvmTypesBuilder.translateAnnotationsTo(parameter.getAnnotations(), (JvmAnnotationTarget)jvmParam);
        executable.getParameters().add((Object)jvmParam);
    }

    protected void transform(XtendConstructor source, JvmGenericType container) {
        JvmConstructor constructor = this.typesFactory.createJvmConstructor();
        container.getMembers().add((Object)constructor);
        this.associator.associatePrimary((EObject)source, (EObject)constructor);
        JvmVisibility visibility = source.getVisibility();
        constructor.setSimpleName(container.getSimpleName());
        constructor.setVisibility(visibility);
        for (XtendParameter parameter : source.getParameters()) {
            this.translateParameter((JvmExecutable)constructor, parameter);
        }
        this.copyAndFixTypeParameters((List<JvmTypeParameter>)source.getTypeParameters(), (JvmTypeParameterDeclarator)constructor);
        for (JvmTypeReference exception : source.getExceptions()) {
            constructor.getExceptions().add((Object)this.jvmTypesBuilder.cloneWithProxies(exception));
        }
        this.jvmTypesBuilder.translateAnnotationsTo(source.getAnnotationInfo().getAnnotations(), (JvmAnnotationTarget)constructor);
        this.associator.associateLogicalContainer((EObject)source.getExpression(), (JvmIdentifiableElement)constructor);
        this.jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)constructor, this.jvmTypesBuilder.getDocumentation((EObject)source));
    }

    protected void transform(XtendField source, JvmGenericType container) {
        if (source.isExtension() || source.getName() != null) {
            JvmField field = this.typesFactory.createJvmField();
            String computeFieldName = this.computeFieldName(source, container);
            field.setSimpleName(computeFieldName);
            container.getMembers().add((Object)field);
            this.associator.associatePrimary((EObject)source, (EObject)field);
            field.setVisibility(source.getVisibility());
            field.setStatic(source.isStatic());
            boolean isDataObject = this.hasAnnotation((XtendAnnotationTarget)source.eContainer(), Data.class);
            if (isDataObject) {
                field.setFinal(true);
            } else {
                field.setFinal(source.isFinal());
            }
            if (source.getType() != null) {
                field.setType(this.jvmTypesBuilder.cloneWithProxies(source.getType()));
            } else if (source.getInitialValue() != null) {
                field.setType(this.getTypeProxy((EObject)source.getInitialValue()));
            }
            boolean isProperty = isDataObject;
            for (XAnnotation anno : source.getAnnotations()) {
                if (anno == null || anno.getAnnotationType() == null || anno.getAnnotationType().getIdentifier() == null) continue;
                if (Property.class.getName().equals(anno.getAnnotationType().getIdentifier())) {
                    isProperty = true;
                    continue;
                }
                JvmAnnotationReference annotationReference = this.jvmTypesBuilder.getJvmAnnotationReference(anno);
                if (annotationReference == null) continue;
                field.getAnnotations().add((Object)annotationReference);
            }
            if (isProperty && !field.isStatic()) {
                field.setSimpleName("_" + computeFieldName);
                JvmOperation getter = this.jvmTypesBuilder.toGetter((EObject)source, computeFieldName, field.getSimpleName(), field.getType());
                this.typeExtensions.setSynthetic((JvmIdentifiableElement)getter, true);
                this.jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)getter, this.jvmTypesBuilder.getDocumentation((EObject)source));
                if (getter != null && !this.hasMethod((XtendClass)source.eContainer(), getter.getSimpleName(), (List<? extends JvmFormalParameter>)getter.getParameters())) {
                    container.getMembers().add((Object)getter);
                }
                if (!source.isFinal() && !isDataObject) {
                    JvmOperation setter = this.jvmTypesBuilder.toSetter((EObject)source, computeFieldName, field.getSimpleName(), field.getType());
                    this.typeExtensions.setSynthetic((JvmIdentifiableElement)setter, true);
                    this.jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)setter, this.jvmTypesBuilder.getDocumentation((EObject)source));
                    if (setter != null && !this.hasMethod((XtendClass)source.eContainer(), setter.getSimpleName(), (List<? extends JvmFormalParameter>)setter.getParameters())) {
                        container.getMembers().add((Object)setter);
                    }
                }
            }
            this.jvmTypesBuilder.setDocumentation((JvmIdentifiableElement)field, this.jvmTypesBuilder.getDocumentation((EObject)source));
            this.jvmTypesBuilder.setInitializer(field, source.getInitialValue());
        }
    }

    protected boolean hasMethod(XtendClass xtendClass, String simpleName, List<? extends JvmFormalParameter> parameters) {
        for (XtendMember member : xtendClass.getMembers()) {
            XtendFunction function;
            String name;
            if (!(member instanceof XtendFunction) || (name = (function = (XtendFunction)member).getName()) == null || !name.equals(simpleName)) continue;
            boolean allMatched = true;
            if (function.getParameters().size() == parameters.size()) {
                int i = 0;
                while (i < parameters.size()) {
                    XtendParameter p1 = (XtendParameter)function.getParameters().get(i);
                    JvmFormalParameter p2 = parameters.get(i);
                    allMatched = allMatched && p1.getParameterType().getType() == p2.getParameterType().getType();
                    ++i;
                }
            }
            if (!allMatched) continue;
            return true;
        }
        return false;
    }

    protected boolean containsAnnotation(EList<XAnnotation> annotations, Class<Property> class1) {
        for (XAnnotation anno : annotations) {
            if (anno == null || anno.getAnnotationType() == null || !class1.getName().equals(anno.getAnnotationType().getIdentifier())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected String computeFieldName(XtendField field, JvmGenericType declaringType) {
        if (field.getName() != null) {
            return field.getName();
        }
        JvmTypeReference type = field.getType();
        String name = null;
        if (type != null) {
            List nodes;
            while (type instanceof JvmGenericArrayTypeReference) {
                type = ((JvmGenericArrayTypeReference)type).getComponentType();
            }
            if (type instanceof JvmParameterizedTypeReference && !(nodes = NodeModelUtils.findNodesForFeature((EObject)type, (EStructuralFeature)TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE)).isEmpty()) {
                String typeName = ((INode)nodes.get(0)).getText().trim();
                int lastDot = typeName.lastIndexOf(46);
                if (lastDot != -1) {
                    typeName = typeName.substring(lastDot + 1);
                }
                name = "_" + Strings.toFirstLower((String)typeName);
            }
        }
        return name;
    }

    protected void computeInferredReturnTypes(JvmGenericType inferredJvmType) {
        Iterable operations = inferredJvmType.getDeclaredOperations();
        for (JvmOperation jvmOperation : operations) {
            if (jvmOperation.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_OPERATION__RETURN_TYPE)) continue;
            jvmOperation.setReturnType(this.getTypeProxy((EObject)jvmOperation));
        }
    }

    protected JvmTypeReference getTypeProxy(EObject pointer) {
        JvmParameterizedTypeReference typeReference = this.typesFactory.createJvmParameterizedTypeReference();
        Resource eResource = pointer.eResource();
        String fragment = eResource.getURIFragment(pointer);
        URI uri = eResource.getURI();
        uri = uri.appendFragment("\u00a7lazyType$" + fragment);
        ((InternalEObject)typeReference).eSetProxyURI(uri);
        return typeReference;
    }
}

