/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.model;

import com.google.common.io.Closeables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.ibm.icu.text.MessageFormat;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IResourceForEditorInputFactory;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.quickfix.XtextResourceMarkerAnnotationModel;
import org.eclipse.xtext.ui.editor.validation.AnnotationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.ui.util.IssueUtil;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;

public class XtextDocumentProvider
extends FileDocumentProvider {
    @Inject
    private Provider<XtextDocument> documentProvider;
    @Inject
    private Provider<IDocumentPartitioner> documentPartitioner;
    @Inject
    private IResourceValidator resourceValidator;
    @Inject
    private IssueResolutionProvider issueResolutionProvider;
    @Inject
    private IssueUtil issueUtil;
    @Inject
    private IResourceForEditorInputFactory resourceForEditorInputFactory;
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private IEncodingProvider encodingProvider;
    private UnchangedElementListener listener;

    protected XtextDocument createEmptyDocument() {
        XtextDocument xtextDocument = (XtextDocument)this.documentProvider.get();
        return xtextDocument;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        XtextDocument document = null;
        if (this.isWorkspaceExternalEditorInput(element)) {
            document = this.createEmptyDocument();
            if (this.setDocumentContent(document, (IEditorInput)element, Charset.defaultCharset().name())) {
                this.setupDocument(element, document);
            }
        } else {
            document = super.createDocument(element);
        }
        if (document != null) {
            IDocumentPartitioner partitioner = (IDocumentPartitioner)this.documentPartitioner.get();
            partitioner.connect((IDocument)document);
            document.setDocumentPartitioner(partitioner);
        }
        return document;
    }

    public boolean isDeleted(Object element) {
        if (this.isWorkspaceExternalEditorInput(element)) {
            IURIEditorInput input = (IURIEditorInput)element;
            boolean result = !input.exists();
            return result;
        }
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            IPath path = input.getFile().getLocation();
            if (path == null) {
                return !input.getFile().exists();
            }
            return !path.toFile().exists();
        }
        return super.isDeleted(element);
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        boolean result;
        if (this.isWorkspaceExternalEditorInput(editorInput)) {
            java.net.URI uri = ((IURIEditorInput)editorInput).getURI();
            try {
                InputStream contentStream = null;
                try {
                    contentStream = uri.toURL().openStream();
                    this.setDocumentContent(document, contentStream, encoding);
                }
                finally {
                    try {
                        if (contentStream != null) {
                            contentStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException ex) {
                String message = ex.getMessage() != null ? ex.getMessage() : "";
                Status s = new Status(4, "org.eclipse.ui", 0, message, (Throwable)ex);
                throw new CoreException((IStatus)s);
            }
            result = true;
        } else {
            result = super.setDocumentContent(document, editorInput, encoding);
        }
        if (result) {
            XtextDocument xtextDocument = (XtextDocument)document;
            XtextResource xtextResource = (XtextResource)this.resourceForEditorInputFactory.createResource(editorInput);
            this.loadResource(xtextResource, xtextDocument.get(), encoding);
            xtextDocument.setInput(xtextResource);
        }
        return result;
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info.fDocument instanceof XtextDocument) {
            XtextDocument document = (XtextDocument)info.fDocument;
            ValidationJob job = (ValidationJob)document.getValidationJob();
            if (job != null) {
                job.cancel();
            }
            document.disposeInput();
        }
        super.disposeElementInfo(element, info);
    }

    protected void loadResource(XtextResource resource, String document, String encoding) throws CoreException {
        try {
            byte[] bytes = encoding != null ? document.getBytes(encoding) : document.getBytes();
            resource.load((InputStream)new ByteArrayInputStream(bytes), Collections.singletonMap(XtextResource.OPTION_ENCODING, encoding));
        }
        catch (IOException ex) {
            String message = ex.getMessage() != null ? ex.getMessage() : ex.toString();
            Status s = new Status(4, "org.eclipse.xtext.ui", 0, message, (Throwable)ex);
            throw new CoreException((IStatus)s);
        }
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        AbstractDocumentProvider.ElementInfo info;
        if (this.isWorkspaceExternalEditorInput(element)) {
            IDocument document = null;
            IStatus status = null;
            try {
                document = this.createDocument(element);
            }
            catch (CoreException x) {
                status = x.getStatus();
                document = this.createEmptyDocument();
            }
            info = new URIInfo(document, this.createAnnotationModel(element));
            info.fStatus = status;
        } else {
            info = super.createElementInfo(element);
        }
        XtextDocument doc = (XtextDocument)info.fDocument;
        if (info.fModel != null) {
            AnnotationIssueProcessor annotationIssueProcessor = new AnnotationIssueProcessor(doc, info.fModel, this.issueResolutionProvider);
            ValidationJob job = new ValidationJob(this.resourceValidator, doc, annotationIssueProcessor, CheckMode.FAST_ONLY);
            doc.setValidationJob(job);
        }
        return info;
    }

    protected void addUnchangedElementListeners(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (info.fDocument != null) {
            if (this.listener != null) {
                info.fDocument.removeDocumentListener((IDocumentListener)this.listener);
            }
            this.listener = new UnchangedElementListener(info);
            info.fDocument.addDocumentListener((IDocumentListener)new UnchangedElementListener(info));
        }
    }

    protected void removeUnchangedElementListeners(Object element, AbstractDocumentProvider.ElementInfo info) {
        if (this.listener != null) {
            info.fDocument.removeDocumentListener((IDocumentListener)this.listener);
            this.listener = null;
        }
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return new XtextResourceMarkerAnnotationModel(input.getFile(), this.issueResolutionProvider, this.issueUtil);
        }
        return super.createAnnotationModel(element);
    }

    public void setResourceForEditorInputFactory(IResourceForEditorInputFactory resourceForEditorInputFactory) {
        this.resourceForEditorInputFactory = resourceForEditorInputFactory;
    }

    public IResourceForEditorInputFactory getResourceForEditorInputFactory() {
        return this.resourceForEditorInputFactory;
    }

    public String getEncoding(Object element) {
        String encoding = super.getEncoding(element);
        if (encoding == null && element instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)element).getStorage();
                URI uri = this.storage2UriMapper.getUri(storage);
                if (uri != null) {
                    encoding = this.encodingProvider.getEncoding(uri);
                } else if (storage instanceof IEncodedStorage) {
                    encoding = ((IEncodedStorage)storage).getCharset();
                }
            }
            catch (CoreException e) {
                throw new WrappedException((Exception)((Object)e));
            }
        }
        return encoding;
    }

    public boolean isSynchronized(Object element) {
        AbstractDocumentProvider.ElementInfo info = this.getElementInfo(element);
        if (info instanceof FileDocumentProvider.FileInfo) {
            FileDocumentProvider.FileInfo fileInfo = (FileDocumentProvider.FileInfo)this.getElementInfo(element);
            long modificationStamp = this.getModificationStamp(element);
            if (fileInfo.fModificationStamp != modificationStamp) {
                return false;
            }
        }
        return super.isSynchronized(element);
    }

    public boolean isModifiable(Object element) {
        URIInfo info;
        if (this.isWorkspaceExternalEditorInput(element) && (info = (URIInfo)this.getElementInfo(element)) != null) {
            if (info.updateCache) {
                try {
                    this.updateCache((IURIEditorInput)element);
                }
                catch (CoreException x) {
                    this.handleCoreException(x, "XtextDocumentProvider.isModifiable");
                }
            }
            return info.isModifiable;
        }
        return super.isModifiable(element);
    }

    public boolean isReadOnly(Object element) {
        URIInfo info;
        if (this.isWorkspaceExternalEditorInput(element) && (info = (URIInfo)this.getElementInfo(element)) != null) {
            if (info.updateCache) {
                try {
                    this.updateCache((IURIEditorInput)element);
                }
                catch (CoreException x) {
                    this.handleCoreException(x, "XtextDocumentProvider.isReadOnly");
                }
            }
            return info.isReadOnly;
        }
        return super.isReadOnly(element);
    }

    protected boolean isWorkspaceExternalEditorInput(Object element) {
        return element instanceof IURIEditorInput && !(element instanceof IFileEditorInput);
    }

    protected void updateCache(IURIEditorInput input) throws CoreException {
        URIInfo info = (URIInfo)this.getElementInfo(input);
        if (info != null) {
            java.net.URI uri = input.getURI();
            if (uri != null) {
                boolean readOnly = true;
                String uriAsString = uri.toString();
                URI emfURI = URI.createURI((String)uriAsString);
                if (emfURI.isFile() && !emfURI.isArchive()) {
                    Map attributes = URIConverter.INSTANCE.getAttributes(emfURI, null);
                    readOnly = "true".equals(attributes.get("readOnly"));
                }
                info.isReadOnly = readOnly;
                info.isModifiable = !readOnly;
            }
            info.updateCache = false;
        }
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        if (this.isWorkspaceExternalEditorInput(element)) {
            CharsetEncoder encoder = Charset.defaultCharset().newEncoder();
            encoder.onMalformedInput(CodingErrorAction.REPLACE);
            encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            OutputStream stream = null;
            try {
                try {
                    try {
                        byte[] bytes;
                        monitor.beginTask("Saving", 2000);
                        ByteBuffer byteBuffer = encoder.encode(CharBuffer.wrap(document.get()));
                        if (byteBuffer.hasArray()) {
                            bytes = byteBuffer.array();
                        } else {
                            bytes = new byte[byteBuffer.limit()];
                            byteBuffer.get(bytes);
                        }
                        String uriAsString = ((IURIEditorInput)element).getURI().toString();
                        URI emfURI = URI.createURI((String)uriAsString);
                        stream = URIConverter.INSTANCE.createOutputStream(emfURI);
                        stream.write(bytes, 0, byteBuffer.limit());
                    }
                    finally {
                        monitor.done();
                    }
                }
                catch (CharacterCodingException ex) {
                    String message = MessageFormat.format((String)"Some characters cannot be mapped using \"{0}\" character encoding.\nEither change the encoding or remove the characters which are not supported by the \"{0}\" character encoding.", (Object[])new Object[]{Charset.defaultCharset().name()});
                    Status s = new Status(4, "org.eclipse.xtext.ui", 1, message, null);
                    throw new CoreException((IStatus)s);
                }
                catch (IOException e) {
                    String message = "Could not save file.";
                    Status s = new Status(4, "org.eclipse.xtext.ui", 272, message, null);
                    throw new CoreException((IStatus)s);
                }
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(stream);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)stream);
            return;
        }
        super.doSaveDocument(monitor, element, document, overwrite);
    }

    protected void doUpdateStateCache(Object element) throws CoreException {
        URIInfo info;
        if (this.isWorkspaceExternalEditorInput(element) && (info = (URIInfo)this.getElementInfo(element)) != null) {
            info.updateCache = true;
            return;
        }
        super.doUpdateStateCache(element);
    }

    protected class URIInfo
    extends AbstractDocumentProvider.ElementInfo {
        public boolean isModifiable;
        public boolean isReadOnly;
        public boolean updateCache;

        public URIInfo(IDocument document, IAnnotationModel model) {
            super((AbstractDocumentProvider)XtextDocumentProvider.this, document, model);
            this.isModifiable = false;
            this.isReadOnly = true;
            this.updateCache = true;
        }
    }

    public class UnchangedElementListener
    implements IDocumentListener {
        private final AbstractDocumentProvider.ElementInfo element;
        private long modificationStamp;

        public UnchangedElementListener(AbstractDocumentProvider.ElementInfo element) {
            this.element = element;
            this.modificationStamp = element.fDocument instanceof IDocumentExtension4 ? ((IDocumentExtension4)element.fDocument).getModificationStamp() : -1L;
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            if (this.element.fCanBeSaved && this.modificationStamp == event.getModificationStamp()) {
                this.element.fCanBeSaved = false;
                XtextDocumentProvider.this.fireElementDirtyStateChanged(this.element.fElement, this.element.fCanBeSaved);
            } else if (!this.element.fCanBeSaved) {
                this.element.fCanBeSaved = true;
                XtextDocumentProvider.this.fireElementDirtyStateChanged(this.element.fElement, this.element.fCanBeSaved);
            }
        }
    }
}

