/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.scoping.batch;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.AbstractSessionBasedScope;
import org.eclipse.xtext.xbase.scoping.batch.BucketedEObjectDescription;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.TypeBucket;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiverFeatureScope
extends AbstractSessionBasedScope {
    private final TypeBucket bucket;
    private final OperatorMapping operatorMapping;
    private final JvmTypeReference receiverType;
    private final XExpression receiver;

    protected ReceiverFeatureScope(IScope parent, IFeatureScopeSession session, XExpression receiver, JvmTypeReference receiverType, XAbstractFeatureCall featureCall, TypeBucket bucket, OperatorMapping operatorMapping) {
        super(parent, session, featureCall);
        this.receiver = receiver;
        this.receiverType = receiverType;
        this.bucket = bucket;
        this.operatorMapping = operatorMapping;
    }

    @Override
    protected Collection<IEObjectDescription> getLocalElementsByName(QualifiedName name) {
        HashSet allFeatures = Sets.newHashSet();
        String simpleName = this.getFeatureName(name);
        for (JvmType type : this.bucket.getTypes()) {
            if (!(type instanceof JvmDeclaredType)) continue;
            Iterable features = ((JvmDeclaredType)type).findAllFeaturesByName(simpleName);
            Iterables.addAll((Collection)allFeatures, (Iterable)features);
        }
        if (allFeatures.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList allDescriptions = Lists.newArrayListWithCapacity((int)allFeatures.size());
        Map<JvmTypeParameter, JvmTypeReference> receiverTypeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(this.receiverType);
        for (JvmIdentifiableElement feature : allFeatures) {
            allDescriptions.add(new BucketedEObjectDescription(name, (EObject)feature, this.receiver, this.receiverType, receiverTypeParameterMapping, this.bucket.getId()));
        }
        return allDescriptions;
    }

    @Override
    protected String getFeatureName(QualifiedName name) {
        QualifiedName methodName = this.operatorMapping.getMethodName(name);
        String simpleName = methodName == null ? name.toString() : methodName.toString();
        return simpleName;
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        HashSet allFeatures = Sets.newHashSet();
        for (JvmType type : this.bucket.getTypes()) {
            if (!(type instanceof JvmDeclaredType)) continue;
            Iterable features = ((JvmDeclaredType)type).getAllFeatures();
            Iterables.addAll((Collection)allFeatures, (Iterable)features);
        }
        if (allFeatures.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList allDescriptions = Lists.newArrayListWithCapacity((int)allFeatures.size());
        Map<JvmTypeParameter, JvmTypeReference> receiverTypeParameterMapping = new DeclaratorTypeArgumentCollector().getTypeParameterMapping(this.receiverType);
        for (JvmIdentifiableElement feature : allFeatures) {
            QualifiedName featureName = QualifiedName.create((String)feature.getSimpleName());
            allDescriptions.add(new BucketedEObjectDescription(featureName, (EObject)feature, this.receiver, this.receiverType, receiverTypeParameterMapping, this.bucket.getId()));
            QualifiedName operator = this.operatorMapping.getOperator(featureName);
            if (operator == null) continue;
            allDescriptions.add(new BucketedEObjectDescription(operator, (EObject)feature, this.receiver, this.receiverType, receiverTypeParameterMapping, this.bucket.getId()));
        }
        return allDescriptions;
    }
}

