/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.Iterator;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.packet.DiscoverInfo;

public class RoomInfo {
    private String room;
    private String description = "";
    private String subject = "";
    private int occupantsCount = -1;
    private boolean membersOnly;
    private boolean moderated;
    private boolean nonanonymous;
    private boolean passwordProtected;
    private boolean persistent;

    RoomInfo(DiscoverInfo info) {
        this.room = info.getFrom();
        this.membersOnly = info.containsFeature("muc_membersonly");
        this.moderated = info.containsFeature("muc_moderated");
        this.nonanonymous = info.containsFeature("muc_nonanonymous");
        this.passwordProtected = info.containsFeature("muc_passwordprotected");
        this.persistent = info.containsFeature("muc_persistent");
        Form form = Form.getFormFrom(info);
        if (form != null) {
            FormField formField = form.getField("muc#roominfo_description");
            this.description = formField == null ? null : formField.getValues().next();
            formField = form.getField("muc#roominfo_subject");
            Iterator<String> values = formField == null ? null : formField.getValues();
            this.subject = values != null && values.hasNext() ? values.next() : "";
            formField = form.getField("muc#roominfo_occupants");
            this.occupantsCount = formField == null ? 0 : Integer.parseInt(formField.getValues().next());
        }
    }

    public String getRoom() {
        return this.room;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSubject() {
        return this.subject;
    }

    public int getOccupantsCount() {
        return this.occupantsCount;
    }

    public boolean isMembersOnly() {
        return this.membersOnly;
    }

    public boolean isModerated() {
        return this.moderated;
    }

    public boolean isNonanonymous() {
        return this.nonanonymous;
    }

    public boolean isPasswordProtected() {
        return this.passwordProtected;
    }

    public boolean isPersistent() {
        return this.persistent;
    }
}

