/* Generated By:JavaCC: Do not edit this line. ij.java */
package org.apache.derby.impl.tools.ij;

import org.apache.derby.iapi.reference.JDBC20Translation;

import org.apache.derby.tools.JDBCDisplayUtil;


import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;

import org.apache.derby.iapi.services.info.JVMInfo;

import java.lang.reflect.*;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.Statement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.io.IOException;
import java.util.Vector;
import java.util.Enumeration;
import java.util.Locale;
import java.util.List;
import java.util.ArrayList;


/**
	This parser works on a statement-at-a-time basis.
	It maintains a connection environment that is
	set by the caller and contains a list of
	connections for the current thread/ij session.
	Multi-user frameworks that use this parser
	tend to maintain multiple connectionEnv's and
	pass in the current one to set ij up.
	A connectionEnv has a default connection in use,
	and the ij connect/set connection/disconnect commands 
	are used to change the current connection.

	Each connection has associated with it a list
	of prepared statements and cursors, created by
	the ij prepare and get cursor statements and
	manipulated by additional ij statements.

	To enable multiple display modes, this parser will
	not output anything, but will return
	objects that the caller can then display.

	This means the caller is responsible for displaying
	thrown exceptions and also SQLWarnings. So, our
	return value is the JDBC object upon which warnings
	will be hung, i.e. the one manipulated by the statement,
	if any.

	If there is no object to display, then a null is
	returned.

 */
class ij implements ijConstants {
        static final String PROTOCOL_PROPERTY = "ij.protocol";
    static final String URLCHECK_PROPERTY = "ij.URLCheck";
        static final String USER_PROPERTY = "ij.user";
    static final String PASSWORD_PROPERTY = "ij.password";
        static final String FRAMEWORK_PROPERTY = "framework";

        boolean                 elapsedTime = false;

        Connection theConnection = null;
        ConnectionEnv currentConnEnv = null;
        String urlCheck = null;

        xaAbstractHelper xahelper = null;
        boolean exit = false;

        utilMain utilInstance = null;
        Hashtable ignoreErrors = null;
        String protocol = null;         // the (single) unnamed protocol
        Hashtable namedProtocols;



        /**
	 * A constructor that understands the local state that needs to be
	 * initialized.
	 *
	 * @param tm			The token manager to use
	 * @param utilInstance	The util to use
	 */
        ij(ijTokenManager tm, utilMain utilInstance) {
                this(tm);
                this.utilInstance = utilInstance;
        }

        /**
	   Initialize this parser from the environment
	   (system properties). Used when ij is being run
	   as a command line program.
	*/
        void initFromEnvironment() {

                // load all protocols specified via properties
                //
        Properties p = (Properties) AccessController.doPrivileged(new PrivilegedAction() {
                public Object run() {
                return System.getProperties();
            }
        });
        urlCheck = p.getProperty(URLCHECK_PROPERTY);
                protocol = p.getProperty(PROTOCOL_PROPERTY);
                String framework_property = p.getProperty(FRAMEWORK_PROPERTY);

                if (ij.JDBC20X() && ij.JTA() && ij.JNDI())
                {
                        try {
                                xahelper = (xaAbstractHelper) Class.forName("org.apache.derby.impl.tools.ij.xaHelper").newInstance();
                                xahelper.setFramework(framework_property);
                        } catch (Exception e) {
                        }

                }


                namedProtocols = new Hashtable();
                String prefix = PROTOCOL_PROPERTY + ".";
                for (Enumeration e = p.propertyNames(); e.hasMoreElements(); )
                {
                        String key = (String)e.nextElement();
                        if (key.startsWith(prefix)) {
                                String name = key.substring(prefix.length());
                                installProtocol(name.toUpperCase(Locale.ENGLISH), p.getProperty(key));
                        }
                }
        }
        /**
	 * Return whether or not JDBC 2.0 (and greater) extension classes can be loaded
	 *
	 * @return true if JDBC 2.0 (and greater) extension classes can be loaded
	 */
        private static boolean JDBC20X()
        {
                try
                {
                        Class.forName("javax.sql.DataSource");
                        Class.forName("javax.sql.ConnectionPoolDataSource");
                        Class.forName("javax.sql.PooledConnection");
                        Class.forName("javax.sql.XAConnection");
                        Class.forName("javax.sql.XADataSource");
                }
                catch(ClassNotFoundException cnfe)
                {
                        return false;
                }
                return true;
        }
        /**
	 * Return whether or not JTA classes can be loaded
	 *
	 * @return true if JTA classes can be loaded
	 */
        private static boolean JTA()
        {
                try
                {
                        Class.forName("javax.transaction.xa.Xid");
                        Class.forName("javax.transaction.xa.XAResource");
                        Class.forName("javax.transaction.xa.XAException");
                }
                catch(ClassNotFoundException cnfe)
                {
                        return false;
                }
                return true;
        }

        /**
	 * Return whether or not JNDI extension classes can be loaded
	 *
	 * @return true if JNDI extension classes can be loaded
	 */
        private static boolean JNDI()
        {
                try
                {
                        Class.forName("javax.naming.spi.Resolver");
                        Class.forName("javax.naming.Referenceable");
                        Class.forName("javax.naming.directory.Attribute");
                }
                catch(ClassNotFoundException cnfe)
                {
                        return false;
                }
                return true;
        }
// FIXME: caller has to deal with ignoreErrors and handleSQLException behavior

        /**
		Add the warnings of wTail to the end of those of wHead.
	 */
        SQLWarning appendWarnings(SQLWarning wHead, SQLWarning wTail) {
                if (wHead == null) return wTail;

                if (wHead.getNextException() == null) {
                        wHead.setNextException(wTail);
                } else {
                        appendWarnings(wHead.getNextWarning(), wTail);
                }
                return wHead;
        }

        /**
	 * Get the "elapsedTime state".
	 */
        boolean getElapsedTimeState()
        {
                return elapsedTime;
        }

        /**
	   this removes the outside quotes from the string.
	   it will also swizzle the special characters
	   into their actual characters, like '' for ', etc.
	 */
        String stringValue(String s) {
                String result = s.substring(1,s.length()-1);
                char quotes = '\'';
                int             index;

                /* Find the first occurrence of adjacent quotes. */
                index = result.indexOf(quotes);

                /* Replace each occurrence with a single quote and begin the
		 * search for the next occurrence from where we left off.
		 */
                while (index != -1)
                {
                        result = result.substring(0, index + 1) + result.substring(index + 2);

                        index = result.indexOf(quotes, index + 1);
                }

                return result;
        }

        void installProtocol(String name, String value) {
            try {
                        // `value' is a JDBC protocol;
                        // we load the "driver" in the prototypical
                        // manner, it will register itself with
                        // the DriverManager.
                        util.loadDriverIfKnown(value);
            } catch (ClassNotFoundException e) {
                        throw ijException.classNotFoundForProtocol(value);
            } catch (IllegalArgumentException e) {
                        throw ijException.classNotFoundForProtocol(value);
            } catch (IllegalAccessException e) {
                        throw ijException.classNotFoundForProtocol(value);
            } catch (InstantiationException e) {
                        throw ijException.classNotFoundForProtocol(value);
            }
                if (name == null)
                        protocol = value;
                else
                        namedProtocols.put(name, value);
        }

        void haveConnection() {
                JDBCDisplayUtil.checkNotNull(theConnection, "connection");
        }

        /**
		We do not reuse statement objects at all, because
		some systems require you to close the object to release
		resources (JBMS), while others will not let you reuse
		the statement object once it is closed (WebLogic).

		If you want to reuse statement objects, you need to
		use the ij PREPARE and EXECUTE statements.

		@param stmt the statement

	 **/
        ijResult executeImmediate(String stmt) throws SQLException {
                Statement aStatement = null;
                try {
                        long    beginTime = 0;
                        long    endTime = 0;
                        boolean cleanUpStmt = false;

                        haveConnection();
                        aStatement = theConnection.createStatement();

                        // for JCC - remove comments at the beginning of the statement
                        // and trim; do the same for Derby Clients that have versions
                        // earlier than 10.2.
                        if (currentConnEnv != null) {
                                boolean trimForDNC = currentConnEnv.getSession().getIsDNC();
                                if (trimForDNC) {
                                // we're using the Derby Client, but we only want to trim
                                // if the version is earlier than 10.2.
                                        DatabaseMetaData dbmd = theConnection.getMetaData();
                                        int majorVersion = dbmd.getDriverMajorVersion();
                                        if ((majorVersion > 10) || ((majorVersion == 10) &&
                                                (dbmd.getDriverMinorVersion() > 1)))
                                        { // 10.2 or later, so don't trim/remove comments.
                                                trimForDNC = false;
                                        }
                                }
                                if (currentConnEnv.getSession().getIsJCC() || trimForDNC) {
                                // remove comments and trim.
                                        int nextline;
                                        while(stmt.startsWith("--"))
                                        {
                                                nextline = stmt.indexOf('\n')+1;
                                                stmt = stmt.substring(nextline);
                                        }
                                        stmt = stmt.trim();
                                }
                        }

                        aStatement.execute(stmt);

                        // FIXME: display results. return start time.
                        return new ijStatementResult(aStatement,true);

                } catch (SQLException e) {
                        if (aStatement!=null)  // free the resource
                                aStatement.close();
                        throw e;
                }
        }

        ijResult quit() throws SQLException {
                exit = true;
                if (getExpect()) { // report stats
                        // FIXME: replace with MVC...
                        // FIXME: this is a kludgy way to quiet /0 and make 0/0=1...
                        int numExpectOr1 = (numExpect==0?1:numExpect);
                        int numPassOr1 = (numPass==numExpect && numPass==0)?1:numPass;
                        int numFailOr1 = (numFail==numExpect && numFail==0)?1:numFail;
                        int numUnxOr1 = (numUnx==numExpect && numUnx==0)?1:numUnx;

            LocalizedResource.OutputWriter().println(LocalizedResource.getMessage("IJ_TestsRun0Pass12Fail34",
            new Object[]{
                        LocalizedResource.getNumber(numExpect), LocalizedResource.getNumber(100*(numPassOr1/numExpectOr1)),
                        LocalizedResource.getNumber(100*(numFailOr1/numExpectOr1))}));
                        if (numUnx > 0) {
                                                        LocalizedResource.OutputWriter().println();
                                                        LocalizedResource.OutputWriter().println(LocalizedResource.getMessage("IJ_UnexpResulUnx01",
                                                        LocalizedResource.getNumber(numUnx), LocalizedResource.getNumber(100*(numUnxOr1/numExpectOr1))));
                        }
                }
                currentConnEnv.removeAllSessions();
                theConnection = null;
                return null;
        }

        /**
		Async execution wants to return results off-cycle.
		We want to control their output, and so will hold it
		up until it is requested with a WAIT FOR asyncName
		statement.  WAIT FOR will return the results of
		the async statement once they are ready.  Note that using
		a select only waits for the execute to complete; the
		logic to step through the result set is in the caller.
	 **/
        ijResult executeAsync(String stmt, String name) {
                AsyncStatement as = new AsyncStatement(theConnection, stmt);

                currentConnEnv.getSession().addAsyncStatement(name,as);

                as.start();

                return null;
        }



        void setConnection(ConnectionEnv connEnv, boolean multipleEnvironments) {
                Connection conn = connEnv.getConnection();

                if (connEnv != currentConnEnv) // single connenv is common case
                        currentConnEnv = connEnv;

                if (theConnection == conn) return; // not changed.

                if ((theConnection == null) || multipleEnvironments) {
                        // must have switched env's (could check)
                        theConnection = conn;
                } else {
                        throw ijException.needToDisconnect();
                }
        }

        /**
		Note the Expect Result in the output and in the stats.

		FIXME
	 */
        int numExpect, numPass, numFail, numUnx;
        private void noteExpect(boolean actual, boolean want) {
                numExpect++;
                if (actual) numPass++;
                else numFail++;

                LocalizedResource.OutputWriter().print(LocalizedResource.getMessage(actual?"IJ_Pass":"IJ_Fail"));
                if (actual != want) {
                        numUnx++;
                                        LocalizedResource.OutputWriter().println(LocalizedResource.getMessage("IJ_Unx"));
                }
                else LocalizedResource.OutputWriter().println();
        }

        private boolean getExpect() {
                return Boolean.getBoolean("ij.expect");
        }

        private ijResult        addSession
        (
                Connection      newConnection,
                String          name
        )
                throws SQLException
        {
                if (currentConnEnv.haveSession(name)) {
                        throw ijException.alreadyHaveConnectionNamed(name);
                }

                currentConnEnv.addSession( newConnection, name );
                return new ijConnectionResult( newConnection );
        }

        private String[] sortConnectionNames()
        {
                int size = 100;
                int count = 0;
                String[] array = new String[size];
                String key;

                Hashtable ss = currentConnEnv.getSessions();
                // Calculate the number of connections in the sessions list and
                // build an array of all the connection names.
                for (Enumeration connectionNames = ss.keys(); connectionNames.hasMoreElements();) {
                    if (count == size) {
                       // need to expand the array
                       size = size*2;
                       String[] expandedArray = new String[size];
                       System.arraycopy(array, 0, expandedArray, 0, count);
                       array = expandedArray;
                    }
                    key = (String)connectionNames.nextElement();
                    array[ count++ ] = key;
                }

                java.util.Arrays.sort(array, 0, count);

        return array;
        }

            /**
	  This is used at the ij startup time to see if there are already some
	      connections made and if so, show connections made so far.
	  Following also gets executed when user types show connections command
	      in ij. In the former case, ignore0Rows is set whereas in the later cas
	  it's set to false. The reason for this is, at ij startup time, if there
	  are no connections made so far, we don't want to show anything. Only if
	  there are connections made, we show the connections. Whereas in show
	  connection command case, we want to show the connection status either way
	  ie if there are no connections, we say no connections. Otherwise we list
	  all the connections made so far.
	    */
        public ijResult showConnectionsMethod(boolean ignore0Rows) throws SQLException {
                Hashtable ss = currentConnEnv.getSessions();
                Vector v = new Vector();
                SQLWarning w = null;
        if (ss == null || ss.size() == 0) {
                if (!ignore0Rows)
                v.addElement(LocalizedResource.getMessage("IJ_NoConneAvail"));
        }
        else {
                boolean haveCurrent=false;
                        int count = 0;
                        for (Enumeration connectionNames = ss.keys(); connectionNames.hasMoreElements();
                                                connectionNames.nextElement())
                        count++;
            String[] array = sortConnectionNames();
                    for ( int ictr = 0; ictr < count; ictr++ ) {
                                String connectionName = array[ ictr ];
                Session s = (Session)ss.get(connectionName);
                if (s.getConnection().isClosed()) {
                        if (currentConnEnv.getSession() != null &&
                                        connectionName.equals(currentConnEnv.getSession().getName())) {
                                currentConnEnv.removeCurrentSession();
                                theConnection = null;
                        }
                        else
                        currentConnEnv.removeSession(connectionName);
                }
                else {
                        StringBuffer row = new StringBuffer();
                        row.append(connectionName);
                        if (currentConnEnv.getSession() != null &&
                                connectionName.equals(currentConnEnv.getSession().getName())) {
                                row.append('*');
                                haveCurrent=true;
                        }

                                //If ij.dataSource property is set, show only connection names.
                                //In this case, URL is not used to get connection, so do not append URL
                                String dsName = util.getSystemProperty("ij.dataSource");
                                        if(dsName == null){
                                row.append(" - \u0009");
                                row.append(s.getConnection().getMetaData().getURL());
                                }
                        // save the warnings from these connections
                        w = appendWarnings(w,s.getConnection().getWarnings());
                        s.getConnection().clearWarnings();
                        v.addElement(row.toString());
                }
                }
                if (haveCurrent)
                v.addElement(LocalizedResource.getMessage("IJ_CurreConne"));
                    else
                v.addElement(LocalizedResource.getMessage("IJ_NoCurreConne"));
                }
                return new ijVectorResult(v,w);
        }

        /**
	   Returns a subset of the input integer array
	   
	   @param input The input integer array
	   @param start Starting index, inclusive
	   @param end   Ending index, exclusive
	 */
        public static int[] intArraySubset(final int[] input, int start, int end) {
                int[] res = new int[end-start];
                System.arraycopy(input, start, res, 0, end-start);
                return res;
        }

        /**
	   Verify that a table exists within a schema. Throws an exception
	   if table does not exist.
	   
	   @param schema Schema for the table
	   @param table  Name of table to check for existence of
	 */
        public void verifyTableExists(String schema, String table)
        throws SQLException {
                if(schema == null)
                        return;

                ResultSet rs = null;
                try {
                        DatabaseMetaData dbmd = theConnection.getMetaData();
                        rs = dbmd.getTables(null,schema,table,null);
                        if(!rs.next())
                                throw ijException.noSuchTable(table);
                } finally {
                        if(rs!=null)
                                rs.close();
                }
        }

        /**
	   Return a resultset of tables (or views, procs...) in the given schema. 

	   @param schema  Schema to get tables for, or null for search 
	                  in all schemas.
	   @param tableType Types of tables to return, see
	                  {@link java.sql.DatabaseMetaData#getTableTypes}
	 */
        public ijResult showTables(String schema, String[] tableType) throws SQLException {
                ResultSet rs = null;
                try {
                        haveConnection();

                        DatabaseMetaData dbmd = theConnection.getMetaData();
                        rs = dbmd.getTables(null,schema,null,tableType);

                        int[] displayColumns = new int[] {
                                rs.findColumn("TABLE_SCHEM"),
                                rs.findColumn("TABLE_NAME"),
                                rs.findColumn("REMARKS"),
                        };
                        int[] columnWidths = new int[] {
                                20,
                                30,
                                20,
                        };

                        return new ijResultSetResult(rs, displayColumns, columnWidths);
                } catch (SQLException e) {
                        if(rs!=null)
                                rs.close();
                        throw e;
                }
        }

        /**
	   Return a resultset of indexes for the given table or schema

	   @param schema  schema to find indexes for
	   @param table the exact name of the table to find indexes for
	*/
    private ResultSet getIndexInfoForTable(String schema, String table)
      throws SQLException {

        ResultSet rs = null;
        try {
            haveConnection();
            verifyTableExists(schema, table);

            DatabaseMetaData dbmd = theConnection.getMetaData();
            rs = dbmd.getIndexInfo(null, schema, table, false, true);

        } catch (SQLException e) {
            if(rs!=null)
                rs.close();
            throw e;
        }
        return rs;
    }

    /**
     * Used by showIndexes to get columns in correct order
     */
    private int[] getDisplayColumnsForIndex(String schema, ResultSet rs)
        throws SQLException{
        int[] displayColumns = new int[] {
            rs.findColumn("TABLE_SCHEM"),
            rs.findColumn("TABLE_NAME"),
            rs.findColumn("COLUMN_NAME"),
            rs.findColumn("NON_UNIQUE"),
            rs.findColumn("TYPE"),
            rs.findColumn("ASC_OR_DESC"),
            rs.findColumn("CARDINALITY"),
            rs.findColumn("PAGES"),
        };
        if(schema!=null) {
            displayColumns = intArraySubset(displayColumns, 1,
                                            displayColumns.length);
        }
        return displayColumns;
    }

    /**
     * Used by showIndexes to get correct column widths
     */
    private int[] getColumnWidthsForIndex(String schema){
        int[] columnWidths = new int[] {
            20,
            20,
            20,
            6,
            4,
            4,
            8,
            8,
        };
        if(schema!=null) {
            columnWidths = intArraySubset(columnWidths, 1,
                                            columnWidths.length);
        }
        return columnWidths;
    }

    /**
     * Used to show all indices.
     *
     * @param schema the schema indices are shown from. 
     * @param table the table name to show indices for. If <code>null</code>,
     *      all indices of the schema are returned.
     */
    public ijResult showIndexes(String schema, String table)
            throws SQLException {

        ijResult result = null;

        int[] displayColumns = null;
        int[] columnWidths = null;

        try {
            if (table != null) {
                ResultSet rs = getIndexInfoForTable(schema, table);
                displayColumns = getDisplayColumnsForIndex(schema, rs);
                columnWidths = getColumnWidthsForIndex(schema);
                result = new ijResultSetResult(rs, displayColumns,
                                               columnWidths);
            }
            else {
                /* DatabaseMetaData#getIndexInfo requires exact table names.
                 * If table is null, we must first get all table names in
                 * the appropriate schema, and then get all indices for each
                 * of these. 
                 */
                haveConnection();
                verifyTableExists(schema, table);

                DatabaseMetaData dbmd = theConnection.getMetaData();
                ResultSet tablers = dbmd.getTables(null,schema,null,null);

                List resultSets = new ArrayList();
                boolean firstIteration = true;
                ResultSet current_rs = null;
                while (tablers.next()){
                    String tableName = tablers.getString("TABLE_NAME");
                    current_rs = getIndexInfoForTable(schema, tableName);
                    resultSets.add(current_rs);

                    if (firstIteration) {
                        displayColumns = getDisplayColumnsForIndex(schema,
                                                                   current_rs);
                        columnWidths = getColumnWidthsForIndex(schema);
                        firstIteration = false;
                    }
                }
                result = new ijMultipleResultSetResult(resultSets,
                                                       displayColumns,
                                                       columnWidths);
            }
            return result;
        } catch (SQLException e) {
            if(result!=null)
                result.closeStatement();
            throw e;
        }
    }

        /**
	   Return a resultset of procedures from database metadata
	 */
        public ijResult showProcedures(String schema) throws SQLException {
                ResultSet rs = null;
                try {
                        haveConnection();

                        DatabaseMetaData dbmd = theConnection.getMetaData();
                        rs = dbmd.getProcedures(null,schema,null);

                        int[] displayColumns = new int[] {
                                rs.findColumn("PROCEDURE_SCHEM"),
                                rs.findColumn("PROCEDURE_NAME"),
                                rs.findColumn("REMARKS"),
                        };
                        int[] columnWidths = new int[] {
                                20,
                                30,
                                20,
                        };

                        return new ijResultSetResult(rs, displayColumns, columnWidths);
                } catch (SQLException e) {
                        if(rs!=null)
                                rs.close();
                        throw e;
                }
        }

        /**
	   Return a resultset of schemas from database metadata
	 */
        public ijResult showSchemas() throws SQLException {
                ResultSet rs = null;
                try {
                        haveConnection();

                        DatabaseMetaData dbmd = theConnection.getMetaData();
                        rs = dbmd.getSchemas();

                        int[] displayColumns = new int[] {
                                rs.findColumn("TABLE_SCHEM")
                        };
                        int[] columnWidths = new int[] {
                                30
                        };

                        return new ijResultSetResult(rs, displayColumns, columnWidths);
                } catch (SQLException e) {
                        if(rs!=null)
                                rs.close();
                        throw e;
                }
        }

        /**
	   Return a resultset of roles. No database metadata
	   available, so select from SYS.SYSROLES directly. This has
	   the side effect of starting a transaction if one is not
	   already active, so we should perhaps give warning when not
	   in autocommit mode.
	*/
        public ijResult showRoles() throws SQLException {
                ResultSet rs = null;
                try {
                        haveConnection();

                        if (currentConnEnv.getSession().getIsDNC() ||
                                currentConnEnv.getSession().getIsEmbeddedDerby()) {
                                rs = theConnection.createStatement().executeQuery
                                        ("SELECT ROLEID FROM SYS.SYSROLES WHERE ISDEF='Y' " +
                                         "ORDER BY ROLEID ASC");

                                int[] displayColumns = new int[] {
                                        rs.findColumn("ROLEID")
                                };
                                int[] columnWidths = new int[] {
                                        30
                                };

                                return new ijResultSetResult(rs, displayColumns, columnWidths);
                        } else {
                                throw ijException.notAvailableForDriver(
                                        theConnection.getMetaData().getDriverName());
                        }
                } catch (SQLException e) {
                        if(rs!=null)
                                rs.close();
                        throw e;
                }
        }

        /**
	 * Return a resultset of enabled roles, sorted on ROLEID. No information
	 * schema is available, we select from VTI SYSCS_DIAG.CONTAINED_ROLES
	 * instead.
	 */
        public ijResult showEnabledRoles() throws SQLException {
                ResultSet rs = null;
                try {
                        haveConnection();

                        if (currentConnEnv.getSession().getIsDNC() ||
                                currentConnEnv.getSession().getIsEmbeddedDerby()) {
                                rs = theConnection.createStatement().executeQuery
                                        ("SELECT * FROM" +
                                        "\u0009 TABLE(" +
                                        "\u0009   SYSCS_DIAG.CONTAINED_ROLES(CURRENT_ROLE)) T " +
                                        "ORDER BY ROLEID");

                                int[] displayColumns = new int[] {
                                        rs.findColumn("ROLEID")
                                };
                                int[] columnWidths = new int[] {
                                        30
                                };

                                return new ijResultSetResult(rs, displayColumns, columnWidths);
                        } else {
                                throw ijException.notAvailableForDriver(
                                        theConnection.getMetaData().getDriverName());
                        }
                } catch (SQLException e) {
                        if(rs!=null)
                                rs.close();
                        throw e;
                }
        }


        /**
	 * Return a resultset of settable roles, sorted on ROLEID.  This has the
	 * side effect of starting a transaction if one is not already active, so
	 * we should perhaps give warning when not in autocommit mode.
	 */
        public ijResult showSettableRoles() throws SQLException {
                ResultSet rs = null;
                final String query  =
                        // Ordinary user is restricted to roles explicitly granted:
                        "select distinct * from (" +
                        "  select roleid from sys.sysroles s" +
                        "    where s.grantee = current_user or s.grantee = 'PUBLIC'" +
                        "  union" +
                        // Data base owner can set all roles:
                        "  select roleid from sys.sysroles s" +
                        "    where s.isdef='Y' and current_user in" +
                        "        (select authorizationid from sys.sysschemas" +
                        "             where schemaname = 'SYS')) t " +
                        "order by roleid";

                try {
                        haveConnection();

                        if (currentConnEnv.getSession().getIsDNC() ||
                                currentConnEnv.getSession().getIsEmbeddedDerby()) {
                                rs = theConnection.createStatement().executeQuery(query);

                                int[] displayColumns = new int[] {
                                        rs.findColumn("ROLEID")
                                };
                                int[] columnWidths = new int[] {
                                        30
                                };

                                return new ijResultSetResult(rs, displayColumns, columnWidths);
                        } else {
                                throw ijException.notAvailableForDriver(
                                        theConnection.getMetaData().getDriverName());
                        }
                } catch (SQLException e) {
                        if(rs!=null)
                                rs.close();
                        throw e;
                }
        }




        /**
	   Outputs the names of all fields of given table. Outputs field
	   names and data type.
	 */
        public ijResult describeTable(String schema, String table) throws SQLException {
                ResultSet rs = null;
                try {
                        haveConnection();
                        verifyTableExists(schema,table);

                        DatabaseMetaData dbmd = theConnection.getMetaData();
                        rs = dbmd.getColumns(null,schema,table,null);

                        int[] displayColumns = new int[] {
                                rs.findColumn("TABLE_SCHEM"),
                                rs.findColumn("TABLE_NAME"),
                                rs.findColumn("COLUMN_NAME"),
                                rs.findColumn("TYPE_NAME"),
                                rs.findColumn("DECIMAL_DIGITS"),
                                rs.findColumn("NUM_PREC_RADIX"),
                                rs.findColumn("COLUMN_SIZE"),
                                rs.findColumn("COLUMN_DEF"),
                                rs.findColumn("CHAR_OCTET_LENGTH"),
                                rs.findColumn("IS_NULLABLE"),
                        };
                        int[] columnWidths = new int[] {
                                20,
                                20,
                                20,
                                9,
                                4,
                                4,
                                6,
                                10,
                                10,
                                8
                        };

                        //
                        // If schema is specified (if util.getSelectedSchema in
                        // DescTableStatement() returns correct value), then we
                        // don't need to output schema and table names.
                        if(schema!=null && table != null) {
                                displayColumns = intArraySubset(displayColumns, 2,
                                                                                                displayColumns.length);
                                columnWidths   = intArraySubset(columnWidths, 2,
                                                                                                columnWidths.length);
                        }

                        return new ijResultSetResult(rs, displayColumns, columnWidths);
                } catch (SQLException e) {
                        if(rs!=null)
                                rs.close();
                        throw e;
                }
        }

        private Object makeXid(int xid)
        {
                return null;
        }

//
// start of BNF rules
//
  final public ijResult ijStatement() throws ParseException, SQLException {
        ijResult r = null;
    if (jj_2_56(2)) {
      if (getToken(1).kind == ROLLBACK &&
                              (!(getToken(3).kind == TO || getToken(3).kind == SAVEPOINT))) {
        r = RollbackStatement();
      } else if (jj_2_1(2)) {
        r = AbsoluteStatement();
      } else if (jj_2_2(2)) {
        r = AfterLastStatement();
      } else if (jj_2_3(2)) {
        r = AutocommitStatement();
      } else if (jj_2_4(2)) {
        r = AsyncStatement();
      } else if (jj_2_5(2)) {
        r = Bang();
      } else if (jj_2_6(2)) {
        r = BeforeFirstStatement();
      } else if (jj_2_7(2)) {
        r = CloseStatement();
      } else if (jj_2_8(2)) {
        r = CommitStatement();
      } else if (jj_2_9(2)) {
        r = ConnectStatement();
      } else if (jj_2_10(2)) {
        r = DescTableStatement();
      } else if (jj_2_11(2)) {
        r = DisconnectStatement();
      } else if (jj_2_12(2)) {
        r = DriverStatement();
      } else if (jj_2_13(2)) {
        r = ElapsedTimeStatement();
      } else if (jj_2_14(2)) {
        r = ExecuteStatement();
      } else if (jj_2_15(2)) {
        r = FirstStatement();
      } else if (jj_2_16(2)) {
        r = FirstStatement();
      } else if (jj_2_17(2)) {
        r = JBMSPreparedStatementExec();
      } else if (jj_2_18(2)) {
        r = F2KExecuteProcedure();
      } else if (jj_2_19(2)) {
        r = ExitStatement();
      } else if (jj_2_20(2)) {
        r = ExpectStatement();
      } else if (jj_2_21(2)) {
        r = GetCursorStatement();
      } else if (jj_2_22(2)) {
        r = GetCurrentRowNumber();
      } else if (jj_2_23(2)) {
        r = HelpStatement();
      } else if (jj_2_24(2)) {
        r = IllegalStatementName();
      } else if (jj_2_25(2)) {
        r = LastStatement();
      } else if (jj_2_26(2)) {
        r = LocalizedDisplay();
      } else if (jj_2_27(2)) {
        r = MaximumDisplayWidthStatement();
      } else if (jj_2_28(2)) {
        r = NextStatement();
      } else if (jj_2_29(2)) {
        r = NoHoldForConnectionStatement();
      } else if (jj_2_30(2)) {
        r = PrepareStatement();
      } else if (jj_2_31(2)) {
        r = PreviousStatement();
      } else if (jj_2_32(2)) {
        r = ProtocolStatement();
      } else if (jj_2_33(2)) {
        r = ReadOnlyStatement();
      } else if (jj_2_34(2)) {
        r = RelativeStatement();
      } else if (jj_2_35(2)) {
        r = RemoveStatement();
      } else if (jj_2_36(2)) {
        r = RunStatement();
      } else if (jj_2_37(2)) {
        r = SetConnectionStatement();
      } else if (jj_2_38(2)) {
        r = ShowStatement();
      } else if (jj_2_39(2)) {
        r = WaitForStatement();
      } else if (jj_2_40(2)) {
        r = XA_DataSourceStatement();
      } else if (jj_2_41(2)) {
        r = XA_ConnectStatement();
      } else if (jj_2_42(2)) {
        r = XA_CommitStatement();
      } else if (jj_2_43(2)) {
        r = XA_DisconnectStatement();
      } else if (jj_2_44(2)) {
        r = XA_GetConnectionStatement();
      } else if (jj_2_45(2)) {
        r = XA_EndStatement();
      } else if (jj_2_46(2)) {
        r = XA_ForgetStatement();
      } else if (jj_2_47(2)) {
        r = XA_PrepareStatement();
      } else if (jj_2_48(2)) {
        r = XA_RecoverStatement();
      } else if (jj_2_49(2)) {
        r = XA_RollbackStatement();
      } else if (jj_2_50(2)) {
        r = XA_StartStatement();
      } else if (jj_2_51(2)) {
        r = DataSourceStatement();
      } else if (jj_2_52(2)) {
        r = CP_DataSourceStatement();
      } else if (jj_2_53(2)) {
        r = CP_ConnectStatement();
      } else if (jj_2_54(2)) {
        r = CP_GetConnectionStatement();
      } else if (jj_2_55(2)) {
        r = CP_DisconnectStatement();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
    jj_consume_token(0);
                {if (true) return r;}
    throw new Error("Missing return statement in function");
  }

/**
 * ProtocolStatement is PROTOCOL 'JDBC protocol' where
 * the protocol is used to prefix any connect request that
 * cannot find a driver.  We will take a stab at loading
 * a driver as each protocol comes in -- we only know about
 * two.
 */
  final public ijResult ProtocolStatement() throws ParseException, SQLException {
        Token t;
        String n = null;
    jj_consume_token(PROTOCOL);
    t = jj_consume_token(STRING);
    if (jj_2_57(2)) {
      jj_consume_token(AS);
      n = identifier();
    } else {
      ;
    }
                installProtocol(n, stringValue(t.image));
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * DriverStatement is DRIVER 'class' where class is the
 * name of a class that is a JDBC driver. It is loaded
 * into the DriverManager with a Class.forName call.
 * <p>
 * You can load as many drivers as you want, the idea is
 * to load up the appropriate one(s) for the connect(s)
 * that you will be issuing.
 */
  final public ijResult DriverStatement() throws ParseException, SQLException {
        Token t;
        String sVal = null;
    jj_consume_token(DRIVER);
    t = jj_consume_token(STRING);
            try {
                // t.image is a class name;
                // we load the "driver" in the prototypical
                // manner, it will register itself with
                // the DriverManager.
                        sVal = stringValue(t.image);
                        util.loadDriver(sVal);
            } catch (ClassNotFoundException e) {
                        {if (true) throw ijException.classNotFound(sVal);}
            } catch (IllegalArgumentException e) {
                        {if (true) throw ijException.driverNotClassName(sVal);}
            } catch (IllegalAccessException e) {
                        {if (true) throw ijException.classNotFound(sVal);}
            } catch (InstantiationException e) {
                        {if (true) throw ijException.classNotFound(sVal);}
            }
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

  final public ijResult ConnectStatement() throws ParseException, SQLException {
        ijResult        result;
    if (jj_2_60(2)) {
      jj_consume_token(CONNECT);
      jj_consume_token(TO);
      result = dynamicConnection(true);
                {if (true) return result;}
    } else if (jj_2_61(2)) {
      jj_consume_token(CONNECT);
      if (jj_2_58(2)) {
        result = dynamicConnection(false);
      } else if (jj_2_59(2)) {
        result = staticConnection();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
                {if (true) return result;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * ConnectStatement is CONNECT 'url' [ PROTOCOL proto ] 
	[ USER 	String PASSWORD String ] 
	[ATTRIBUTES attributeName = value [, attributeName = value]* ]
	[ AS ident ], where url is the
 * url for the database, i.e. jdbc:protocol:dbname etc.
 * Attributes are connection attributes to 
 * <p>
 * There can only be one connection at a time; if there
 * is already one, it is put on hold and this one takes its place.
 * <p>
 * if a driver can't be found, the current protocol will
 * be added at the front.
 * <p>
 * the as ident part is used for set connection.  If you don't
 * specify a name, we create one that is CONNECTION# for the #
 * of open connections that now exists. If the name duplicates,
 * an error results.
 */
  final public ijResult dynamicConnection(boolean simplifiedPath) throws ParseException, SQLException {
        Token t;
        Token userT = null;
        Token passwordT = null;
        String n = null, p = null, sVal;
    String userS =  util.getSystemProperty(USER_PROPERTY);
    String passwordS = util.getSystemProperty(PASSWORD_PROPERTY);
        Properties connInfo = null;
    t = jj_consume_token(STRING);
    if (jj_2_62(2)) {
      jj_consume_token(PROTOCOL);
      p = identifier();
    } else {
      ;
    }
    if (jj_2_63(2)) {
      jj_consume_token(USER);
      userT = jj_consume_token(STRING);
    } else {
      ;
    }
    if (jj_2_64(2)) {
      jj_consume_token(PASSWORD);
      passwordT = jj_consume_token(STRING);
    } else {
      ;
    }
    if (jj_2_65(2)) {
      jj_consume_token(ATTRIBUTES);
      connInfo = attributeList();
    } else {
      ;
    }
    if (jj_2_66(2)) {
      jj_consume_token(AS);
      n = identifier();
    } else {
      ;
    }
                // t.image is a database URL
                // we get the connection and salt it away
                // for use with other statements.
                //
                // FUTURE: we could have the syntax be
                // CONNECT <STRING> AS <IDENTIFIER>
                // and have a SET CONNECTION string to
                // re-activate a named connection.
                // Or not, and wait for SQL-J to support that
                // statement... although then we will have to
                // figure out if we will allow that SQL-J through
                // JDBC or not.
                // get the value of the string
                // n.b. at some point this will have to deal with ''s
                if (userT != null)
                userS = stringValue(userT.image);

        if (passwordT != null)
                passwordS = stringValue(passwordT.image);

        //If ij.dataSource property is set,use DataSource to get the connection
                String dsName = util.getSystemProperty("ij.dataSource");
                if (dsName != null){
                //Check that t.image does not start with jdbc:
                //If it starts with jdbc:, do not use DataSource to get connection
                sVal = stringValue(t.image);
                if(!sVal.startsWith("jdbc:") ){
                        theConnection = util.getDataSourceConnection(dsName,userS,passwordS,sVal,false);
                        {if (true) return addSession( theConnection, n );}
                }
        }

                if (simplifiedPath)
                        // url for the database W/O 'jdbc:protocol:', i.e. just a dbname
                        // For example,
                        //		CONNECT TO 'test'
                        // is equivalent to
                        // 		CONNECT TO 'jdbc:derby:test'
                        sVal = "jdbc:derby:" + stringValue(t.image);
                else
                        sVal = stringValue(t.image);

                // add named protocol if it was specified
                if (p != null) {
                        String protocol = (String)namedProtocols.get(p);
                        if (protocol == null) { {if (true) throw ijException.noSuchProtocol(p);} }
                        sVal = protocol + sVal;
                }

                // add protocol if no driver matches url
                boolean noDriver = false;
                        // if we have a full URL, make sure it's loaded first
                        try {
                                if (sVal.startsWith("jdbc:"))
                                        util.loadDriverIfKnown(sVal);
                        } catch (Exception e) {
                                // want to continue with the attempt
                        }
                        // By default perform extra checking on the URL attributes.
                        // This checking does not change the processing.
                        if (urlCheck == null || Boolean.valueOf(urlCheck).booleanValue()) {
                          URLCheck aCheck = new URLCheck(sVal);
                        }
                if (!sVal.startsWith("jdbc:") && (p == null) && (protocol != null)) {
                        sVal = protocol + sVal;
                }


                // If no ATTRIBUTES on the connection get them from the
                // defaults
                connInfo = util.updateConnInfo(userS,passwordS, connInfo);


                theConnection = DriverManager.getConnection(sVal,connInfo);

                {if (true) return addSession( theConnection, n );}
    throw new Error("Missing return statement in function");
  }

/**
 * Handles DESCRIBE table
 */
  final public ijResult DescTableStatement() throws ParseException, SQLException {
        String i = null;
        String i2 = null;
        Token  s = null;
    jj_consume_token(DESCRIBE);
    if (jj_2_67(2)) {
      i = identifier();
      jj_consume_token(PERIOD);
      i2 = identifier();
    } else if (jj_2_68(2)) {
      i2 = identifier();
    } else if (jj_2_69(2)) {
      s = jj_consume_token(STRING);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
                if(s!=null) {
                        i2 = stringValue(s.image);

                        if (i2.length() == 0)
                                {if (true) throw ijException.noSuchTable("(missing)");}

                        int dotPosition = i2.indexOf('.');
                        if(dotPosition!=-1) {
                                i = i2.substring(0,dotPosition);
                                i2 = i2.substring(dotPosition+1);
                        }
                        if ("*".equals(i2))
                                i2 = null;
                }

                if(i==null)
                        i = util.getSelectedSchema(theConnection);

                {if (true) return describeTable(i,i2);}
    throw new Error("Missing return statement in function");
  }

/**
  * Handles CONNECT yadda.yadda.foo( stringArg, ... stringArg ) AS connectionName
  */
  final public ijResult staticConnection() throws ParseException, SQLException {
        String                  name = null;
        Vector                  idList;
        int                             idx = 0;
        int                             lastID = 0;
        StringBuffer    buffer;
        String                  className;
        String                  methodName;
        Class                   classC;
        Method                  method;
        int                             argCount;
        String[]                args;
        Class                   stringClass;
        Class[]                 argTypes;
        ijResult                result = null;
    idList = staticMethodName();
    args = staticMethodArgs();
    if (jj_2_70(2)) {
      jj_consume_token(AS);
      name = identifier();
    } else {
      ;
    }
                lastID = idList.size() - 1;
                buffer = new StringBuffer();

                for ( ; idx < lastID; idx++ )
                {
                        if ( idx > 0 ) { buffer.append( "." ); }
                        buffer.append( (String) idList.elementAt( idx ) );
                }
                methodName = (String) idList.elementAt( idx );
                className = buffer.toString();

                try {
                        argCount = args.length;
                        argTypes = new Class[ argCount ];
                        stringClass = Class.forName( "java.lang.String" );
                        for ( idx = 0; idx < argCount; idx++ ) { argTypes[ idx ] = stringClass; }

                        classC = Class.forName( className );
                        method = classC.getMethod( methodName, argTypes );
                        theConnection = (Connection) method.invoke( null, args );
                        result = addSession( theConnection, name );

                }
                catch (java.lang.reflect.InvocationTargetException ite) {
                        Throwable t = ite.getTargetException();
                        if (t instanceof SQLException)
                                {if (true) throw (SQLException) t;}

                        {if (true) throw new SQLException( t.toString() );}
                }
                catch (Exception e) { {if (true) throw new SQLException( e.toString() );} }

                {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/**
 * SetConnectionStatement is SET CONNECTION ident
 * <p>
 * Moves to the named session, if it exists. If it doesn't
 * exist, remains on the current session and returns an error.
 */
  final public ijResult SetConnectionStatement() throws ParseException, SQLException {
        String t;
    jj_consume_token(SET);
    jj_consume_token(CONNECTION);
    t = identifier();
                if (!currentConnEnv.haveSession(t)) {
                        {if (true) throw ijException.noSuchConnection(t);}
                }
                currentConnEnv.setCurrentSession(t);
                theConnection = currentConnEnv.getConnection();
                {if (true) return new ijConnectionResult(theConnection);}
    throw new Error("Missing return statement in function");
  }

/**
 * Handles showing current connections for the current environment, and
 * SHOW TABLES/VIEWS/... commands.
 */
  final public ijResult ShowStatement() throws ParseException, SQLException {
        String schema  = null;
        String tblname = null;
        String str     = null;
        String[] types = null;
        Token t = null;
        Token v = null;
    if (jj_2_81(2)) {
      jj_consume_token(SHOW);
      jj_consume_token(CONNECTIONS);
                {if (true) return showConnectionsMethod(false);}
    } else if (jj_2_82(2)) {
      jj_consume_token(SHOW);
      if (jj_2_71(2)) {
        t = jj_consume_token(TABLES);
      } else if (jj_2_72(2)) {
        v = jj_consume_token(VIEWS);
      } else if (jj_2_73(2)) {
        jj_consume_token(SYNONYMS);
      } else if (jj_2_74(2)) {
        jj_consume_token(ALIASES);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_75(2)) {
        jj_consume_token(IN);
        schema = identifier();
      } else {
        ;
      }
                if(t!=null) {
                    types = new String[] { "TABLE", "SYSTEM TABLE" };
                }
                else if(v!=null)
                        types = new String[] { "VIEW" };
                else
                        types = new String[] { "SYNONYM" };
                {if (true) return showTables(schema, types);}
    } else if (jj_2_83(2)) {
      jj_consume_token(SHOW);
      jj_consume_token(INDEXES);
      if (jj_2_79(2)) {
        if (jj_2_77(2)) {
          jj_consume_token(IN);
          schema = identifier();
        } else if (jj_2_78(2)) {
          jj_consume_token(FROM);
          tblname = identifier();
          if (jj_2_76(2)) {
            jj_consume_token(PERIOD);
            str = identifier();
          } else {
            ;
          }
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
                if(str != null) {
                        // if absolute table reference given
                        schema = tblname;
                        tblname = str;
                }

                // If user specifies a table name, then assume schema is
                // current schema. Note that getSelectedSchema may return
                // null for some DBMSes.
                if(schema == null && tblname != null)
                        schema = util.getSelectedSchema(theConnection);
                {if (true) return showIndexes(schema,tblname);}
    } else if (jj_2_84(2)) {
      jj_consume_token(SHOW);
      jj_consume_token(PROCEDURES);
      if (jj_2_80(2)) {
        jj_consume_token(IN);
        schema = identifier();
      } else {
        ;
      }
                {if (true) return showProcedures(schema);}
    } else if (jj_2_85(2)) {
      jj_consume_token(SHOW);
      jj_consume_token(SCHEMAS);
                {if (true) return showSchemas();}
    } else if (jj_2_86(2)) {
      jj_consume_token(SHOW);
      jj_consume_token(ROLES);
            {if (true) return showRoles();}
    } else if (jj_2_87(2)) {
      jj_consume_token(SHOW);
      jj_consume_token(ENABLED_ROLES);
            {if (true) return showEnabledRoles();}
    } else if (jj_2_88(2)) {
      jj_consume_token(SHOW);
      jj_consume_token(SETTABLE_ROLES);
            {if (true) return showSettableRoles();}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * CommitStatement is simply COMMIT.
 * It commits the current transation.
 */
  final public ijResult CommitStatement() throws ParseException, SQLException {
    jj_consume_token(COMMIT);
    if (jj_2_89(2)) {
      jj_consume_token(WORK);
    } else {
      ;
    }
                haveConnection();
                theConnection.commit();
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * RollbackStatement is simply ROLLBACK.
 * It undoes the current transation.
 */
  final public ijResult RollbackStatement() throws ParseException, SQLException {
    jj_consume_token(ROLLBACK);
    if (jj_2_90(2)) {
      jj_consume_token(WORK);
    } else {
      ;
    }
                haveConnection();
                theConnection.rollback();
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * DisconnectStatement is simply DISCONNECT [ ALL | CURRENT | connectionName ]
 * it ends the specified connection(s) and
 * releases its statement resource.
 * <p>
 * If ALL is specified, it disconnects all available sessions
 * in the current environment.
 */
  final public ijResult DisconnectStatement() throws ParseException, SQLException {
        Token a = null;
        String n = null;
    jj_consume_token(DISCONNECT);
    if (jj_2_94(2)) {
      if (jj_2_91(2)) {
        jj_consume_token(CURRENT);
      } else if (jj_2_92(2)) {
        a = jj_consume_token(ALL);
      } else if (jj_2_93(2)) {
        n = identifier();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
                if ( a == null ) {
                        if (n == null) {
                        // only remove the current session
                            haveConnection();
                            // Also need to release the session object
                            currentConnEnv.removeCurrentSession();
                            theConnection = null;
                        }
                        else {
                            if (! currentConnEnv.haveSession(n))
                                    {if (true) throw ijException.noSuchConnection(n);}
                                currentConnEnv.removeSession(n);
                            if (currentConnEnv.getSession() == null)
                                    theConnection = null;
                        }
                } else {
                        currentConnEnv.removeAllSessions();
                        theConnection = null;
                }
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

  final public ijResult ExitStatement() throws ParseException, SQLException {
    if (jj_2_95(2)) {
      jj_consume_token(EXIT);
                {if (true) return quit();}
    } else if (jj_2_96(2)) {
      jj_consume_token(QUIT);
                {if (true) return quit();}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ijResult IllegalStatementName() throws ParseException, SQLException {
        Token s = null;
    jj_consume_token(PREPARE);
    jj_consume_token(PROCEDURE);
    jj_consume_token(AS);
    s = jj_consume_token(STRING);
                // "procedure" is not allowed as a statement name. this is
                // because "execute procedure" is a valid Foundation2000
                // command
                {if (true) throw ijException.illegalStatementName( "procedure" );}
    throw new Error("Missing return statement in function");
  }

  final public ijResult PrepareStatement() throws ParseException, SQLException {
        Token t;
        String i;
        PreparedStatement ps;
        String sVal;
    jj_consume_token(PREPARE);
    i = identifier();
    jj_consume_token(AS);
    t = jj_consume_token(STRING);
                haveConnection();
                sVal = stringValue(t.image);
                ps = theConnection.prepareStatement(sVal);
                JDBCDisplayUtil.checkNotNull(ps,"prepared statement");
                currentConnEnv.getSession().addPreparedStatement(i,ps);

                // all we want callers to see are the warnings.
                SQLWarning w = ps.getWarnings();
                ps.clearWarnings();
                {if (true) return new ijWarningResult(w);}
    throw new Error("Missing return statement in function");
  }

  final public ijResult GetCursorStatement() throws ParseException, SQLException {
        haveConnection();
        int scrollType = ResultSet.TYPE_FORWARD_ONLY;
        Token s;
        Token scrolling = null;
        Token withtoken = null;
        int holdType = theConnection.getHoldability();
        String c;
        Statement st = null;
        String sVal;
        ResultSet rs = null;
        SQLWarning warns;
    jj_consume_token(GET);
    if (jj_2_97(2)) {
      scrolling = jj_consume_token(SCROLL);
      scrollType = scrollType();
    } else {
      ;
    }
    if (jj_2_98(2)) {
      withtoken = jj_consume_token(WITH);
      holdType = holdType();
    } else {
      ;
    }
    jj_consume_token(CURSOR);
    c = identifier();
    jj_consume_token(AS);
    s = jj_consume_token(STRING);
                sVal = stringValue(s.image);
                try {
                        st = theConnection.createStatement(
                                scrollType, ResultSet.CONCUR_READ_ONLY, holdType);
                        JDBCDisplayUtil.checkNotNull(st,"cursor");
                        st.setCursorName(c);
                        rs = st.executeQuery(sVal);
                        JDBCDisplayUtil.checkNotNull(rs,"cursor");
                        Session sn = currentConnEnv.getSession();
                        sn.addCursorStatement(c,st);
                        sn.addCursor(c,rs);
                } catch (SQLException e) {
                        if (rs!=null) rs.close();
                        if (st!=null) st.close();
                        {if (true) throw e;}
                }

                // all we want callers to see are the warnings.
                SQLWarning w1 = theConnection.getWarnings();
                SQLWarning w2 = st.getWarnings();
                SQLWarning w3 = rs.getWarnings();
                theConnection.clearWarnings();
                st.clearWarnings();
                rs.clearWarnings();
                warns = appendWarnings(w1,w2);
                {if (true) return new ijWarningResult(appendWarnings(warns,w3));}
    throw new Error("Missing return statement in function");
  }

  final public int scrollType() throws ParseException, SQLException {
    if (jj_2_99(2)) {
      jj_consume_token(INSENSITIVE);
                {if (true) return ResultSet.TYPE_SCROLL_INSENSITIVE;}
    } else if (jj_2_100(2)) {
      jj_consume_token(SENSITIVE);
                {if (true) return ResultSet.TYPE_SCROLL_SENSITIVE;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public int holdType() throws ParseException, SQLException {
    if (jj_2_101(2)) {
      jj_consume_token(HOLD);
                {if (true) return ResultSet.HOLD_CURSORS_OVER_COMMIT;}
    } else if (jj_2_102(2)) {
      jj_consume_token(NOHOLD);
                {if (true) return ResultSet.CLOSE_CURSORS_AT_COMMIT;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public ijResult AbsoluteStatement() throws ParseException, SQLException {
        int row;
        String c;
        ResultSet rs;
    jj_consume_token(ABSOLUTE);
    row = intLiteral();
    c = identifier();
                haveConnection();
                // Verify that we have JDBC 2.0
                Session s = currentConnEnv.getSession();
                rs = (ResultSet) s.getCursor(c);
                JDBCDisplayUtil.checkNotNull(rs,"cursor");

                {if (true) return utilInstance.absolute(rs, row);}
    throw new Error("Missing return statement in function");
  }

  final public ijResult RelativeStatement() throws ParseException, SQLException {
        int row;
        String c;
        ResultSet rs;
    jj_consume_token(RELATIVE);
    row = intLiteral();
    c = identifier();
                haveConnection();
                // Verify that we have JDBC 2.0
                Session s = currentConnEnv.getSession();
                rs = (ResultSet) s.getCursor(c);
                JDBCDisplayUtil.checkNotNull(rs,"cursor");

                {if (true) return utilInstance.relative(rs, row);}
    throw new Error("Missing return statement in function");
  }

  final public ijResult BeforeFirstStatement() throws ParseException, SQLException {
        String c;
        ResultSet rs;
    jj_consume_token(BEFORE);
    jj_consume_token(FIRST);
    c = identifier();
                haveConnection();
                // Verify that we have JDBC 2.0
                Session s = currentConnEnv.getSession();
                rs = (ResultSet) s.getCursor(c);
                JDBCDisplayUtil.checkNotNull(rs,"cursor");

                {if (true) return utilInstance.beforeFirst(rs);}
    throw new Error("Missing return statement in function");
  }

  final public ijResult FirstStatement() throws ParseException, SQLException {
        String c;
        ResultSet rs;
    jj_consume_token(FIRST);
    c = identifier();
                haveConnection();
                // Verify that we have JDBC 2.0
                Session s = currentConnEnv.getSession();
                rs = (ResultSet) s.getCursor(c);
                JDBCDisplayUtil.checkNotNull(rs,"cursor");

                {if (true) return utilInstance.first(rs);}
    throw new Error("Missing return statement in function");
  }

  final public ijResult NextStatement() throws ParseException, SQLException {
        String c;
        ResultSet rs;
    jj_consume_token(NEXT);
    c = identifier();
                haveConnection();
                Session s = currentConnEnv.getSession();
                rs = (ResultSet) s.getCursor(c);
                JDBCDisplayUtil.checkNotNull(rs,"cursor");

                {if (true) return new ijRowResult(rs, rs.next());}
    throw new Error("Missing return statement in function");
  }

  final public ijResult AfterLastStatement() throws ParseException, SQLException {
        String c;
        ResultSet rs;
    jj_consume_token(AFTER);
    jj_consume_token(LAST);
    c = identifier();
                haveConnection();
                // Verify that we have JDBC 2.0
                Session s = currentConnEnv.getSession();
                rs = (ResultSet) s.getCursor(c);
                JDBCDisplayUtil.checkNotNull(rs,"cursor");

                {if (true) return utilInstance.afterLast(rs);}
    throw new Error("Missing return statement in function");
  }

  final public ijResult LastStatement() throws ParseException, SQLException {
        String c;
        ResultSet rs;
    jj_consume_token(LAST);
    c = identifier();
                haveConnection();
                // Verify that we have JDBC 2.0
                Session s = currentConnEnv.getSession();
                rs = (ResultSet) s.getCursor(c);
                JDBCDisplayUtil.checkNotNull(rs,"cursor");

                {if (true) return utilInstance.last(rs);}
    throw new Error("Missing return statement in function");
  }

  final public ijResult PreviousStatement() throws ParseException, SQLException {
        String c;
        ResultSet rs;
    jj_consume_token(PREVIOUS);
    c = identifier();
                haveConnection();
                // Verify that we have JDBC 2.0
                Session s = currentConnEnv.getSession();
                rs = (ResultSet) s.getCursor(c);
                JDBCDisplayUtil.checkNotNull(rs,"cursor");

                {if (true) return utilInstance.previous(rs);}
    throw new Error("Missing return statement in function");
  }

  final public ijResult GetCurrentRowNumber() throws ParseException, SQLException {
        ResultSet rs;
        String c;
    jj_consume_token(GETCURRENTROWNUMBER);
    c = identifier();
                haveConnection();
                // Verify that we have JDBC 2.0
                Session s = currentConnEnv.getSession();
                rs = (ResultSet) s.getCursor(c);
                JDBCDisplayUtil.checkNotNull(rs,"cursor");

        LocalizedResource.OutputWriter().println(utilInstance.getCurrentRowNumber(rs));
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

  final public ijResult CloseStatement() throws ParseException, SQLException {
        String c;
        ResultSet rs;
        Statement s;
    jj_consume_token(CLOSE);
    c = identifier();
                haveConnection();
                Session sn = currentConnEnv.getSession();
                rs = (ResultSet) sn.getCursor(c);
                JDBCDisplayUtil.checkNotNull(rs,"cursor");
                s = (Statement) sn.getCursorStatement(c);
                JDBCDisplayUtil.checkNotNull(s,"cursor");
                rs.close();
                s.close();
                sn.removeCursor(c);
                sn.removeCursorStatement(c);

                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * Hack to get the grammar to leave a
 * EXECUTE STATEMENT &lt;stmt&gt; alone.  Short
 * circuit the ij EXECUTE built in.
 */
  final public ijResult JBMSPreparedStatementExec() throws ParseException, SQLException {
        Token s = null;
    jj_consume_token(EXECUTE);
    jj_consume_token(STATEMENT);
    s = jj_consume_token(STRING);
                {if (true) return executeImmediate(stringValue(s.image));}
    throw new Error("Missing return statement in function");
  }

/**
 * Hack to get the grammar to leave a
 * EXECUTE PROCEDURE &lt;procSpec&gt; alone.  Short
 * circuit the ij EXECUTE built in so that
 * we can deploy ij against Foundation2000.
 */
  final public ijResult F2KExecuteProcedure() throws ParseException, SQLException {
        Token s = null;
    jj_consume_token(EXECUTE);
    jj_consume_token(PROCEDURE);
    s = jj_consume_token(STRING);
                haveConnection();

                Statement       aStatement = theConnection.createStatement();
                String          text = "execute procedure " + s;

                aStatement.execute( text );

                {if (true) return new ijStatementResult( aStatement,true );}
    throw new Error("Missing return statement in function");
  }

/**
 * Two forms of execute: immediate, with a string
 * and prepared, with the id of a prepared statement.
 * We expect the latter form will
 * eventually support a USING clause to supply
 * parameter values (that will be constants).
 * No parameters yet, however.
 * <p>
 * Syntax:
 *   EXECUTE statementSource [ USING statementSource] ;
 *
 *	 statementSource is an identifier of a previously prepared statement
 *	 or a string containing SQL-J text.
 */
  final public ijResult ExecuteStatement() throws ParseException, SQLException {
        String i = null;
        Token s = null;
        PreparedStatement ps;
        String sVal = null;

        String iUsing = null;
        Token sUsing = null;
        Token   usingObject = null;
    jj_consume_token(EXECUTE);
    if (jj_2_103(2)) {
      i = identifier();
    } else if (jj_2_104(2)) {
      s = jj_consume_token(STRING);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_107(2)) {
      jj_consume_token(USING);
      if (jj_2_105(2)) {
        iUsing = identifier();
      } else if (jj_2_106(2)) {
        sUsing = jj_consume_token(STRING);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
            if (iUsing!=null || sUsing!=null) { // parameters in use
                        String sUsingVal = null;
                        PreparedStatement psUsing;
                        SQLWarning warns = null;

                        haveConnection();

                        /*
				Steps:
				1. find or prepare the statement
				2. execute the using statement
				3. push the row of the using statement into the parameters
				4. execute the statement against those parameters
				5. clear the parameters
			 */
                        /*
				get the prepared statement
			 */
                        boolean closeWhenDone = false; // will we close the ps when done?
                if (i!=null) {
                                ps = (PreparedStatement) currentConnEnv.getSession().getPreparedStatement(i);
                                JDBCDisplayUtil.checkNotNull(ps,"prepared statement "+i);
                }
                else { // (s!=null)
                                sVal = stringValue(s.image);
                                ps = theConnection.prepareStatement(sVal);
                                closeWhenDone = true;
                                JDBCDisplayUtil.checkNotNull(ps,"prepared statement");
                                warns = appendWarnings(warns, ps.getWarnings());
                                ps.clearWarnings();
                }

                        /*
				execute the using statement
			 */
                if (iUsing!=null) {
                                psUsing = (PreparedStatement) currentConnEnv.getSession().getPreparedStatement(iUsing);
                                JDBCDisplayUtil.checkNotNull(psUsing,"prepared statement "+iUsing);
                }
                else { // (sUsing!=null)
                                sUsingVal = stringValue(sUsing.image);
                                psUsing = theConnection.prepareStatement(sUsingVal);
                                JDBCDisplayUtil.checkNotNull(psUsing,"prepared statement");
                                warns = appendWarnings(warns, psUsing.getWarnings());
                                psUsing.clearWarnings();
                }

                        ResultSet rsUsing;
                        /*
				If the USING statement is not a query, we
				will not execute the statement; the number of
				rows controls the execution.
			 */
                        if (psUsing.execute()) {
                                rsUsing = psUsing.getResultSet();

                                /*
					push the row of the using statement into the parameters
				 */

                                ResultSetMetaData rsmdUsing = rsUsing.getMetaData();
                                int numCols = rsmdUsing.getColumnCount();

                                /*
					Insufficient or too many parameters will
					be caught at the JDBC level, and halt execution.
				 */
                                boolean exec = false;

                                /* Only do 1 next on rsUsing if autocommit is on,
				 * since rsUsing will be closed when ps is closed.
				 */
                            boolean autoCommited = false;
                                ijMultiResult result = new ijMultiResult(ps,rsUsing,closeWhenDone);

//				while (! autoCommited && rsUsing.next()) {
//					// note the first time through
//					if (!exec) {
//						exec = true;
//
//						// send a warning if additional results may be lost
//						if (theConnection.getAutoCommit()) {
//							// FIXME: currOut.println("IJ WARNING: Autocommit may close using result set");
//							autoCommited = true;
//						}
//					}
//					for (int c=1; c<=numCols; c++) {
//						if (usingObject == null)
//						{
//							ps.setObject(c,rsUsing.getObject(c),
//								rsmdUsing.getColumnType(c));
//						} 
//						else
//						{
//							ps.setObject(c,rsUsing.getObject(c));
//						}
//					}
//
//					/*
//						4. execute the statement against those parameters
//					 */
//
//					ps.execute();
//					result.addStatementResult(ps);
//
//					/*
//						5. clear the parameters
//					 */
//					ps.clearParameters();
//
//				}
//				if (!exec) {
//					throw ijException.noUsingResults();
//				}
//
//				if (! theConnection.getAutoCommit())
//				{
//					rsUsing.close();
//				}
//				// REMIND: any way to look for more rsUsing rows if autoCommit?
//				// perhaps just document the behavior... 

                                {if (true) return result;}
                        }
                        else
                                {if (true) throw ijException.noUsingResults();}
                }
                else { // no parameters in use
                if (i!=null) {
                                haveConnection();
                                ps = (PreparedStatement) currentConnEnv.getSession().getPreparedStatement(i);
                                JDBCDisplayUtil.checkNotNull(ps,"prepared statement "+i);
                                ps.execute();

                                {if (true) return new ijStatementResult(ps,false);}
                }
                else { // (s!=null)
                            {if (true) return executeImmediate(stringValue(s.image));}
                }
            }
    throw new Error("Missing return statement in function");
  }

/**
 * Async: like execute immediate, without using,
 * but runs the statement in a separate thread, against
 * the current connection.
 * <p>
 * Syntax:
 *   ASYNC asyncName statementSource 
 *
 *	 statementSource is a string containing SQL-J text.
 */
  final public ijResult AsyncStatement() throws ParseException, SQLException {
        Token s = null;
        String n = null;
    jj_consume_token(ASYNC);
    n = identifier();
    s = jj_consume_token(STRING);
            {if (true) return executeAsync(stringValue(s.image), n);}
    throw new Error("Missing return statement in function");
  }

/**
 * Wait for: the second half of Async, waits for completion
 * if needed and then supplies the result.  Only execute is done,
 * not row fetching.
 * <p>
 * Syntax:
 *   WAIT FOR asyncName 
 *
 *	 asyncName is a name used in an ASYNC statement previously
 */
  final public ijResult WaitForStatement() throws ParseException, SQLException {
        Token s = null;
        String n = null;
    jj_consume_token(WAIT);
    jj_consume_token(FOR);
    n = identifier();
                AsyncStatement as = currentConnEnv.getSession().getAsyncStatement(n);
                if (as == null) {if (true) throw ijException.noSuchAsyncStatement(n);}
                try {
                    as.join(); // we wait for it to finish.
                } catch (InterruptedException ie) {
                        {if (true) throw ijException.waitInterrupted(ie);}
                }
                {if (true) return as.getResult();}
    throw new Error("Missing return statement in function");
  }

/**
 * RemoveStatement is REMOVE identifier. It identifies
 * a previously prepared statement.  We would prefer a DROP
 * syntax, but SQL-J is using that word and I want to point out
 * that special processing will be needed to give that parser
 * this parser's input for unrecognized text.
 */
  final public ijResult RemoveStatement() throws ParseException, SQLException {
        String i;
        PreparedStatement ps;
    jj_consume_token(REMOVE);
    i = identifier();
                haveConnection();
                Session s = currentConnEnv.getSession();
                ps = (PreparedStatement) s.getPreparedStatement(i);
                JDBCDisplayUtil.checkNotNull(ps,"prepared statement "+i);
                ps.close();
                s.removePreparedStatement(i);

                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

  final public ijResult RunStatement() throws ParseException, SQLException {
        Token i;
    Token r = null;
        PreparedStatement ps;
    jj_consume_token(RUN);
    if (jj_2_108(2)) {
      r = jj_consume_token(RESOURCE);
    } else {
      ;
    }
    i = jj_consume_token(STRING);
                if (utilInstance==null) {if (true) return null;}
            if (r == null)
                        utilInstance.newInput(stringValue(i.image));
                else
            utilInstance.newResourceInput(stringValue(i.image));
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * Autocommit lets you control this aspect of the connection.
 * REMIND: should have a general way to set all connection attributes,
 * this is a shortcut for immediate needs.
 * <p>
 * Syntax:
 *   AUTOCOMMIT [ ON | OFF ] ;
 */
  final public ijResult AutocommitStatement() throws ParseException, SQLException {
        Token on=null;
    jj_consume_token(AUTOCOMMIT);
    if (jj_2_109(2)) {
      on = jj_consume_token(ON);
    } else if (jj_2_110(2)) {
      jj_consume_token(OFF);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
                haveConnection();
                // REMIND: want to warn if unchanged?
                theConnection.setAutoCommit((on==null?false:true));

                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * By default, holdability is set to true for Connection objects. This syntax NOHOLDFORCONNECTION lets you set it to close cursors at commit.
 * Syntax:
 *   NOHOLDFORCONNECTION ;
 */
  final public ijResult NoHoldForConnectionStatement() throws ParseException, SQLException {
        Token on=null;
    jj_consume_token(NOHOLDFORCONNECTION);
                haveConnection();
                theConnection.setHoldability(ResultSet.CLOSE_CURSORS_AT_COMMIT);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * Localizeddisplay controls locale sensitive data representayion
 * <p>
 * Syntax:
 *   LOCALIZEDDISPLAY [ ON | OFF ] ;
 */
  final public ijResult LocalizedDisplay() throws ParseException {
        Token on=null;
    jj_consume_token(LOCALIZEDDISPLAY);
    if (jj_2_111(2)) {
      on = jj_consume_token(ON);
    } else if (jj_2_112(2)) {
      jj_consume_token(OFF);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
                LocalizedResource.enableLocalization((on==null?false:true));
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * ReadOnly lets you control this aspect of the connection.
 * REMIND: should have a general way to set all connection attributes,
 * this is a shortcut for immediate needs.
 * <p>
 * Syntax:
 *   READONLY [ ON | OFF ] ;
 */
  final public ijResult ReadOnlyStatement() throws ParseException, SQLException {
        Token on=null;
    jj_consume_token(READONLY);
    if (jj_2_113(2)) {
      on = jj_consume_token(ON);
    } else if (jj_2_114(2)) {
      jj_consume_token(OFF);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
                haveConnection();
                theConnection.setReadOnly((on==null?false:true));
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * Elapsedtime on causes ij to dump out the elapsed time it takes
 * to run a user statement at the end of that statement.
 * <p>
 * Syntax:
 *   ELAPSEDTIME [ ON | OFF ] ;
 */
  final public ijResult ElapsedTimeStatement() throws ParseException {
        Token on=null;
    jj_consume_token(ELAPSEDTIME);
    if (jj_2_115(2)) {
      on = jj_consume_token(ON);
    } else if (jj_2_116(2)) {
      jj_consume_token(OFF);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
                elapsedTime = (on != null);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * MaximumDisplayWidth EXACT_NUMERIC changes the maximum display width for
 * java.lang.String to the specified EXACT_NUMERIC.
 * This is only used by the console view.
 * <p>
 * Syntax:
 *   MAXIMUMDISPLAYWIDTH INTEGER ;
 */
  final public ijResult MaximumDisplayWidthStatement() throws ParseException {
        int       maxWidth;
    jj_consume_token(MAXIMUMDISPLAYWIDTH);
    maxWidth = intValue();
                JDBCDisplayUtil.setMaxDisplayWidth(maxWidth);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

  final public int intValue() throws ParseException {
        Token t;
    t = jj_consume_token(INTEGER);
                {if (true) return Integer.parseInt(t.image);}
    throw new Error("Missing return statement in function");
  }

/**
 * Bang lets you issue a system command using System.exec.
 * <p>
 * Syntax:
 *   ! 'command to issue' ;
 */
  final public ijResult Bang() throws ParseException {
        Token cmd=null;
    jj_consume_token(BANG);
    cmd = jj_consume_token(STRING);
          ijResult result = null;
          try {
                Process p = Runtime.getRuntime().exec(stringValue(cmd.image));
                LocalizedInput in = new LocalizedInput(p.getInputStream());
                int c;
                Vector v = new Vector();
                StringBuffer output = new StringBuffer();
                // echo output
                while ((c = in.read()) != -1) {
                        output.append((char)c);
                }
                in.close();
                // echo errors
                in = new LocalizedInput(p.getErrorStream());
                // echo output
                while ((c = in.read()) != -1) {
                        output.append((char)c);
                }
                in.close();
                v.addElement(output);
                result = new ijVectorResult(v,null);
                // wait for completion
                try {
                        p.waitFor();
                } catch (InterruptedException e) {
                        {if (true) throw ijException.bangException(e);}
                }
          } catch (IOException ioe) {
                {if (true) throw ijException.bangException(ioe);}
          }
          {if (true) return result;}
    throw new Error("Missing return statement in function");
  }

/**
	ExpectStatement is EXPECT [ FAIL ] {'String'}* END EXPECT
	<p>
	Will eventually detect the lines that the strings are without
	special literals, but for now this is expedient (except for the
	doubling of quotes...)
	<p>
	Used to test the previous statement's output. Note that ij must be
	in "expect" mode to use this statement, otherwise it is just
	ignored.  This is due to the overhead of tracking the prior statement's
	output.
 */
  final public ijResult ExpectStatement() throws ParseException {
        Token f = null;
        Vector stringVector = new Vector();
    jj_consume_token(EXPECT);
    if (jj_2_117(2)) {
      f = jj_consume_token(FAIL);
    } else {
      ;
    }
    StringList(stringVector);
    jj_consume_token(END);
    jj_consume_token(EXPECT);
                if (!getExpect()) {if (true) return null;} // don't bother processing.

                // FIXME

                // Do the comparison of the string list to the prior rows of
                // output, using a row-by-row perl-regex comparison.
                boolean result = true;

                // register the result and whether it should be true or false
                // FIXME: how to find the expecter??
                noteExpect(result, f==null);

                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

  final public void StringList(Vector v) throws ParseException {
    StringItem(v);
    label_1:
    while (true) {
      if (jj_2_118(2)) {
        ;
      } else {
        break label_1;
      }
      StringItem(v);
    }
  }

  final public void StringItem(Vector v) throws ParseException {
        Token s;
    s = jj_consume_token(STRING);
                v.addElement(s);
  }

/**
	Haven't included: ASYNC, !, EXPECT
	Don't include: XA_*
 **/
  final public ijResult HelpStatement() throws ParseException {
    jj_consume_token(HELP);
                Vector v = new Vector();

                StringTokenizer st = new StringTokenizer(LocalizedResource.getMessage("IJ_HelpText"), "\n");
                while (st.hasMoreTokens()) {
                    v.addElement(st.nextToken());
                }

                {if (true) return new ijVectorResult(v,null);}
    throw new Error("Missing return statement in function");
  }

  final public String identifier() throws ParseException {
        Token t;
    t = jj_consume_token(IDENTIFIER);
                // identifiers are case insensitive, so we map them up.
                // ij doesn't recognize any use of delimited identifiers in its syntax.
                {if (true) return (t.image.toUpperCase(Locale.ENGLISH));}
    throw new Error("Missing return statement in function");
  }

  final public int intLiteral() throws ParseException, SQLException {
        String  sign = "";
        Token   tok;
    if (jj_2_119(2)) {
      sign = sign();
    } else {
      ;
    }
    tok = jj_consume_token(INTEGER);
                /*
		** The various java parse utilities can't handle leading +,
		** so only concatenate leading -.
		*/

                String num = tok.image;

                if (sign.equals("-"))
                {
                        num = sign.concat(num);
                }

                {if (true) return Integer.parseInt(num);}
    throw new Error("Missing return statement in function");
  }

  final public Vector staticMethodName() throws ParseException, SQLException {
        Vector  list = new Vector();
    methodLeg(list);
    label_2:
    while (true) {
      jj_consume_token(PERIOD);
      methodLeg(list);
      if (jj_2_120(2)) {
        ;
      } else {
        break label_2;
      }
    }
                {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public void methodLeg(Vector list) throws ParseException, SQLException {
        Token   id;
    id = jj_consume_token(IDENTIFIER);
                list.addElement( id.image );
  }

  final public String[] staticMethodArgs() throws ParseException, SQLException {
        Vector          list = new Vector();
        String[]        args;
    jj_consume_token(LEFT_PAREN);
    if (jj_2_122(2)) {
      oneStaticArg(list);
      label_3:
      while (true) {
        if (jj_2_121(2)) {
          ;
        } else {
          break label_3;
        }
        jj_consume_token(COMMA);
        oneStaticArg(list);
      }
    } else {
      ;
    }
    jj_consume_token(RIGHT_PAREN);
                args = new String[ list.size() ];
                list.copyInto( args );

                {if (true) return args;}
    throw new Error("Missing return statement in function");
  }

  final public void oneStaticArg(Vector list) throws ParseException, SQLException {
        Token   tok;
    tok = jj_consume_token(STRING);
                list.addElement( stringValue( tok.image ) );
  }

/*
 * <A NAME="sign">sign</A>
 */
  final public String sign() throws ParseException, SQLException {
        Token   s;
    if (jj_2_123(2)) {
      s = jj_consume_token(PLUS_SIGN);
                {if (true) return s.image;}
    } else if (jj_2_124(2)) {
      s = jj_consume_token(MINUS_SIGN);
                {if (true) return s.image;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
	Undocumented commands to help XA testing.

	This is the grammer for the XA commands

	&lt;XA_DATASOURCE&gt; 'dbname' ( &lt;CREATE&gt; | shutdown ) 
		 - get a XADataSource whose database name is dbname and make that
		XADataSource the current XADataSource

	&lt;XA_CONNECT&gt; 	[ &lt;USER&gt; 'user' ]
			[ &lt;PASSWORD&gt; 'password' ]
			[ &lt;AS&gt; xaconnid ] 
		- make an XAConnection using the current XADataSource and make
		that XAConnection the current XAConnection.  If xaconnid is 
		given, then associate xaconnid with the XAConnection.  
		(xaconnid not implemeneted)


	&lt;XA_COMMIT&gt;  ( &lt;XA_1PHASE&gt; | &lt;XA_2PHASE&gt; ) xid
		- commit a global transaction xid


	&lt;XA_DISCONNECT&gt; [ xaconnid = identifier() ] 
		- disconnect an XAConnection.  If xaconnid is given, then
		disconnect the XAConnection with the given xaconnid. 
		(xaconnid not implemeneted)


	&lt;XA_END&gt; ( &lt;XA_SUSPEND&gt; | &lt;XA_SUCCESS&gt; | &lt;XA_FAIL&gt; ) xid
		- dissociate a transaction from the current XAConnection or end
		an already suspened one 

	&lt;XA_FORGET&gt; xid		- forget about a global transaction

	&lt;XA_GETCONNECTION&gt;  [ &lt;AS&gt; connid ] 
		- get a Connection object from the current XAConnection.
		If connid is given, then associate connid with the connection.
		(connid not implemented)

	&lt;XA_PREPARE&gt; xid	- prepare a global transaction

	&lt;XA_RECOVER&gt; ( &lt;XA_NOFLAGS&gt; | &lt;XA_STARTRSCAN&gt; | &lt;XA_ENDRSCAN&gt; )
	 	- return the list of in-doubt transactions

	&lt;XA_ROLLBACK&gt; xid	- rollback a global transaction

	&lt;XA_START&gt; ( &lt;XA_NOFLAGS&gt; | &lt;XA_JOIN&gt; | &lt;XA_RESUME&gt; ) xid
		- associate a transaction or start a new global
		transaction with the current XAConnection.

	The following is for testing other JDBC2.0 ext interface, DataSource
	and ConnectionPoolDataSource.  Strictly speaking, these are not xa, but
	their functionality will be lumped into xaHelper because these are here
	only for testing purposes.

	&lt;DATASOURCE&gt; 'dbname'	[ &lt;PROTOCOL&gt; 'protocol' ]
				[ &lt;USER&gt; 'user' ]
				[ &lt;PASSWORD&gt; 'password' ]
				[ &lt;AS&gt; n=identifier() ]
		- get a data source whose database name is dbname and make that
		DataSource the current DataSource.  If &lt;PROTOCOL&gt; is specified,
		the DataSource may be remote.   Get a connection from that
		dataSource and use the user/password if specified.

	&lt;CP_DATASOURCE&gt; 'dbname' [ &lt;PROTOCOL&gt; 'protocol' ]
		- get a connection pool data source whose database name is
		dbname and make that DataSource the current CPDataSource.  
		If &lt;PROTOCOL&gt; is specified, the DataSource may be
		remote.

	&lt;CP_CONNECT&gt;	[ &lt;USER&gt; 'user' ]
			[ &lt;PASSWORD&gt; 'password' ]
			[ &lt;AS&gt; cpconnid ]
		- make a PooledConnection using the current CPDataSource and
		make that PooledConnection the current PooledConnection.
		If cpconnid is given, then associate cpconnid with the
		PooledConnection. (cpconnid not implemented).

	&lt;CP_GETCONNECTION&gt; [ &lt;AS&gt; connid ]
		- get a Connection object from the current PooledConnection.
		If connid is given, the associate connid with the connection.
		(connid not implemented)

	&lt;CP_DISCONNECT&gt; [  cpconnid = identifier() ] 
		- disconnect a PooledConnection.  If cpconnid is given, then
		disconnect the PooledConnection with the given cpconnid. 
		(cpconnid not implemented)

*/


/**
 * XA_DataSourceStatement is XA_DataSource 'dbname' ( create | shutdown )
 * We new'ed an instance of XADataSource as the current DataSource and set its
 * database name to dbname.
 */
  final public ijResult XA_DataSourceStatement() throws ParseException, SQLException {
        Token dbname = null;
        Token shut = null;
        String create = null;
    jj_consume_token(XA_DATASOURCE);
    dbname = jj_consume_token(STRING);
    if (jj_2_127(2)) {
      if (jj_2_125(2)) {
        shut = jj_consume_token(SHUTDOWN);
      } else if (jj_2_126(2)) {
        create = identifier();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
                xahelper.XADataSourceStatement(this, dbname, shut, create);

                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * XA_ConnectStatement is XA_CONNECT (&lt;AS&gt; connid)
 * make a XAConnection using the currentXADataSource and make that XAConnection
 * the current XAConnection.  If connid is given, then associate connid with
 * the XAConnection.  This connid is not th xid.
 */
  final public ijResult XA_ConnectStatement() throws ParseException, SQLException {
        Token userT = null;
        Token passwordT = null;
        String n = null;
    jj_consume_token(XA_CONNECT);
    if (jj_2_128(2)) {
      jj_consume_token(USER);
      userT = jj_consume_token(STRING);
    } else {
      ;
    }
    if (jj_2_129(2)) {
      jj_consume_token(PASSWORD);
      passwordT = jj_consume_token(STRING);
    } else {
      ;
    }
    if (jj_2_130(2)) {
      jj_consume_token(AS);
      n = identifier();
    } else {
      ;
    }
                xahelper.XAConnectStatement(this, userT, passwordT, n);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * XA_DisconnectStatement is XA_DISCONNECT [xaconnid = identifier()]
 * disconnect the current XAConnection 
 * If xaconnid is given, then disconnect XAConnection with xaconnid (xaconnid
 *	not implemented).
 * 
 */
  final public ijResult XA_DisconnectStatement() throws ParseException, SQLException {
        String n = null;
    jj_consume_token(XA_DISCONNECT);
    if (jj_2_131(2)) {
      n = identifier();
    } else {
      ;
    }
                xahelper.XADisconnectStatement(this, n);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * XA_CommitStatement is XA_COMMIT [ XA_1PHASE | XA_2PHASE ] xid
 * commits a global transaction xid
 */
  final public ijResult XA_CommitStatement() throws ParseException, SQLException {
        Token onePhase=null;
        Token twoPhase=null;
        int xid = 0;
    jj_consume_token(XA_COMMIT);
    if (jj_2_132(2)) {
      onePhase = jj_consume_token(XA_1PHASE);
    } else if (jj_2_133(2)) {
      twoPhase = jj_consume_token(XA_2PHASE);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    xid = intValue();
                xahelper.CommitStatement(this, onePhase, twoPhase, xid);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * XA_EndStatement is XA_END [ XA_SUSPEND | XA_SUCCESS | XA_FAIL] xid
 * dissociates a transaction from the current XAConnection or end an already
 * suspended one
 */
  final public ijResult XA_EndStatement() throws ParseException, SQLException {
        int flag = 0;
        int xid = 0;
    jj_consume_token(XA_END);
    flag = xatmflag();
    xid = intValue();
                xahelper.EndStatement(this, flag, xid);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * XA_ForgetStatement is XA_FORGET xid
 * forgets about a heuristically completed transaction
 */
  final public ijResult XA_ForgetStatement() throws ParseException, SQLException {
        int xid = 0;
    jj_consume_token(XA_FORGET);
    xid = intValue();
                xahelper.ForgetStatement(this, xid);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * XA_GetConnectionStatement is XA_GETCONNECTION
 * it gets a Connection from the currentXAConnection and uses that as the
 * current connection 
 */
  final public ijResult XA_GetConnectionStatement() throws ParseException, SQLException {
        String n = "XA";
    jj_consume_token(XA_GETCONNECTION);
    if (jj_2_134(2)) {
      jj_consume_token(AS);
      n = identifier();
    } else {
      ;
    }
                theConnection = xahelper.XAGetConnectionStatement(this, n);
                currentConnEnv.addSession(theConnection, n);

                {if (true) return new ijConnectionResult(theConnection);}
    throw new Error("Missing return statement in function");
  }

/**
 * XA_PrepareStatement is XA_PREPARE xid
 * prepares a global transaction
 */
  final public ijResult XA_PrepareStatement() throws ParseException, SQLException {
        int xid = 0;
    jj_consume_token(XA_PREPARE);
    xid = intValue();
                xahelper.PrepareStatement(this, xid);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * XA_RecoverStatement is XA_RECOVER flag
 * displays the list of prepared transactions
 */
  final public ijResult XA_RecoverStatement() throws ParseException, SQLException {
        int flag = 0;
    jj_consume_token(XA_RECOVER);
    flag = xatmflag();
                {if (true) return xahelper.RecoverStatement(this, flag);}
    throw new Error("Missing return statement in function");
  }

/**
 * XA_RollbackStatement is XA_Rollback xid
 * rolls back a global transaction
 */
  final public ijResult XA_RollbackStatement() throws ParseException, SQLException {
        int xid = 0;
    jj_consume_token(XA_ROLLBACK);
    xid = intValue();
                xahelper.RollbackStatement(this, xid);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * XA_StartStatement is XA_START [ XA_NOFLAGS | XA_JOIN | XA_RESUME ] xid
 * start or associates a transaction with the current XAConnection
 */
  final public ijResult XA_StartStatement() throws ParseException, SQLException {
        int flag = 0;
        int xid = 0;
    jj_consume_token(XA_START);
    flag = xatmflag();
    xid = intValue();
                xahelper.StartStatement(this, flag, xid);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

  final public int xatmflag() throws ParseException, SQLException {
    if (jj_2_135(2)) {
      jj_consume_token(XA_ENDRSCAN);
                {if (true) return JDBC20Translation.XA_ENDRSCAN;}
    } else if (jj_2_136(2)) {
      jj_consume_token(XA_FAIL);
                {if (true) return JDBC20Translation.XA_FAIL;}
    } else if (jj_2_137(2)) {
      jj_consume_token(XA_JOIN);
                {if (true) return JDBC20Translation.XA_JOIN;}
    } else if (jj_2_138(2)) {
      jj_consume_token(XA_NOFLAGS);
                {if (true) return JDBC20Translation.XA_NOFLAGS;}
    } else if (jj_2_139(2)) {
      jj_consume_token(XA_RESUME);
                {if (true) return JDBC20Translation.XA_RESUME;}
    } else if (jj_2_140(2)) {
      jj_consume_token(XA_STARTRSCAN);
                {if (true) return JDBC20Translation.XA_STARTRSCAN;}
    } else if (jj_2_141(2)) {
      jj_consume_token(XA_SUCCESS);
                {if (true) return JDBC20Translation.XA_SUCCESS;}
    } else if (jj_2_142(2)) {
      jj_consume_token(XA_SUSPEND);
                {if (true) return JDBC20Translation.XA_SUSPEND;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

/**
 * DataSourceStatement is 
 *	DataSource 'dbname' 
 *		[ &lt;PROTCOL&gt; 'protocol']
 *		[ &lt;USER&gt; 'user' ]
 *		[ &lt;PASSWORD&gt; 'password' ]
 *		[ &lt;AS&gt; n=identifier() ]
 *
 * We new'ed an instance of DataSource as the current DataSource and set its
 * database name to dbname.  Also get a connection
 */
  final public ijResult DataSourceStatement() throws ParseException, SQLException {
        Token dbname = null;
        Token protocol = null;
        Token userT = null;
        Token passwordT = null;
        String n = null;
    jj_consume_token(DATASOURCE);
    dbname = jj_consume_token(STRING);
    if (jj_2_143(2)) {
      jj_consume_token(PROTOCOL);
      protocol = jj_consume_token(STRING);
    } else {
      ;
    }
    if (jj_2_144(2)) {
      jj_consume_token(USER);
      userT = jj_consume_token(STRING);
    } else {
      ;
    }
    if (jj_2_145(2)) {
      jj_consume_token(PASSWORD);
      passwordT = jj_consume_token(STRING);
    } else {
      ;
    }
    if (jj_2_146(2)) {
      jj_consume_token(AS);
      n = identifier();
    } else {
      ;
    }
                theConnection = xahelper.DataSourceStatement(this, dbname, protocol,
                        userT, passwordT, n);

                {if (true) return addSession( theConnection, n );}
    throw new Error("Missing return statement in function");
  }

/**
 * CP_DataSourceStatement is
 *	CP_DataSource 'dbname' [ &lt;PROTOCOL&gt; 'protocol' ]
 *		- get a connection pool data source whose database name is
 *		dbname and make that DataSource the current CPDataSource.  
 *		If &lt;PROTOCOL&gt; is specified, the DataSource may be
 *		remote.
 */
  final public ijResult CP_DataSourceStatement() throws ParseException, SQLException {
        Token dbname = null;
        Token protocol = null;
    jj_consume_token(CP_DATASOURCE);
    dbname = jj_consume_token(STRING);
    if (jj_2_147(2)) {
      jj_consume_token(PROTOCOL);
      protocol = jj_consume_token(STRING);
    } else {
      ;
    }
                xahelper.CPDataSourceStatement(this, dbname, protocol);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * CP_ConnectStatement is
 *	&lt;CP_CONNECT&gt;	[ &lt;USER&gt; 'user' ]
 *			[ &lt;PASSWORD&gt; 'password' ]
 *			[ &lt;AS&gt; cpconnid ]
 * make a PooledConnection using the current CPDataSource and
 * make that PooledConnection the current PooledConnection.
 * If cpconnid is given, then associate cpconnid with the
 * PooledConnection. (cpconnid not implemented).
 */
  final public ijResult CP_ConnectStatement() throws ParseException, SQLException {
        Token userT = null;
        Token passwordT = null;
        String n = null;
    jj_consume_token(CP_CONNECT);
    if (jj_2_148(2)) {
      jj_consume_token(USER);
      userT = jj_consume_token(STRING);
    } else {
      ;
    }
    if (jj_2_149(2)) {
      jj_consume_token(PASSWORD);
      passwordT = jj_consume_token(STRING);
    } else {
      ;
    }
    if (jj_2_150(2)) {
      jj_consume_token(AS);
      n = identifier();
    } else {
      ;
    }
                xahelper.CPConnectStatement(this, userT, passwordT, n);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

/**
 * CP_GetConnectionStatement is
 *	&lt;CP_GETCONNECTION&gt; [ &lt;AS&gt; connid ]
 * get a Connection object from the current PooledConnection.
 * If connid is given, the associate connid with the connection.
 * (connid not implemented)
 */
  final public ijResult CP_GetConnectionStatement() throws ParseException, SQLException {
        String n = "Pooled";
    jj_consume_token(CP_GETCONNECTION);
    if (jj_2_151(2)) {
      jj_consume_token(AS);
      n = identifier();
    } else {
      ;
    }
                theConnection = xahelper.CPGetConnectionStatement(this, n);
                currentConnEnv.addSession(theConnection, n);
                {if (true) return new ijConnectionResult(theConnection);}
    throw new Error("Missing return statement in function");
  }

/**
 * CP_DisconnectStatement is
 *	&lt;CP_DISCONNECT&gt; [ cpconnid = identifier() ]
 * disconnect a PooledConnection.  If cpconnid is given, then
 * disconnect the PooledConnection with the given cpconnid. 
 * (cpconnid not implemented)
 */
  final public ijResult CP_DisconnectStatement() throws ParseException, SQLException {
        String n = null;
    jj_consume_token(CP_DISCONNECT);
    if (jj_2_152(2)) {
      n = identifier();
    } else {
      ;
    }
                xahelper.CPDisconnectStatement(this, n);
                {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

  final public Properties attributeList() throws ParseException {
        Properties properties = new Properties();
        Token tok;
        String value;
    if (jj_2_154(2)) {
      property(properties);
      label_4:
      while (true) {
        if (jj_2_153(2)) {
          ;
        } else {
          break label_4;
        }
        jj_consume_token(COMMA);
        property(properties);
      }
    } else {
      ;
    }
                //properties.put(tok.image,value);
                {if (true) return properties;}
    throw new Error("Missing return statement in function");
  }

  final public void property(Properties properties) throws ParseException {
        String key;
        String value;
    key = caseSensitiveIdentifierOrKeyword();
    jj_consume_token(EQUALS_OPERATOR);
    value = caseSensitiveIdentifierOrKeyword();
                properties.put(key, value);
  }

  final public String caseSensitiveIdentifierOrKeyword() throws ParseException {
        String value=null;
        Token tok;
    if (jj_2_155(2)) {
      value = keyword();
                {if (true) return value;}
    } else if (jj_2_156(2)) {
      tok = jj_consume_token(IDENTIFIER);
                {if (true) return tok.image;}
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String caseSensitiveIdentifier() throws ParseException {
        Token tok;
    tok = jj_consume_token(IDENTIFIER);
                {if (true) return tok.image;}
    throw new Error("Missing return statement in function");
  }

  final public String keyword() throws ParseException {
        Token tok;
        String value= null;
    if (jj_2_157(2)) {
      tok = jj_consume_token(ABSOLUTE);
    } else if (jj_2_158(2)) {
      tok = jj_consume_token(AFTER);
    } else if (jj_2_159(2)) {
      tok = jj_consume_token(ALIASES);
    } else if (jj_2_160(2)) {
      tok = jj_consume_token(ALL);
    } else if (jj_2_161(2)) {
      tok = jj_consume_token(AS);
    } else if (jj_2_162(2)) {
      tok = jj_consume_token(ASYNC);
    } else if (jj_2_163(2)) {
      tok = jj_consume_token(ATTRIBUTES);
    } else if (jj_2_164(2)) {
      tok = jj_consume_token(AUTOCOMMIT);
    } else if (jj_2_165(2)) {
      tok = jj_consume_token(BANG);
    } else if (jj_2_166(2)) {
      tok = jj_consume_token(BEFORE);
    } else if (jj_2_167(2)) {
      tok = jj_consume_token(CLOSE);
    } else if (jj_2_168(2)) {
      tok = jj_consume_token(COMMIT);
    } else if (jj_2_169(2)) {
      tok = jj_consume_token(CONNECT);
    } else if (jj_2_170(2)) {
      tok = jj_consume_token(CONNECTION);
    } else if (jj_2_171(2)) {
      tok = jj_consume_token(CONNECTIONS);
    } else if (jj_2_172(2)) {
      tok = jj_consume_token(CURRENT);
    } else if (jj_2_173(2)) {
      tok = jj_consume_token(CURSOR);
    } else if (jj_2_174(2)) {
      tok = jj_consume_token(DESCRIBE);
    } else if (jj_2_175(2)) {
      tok = jj_consume_token(DISCONNECT);
    } else if (jj_2_176(2)) {
      tok = jj_consume_token(DRIVER);
    } else if (jj_2_177(2)) {
      tok = jj_consume_token(ELAPSEDTIME);
    } else if (jj_2_178(2)) {
      tok = jj_consume_token(END);
    } else if (jj_2_179(2)) {
      tok = jj_consume_token(EXECUTE);
    } else if (jj_2_180(2)) {
      tok = jj_consume_token(EXIT);
    } else if (jj_2_181(2)) {
      tok = jj_consume_token(EXPECT);
    } else if (jj_2_182(2)) {
      tok = jj_consume_token(FAIL);
    } else if (jj_2_183(2)) {
      tok = jj_consume_token(FIRST);
    } else if (jj_2_184(2)) {
      tok = jj_consume_token(FOR);
    } else if (jj_2_185(2)) {
      tok = jj_consume_token(FROM);
    } else if (jj_2_186(2)) {
      tok = jj_consume_token(GET);
    } else if (jj_2_187(2)) {
      tok = jj_consume_token(GETCURRENTROWNUMBER);
    } else if (jj_2_188(2)) {
      tok = jj_consume_token(HOLD);
    } else if (jj_2_189(2)) {
      tok = jj_consume_token(HELP);
    } else if (jj_2_190(2)) {
      tok = jj_consume_token(IN);
    } else if (jj_2_191(2)) {
      tok = jj_consume_token(INDEXES);
    } else if (jj_2_192(2)) {
      tok = jj_consume_token(INSENSITIVE);
    } else if (jj_2_193(2)) {
      tok = jj_consume_token(INTO);
    } else if (jj_2_194(2)) {
      tok = jj_consume_token(LAST);
    } else if (jj_2_195(2)) {
      tok = jj_consume_token(LOCALIZEDDISPLAY);
    } else if (jj_2_196(2)) {
      tok = jj_consume_token(MAXIMUMDISPLAYWIDTH);
    } else if (jj_2_197(2)) {
      tok = jj_consume_token(NAME);
    } else if (jj_2_198(2)) {
      tok = jj_consume_token(NEXT);
    } else if (jj_2_199(2)) {
      tok = jj_consume_token(NOHOLD);
    } else if (jj_2_200(2)) {
      tok = jj_consume_token(NOHOLDFORCONNECTION);
    } else if (jj_2_201(2)) {
      tok = jj_consume_token(OFF);
    } else if (jj_2_202(2)) {
      tok = jj_consume_token(ON);
    } else if (jj_2_203(2)) {
      tok = jj_consume_token(PASSWORD);
    } else if (jj_2_204(2)) {
      tok = jj_consume_token(PERIOD);
    } else if (jj_2_205(2)) {
      tok = jj_consume_token(PREPARE);
    } else if (jj_2_206(2)) {
      tok = jj_consume_token(PREVIOUS);
    } else if (jj_2_207(2)) {
      tok = jj_consume_token(PROCEDURE);
    } else if (jj_2_208(2)) {
      tok = jj_consume_token(PROCEDURES);
    } else if (jj_2_209(2)) {
      tok = jj_consume_token(PROPERTIES);
    } else if (jj_2_210(2)) {
      tok = jj_consume_token(PROTOCOL);
    } else if (jj_2_211(2)) {
      tok = jj_consume_token(QUIT);
    } else if (jj_2_212(2)) {
      tok = jj_consume_token(READONLY);
    } else if (jj_2_213(2)) {
      tok = jj_consume_token(RELATIVE);
    } else if (jj_2_214(2)) {
      tok = jj_consume_token(REMOVE);
    } else if (jj_2_215(2)) {
      tok = jj_consume_token(RESOURCE);
    } else if (jj_2_216(2)) {
      tok = jj_consume_token(ROLLBACK);
    } else if (jj_2_217(2)) {
      tok = jj_consume_token(RUN);
    } else if (jj_2_218(2)) {
      tok = jj_consume_token(TO);
    } else if (jj_2_219(2)) {
      tok = jj_consume_token(SCHEMAS);
    } else if (jj_2_220(2)) {
      tok = jj_consume_token(SCROLL);
    } else if (jj_2_221(2)) {
      tok = jj_consume_token(SENSITIVE);
    } else if (jj_2_222(2)) {
      tok = jj_consume_token(SET);
    } else if (jj_2_223(2)) {
      tok = jj_consume_token(SHOW);
    } else if (jj_2_224(2)) {
      tok = jj_consume_token(SHUTDOWN);
    } else if (jj_2_225(2)) {
      tok = jj_consume_token(STATEMENT);
    } else if (jj_2_226(2)) {
      tok = jj_consume_token(SYNONYMS);
    } else if (jj_2_227(2)) {
      tok = jj_consume_token(TABLES);
    } else if (jj_2_228(2)) {
      tok = jj_consume_token(USER);
    } else if (jj_2_229(2)) {
      tok = jj_consume_token(USING);
    } else if (jj_2_230(2)) {
      tok = jj_consume_token(VIEWS);
    } else if (jj_2_231(2)) {
      tok = jj_consume_token(WAIT);
    } else if (jj_2_232(2)) {
      tok = jj_consume_token(WITH);
    } else if (jj_2_233(2)) {
      tok = jj_consume_token(XA_1PHASE);
    } else if (jj_2_234(2)) {
      tok = jj_consume_token(XA_2PHASE);
    } else if (jj_2_235(2)) {
      tok = jj_consume_token(XA_DATASOURCE);
    } else if (jj_2_236(2)) {
      tok = jj_consume_token(XA_CONNECT);
    } else if (jj_2_237(2)) {
      tok = jj_consume_token(XA_COMMIT);
    } else if (jj_2_238(2)) {
      tok = jj_consume_token(XA_DISCONNECT);
    } else if (jj_2_239(2)) {
      tok = jj_consume_token(XA_END);
    } else if (jj_2_240(2)) {
      tok = jj_consume_token(XA_ENDRSCAN);
    } else if (jj_2_241(2)) {
      tok = jj_consume_token(XA_FAIL);
    } else if (jj_2_242(2)) {
      tok = jj_consume_token(XA_FORGET);
    } else if (jj_2_243(2)) {
      tok = jj_consume_token(XA_GETCONNECTION);
    } else if (jj_2_244(2)) {
      tok = jj_consume_token(XA_JOIN);
    } else if (jj_2_245(2)) {
      tok = jj_consume_token(XA_NOFLAGS);
    } else if (jj_2_246(2)) {
      tok = jj_consume_token(XA_PREPARE);
    } else if (jj_2_247(2)) {
      tok = jj_consume_token(XA_RECOVER);
    } else if (jj_2_248(2)) {
      tok = jj_consume_token(XA_RESUME);
    } else if (jj_2_249(2)) {
      tok = jj_consume_token(XA_ROLLBACK);
    } else if (jj_2_250(2)) {
      tok = jj_consume_token(XA_START);
    } else if (jj_2_251(2)) {
      tok = jj_consume_token(XA_STARTRSCAN);
    } else if (jj_2_252(2)) {
      tok = jj_consume_token(XA_SUCCESS);
    } else if (jj_2_253(2)) {
      tok = jj_consume_token(XA_SUSPEND);
    } else if (jj_2_254(2)) {
      tok = jj_consume_token(DATASOURCE);
    } else if (jj_2_255(2)) {
      tok = jj_consume_token(CP_DATASOURCE);
    } else if (jj_2_256(2)) {
      tok = jj_consume_token(CP_CONNECT);
    } else if (jj_2_257(2)) {
      tok = jj_consume_token(CP_GETCONNECTION);
    } else if (jj_2_258(2)) {
      tok = jj_consume_token(CP_DISCONNECT);
    } else if (jj_2_259(2)) {
      tok = jj_consume_token(WORK);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
                {if (true) return tok.image;}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_51(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(50, xla); }
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_52(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(51, xla); }
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_53(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(52, xla); }
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_54(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(53, xla); }
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_55(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(54, xla); }
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_56(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(55, xla); }
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_57(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(56, xla); }
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_58(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(57, xla); }
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_59(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(58, xla); }
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_60(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(59, xla); }
  }

  final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_61(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(60, xla); }
  }

  final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_62(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(61, xla); }
  }

  final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_63(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(62, xla); }
  }

  final private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_64(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(63, xla); }
  }

  final private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_65(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(64, xla); }
  }

  final private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_66(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(65, xla); }
  }

  final private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_67(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(66, xla); }
  }

  final private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_68(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(67, xla); }
  }

  final private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_69(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(68, xla); }
  }

  final private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_70(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(69, xla); }
  }

  final private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_71(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(70, xla); }
  }

  final private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_72(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(71, xla); }
  }

  final private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_73(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(72, xla); }
  }

  final private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_74(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(73, xla); }
  }

  final private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_75(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(74, xla); }
  }

  final private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_76(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(75, xla); }
  }

  final private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_77(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(76, xla); }
  }

  final private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_78(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(77, xla); }
  }

  final private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_79(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(78, xla); }
  }

  final private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_80(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(79, xla); }
  }

  final private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_81(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(80, xla); }
  }

  final private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_82(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(81, xla); }
  }

  final private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_83(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(82, xla); }
  }

  final private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_84(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(83, xla); }
  }

  final private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_85(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(84, xla); }
  }

  final private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_86(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(85, xla); }
  }

  final private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_87(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(86, xla); }
  }

  final private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_88(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(87, xla); }
  }

  final private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_89(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(88, xla); }
  }

  final private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_90(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(89, xla); }
  }

  final private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_91(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(90, xla); }
  }

  final private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_92(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(91, xla); }
  }

  final private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_93(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(92, xla); }
  }

  final private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_94(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(93, xla); }
  }

  final private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_95(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(94, xla); }
  }

  final private boolean jj_2_96(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_96(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(95, xla); }
  }

  final private boolean jj_2_97(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_97(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(96, xla); }
  }

  final private boolean jj_2_98(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_98(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(97, xla); }
  }

  final private boolean jj_2_99(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_99(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(98, xla); }
  }

  final private boolean jj_2_100(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_100(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(99, xla); }
  }

  final private boolean jj_2_101(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_101(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(100, xla); }
  }

  final private boolean jj_2_102(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_102(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(101, xla); }
  }

  final private boolean jj_2_103(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_103(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(102, xla); }
  }

  final private boolean jj_2_104(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_104(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(103, xla); }
  }

  final private boolean jj_2_105(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_105(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(104, xla); }
  }

  final private boolean jj_2_106(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_106(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(105, xla); }
  }

  final private boolean jj_2_107(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_107(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(106, xla); }
  }

  final private boolean jj_2_108(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_108(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(107, xla); }
  }

  final private boolean jj_2_109(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_109(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(108, xla); }
  }

  final private boolean jj_2_110(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_110(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(109, xla); }
  }

  final private boolean jj_2_111(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_111(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(110, xla); }
  }

  final private boolean jj_2_112(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_112(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(111, xla); }
  }

  final private boolean jj_2_113(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_113(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(112, xla); }
  }

  final private boolean jj_2_114(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_114(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(113, xla); }
  }

  final private boolean jj_2_115(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_115(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(114, xla); }
  }

  final private boolean jj_2_116(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_116(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(115, xla); }
  }

  final private boolean jj_2_117(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_117(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(116, xla); }
  }

  final private boolean jj_2_118(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_118(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(117, xla); }
  }

  final private boolean jj_2_119(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_119(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(118, xla); }
  }

  final private boolean jj_2_120(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_120(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(119, xla); }
  }

  final private boolean jj_2_121(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_121(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(120, xla); }
  }

  final private boolean jj_2_122(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_122(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(121, xla); }
  }

  final private boolean jj_2_123(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_123(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(122, xla); }
  }

  final private boolean jj_2_124(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_124(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(123, xla); }
  }

  final private boolean jj_2_125(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_125(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(124, xla); }
  }

  final private boolean jj_2_126(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_126(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(125, xla); }
  }

  final private boolean jj_2_127(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_127(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(126, xla); }
  }

  final private boolean jj_2_128(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_128(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(127, xla); }
  }

  final private boolean jj_2_129(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_129(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(128, xla); }
  }

  final private boolean jj_2_130(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_130(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(129, xla); }
  }

  final private boolean jj_2_131(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_131(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(130, xla); }
  }

  final private boolean jj_2_132(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_132(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(131, xla); }
  }

  final private boolean jj_2_133(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_133(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(132, xla); }
  }

  final private boolean jj_2_134(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_134(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(133, xla); }
  }

  final private boolean jj_2_135(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_135(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(134, xla); }
  }

  final private boolean jj_2_136(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_136(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(135, xla); }
  }

  final private boolean jj_2_137(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_137(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(136, xla); }
  }

  final private boolean jj_2_138(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_138(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(137, xla); }
  }

  final private boolean jj_2_139(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_139(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(138, xla); }
  }

  final private boolean jj_2_140(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_140(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(139, xla); }
  }

  final private boolean jj_2_141(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_141(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(140, xla); }
  }

  final private boolean jj_2_142(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_142(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(141, xla); }
  }

  final private boolean jj_2_143(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_143(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(142, xla); }
  }

  final private boolean jj_2_144(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_144(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(143, xla); }
  }

  final private boolean jj_2_145(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_145(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(144, xla); }
  }

  final private boolean jj_2_146(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_146(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(145, xla); }
  }

  final private boolean jj_2_147(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_147(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(146, xla); }
  }

  final private boolean jj_2_148(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_148(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(147, xla); }
  }

  final private boolean jj_2_149(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_149(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(148, xla); }
  }

  final private boolean jj_2_150(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_150(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(149, xla); }
  }

  final private boolean jj_2_151(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_151(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(150, xla); }
  }

  final private boolean jj_2_152(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_152(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(151, xla); }
  }

  final private boolean jj_2_153(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_153(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(152, xla); }
  }

  final private boolean jj_2_154(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_154(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(153, xla); }
  }

  final private boolean jj_2_155(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_155(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(154, xla); }
  }

  final private boolean jj_2_156(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_156(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(155, xla); }
  }

  final private boolean jj_2_157(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_157(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(156, xla); }
  }

  final private boolean jj_2_158(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_158(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(157, xla); }
  }

  final private boolean jj_2_159(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_159(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(158, xla); }
  }

  final private boolean jj_2_160(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_160(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(159, xla); }
  }

  final private boolean jj_2_161(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_161(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(160, xla); }
  }

  final private boolean jj_2_162(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_162(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(161, xla); }
  }

  final private boolean jj_2_163(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_163(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(162, xla); }
  }

  final private boolean jj_2_164(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_164(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(163, xla); }
  }

  final private boolean jj_2_165(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_165(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(164, xla); }
  }

  final private boolean jj_2_166(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_166(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(165, xla); }
  }

  final private boolean jj_2_167(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_167(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(166, xla); }
  }

  final private boolean jj_2_168(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_168(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(167, xla); }
  }

  final private boolean jj_2_169(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_169(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(168, xla); }
  }

  final private boolean jj_2_170(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_170(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(169, xla); }
  }

  final private boolean jj_2_171(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_171(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(170, xla); }
  }

  final private boolean jj_2_172(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_172(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(171, xla); }
  }

  final private boolean jj_2_173(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_173(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(172, xla); }
  }

  final private boolean jj_2_174(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_174(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(173, xla); }
  }

  final private boolean jj_2_175(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_175(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(174, xla); }
  }

  final private boolean jj_2_176(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_176(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(175, xla); }
  }

  final private boolean jj_2_177(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_177(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(176, xla); }
  }

  final private boolean jj_2_178(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_178(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(177, xla); }
  }

  final private boolean jj_2_179(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_179(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(178, xla); }
  }

  final private boolean jj_2_180(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_180(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(179, xla); }
  }

  final private boolean jj_2_181(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_181(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(180, xla); }
  }

  final private boolean jj_2_182(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_182(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(181, xla); }
  }

  final private boolean jj_2_183(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_183(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(182, xla); }
  }

  final private boolean jj_2_184(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_184(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(183, xla); }
  }

  final private boolean jj_2_185(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_185(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(184, xla); }
  }

  final private boolean jj_2_186(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_186(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(185, xla); }
  }

  final private boolean jj_2_187(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_187(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(186, xla); }
  }

  final private boolean jj_2_188(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_188(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(187, xla); }
  }

  final private boolean jj_2_189(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_189(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(188, xla); }
  }

  final private boolean jj_2_190(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_190(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(189, xla); }
  }

  final private boolean jj_2_191(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_191(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(190, xla); }
  }

  final private boolean jj_2_192(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_192(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(191, xla); }
  }

  final private boolean jj_2_193(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_193(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(192, xla); }
  }

  final private boolean jj_2_194(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_194(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(193, xla); }
  }

  final private boolean jj_2_195(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_195(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(194, xla); }
  }

  final private boolean jj_2_196(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_196(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(195, xla); }
  }

  final private boolean jj_2_197(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_197(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(196, xla); }
  }

  final private boolean jj_2_198(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_198(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(197, xla); }
  }

  final private boolean jj_2_199(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_199(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(198, xla); }
  }

  final private boolean jj_2_200(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_200(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(199, xla); }
  }

  final private boolean jj_2_201(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_201(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(200, xla); }
  }

  final private boolean jj_2_202(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_202(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(201, xla); }
  }

  final private boolean jj_2_203(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_203(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(202, xla); }
  }

  final private boolean jj_2_204(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_204(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(203, xla); }
  }

  final private boolean jj_2_205(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_205(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(204, xla); }
  }

  final private boolean jj_2_206(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_206(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(205, xla); }
  }

  final private boolean jj_2_207(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_207(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(206, xla); }
  }

  final private boolean jj_2_208(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_208(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(207, xla); }
  }

  final private boolean jj_2_209(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_209(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(208, xla); }
  }

  final private boolean jj_2_210(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_210(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(209, xla); }
  }

  final private boolean jj_2_211(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_211(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(210, xla); }
  }

  final private boolean jj_2_212(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_212(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(211, xla); }
  }

  final private boolean jj_2_213(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_213(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(212, xla); }
  }

  final private boolean jj_2_214(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_214(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(213, xla); }
  }

  final private boolean jj_2_215(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_215(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(214, xla); }
  }

  final private boolean jj_2_216(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_216(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(215, xla); }
  }

  final private boolean jj_2_217(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_217(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(216, xla); }
  }

  final private boolean jj_2_218(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_218(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(217, xla); }
  }

  final private boolean jj_2_219(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_219(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(218, xla); }
  }

  final private boolean jj_2_220(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_220(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(219, xla); }
  }

  final private boolean jj_2_221(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_221(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(220, xla); }
  }

  final private boolean jj_2_222(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_222(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(221, xla); }
  }

  final private boolean jj_2_223(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_223(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(222, xla); }
  }

  final private boolean jj_2_224(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_224(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(223, xla); }
  }

  final private boolean jj_2_225(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_225(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(224, xla); }
  }

  final private boolean jj_2_226(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_226(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(225, xla); }
  }

  final private boolean jj_2_227(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_227(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(226, xla); }
  }

  final private boolean jj_2_228(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_228(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(227, xla); }
  }

  final private boolean jj_2_229(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_229(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(228, xla); }
  }

  final private boolean jj_2_230(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_230(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(229, xla); }
  }

  final private boolean jj_2_231(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_231(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(230, xla); }
  }

  final private boolean jj_2_232(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_232(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(231, xla); }
  }

  final private boolean jj_2_233(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_233(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(232, xla); }
  }

  final private boolean jj_2_234(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_234(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(233, xla); }
  }

  final private boolean jj_2_235(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_235(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(234, xla); }
  }

  final private boolean jj_2_236(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_236(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(235, xla); }
  }

  final private boolean jj_2_237(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_237(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(236, xla); }
  }

  final private boolean jj_2_238(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_238(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(237, xla); }
  }

  final private boolean jj_2_239(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_239(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(238, xla); }
  }

  final private boolean jj_2_240(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_240(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(239, xla); }
  }

  final private boolean jj_2_241(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_241(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(240, xla); }
  }

  final private boolean jj_2_242(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_242(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(241, xla); }
  }

  final private boolean jj_2_243(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_243(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(242, xla); }
  }

  final private boolean jj_2_244(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_244(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(243, xla); }
  }

  final private boolean jj_2_245(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_245(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(244, xla); }
  }

  final private boolean jj_2_246(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_246(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(245, xla); }
  }

  final private boolean jj_2_247(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_247(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(246, xla); }
  }

  final private boolean jj_2_248(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_248(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(247, xla); }
  }

  final private boolean jj_2_249(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_249(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(248, xla); }
  }

  final private boolean jj_2_250(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_250(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(249, xla); }
  }

  final private boolean jj_2_251(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_251(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(250, xla); }
  }

  final private boolean jj_2_252(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_252(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(251, xla); }
  }

  final private boolean jj_2_253(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_253(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(252, xla); }
  }

  final private boolean jj_2_254(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_254(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(253, xla); }
  }

  final private boolean jj_2_255(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_255(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(254, xla); }
  }

  final private boolean jj_2_256(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_256(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(255, xla); }
  }

  final private boolean jj_2_257(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_257(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(256, xla); }
  }

  final private boolean jj_2_258(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_258(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(257, xla); }
  }

  final private boolean jj_2_259(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_259(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(258, xla); }
  }

  final private boolean jj_3_43() {
    if (jj_3R_46()) return true;
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_3R_45()) return true;
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_3R_44()) return true;
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_3R_43()) return true;
    return false;
  }

  final private boolean jj_3_39() {
    if (jj_3R_42()) return true;
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_3R_68()) return true;
    Token xsp;
    if (jj_3_120()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_120()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3_38() {
    if (jj_3R_41()) return true;
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_3R_40()) return true;
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_3R_39()) return true;
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_3R_38()) return true;
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_3R_37()) return true;
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_3R_36()) return true;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_3R_35()) return true;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_3R_34()) return true;
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_3R_33()) return true;
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_3R_32()) return true;
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_3R_31()) return true;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_3R_30()) return true;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_3R_29()) return true;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_3R_28()) return true;
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_3R_27()) return true;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(NEXT)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_3R_26()) return true;
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_3R_25()) return true;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_3R_24()) return true;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_3R_23()) return true;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_3R_22()) return true;
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_3R_21()) return true;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_3R_20()) return true;
    return false;
  }

  final private boolean jj_3_259() {
    if (jj_scan_token(WORK)) return true;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3_119() {
    if (jj_3R_67()) return true;
    return false;
  }

  final private boolean jj_3_258() {
    if (jj_scan_token(CP_DISCONNECT)) return true;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_3R_19()) return true;
    return false;
  }

  final private boolean jj_3_257() {
    if (jj_scan_token(CP_GETCONNECTION)) return true;
    return false;
  }

  final private boolean jj_3R_72() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_119()) jj_scanpos = xsp;
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_3R_18()) return true;
    return false;
  }

  final private boolean jj_3_256() {
    if (jj_scan_token(CP_CONNECT)) return true;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_3R_17()) return true;
    return false;
  }

  final private boolean jj_3_255() {
    if (jj_scan_token(CP_DATASOURCE)) return true;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_16()) return true;
    return false;
  }

  final private boolean jj_3_254() {
    if (jj_scan_token(DATASOURCE)) return true;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_15()) return true;
    return false;
  }

  final private boolean jj_3_253() {
    if (jj_scan_token(XA_SUSPEND)) return true;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_14()) return true;
    return false;
  }

  final private boolean jj_3_252() {
    if (jj_scan_token(XA_SUCCESS)) return true;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_13()) return true;
    return false;
  }

  final private boolean jj_3_251() {
    if (jj_scan_token(XA_STARTRSCAN)) return true;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_12()) return true;
    return false;
  }

  final private boolean jj_3_250() {
    if (jj_scan_token(XA_START)) return true;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_11()) return true;
    return false;
  }

  final private boolean jj_3_249() {
    if (jj_scan_token(XA_ROLLBACK)) return true;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3_248() {
    if (jj_scan_token(XA_RESUME)) return true;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_9()) return true;
    return false;
  }

  final private boolean jj_3_247() {
    if (jj_scan_token(XA_RECOVER)) return true;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_8()) return true;
    return false;
  }

  final private boolean jj_3_246() {
    if (jj_scan_token(XA_PREPARE)) return true;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_7()) return true;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_scan_token(FIRST)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_245() {
    if (jj_scan_token(XA_NOFLAGS)) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_6()) return true;
    return false;
  }

  final private boolean jj_3_244() {
    if (jj_scan_token(XA_JOIN)) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_5()) return true;
    return false;
  }

  final private boolean jj_3_243() {
    if (jj_scan_token(XA_GETCONNECTION)) return true;
    return false;
  }

  final private boolean jj_3_242() {
    if (jj_scan_token(XA_FORGET)) return true;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3_241() {
    if (jj_scan_token(XA_FAIL)) return true;
    return false;
  }

  final private boolean jj_3_240() {
    if (jj_scan_token(XA_ENDRSCAN)) return true;
    return false;
  }

  final private boolean jj_3_239() {
    if (jj_scan_token(XA_END)) return true;
    return false;
  }

  final private boolean jj_3_238() {
    if (jj_scan_token(XA_DISCONNECT)) return true;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_3R_76()) return true;
    return false;
  }

  final private boolean jj_3_56() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = getToken(1).kind == ROLLBACK &&
                        (!(getToken(3).kind == TO || getToken(3).kind == SAVEPOINT));
    lookingAhead = false;
    if (!jj_semLA || jj_3R_59()) {
    jj_scanpos = xsp;
    if (jj_3_1()) {
    jj_scanpos = xsp;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3_12()) {
    jj_scanpos = xsp;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3_17()) {
    jj_scanpos = xsp;
    if (jj_3_18()) {
    jj_scanpos = xsp;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_3_22()) {
    jj_scanpos = xsp;
    if (jj_3_23()) {
    jj_scanpos = xsp;
    if (jj_3_24()) {
    jj_scanpos = xsp;
    if (jj_3_25()) {
    jj_scanpos = xsp;
    if (jj_3_26()) {
    jj_scanpos = xsp;
    if (jj_3_27()) {
    jj_scanpos = xsp;
    if (jj_3_28()) {
    jj_scanpos = xsp;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3_31()) {
    jj_scanpos = xsp;
    if (jj_3_32()) {
    jj_scanpos = xsp;
    if (jj_3_33()) {
    jj_scanpos = xsp;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3_35()) {
    jj_scanpos = xsp;
    if (jj_3_36()) {
    jj_scanpos = xsp;
    if (jj_3_37()) {
    jj_scanpos = xsp;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3_40()) {
    jj_scanpos = xsp;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3_42()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3_44()) {
    jj_scanpos = xsp;
    if (jj_3_45()) {
    jj_scanpos = xsp;
    if (jj_3_46()) {
    jj_scanpos = xsp;
    if (jj_3_47()) {
    jj_scanpos = xsp;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3_50()) {
    jj_scanpos = xsp;
    if (jj_3_51()) {
    jj_scanpos = xsp;
    if (jj_3_52()) {
    jj_scanpos = xsp;
    if (jj_3_53()) {
    jj_scanpos = xsp;
    if (jj_3_54()) {
    jj_scanpos = xsp;
    if (jj_3_55()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_237() {
    if (jj_scan_token(XA_COMMIT)) return true;
    return false;
  }

  final private boolean jj_3_236() {
    if (jj_scan_token(XA_CONNECT)) return true;
    return false;
  }

  final private boolean jj_3_235() {
    if (jj_scan_token(XA_DATASOURCE)) return true;
    return false;
  }

  final private boolean jj_3_234() {
    if (jj_scan_token(XA_2PHASE)) return true;
    return false;
  }

  final private boolean jj_3_233() {
    if (jj_scan_token(XA_1PHASE)) return true;
    return false;
  }

  final private boolean jj_3_232() {
    if (jj_scan_token(WITH)) return true;
    return false;
  }

  final private boolean jj_3_231() {
    if (jj_scan_token(WAIT)) return true;
    return false;
  }

  final private boolean jj_3_230() {
    if (jj_scan_token(VIEWS)) return true;
    return false;
  }

  final private boolean jj_3_229() {
    if (jj_scan_token(USING)) return true;
    return false;
  }

  final private boolean jj_3_228() {
    if (jj_scan_token(USER)) return true;
    return false;
  }

  final private boolean jj_3_227() {
    if (jj_scan_token(TABLES)) return true;
    return false;
  }

  final private boolean jj_3_226() {
    if (jj_scan_token(SYNONYMS)) return true;
    return false;
  }

  final private boolean jj_3_225() {
    if (jj_scan_token(STATEMENT)) return true;
    return false;
  }

  final private boolean jj_3R_10() {
    if (jj_scan_token(BEFORE)) return true;
    if (jj_scan_token(FIRST)) return true;
    return false;
  }

  final private boolean jj_3_224() {
    if (jj_scan_token(SHUTDOWN)) return true;
    return false;
  }

  final private boolean jj_3_223() {
    if (jj_scan_token(SHOW)) return true;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_scan_token(HELP)) return true;
    return false;
  }

  final private boolean jj_3_222() {
    if (jj_scan_token(SET)) return true;
    return false;
  }

  final private boolean jj_3_221() {
    if (jj_scan_token(SENSITIVE)) return true;
    return false;
  }

  final private boolean jj_3_220() {
    if (jj_scan_token(SCROLL)) return true;
    return false;
  }

  final private boolean jj_3_219() {
    if (jj_scan_token(SCHEMAS)) return true;
    return false;
  }

  final private boolean jj_3_218() {
    if (jj_scan_token(TO)) return true;
    return false;
  }

  final private boolean jj_3_217() {
    if (jj_scan_token(RUN)) return true;
    return false;
  }

  final private boolean jj_3_216() {
    if (jj_scan_token(ROLLBACK)) return true;
    return false;
  }

  final private boolean jj_3_215() {
    if (jj_scan_token(RESOURCE)) return true;
    return false;
  }

  final private boolean jj_3_118() {
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3_214() {
    if (jj_scan_token(REMOVE)) return true;
    return false;
  }

  final private boolean jj_3_213() {
    if (jj_scan_token(RELATIVE)) return true;
    return false;
  }

  final private boolean jj_3_212() {
    if (jj_scan_token(READONLY)) return true;
    return false;
  }

  final private boolean jj_3_211() {
    if (jj_scan_token(QUIT)) return true;
    return false;
  }

  final private boolean jj_3_210() {
    if (jj_scan_token(PROTOCOL)) return true;
    return false;
  }

  final private boolean jj_3_209() {
    if (jj_scan_token(PROPERTIES)) return true;
    return false;
  }

  final private boolean jj_3_208() {
    if (jj_scan_token(PROCEDURES)) return true;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_207() {
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  final private boolean jj_3_206() {
    if (jj_scan_token(PREVIOUS)) return true;
    return false;
  }

  final private boolean jj_3_205() {
    if (jj_scan_token(PREPARE)) return true;
    return false;
  }

  final private boolean jj_3_204() {
    if (jj_scan_token(PERIOD)) return true;
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_scan_token(RELATIVE)) return true;
    if (jj_3R_72()) return true;
    return false;
  }

  final private boolean jj_3_203() {
    if (jj_scan_token(PASSWORD)) return true;
    return false;
  }

  final private boolean jj_3_202() {
    if (jj_scan_token(ON)) return true;
    return false;
  }

  final private boolean jj_3_201() {
    if (jj_scan_token(OFF)) return true;
    return false;
  }

  final private boolean jj_3_200() {
    if (jj_scan_token(NOHOLDFORCONNECTION)) return true;
    return false;
  }

  final private boolean jj_3_199() {
    if (jj_scan_token(NOHOLD)) return true;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_3R_66()) return true;
    return false;
  }

  final private boolean jj_3_198() {
    if (jj_scan_token(NEXT)) return true;
    return false;
  }

  final private boolean jj_3_197() {
    if (jj_scan_token(NAME)) return true;
    return false;
  }

  final private boolean jj_3_196() {
    if (jj_scan_token(MAXIMUMDISPLAYWIDTH)) return true;
    return false;
  }

  final private boolean jj_3_195() {
    if (jj_scan_token(LOCALIZEDDISPLAY)) return true;
    return false;
  }

  final private boolean jj_3_194() {
    if (jj_scan_token(LAST)) return true;
    return false;
  }

  final private boolean jj_3_193() {
    if (jj_scan_token(INTO)) return true;
    return false;
  }

  final private boolean jj_3_192() {
    if (jj_scan_token(INSENSITIVE)) return true;
    return false;
  }

  final private boolean jj_3_191() {
    if (jj_scan_token(INDEXES)) return true;
    return false;
  }

  final private boolean jj_3_190() {
    if (jj_scan_token(IN)) return true;
    return false;
  }

  final private boolean jj_3_189() {
    if (jj_scan_token(HELP)) return true;
    return false;
  }

  final private boolean jj_3_188() {
    if (jj_scan_token(HOLD)) return true;
    return false;
  }

  final private boolean jj_3_187() {
    if (jj_scan_token(GETCURRENTROWNUMBER)) return true;
    return false;
  }

  final private boolean jj_3_117() {
    if (jj_scan_token(FAIL)) return true;
    return false;
  }

  final private boolean jj_3_186() {
    if (jj_scan_token(GET)) return true;
    return false;
  }

  final private boolean jj_3_185() {
    if (jj_scan_token(FROM)) return true;
    return false;
  }

  final private boolean jj_3_184() {
    if (jj_scan_token(FOR)) return true;
    return false;
  }

  final private boolean jj_3_183() {
    if (jj_scan_token(FIRST)) return true;
    return false;
  }

  final private boolean jj_3_182() {
    if (jj_scan_token(FAIL)) return true;
    return false;
  }

  final private boolean jj_3R_5() {
    if (jj_scan_token(ABSOLUTE)) return true;
    if (jj_3R_72()) return true;
    return false;
  }

  final private boolean jj_3_181() {
    if (jj_scan_token(EXPECT)) return true;
    return false;
  }

  final private boolean jj_3_180() {
    if (jj_scan_token(EXIT)) return true;
    return false;
  }

  final private boolean jj_3_179() {
    if (jj_scan_token(EXECUTE)) return true;
    return false;
  }

  final private boolean jj_3_178() {
    if (jj_scan_token(END)) return true;
    return false;
  }

  final private boolean jj_3_177() {
    if (jj_scan_token(ELAPSEDTIME)) return true;
    return false;
  }

  final private boolean jj_3_176() {
    if (jj_scan_token(DRIVER)) return true;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_scan_token(EXPECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_117()) jj_scanpos = xsp;
    if (jj_3R_73()) return true;
    return false;
  }

  final private boolean jj_3_175() {
    if (jj_scan_token(DISCONNECT)) return true;
    return false;
  }

  final private boolean jj_3_174() {
    if (jj_scan_token(DESCRIBE)) return true;
    return false;
  }

  final private boolean jj_3_173() {
    if (jj_scan_token(CURSOR)) return true;
    return false;
  }

  final private boolean jj_3_172() {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  final private boolean jj_3_171() {
    if (jj_scan_token(CONNECTIONS)) return true;
    return false;
  }

  final private boolean jj_3_170() {
    if (jj_scan_token(CONNECTION)) return true;
    return false;
  }

  final private boolean jj_3_169() {
    if (jj_scan_token(CONNECT)) return true;
    return false;
  }

  final private boolean jj_3_168() {
    if (jj_scan_token(COMMIT)) return true;
    return false;
  }

  final private boolean jj_3_167() {
    if (jj_scan_token(CLOSE)) return true;
    return false;
  }

  final private boolean jj_3_166() {
    if (jj_scan_token(BEFORE)) return true;
    return false;
  }

  final private boolean jj_3_102() {
    if (jj_scan_token(NOHOLD)) return true;
    return false;
  }

  final private boolean jj_3_165() {
    if (jj_scan_token(BANG)) return true;
    return false;
  }

  final private boolean jj_3_164() {
    if (jj_scan_token(AUTOCOMMIT)) return true;
    return false;
  }

  final private boolean jj_3_163() {
    if (jj_scan_token(ATTRIBUTES)) return true;
    return false;
  }

  final private boolean jj_3_162() {
    if (jj_scan_token(ASYNC)) return true;
    return false;
  }

  final private boolean jj_3_161() {
    if (jj_scan_token(AS)) return true;
    return false;
  }

  final private boolean jj_3R_65() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_101()) {
    jj_scanpos = xsp;
    if (jj_3_102()) return true;
    }
    return false;
  }

  final private boolean jj_3_101() {
    if (jj_scan_token(HOLD)) return true;
    return false;
  }

  final private boolean jj_3_160() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  final private boolean jj_3_159() {
    if (jj_scan_token(ALIASES)) return true;
    return false;
  }

  final private boolean jj_3_158() {
    if (jj_scan_token(AFTER)) return true;
    return false;
  }

  final private boolean jj_3_157() {
    if (jj_scan_token(ABSOLUTE)) return true;
    return false;
  }

  final private boolean jj_3R_71() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_157()) {
    jj_scanpos = xsp;
    if (jj_3_158()) {
    jj_scanpos = xsp;
    if (jj_3_159()) {
    jj_scanpos = xsp;
    if (jj_3_160()) {
    jj_scanpos = xsp;
    if (jj_3_161()) {
    jj_scanpos = xsp;
    if (jj_3_162()) {
    jj_scanpos = xsp;
    if (jj_3_163()) {
    jj_scanpos = xsp;
    if (jj_3_164()) {
    jj_scanpos = xsp;
    if (jj_3_165()) {
    jj_scanpos = xsp;
    if (jj_3_166()) {
    jj_scanpos = xsp;
    if (jj_3_167()) {
    jj_scanpos = xsp;
    if (jj_3_168()) {
    jj_scanpos = xsp;
    if (jj_3_169()) {
    jj_scanpos = xsp;
    if (jj_3_170()) {
    jj_scanpos = xsp;
    if (jj_3_171()) {
    jj_scanpos = xsp;
    if (jj_3_172()) {
    jj_scanpos = xsp;
    if (jj_3_173()) {
    jj_scanpos = xsp;
    if (jj_3_174()) {
    jj_scanpos = xsp;
    if (jj_3_175()) {
    jj_scanpos = xsp;
    if (jj_3_176()) {
    jj_scanpos = xsp;
    if (jj_3_177()) {
    jj_scanpos = xsp;
    if (jj_3_178()) {
    jj_scanpos = xsp;
    if (jj_3_179()) {
    jj_scanpos = xsp;
    if (jj_3_180()) {
    jj_scanpos = xsp;
    if (jj_3_181()) {
    jj_scanpos = xsp;
    if (jj_3_182()) {
    jj_scanpos = xsp;
    if (jj_3_183()) {
    jj_scanpos = xsp;
    if (jj_3_184()) {
    jj_scanpos = xsp;
    if (jj_3_185()) {
    jj_scanpos = xsp;
    if (jj_3_186()) {
    jj_scanpos = xsp;
    if (jj_3_187()) {
    jj_scanpos = xsp;
    if (jj_3_188()) {
    jj_scanpos = xsp;
    if (jj_3_189()) {
    jj_scanpos = xsp;
    if (jj_3_190()) {
    jj_scanpos = xsp;
    if (jj_3_191()) {
    jj_scanpos = xsp;
    if (jj_3_192()) {
    jj_scanpos = xsp;
    if (jj_3_193()) {
    jj_scanpos = xsp;
    if (jj_3_194()) {
    jj_scanpos = xsp;
    if (jj_3_195()) {
    jj_scanpos = xsp;
    if (jj_3_196()) {
    jj_scanpos = xsp;
    if (jj_3_197()) {
    jj_scanpos = xsp;
    if (jj_3_198()) {
    jj_scanpos = xsp;
    if (jj_3_199()) {
    jj_scanpos = xsp;
    if (jj_3_200()) {
    jj_scanpos = xsp;
    if (jj_3_201()) {
    jj_scanpos = xsp;
    if (jj_3_202()) {
    jj_scanpos = xsp;
    if (jj_3_203()) {
    jj_scanpos = xsp;
    if (jj_3_204()) {
    jj_scanpos = xsp;
    if (jj_3_205()) {
    jj_scanpos = xsp;
    if (jj_3_206()) {
    jj_scanpos = xsp;
    if (jj_3_207()) {
    jj_scanpos = xsp;
    if (jj_3_208()) {
    jj_scanpos = xsp;
    if (jj_3_209()) {
    jj_scanpos = xsp;
    if (jj_3_210()) {
    jj_scanpos = xsp;
    if (jj_3_211()) {
    jj_scanpos = xsp;
    if (jj_3_212()) {
    jj_scanpos = xsp;
    if (jj_3_213()) {
    jj_scanpos = xsp;
    if (jj_3_214()) {
    jj_scanpos = xsp;
    if (jj_3_215()) {
    jj_scanpos = xsp;
    if (jj_3_216()) {
    jj_scanpos = xsp;
    if (jj_3_217()) {
    jj_scanpos = xsp;
    if (jj_3_218()) {
    jj_scanpos = xsp;
    if (jj_3_219()) {
    jj_scanpos = xsp;
    if (jj_3_220()) {
    jj_scanpos = xsp;
    if (jj_3_221()) {
    jj_scanpos = xsp;
    if (jj_3_222()) {
    jj_scanpos = xsp;
    if (jj_3_223()) {
    jj_scanpos = xsp;
    if (jj_3_224()) {
    jj_scanpos = xsp;
    if (jj_3_225()) {
    jj_scanpos = xsp;
    if (jj_3_226()) {
    jj_scanpos = xsp;
    if (jj_3_227()) {
    jj_scanpos = xsp;
    if (jj_3_228()) {
    jj_scanpos = xsp;
    if (jj_3_229()) {
    jj_scanpos = xsp;
    if (jj_3_230()) {
    jj_scanpos = xsp;
    if (jj_3_231()) {
    jj_scanpos = xsp;
    if (jj_3_232()) {
    jj_scanpos = xsp;
    if (jj_3_233()) {
    jj_scanpos = xsp;
    if (jj_3_234()) {
    jj_scanpos = xsp;
    if (jj_3_235()) {
    jj_scanpos = xsp;
    if (jj_3_236()) {
    jj_scanpos = xsp;
    if (jj_3_237()) {
    jj_scanpos = xsp;
    if (jj_3_238()) {
    jj_scanpos = xsp;
    if (jj_3_239()) {
    jj_scanpos = xsp;
    if (jj_3_240()) {
    jj_scanpos = xsp;
    if (jj_3_241()) {
    jj_scanpos = xsp;
    if (jj_3_242()) {
    jj_scanpos = xsp;
    if (jj_3_243()) {
    jj_scanpos = xsp;
    if (jj_3_244()) {
    jj_scanpos = xsp;
    if (jj_3_245()) {
    jj_scanpos = xsp;
    if (jj_3_246()) {
    jj_scanpos = xsp;
    if (jj_3_247()) {
    jj_scanpos = xsp;
    if (jj_3_248()) {
    jj_scanpos = xsp;
    if (jj_3_249()) {
    jj_scanpos = xsp;
    if (jj_3_250()) {
    jj_scanpos = xsp;
    if (jj_3_251()) {
    jj_scanpos = xsp;
    if (jj_3_252()) {
    jj_scanpos = xsp;
    if (jj_3_253()) {
    jj_scanpos = xsp;
    if (jj_3_254()) {
    jj_scanpos = xsp;
    if (jj_3_255()) {
    jj_scanpos = xsp;
    if (jj_3_256()) {
    jj_scanpos = xsp;
    if (jj_3_257()) {
    jj_scanpos = xsp;
    if (jj_3_258()) {
    jj_scanpos = xsp;
    if (jj_3_259()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_100() {
    if (jj_scan_token(SENSITIVE)) return true;
    return false;
  }

  final private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_99()) {
    jj_scanpos = xsp;
    if (jj_3_100()) return true;
    }
    return false;
  }

  final private boolean jj_3_99() {
    if (jj_scan_token(INSENSITIVE)) return true;
    return false;
  }

  final private boolean jj_3_156() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_78() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_155()) {
    jj_scanpos = xsp;
    if (jj_3_156()) return true;
    }
    return false;
  }

  final private boolean jj_3_155() {
    if (jj_3R_71()) return true;
    return false;
  }

  final private boolean jj_3R_9() {
    if (jj_scan_token(BANG)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_153() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_70()) return true;
    return false;
  }

  final private boolean jj_3_97() {
    if (jj_scan_token(SCROLL)) return true;
    if (jj_3R_64()) return true;
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_3R_78()) return true;
    if (jj_scan_token(EQUALS_OPERATOR)) return true;
    return false;
  }

  final private boolean jj_3_98() {
    if (jj_scan_token(WITH)) return true;
    if (jj_3R_65()) return true;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_scan_token(GET)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_97()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_98()) jj_scanpos = xsp;
    if (jj_scan_token(CURSOR)) return true;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_scan_token(INTEGER)) return true;
    return false;
  }

  final private boolean jj_3_154() {
    if (jj_3R_70()) return true;
    return false;
  }

  final private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_154()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_152() {
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_scan_token(MAXIMUMDISPLAYWIDTH)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  final private boolean jj_3R_58() {
    if (jj_scan_token(CP_DISCONNECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_152()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_151() {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_33() {
    if (jj_scan_token(PREPARE)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_116() {
    if (jj_scan_token(OFF)) return true;
    return false;
  }

  final private boolean jj_3_115() {
    if (jj_scan_token(ON)) return true;
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_scan_token(ELAPSEDTIME)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_115()) {
    jj_scanpos = xsp;
    if (jj_3_116()) return true;
    }
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_scan_token(CP_GETCONNECTION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_151()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_scan_token(PREPARE)) return true;
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  final private boolean jj_3_150() {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_149() {
    if (jj_scan_token(PASSWORD)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_148() {
    if (jj_scan_token(USER)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_114() {
    if (jj_scan_token(OFF)) return true;
    return false;
  }

  final private boolean jj_3_113() {
    if (jj_scan_token(ON)) return true;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(READONLY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_113()) {
    jj_scanpos = xsp;
    if (jj_3_114()) return true;
    }
    return false;
  }

  final private boolean jj_3_93() {
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_147() {
    if (jj_scan_token(PROTOCOL)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_96() {
    if (jj_scan_token(QUIT)) return true;
    return false;
  }

  final private boolean jj_3_95() {
    if (jj_scan_token(EXIT)) return true;
    return false;
  }

  final private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_95()) {
    jj_scanpos = xsp;
    if (jj_3_96()) return true;
    }
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_scan_token(CP_CONNECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_148()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_149()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_150()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_92() {
    if (jj_scan_token(ALL)) return true;
    return false;
  }

  final private boolean jj_3_112() {
    if (jj_scan_token(OFF)) return true;
    return false;
  }

  final private boolean jj_3_111() {
    if (jj_scan_token(ON)) return true;
    return false;
  }

  final private boolean jj_3_91() {
    if (jj_scan_token(CURRENT)) return true;
    return false;
  }

  final private boolean jj_3_94() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_91()) {
    jj_scanpos = xsp;
    if (jj_3_92()) {
    jj_scanpos = xsp;
    if (jj_3_93()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_29() {
    if (jj_scan_token(LOCALIZEDDISPLAY)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_111()) {
    jj_scanpos = xsp;
    if (jj_3_112()) return true;
    }
    return false;
  }

  final private boolean jj_3_146() {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_145() {
    if (jj_scan_token(PASSWORD)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_144() {
    if (jj_scan_token(USER)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_143() {
    if (jj_scan_token(PROTOCOL)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3R_55() {
    if (jj_scan_token(CP_DATASOURCE)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_scan_token(DISCONNECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_94()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(NOHOLDFORCONNECTION)) return true;
    return false;
  }

  final private boolean jj_3_90() {
    if (jj_scan_token(WORK)) return true;
    return false;
  }

  final private boolean jj_3R_54() {
    if (jj_scan_token(DATASOURCE)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_scan_token(ROLLBACK)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_90()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_110() {
    if (jj_scan_token(OFF)) return true;
    return false;
  }

  final private boolean jj_3_109() {
    if (jj_scan_token(ON)) return true;
    return false;
  }

  final private boolean jj_3R_7() {
    if (jj_scan_token(AUTOCOMMIT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_109()) {
    jj_scanpos = xsp;
    if (jj_3_110()) return true;
    }
    return false;
  }

  final private boolean jj_3_89() {
    if (jj_scan_token(WORK)) return true;
    return false;
  }

  final private boolean jj_3R_12() {
    if (jj_scan_token(COMMIT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_89()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_108() {
    if (jj_scan_token(RESOURCE)) return true;
    return false;
  }

  final private boolean jj_3_76() {
    if (jj_scan_token(PERIOD)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_142() {
    if (jj_scan_token(XA_SUSPEND)) return true;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_scan_token(RUN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_108()) jj_scanpos = xsp;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_141() {
    if (jj_scan_token(XA_SUCCESS)) return true;
    return false;
  }

  final private boolean jj_3_88() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(SETTABLE_ROLES)) return true;
    return false;
  }

  final private boolean jj_3_140() {
    if (jj_scan_token(XA_STARTRSCAN)) return true;
    return false;
  }

  final private boolean jj_3_87() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(ENABLED_ROLES)) return true;
    return false;
  }

  final private boolean jj_3_74() {
    if (jj_scan_token(ALIASES)) return true;
    return false;
  }

  final private boolean jj_3_80() {
    if (jj_scan_token(IN)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_139() {
    if (jj_scan_token(XA_RESUME)) return true;
    return false;
  }

  final private boolean jj_3_86() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(ROLES)) return true;
    return false;
  }

  final private boolean jj_3_85() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(SCHEMAS)) return true;
    return false;
  }

  final private boolean jj_3_138() {
    if (jj_scan_token(XA_NOFLAGS)) return true;
    return false;
  }

  final private boolean jj_3_84() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(PROCEDURES)) return true;
    return false;
  }

  final private boolean jj_3_73() {
    if (jj_scan_token(SYNONYMS)) return true;
    return false;
  }

  final private boolean jj_3_137() {
    if (jj_scan_token(XA_JOIN)) return true;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_scan_token(REMOVE)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_78() {
    if (jj_scan_token(FROM)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_136() {
    if (jj_scan_token(XA_FAIL)) return true;
    return false;
  }

  final private boolean jj_3_79() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_77()) {
    jj_scanpos = xsp;
    if (jj_3_78()) return true;
    }
    return false;
  }

  final private boolean jj_3_77() {
    if (jj_scan_token(IN)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_75() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_135()) {
    jj_scanpos = xsp;
    if (jj_3_136()) {
    jj_scanpos = xsp;
    if (jj_3_137()) {
    jj_scanpos = xsp;
    if (jj_3_138()) {
    jj_scanpos = xsp;
    if (jj_3_139()) {
    jj_scanpos = xsp;
    if (jj_3_140()) {
    jj_scanpos = xsp;
    if (jj_3_141()) {
    jj_scanpos = xsp;
    if (jj_3_142()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_135() {
    if (jj_scan_token(XA_ENDRSCAN)) return true;
    return false;
  }

  final private boolean jj_3_72() {
    if (jj_scan_token(VIEWS)) return true;
    return false;
  }

  final private boolean jj_3_83() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(INDEXES)) return true;
    return false;
  }

  final private boolean jj_3_75() {
    if (jj_scan_token(IN)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_53() {
    if (jj_scan_token(XA_START)) return true;
    if (jj_3R_75()) return true;
    return false;
  }

  final private boolean jj_3_71() {
    if (jj_scan_token(TABLES)) return true;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_scan_token(WAIT)) return true;
    if (jj_scan_token(FOR)) return true;
    return false;
  }

  final private boolean jj_3R_41() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_81()) {
    jj_scanpos = xsp;
    if (jj_3_82()) {
    jj_scanpos = xsp;
    if (jj_3_83()) {
    jj_scanpos = xsp;
    if (jj_3_84()) {
    jj_scanpos = xsp;
    if (jj_3_85()) {
    jj_scanpos = xsp;
    if (jj_3_86()) {
    jj_scanpos = xsp;
    if (jj_3_87()) {
    jj_scanpos = xsp;
    if (jj_3_88()) return true;
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  final private boolean jj_3_82() {
    if (jj_scan_token(SHOW)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_71()) {
    jj_scanpos = xsp;
    if (jj_3_72()) {
    jj_scanpos = xsp;
    if (jj_3_73()) {
    jj_scanpos = xsp;
    if (jj_3_74()) return true;
    }
    }
    }
    return false;
  }

  final private boolean jj_3_81() {
    if (jj_scan_token(SHOW)) return true;
    if (jj_scan_token(CONNECTIONS)) return true;
    return false;
  }

  final private boolean jj_3R_52() {
    if (jj_scan_token(XA_ROLLBACK)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  final private boolean jj_3R_8() {
    if (jj_scan_token(ASYNC)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_70() {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_scan_token(XA_RECOVER)) return true;
    if (jj_3R_75()) return true;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_scan_token(SET)) return true;
    if (jj_scan_token(CONNECTION)) return true;
    return false;
  }

  final private boolean jj_3_134() {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_50() {
    if (jj_scan_token(XA_PREPARE)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  final private boolean jj_3R_47() {
    if (jj_scan_token(XA_GETCONNECTION)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_134()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3R_62() {
    if (jj_3R_77()) return true;
    return false;
  }

  final private boolean jj_3R_49() {
    if (jj_scan_token(XA_FORGET)) return true;
    if (jj_3R_74()) return true;
    return false;
  }

  final private boolean jj_3_133() {
    if (jj_scan_token(XA_2PHASE)) return true;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_scan_token(XA_END)) return true;
    if (jj_3R_75()) return true;
    return false;
  }

  final private boolean jj_3_132() {
    if (jj_scan_token(XA_1PHASE)) return true;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_scan_token(XA_COMMIT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_132()) {
    jj_scanpos = xsp;
    if (jj_3_133()) return true;
    }
    return false;
  }

  final private boolean jj_3_69() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_68() {
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_67() {
    if (jj_3R_60()) return true;
    if (jj_scan_token(PERIOD)) return true;
    return false;
  }

  final private boolean jj_3_131() {
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_scan_token(DESCRIBE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_67()) {
    jj_scanpos = xsp;
    if (jj_3_68()) {
    jj_scanpos = xsp;
    if (jj_3_69()) return true;
    }
    }
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_scan_token(XA_DISCONNECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_131()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_130() {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_129() {
    if (jj_scan_token(PASSWORD)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_128() {
    if (jj_scan_token(USER)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_126() {
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_106() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3R_44() {
    if (jj_scan_token(XA_CONNECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_128()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_129()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_130()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_105() {
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_125() {
    if (jj_scan_token(SHUTDOWN)) return true;
    return false;
  }

  final private boolean jj_3_107() {
    if (jj_scan_token(USING)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_105()) {
    jj_scanpos = xsp;
    if (jj_3_106()) return true;
    }
    return false;
  }

  final private boolean jj_3_127() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_125()) {
    jj_scanpos = xsp;
    if (jj_3_126()) return true;
    }
    return false;
  }

  final private boolean jj_3_104() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_103() {
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_18() {
    if (jj_scan_token(EXECUTE)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_103()) {
    jj_scanpos = xsp;
    if (jj_3_104()) return true;
    }
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_scan_token(XA_DATASOURCE)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_66() {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_64() {
    if (jj_scan_token(PASSWORD)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_63() {
    if (jj_scan_token(USER)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_65() {
    if (jj_scan_token(ATTRIBUTES)) return true;
    if (jj_3R_63()) return true;
    return false;
  }

  final private boolean jj_3_62() {
    if (jj_scan_token(PROTOCOL)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_61() {
    if (jj_scan_token(STRING)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_62()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_63()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_64()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_65()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3_66()) jj_scanpos = xsp;
    return false;
  }

  final private boolean jj_3_59() {
    if (jj_3R_62()) return true;
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_scan_token(EXECUTE)) return true;
    if (jj_scan_token(PROCEDURE)) return true;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_scan_token(EXECUTE)) return true;
    if (jj_scan_token(STATEMENT)) return true;
    return false;
  }

  final private boolean jj_3_58() {
    if (jj_3R_61()) return true;
    return false;
  }

  final private boolean jj_3_61() {
    if (jj_scan_token(CONNECT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_58()) {
    jj_scanpos = xsp;
    if (jj_3_59()) return true;
    }
    return false;
  }

  final private boolean jj_3_60() {
    if (jj_scan_token(CONNECT)) return true;
    if (jj_scan_token(TO)) return true;
    return false;
  }

  final private boolean jj_3R_13() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_60()) {
    jj_scanpos = xsp;
    if (jj_3_61()) return true;
    }
    return false;
  }

  final private boolean jj_3R_11() {
    if (jj_scan_token(CLOSE)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_scan_token(GETCURRENTROWNUMBER)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_scan_token(DRIVER)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_57() {
    if (jj_scan_token(AS)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_124() {
    if (jj_scan_token(MINUS_SIGN)) return true;
    return false;
  }

  final private boolean jj_3R_67() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_123()) {
    jj_scanpos = xsp;
    if (jj_3_124()) return true;
    }
    return false;
  }

  final private boolean jj_3_123() {
    if (jj_scan_token(PLUS_SIGN)) return true;
    return false;
  }

  final private boolean jj_3_121() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_3R_69()) return true;
    return false;
  }

  final private boolean jj_3R_34() {
    if (jj_scan_token(PREVIOUS)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(PROTOCOL)) return true;
    if (jj_scan_token(STRING)) return true;
    return false;
  }

  final private boolean jj_3_122() {
    if (jj_3R_69()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_121()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  final private boolean jj_3R_28() {
    if (jj_scan_token(LAST)) return true;
    if (jj_3R_60()) return true;
    return false;
  }

  final private boolean jj_3_120() {
    if (jj_scan_token(PERIOD)) return true;
    if (jj_3R_68()) return true;
    return false;
  }

  final private boolean jj_3_55() {
    if (jj_3R_58()) return true;
    return false;
  }

  final private boolean jj_3_54() {
    if (jj_3R_57()) return true;
    return false;
  }

  final private boolean jj_3_53() {
    if (jj_3R_56()) return true;
    return false;
  }

  final private boolean jj_3_52() {
    if (jj_3R_55()) return true;
    return false;
  }

  final private boolean jj_3_51() {
    if (jj_3R_54()) return true;
    return false;
  }

  final private boolean jj_3R_68() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3_50() {
    if (jj_3R_53()) return true;
    return false;
  }

  final private boolean jj_3_49() {
    if (jj_3R_52()) return true;
    return false;
  }

  final private boolean jj_3_48() {
    if (jj_3R_51()) return true;
    return false;
  }

  final private boolean jj_3_47() {
    if (jj_3R_50()) return true;
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_3R_49()) return true;
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_3R_48()) return true;
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_3R_47()) return true;
    return false;
  }

  final private boolean jj_3R_6() {
    if (jj_scan_token(AFTER)) return true;
    if (jj_scan_token(LAST)) return true;
    return false;
  }

  public ijTokenManager token_source;
  public Token token, jj_nt;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[0];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
      jj_la1_4();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {};
   }
   private static void jj_la1_4() {
      jj_la1_4 = new int[] {};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[259];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public ij(CharStream stream) {
    token_source = new ijTokenManager(stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public ij(ijTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ijTokenManager tm) {
    token_source = tm;
    token = new Token();
    token.next = jj_nt = token_source.getNextToken();
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken = token;
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    jj_nt = token;
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if ((token = jj_nt).next != null) jj_nt = jj_nt.next;
    else jj_nt = jj_nt.next = token_source.getNextToken();
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[134];
    for (int i = 0; i < 134; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 134; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, ijConstants.tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 259; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
            case 85: jj_3_86(); break;
            case 86: jj_3_87(); break;
            case 87: jj_3_88(); break;
            case 88: jj_3_89(); break;
            case 89: jj_3_90(); break;
            case 90: jj_3_91(); break;
            case 91: jj_3_92(); break;
            case 92: jj_3_93(); break;
            case 93: jj_3_94(); break;
            case 94: jj_3_95(); break;
            case 95: jj_3_96(); break;
            case 96: jj_3_97(); break;
            case 97: jj_3_98(); break;
            case 98: jj_3_99(); break;
            case 99: jj_3_100(); break;
            case 100: jj_3_101(); break;
            case 101: jj_3_102(); break;
            case 102: jj_3_103(); break;
            case 103: jj_3_104(); break;
            case 104: jj_3_105(); break;
            case 105: jj_3_106(); break;
            case 106: jj_3_107(); break;
            case 107: jj_3_108(); break;
            case 108: jj_3_109(); break;
            case 109: jj_3_110(); break;
            case 110: jj_3_111(); break;
            case 111: jj_3_112(); break;
            case 112: jj_3_113(); break;
            case 113: jj_3_114(); break;
            case 114: jj_3_115(); break;
            case 115: jj_3_116(); break;
            case 116: jj_3_117(); break;
            case 117: jj_3_118(); break;
            case 118: jj_3_119(); break;
            case 119: jj_3_120(); break;
            case 120: jj_3_121(); break;
            case 121: jj_3_122(); break;
            case 122: jj_3_123(); break;
            case 123: jj_3_124(); break;
            case 124: jj_3_125(); break;
            case 125: jj_3_126(); break;
            case 126: jj_3_127(); break;
            case 127: jj_3_128(); break;
            case 128: jj_3_129(); break;
            case 129: jj_3_130(); break;
            case 130: jj_3_131(); break;
            case 131: jj_3_132(); break;
            case 132: jj_3_133(); break;
            case 133: jj_3_134(); break;
            case 134: jj_3_135(); break;
            case 135: jj_3_136(); break;
            case 136: jj_3_137(); break;
            case 137: jj_3_138(); break;
            case 138: jj_3_139(); break;
            case 139: jj_3_140(); break;
            case 140: jj_3_141(); break;
            case 141: jj_3_142(); break;
            case 142: jj_3_143(); break;
            case 143: jj_3_144(); break;
            case 144: jj_3_145(); break;
            case 145: jj_3_146(); break;
            case 146: jj_3_147(); break;
            case 147: jj_3_148(); break;
            case 148: jj_3_149(); break;
            case 149: jj_3_150(); break;
            case 150: jj_3_151(); break;
            case 151: jj_3_152(); break;
            case 152: jj_3_153(); break;
            case 153: jj_3_154(); break;
            case 154: jj_3_155(); break;
            case 155: jj_3_156(); break;
            case 156: jj_3_157(); break;
            case 157: jj_3_158(); break;
            case 158: jj_3_159(); break;
            case 159: jj_3_160(); break;
            case 160: jj_3_161(); break;
            case 161: jj_3_162(); break;
            case 162: jj_3_163(); break;
            case 163: jj_3_164(); break;
            case 164: jj_3_165(); break;
            case 165: jj_3_166(); break;
            case 166: jj_3_167(); break;
            case 167: jj_3_168(); break;
            case 168: jj_3_169(); break;
            case 169: jj_3_170(); break;
            case 170: jj_3_171(); break;
            case 171: jj_3_172(); break;
            case 172: jj_3_173(); break;
            case 173: jj_3_174(); break;
            case 174: jj_3_175(); break;
            case 175: jj_3_176(); break;
            case 176: jj_3_177(); break;
            case 177: jj_3_178(); break;
            case 178: jj_3_179(); break;
            case 179: jj_3_180(); break;
            case 180: jj_3_181(); break;
            case 181: jj_3_182(); break;
            case 182: jj_3_183(); break;
            case 183: jj_3_184(); break;
            case 184: jj_3_185(); break;
            case 185: jj_3_186(); break;
            case 186: jj_3_187(); break;
            case 187: jj_3_188(); break;
            case 188: jj_3_189(); break;
            case 189: jj_3_190(); break;
            case 190: jj_3_191(); break;
            case 191: jj_3_192(); break;
            case 192: jj_3_193(); break;
            case 193: jj_3_194(); break;
            case 194: jj_3_195(); break;
            case 195: jj_3_196(); break;
            case 196: jj_3_197(); break;
            case 197: jj_3_198(); break;
            case 198: jj_3_199(); break;
            case 199: jj_3_200(); break;
            case 200: jj_3_201(); break;
            case 201: jj_3_202(); break;
            case 202: jj_3_203(); break;
            case 203: jj_3_204(); break;
            case 204: jj_3_205(); break;
            case 205: jj_3_206(); break;
            case 206: jj_3_207(); break;
            case 207: jj_3_208(); break;
            case 208: jj_3_209(); break;
            case 209: jj_3_210(); break;
            case 210: jj_3_211(); break;
            case 211: jj_3_212(); break;
            case 212: jj_3_213(); break;
            case 213: jj_3_214(); break;
            case 214: jj_3_215(); break;
            case 215: jj_3_216(); break;
            case 216: jj_3_217(); break;
            case 217: jj_3_218(); break;
            case 218: jj_3_219(); break;
            case 219: jj_3_220(); break;
            case 220: jj_3_221(); break;
            case 221: jj_3_222(); break;
            case 222: jj_3_223(); break;
            case 223: jj_3_224(); break;
            case 224: jj_3_225(); break;
            case 225: jj_3_226(); break;
            case 226: jj_3_227(); break;
            case 227: jj_3_228(); break;
            case 228: jj_3_229(); break;
            case 229: jj_3_230(); break;
            case 230: jj_3_231(); break;
            case 231: jj_3_232(); break;
            case 232: jj_3_233(); break;
            case 233: jj_3_234(); break;
            case 234: jj_3_235(); break;
            case 235: jj_3_236(); break;
            case 236: jj_3_237(); break;
            case 237: jj_3_238(); break;
            case 238: jj_3_239(); break;
            case 239: jj_3_240(); break;
            case 240: jj_3_241(); break;
            case 241: jj_3_242(); break;
            case 242: jj_3_243(); break;
            case 243: jj_3_244(); break;
            case 244: jj_3_245(); break;
            case 245: jj_3_246(); break;
            case 246: jj_3_247(); break;
            case 247: jj_3_248(); break;
            case 248: jj_3_249(); break;
            case 249: jj_3_250(); break;
            case 250: jj_3_251(); break;
            case 251: jj_3_252(); break;
            case 252: jj_3_253(); break;
            case 253: jj_3_254(); break;
            case 254: jj_3_255(); break;
            case 255: jj_3_256(); break;
            case 256: jj_3_257(); break;
            case 257: jj_3_258(); break;
            case 258: jj_3_259(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
