/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.iapi.services.sanity.SanityManager;

public class ClobLocatorInputStream
extends InputStream {
    private final Connection connection;
    private final Clob clob;
    private long currentPos;

    public ClobLocatorInputStream(Connection connection, Clob clob) throws SqlException {
        SanityManager.ASSERT(clob.isLocator());
        this.connection = connection;
        this.clob = clob;
        this.currentPos = 1L;
    }

    public ClobLocatorInputStream(Connection connection, Clob clob, long pos) throws SqlException {
        this(connection, clob);
        this.currentPos = pos;
    }

    public int read() throws IOException {
        byte[] bytes = this.readBytes(1);
        if (bytes.length == 0) {
            return -1;
        }
        return bytes[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        byte[] bytes = this.readBytes(len);
        if (bytes.length == 0) {
            return -1;
        }
        System.arraycopy(bytes, 0, b, off, bytes.length);
        return bytes.length;
    }

    private byte[] readBytes(int len) throws IOException {
        try {
            int actualLength = (int)Math.min((long)len, this.clob.sqlLength() - this.currentPos + 1L);
            String resultStr = this.connection.locatorProcedureCall().clobGetSubString(this.clob.getLocator(), this.currentPos, actualLength);
            byte[] result = this.getBytesFromString(resultStr);
            this.currentPos += (long)result.length;
            return result;
        }
        catch (SqlException ex) {
            IOException ioEx = new IOException();
            ioEx.initCause(ex);
            throw ioEx;
        }
    }

    private byte[] getBytesFromString(String str) {
        byte[] result = new byte[str.length()];
        for (int i = 1; i <= str.length(); ++i) {
            char oneChar = str.charAt(i - 1);
            result[i - 1] = oneChar <= '\u00ff' ? (int)oneChar : 63;
        }
        return result;
    }
}

