/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.loader;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.sanity.SanityManager;

public final class ClassInspector {
    private static final String[] primTypeNames = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private static final String[] nonPrimTypeNames = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    private static final String OBJECT_TYPE_NAME = "java.lang.Object";
    private static final String STRING_TYPE_NAME = "java.lang.String";
    private static final String BIGDECIMAL_TYPE_NAME = "java.math.BigDecimal";
    private final ClassFactory cf;

    public ClassInspector(ClassFactory cf) {
        this.cf = cf;
    }

    public boolean instanceOf(String className, Object obj) throws ClassNotFoundException {
        Class clazz = this.getClass(className);
        if (clazz == null) {
            return false;
        }
        return clazz.isInstance(obj);
    }

    public boolean assignableTo(String fromClassName, String toClassName) {
        try {
            Class toClass = this.getClass(toClassName);
            if (toClass == null) {
                return false;
            }
            Class fromClass = this.getClass(fromClassName);
            if (fromClass == null) {
                return !toClass.isPrimitive() || toClass == Void.TYPE;
            }
            return toClass.isAssignableFrom(fromClass);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    public boolean accessible(String className) throws ClassNotFoundException {
        Class theClass = this.getClass(className);
        if (theClass == null) {
            return false;
        }
        return Modifier.isPublic(theClass.getModifiers());
    }

    public String getType(Member member) {
        Class<Object> type = member instanceof Method ? ((Method)member).getReturnType() : (member instanceof Field ? ((Field)member).getType() : (member instanceof Constructor ? ((Constructor)member).getDeclaringClass() : Void.TYPE));
        return ClassInspector.readableClassName(type);
    }

    public Member findPublicMethod(String receiverType, String methodName, String[] parmTypes, String[] primParmTypes, boolean[] isParam, boolean staticMethod, boolean repeatLastParameter) throws ClassNotFoundException, StandardException {
        Class[] primParamClasses;
        Class[] paramClasses;
        Class receiverClass;
        block13: {
            receiverClass = this.getClass(receiverType);
            if (receiverClass == null) {
                return null;
            }
            if (receiverClass.isPrimitive()) {
                return null;
            }
            if (parmTypes == null) {
                Method[] methods = receiverClass.getMethods();
                for (int index = 0; index < methods.length; ++index) {
                    if (staticMethod && !Modifier.isStatic(methods[index].getModifiers()) || !methodName.equals(methods[index].getName())) continue;
                    return methods[index];
                }
                return null;
            }
            paramClasses = new Class[parmTypes.length];
            primParamClasses = null;
            if (primParmTypes != null) {
                primParamClasses = new Class[primParmTypes.length];
            }
            for (int i = 0; i < paramClasses.length; ++i) {
                paramClasses[i] = this.getClass(parmTypes[i]);
                if (primParmTypes == null) continue;
                primParamClasses[i] = primParmTypes[i].equals(parmTypes[i]) ? null : this.getClass(primParmTypes[i]);
            }
            if (paramClasses.length == 0) {
                try {
                    Method method = receiverClass.getMethod(methodName, paramClasses);
                    if (staticMethod && !Modifier.isStatic(method.getModifiers())) {
                        return null;
                    }
                    return method;
                }
                catch (NoSuchMethodException nsme2) {
                    if (receiverClass.isInterface()) break block13;
                    return null;
                }
            }
        }
        Member[] methodList = receiverClass.getMethods();
        if (receiverClass.isInterface()) {
            Method[] objectMethods = Object.class.getMethods();
            if (methodList.length == 0) {
                methodList = objectMethods;
            } else {
                Member[] set = new Member[methodList.length + objectMethods.length];
                System.arraycopy(methodList, 0, set, 0, methodList.length);
                System.arraycopy(objectMethods, 0, set, methodList.length, objectMethods.length);
                methodList = set;
            }
        }
        return this.resolveMethod(receiverClass, methodName, paramClasses, primParamClasses, isParam, staticMethod, repeatLastParameter, methodList);
    }

    public Member findPublicField(String receiverType, String fieldName, boolean staticField) throws StandardException {
        Exception e;
        block10: {
            e = null;
            try {
                Class receiverClass = this.getClass(receiverType);
                if (receiverClass == null) {
                    return null;
                }
                if (receiverClass.isArray() || receiverClass.isPrimitive()) {
                    return null;
                }
                int modifier = staticField ? 9 : 1;
                Field publicField = receiverClass.getField(fieldName);
                if ((publicField.getModifiers() & modifier) != modifier) break block10;
                if (receiverClass.isInterface() || publicField.getDeclaringClass().equals(receiverClass)) {
                    return publicField;
                }
                try {
                    Field declaredField = receiverClass.getDeclaredField(fieldName);
                    if ((declaredField.getModifiers() & 1) == 1) {
                        SanityManager.THROWASSERT("declared field not expected to be public here " + declaredField);
                    }
                }
                catch (NoSuchFieldException nsfe) {
                    return publicField;
                }
            }
            catch (ClassNotFoundException cnfe) {
                e = cnfe;
            }
            catch (NoSuchFieldException nsfep) {
                e = nsfep;
            }
            catch (SecurityException se) {
                e = se;
            }
        }
        throw StandardException.newException(staticField ? "42X72" : "42X68", e, (Object)fieldName, (Object)receiverType);
    }

    public Member findPublicConstructor(String receiverType, String[] parmTypes, String[] primParmTypes, boolean[] isParam) throws ClassNotFoundException, StandardException {
        Class[] primParamClasses;
        Class[] paramClasses;
        Class receiverClass;
        block8: {
            receiverClass = this.getClass(receiverType);
            if (receiverClass == null) {
                return null;
            }
            if (receiverClass.isArray() || receiverClass.isPrimitive() || receiverClass.isInterface()) {
                return null;
            }
            paramClasses = new Class[parmTypes.length];
            primParamClasses = null;
            if (primParmTypes != null) {
                primParamClasses = new Class[primParmTypes.length];
            }
            boolean unknownParameters = false;
            for (int i = 0; i < paramClasses.length; ++i) {
                paramClasses[i] = this.getClass(parmTypes[i]);
                if (paramClasses[i] == null) {
                    unknownParameters = true;
                }
                if (primParmTypes == null) continue;
                primParamClasses[i] = primParmTypes[i].equals(parmTypes[i]) ? null : this.getClass(primParmTypes[i]);
            }
            try {
                if (!unknownParameters && primParmTypes == null) {
                    Constructor method = receiverClass.getConstructor(paramClasses);
                    return method;
                }
            }
            catch (NoSuchMethodException nsme) {
                if (paramClasses.length != 0) break block8;
                return null;
            }
        }
        return this.resolveMethod(receiverClass, "<init>", paramClasses, primParamClasses, isParam, false, false, receiverClass.getConstructors());
    }

    public String[] getParameterTypes(Member method) {
        Class<?>[] parameterClasses = method instanceof Method ? ((Method)method).getParameterTypes() : ((Constructor)method).getParameterTypes();
        String[] parameterTypes = new String[parameterClasses.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = ClassInspector.readableClassName(parameterClasses[i]);
        }
        return parameterTypes;
    }

    public static boolean primitiveType(String typeName) {
        for (int i = 0; i < primTypeNames.length; ++i) {
            if (!typeName.equals(primTypeNames[i])) continue;
            return true;
        }
        return false;
    }

    private Member resolveMethod(Class receiverClass, String methodName, Class[] paramClasses, Class[] primParamClasses, boolean[] isParam, boolean staticMethod, boolean repeatLastParameter, Member[] methods) throws StandardException {
        boolean somethingChanged;
        boolean ambiguous;
        if (SanityManager.DEBUG_ON("MethodResolutionInfo")) {
            SanityManager.DEBUG("MethodResolutionInfo", "MRI - Begin method resolution trace for " + methodName + "() with " + paramClasses.length + (repeatLastParameter ? "+" : "") + " parameters");
            for (int parmCtr = 0; parmCtr < paramClasses.length; ++parmCtr) {
                SanityManager.DEBUG("MethodResolutionInfo", "MRI - Parameter #" + parmCtr + " is of type " + (paramClasses[parmCtr] == null ? "null" : paramClasses[parmCtr].getName()));
            }
        }
        int candidateIndex = -1;
        boolean firstTimeAround = true;
        do {
            ambiguous = false;
            somethingChanged = false;
            block2: for (int i = 0; i < methods.length; ++i) {
                Class[] currentMethodParameters;
                Member currentMethod = methods[i];
                if (currentMethod == null || i == candidateIndex) continue;
                Class[] classArray = currentMethodParameters = currentMethod instanceof Method ? ((Method)currentMethod).getParameterTypes() : ((Constructor)currentMethod).getParameterTypes();
                if (firstTimeAround) {
                    if (repeatLastParameter) {
                        if (currentMethodParameters.length < paramClasses.length) {
                            methods[i] = null;
                            continue;
                        }
                    } else if (currentMethodParameters.length != paramClasses.length) {
                        methods[i] = null;
                        continue;
                    }
                    if (staticMethod && !Modifier.isStatic(currentMethod.getModifiers())) {
                        methods[i] = null;
                        continue;
                    }
                    if (!methodName.startsWith("<") && !methodName.equals(currentMethod.getName())) {
                        methods[i] = null;
                        continue;
                    }
                    if (repeatLastParameter) {
                        for (int pr = paramClasses.length - 1; pr < currentMethodParameters.length; ++pr) {
                            if (currentMethodParameters[pr].equals(paramClasses[paramClasses.length - 1])) continue;
                            methods[i] = null;
                            continue block2;
                        }
                    }
                }
                if (SanityManager.DEBUG_ON("MethodResolutionInfo")) {
                    SanityManager.DEBUG("MethodResolutionInfo", "MRI - Considering :" + currentMethod.toString());
                }
                if (!this.signatureConvertableFromTo(paramClasses, primParamClasses, currentMethodParameters, isParam, true)) {
                    if (SanityManager.DEBUG_ON("MethodResolutionInfo")) {
                        SanityManager.DEBUG("MethodResolutionInfo", "MRI - Skipping :" + currentMethod.toString());
                    }
                    methods[i] = null;
                    continue;
                }
                if (SanityManager.DEBUG_ON("MethodResolutionInfo")) {
                    SanityManager.DEBUG("MethodResolutionInfo", "MRI - Match found ");
                }
                if (candidateIndex == -1) {
                    candidateIndex = i;
                    if (!SanityManager.DEBUG_ON("MethodResolutionInfo")) continue;
                    SanityManager.DEBUG("MethodResolutionInfo", "MRI - Current method is now candidate");
                    continue;
                }
                ambiguous = true;
                if (!SanityManager.DEBUG_ON("MethodResolutionInfo")) continue;
                SanityManager.DEBUG("MethodResolutionInfo", "MRI - Ambiguous match");
            }
            firstTimeAround = false;
        } while (ambiguous && somethingChanged);
        if (SanityManager.DEBUG_ON("MethodResolutionInfo")) {
            SanityManager.DEBUG("MethodResolutionInfo", "MRI - End method resolution trace for " + methodName + "()" + "\nMRI - ");
        }
        if (ambiguous) {
            String parmTypesString = "";
            for (int i = 0; i < paramClasses.length; ++i) {
                if (i != 0) {
                    parmTypesString = parmTypesString + ", ";
                }
                parmTypesString = parmTypesString + (paramClasses[i] == null ? "null" : paramClasses[i].getName());
                if (primParamClasses == null || primParamClasses[i] == null) continue;
                parmTypesString = parmTypesString + "(" + primParamClasses[i].getName() + ")";
            }
            throw StandardException.newException("42X73", (Object)receiverClass.getName(), (Object)methodName, (Object)parmTypesString);
        }
        if (candidateIndex == -1) {
            return null;
        }
        if (methods[candidateIndex] == null) {
            SanityManager.THROWASSERT("methods is null at index " + candidateIndex);
        }
        return methods[candidateIndex];
    }

    public Class getClass(String className) throws ClassNotFoundException {
        if (className == null || className.length() == 0) {
            return null;
        }
        int arrayDepth = 0;
        int classNameLength = className.length();
        int position = classNameLength - 2;
        while (position >= 0 && className.substring(position, position + 2).equals("[]")) {
            ++arrayDepth;
            position -= 2;
            classNameLength -= 2;
        }
        if (classNameLength <= 0) {
            return Class.forName(className);
        }
        if (arrayDepth != 0) {
            className = className.substring(0, classNameLength);
        }
        Class<Object> baseClass = null;
        if (classNameLength >= 3 && classNameLength <= 7) {
            if ("int".equals(className)) {
                baseClass = Integer.TYPE;
            } else if ("short".equals(className)) {
                baseClass = Short.TYPE;
            } else if ("boolean".equals(className)) {
                baseClass = Boolean.TYPE;
            } else if ("byte".equals(className)) {
                baseClass = Byte.TYPE;
            } else if ("float".equals(className)) {
                baseClass = Float.TYPE;
            } else if ("double".equals(className)) {
                baseClass = Double.TYPE;
            } else if ("long".equals(className)) {
                baseClass = Long.TYPE;
            } else if ("char".equals(className)) {
                baseClass = Character.TYPE;
            } else if ("void".equals(className)) {
                baseClass = Void.TYPE;
            }
        }
        if (baseClass == null) {
            baseClass = this.cf.loadApplicationClass(className);
        }
        if (arrayDepth == 0) {
            return baseClass;
        }
        if (arrayDepth == 1) {
            return Array.newInstance(baseClass, 0).getClass();
        }
        return Array.newInstance(baseClass, new int[arrayDepth]).getClass();
    }

    private boolean isMethodMoreSpecificOrEqual(Member T, Member U, boolean[] isParam) {
        Class[] UC;
        Class[] TC;
        if (T instanceof Method) {
            if (!this.classConvertableFromTo(T.getDeclaringClass(), U.getDeclaringClass(), true)) {
                return false;
            }
            TC = ((Method)T).getParameterTypes();
            UC = ((Method)U).getParameterTypes();
        } else {
            TC = ((Constructor)T).getParameterTypes();
            UC = ((Constructor)U).getParameterTypes();
        }
        return this.signatureConvertableFromTo(TC, null, UC, isParam, true);
    }

    private boolean signatureConvertableFromTo(Class[] fromTypes, Class[] primFromTypes, Class[] toTypes, boolean[] isParam, boolean mixTypes) {
        int checkCount = fromTypes.length;
        if (toTypes.length < checkCount) {
            checkCount = toTypes.length;
        }
        for (int i = 0; i < checkCount; ++i) {
            Class fromClass = fromTypes[i];
            Class toClass = toTypes[i];
            if (!(fromClass == null ? toClass.isPrimitive() && (primFromTypes == null || isParam != null && !isParam[i]) : !this.classConvertableFromTo(fromClass, toClass, mixTypes) && (primFromTypes == null || primFromTypes[i] == null || !this.classConvertableFromTo(primFromTypes[i], toClass, mixTypes)))) continue;
            return false;
        }
        return true;
    }

    protected boolean classConvertableFromTo(Class fromClass, Class toClass, boolean mixTypes) {
        if (fromClass.getName().equals(toClass.getName())) {
            return true;
        }
        if (!(toClass.isPrimitive() && fromClass.isPrimitive() || mixTypes)) {
            return false;
        }
        String fromName = fromClass.getName();
        String toName = toClass.getName();
        return fromClass == Boolean.TYPE || fromName.equals(nonPrimTypeNames[0]) ? toClass == Boolean.TYPE || toName.equals(nonPrimTypeNames[0]) : (fromClass == Byte.TYPE || fromName.equals(nonPrimTypeNames[1]) ? toClass == Byte.TYPE || toName.equals(nonPrimTypeNames[1]) || toClass == Short.TYPE || toClass == Integer.TYPE || toClass == Long.TYPE || toClass == Float.TYPE || toClass == Double.TYPE : (fromClass == Character.TYPE || fromName.equals(nonPrimTypeNames[2]) ? toClass == Character.TYPE || toName.equals(nonPrimTypeNames[2]) || toClass == Integer.TYPE || toClass == Long.TYPE || toClass == Float.TYPE || toClass == Double.TYPE : (fromClass == Short.TYPE || fromName.equals(nonPrimTypeNames[3]) ? toClass == Short.TYPE || toName.equals(nonPrimTypeNames[4]) : (fromClass == Integer.TYPE || fromName.equals(nonPrimTypeNames[4]) ? toClass == Integer.TYPE || toName.equals(nonPrimTypeNames[4]) : (fromClass == Long.TYPE || fromName.equals(nonPrimTypeNames[5]) ? toClass == Long.TYPE || toName.equals(nonPrimTypeNames[5]) : (fromClass == Float.TYPE || fromName.equals(nonPrimTypeNames[6]) ? toClass == Float.TYPE || toName.equals(nonPrimTypeNames[6]) : !(fromClass != Double.TYPE && !fromName.equals(nonPrimTypeNames[7]) || toClass != Double.TYPE && !toName.equals(nonPrimTypeNames[7]))))))));
    }

    public static String readableClassName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        int arrayDepth = 0;
        do {
            ++arrayDepth;
        } while ((clazz = clazz.getComponentType()).isArray());
        StringBuffer sb = new StringBuffer(clazz.getName());
        for (int i = 0; i < arrayDepth; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static boolean classIsLoadable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException ce) {
            return false;
        }
        catch (LinkageError ce) {
            return false;
        }
    }

    public String getDeclaringClass(Member method) {
        return method.getDeclaringClass().getName();
    }
}

