/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;

public final class SQLLongint
extends NumberDataType {
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLLongint.class);
    private long value;
    private boolean isnull;

    public int getInt() throws StandardException {
        if (this.value > Integer.MAX_VALUE || this.value < Integer.MIN_VALUE) {
            throw StandardException.newException("22003", "INTEGER");
        }
        return (int)this.value;
    }

    public byte getByte() throws StandardException {
        if (this.value > 127L || this.value < -128L) {
            throw StandardException.newException("22003", "TINYINT");
        }
        return (byte)this.value;
    }

    public short getShort() throws StandardException {
        if (this.value > 32767L || this.value < -32768L) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        return (short)this.value;
    }

    public long getLong() {
        return this.value;
    }

    public float getFloat() {
        return this.value;
    }

    public double getDouble() {
        return this.value;
    }

    public boolean getBoolean() {
        return this.value != 0L;
    }

    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Long.toString(this.value);
    }

    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Long(this.value);
    }

    public int getLength() {
        return 8;
    }

    public String getTypeName() {
        return "BIGINT";
    }

    public int getTypeFormatId() {
        return 84;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(!this.isNull());
        out.writeLong(this.value);
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.value = in.readLong();
        this.isnull = false;
    }

    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.value = in.readLong();
        this.isnull = false;
    }

    public void restoreToNull() {
        this.value = 0L;
        this.isnull = true;
    }

    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        long otherValue;
        long thisValue = this.getLong();
        if (thisValue == (otherValue = arg.getLong())) {
            return 0;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return -1;
    }

    public DataValueDescriptor getClone() {
        return new SQLLongint(this.value, this.isnull);
    }

    public DataValueDescriptor getNewNull() {
        return new SQLLongint();
    }

    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getLong(colNumber);
        this.isnull = this.value == 0L ? isNullable && resultSet.wasNull() : false;
    }

    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, -5);
            return;
        }
        ps.setLong(position, this.value);
    }

    public final void setInto(ResultSet rs, int position) throws SQLException {
        rs.updateLong(position, this.value);
    }

    public SQLLongint() {
        this.isnull = true;
    }

    public SQLLongint(long val) {
        this.value = val;
    }

    private SQLLongint(long val, boolean isnull) {
        this.value = val;
        this.isnull = isnull;
    }

    public SQLLongint(Long obj) {
        this.isnull = obj == null;
        if (!this.isnull) {
            this.value = obj;
        }
    }

    public void setValue(String theValue) throws StandardException {
        if (theValue == null) {
            this.value = 0L;
            this.isnull = true;
        } else {
            try {
                this.value = Long.valueOf(theValue.trim());
            }
            catch (NumberFormatException nfe) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    public final void setValue(Number theValue) {
        if (this.objectNull(theValue)) {
            return;
        }
        if (!(theValue instanceof Long)) {
            SanityManager.THROWASSERT("SQLLongint.setValue(Number) passed a " + theValue.getClass());
        }
        this.setValue(theValue.longValue());
    }

    public void setValue(long theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    public void setValue(int theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    public void setValue(float theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeREAL(theValue)) > 9.223372E18f || theValue < -9.223372E18f) {
            throw StandardException.newException("22003", "BIGINT");
        }
        float floorValue = (float)Math.floor(theValue);
        this.value = (long)floorValue;
        this.isnull = false;
    }

    public void setValue(double theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeDOUBLE(theValue)) > 9.223372036854776E18 || theValue < -9.223372036854776E18) {
            throw StandardException.newException("22003", "BIGINT");
        }
        double floorValue = Math.floor(theValue);
        this.value = (long)floorValue;
        this.isnull = false;
    }

    public void setValue(boolean theValue) {
        this.value = theValue ? 1L : 0L;
        this.isnull = false;
    }

    void setObject(Object theValue) {
        this.setValue((Long)theValue);
    }

    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getLong());
    }

    public int typePrecedence() {
        return 60;
    }

    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() == right.getLong());
    }

    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() != right.getLong());
    }

    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() < right.getLong());
    }

    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() > right.getLong());
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() <= right.getLong());
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() >= right.getLong());
    }

    public NumberDataValue plus(NumberDataValue addend1, NumberDataValue addend2, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (addend1.isNull() || addend2.isNull()) {
            result.setToNull();
            return result;
        }
        long addend1Long = addend1.getLong();
        long addend2Long = addend2.getLong();
        long resultValue = addend1Long + addend2Long;
        if (addend1Long < 0L == addend2Long < 0L && addend1Long < 0L != resultValue < 0L) {
            throw StandardException.newException("22003", "BIGINT");
        }
        result.setValue(resultValue);
        return result;
    }

    public NumberDataValue minus(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        long diff = left.getLong() - right.getLong();
        if (left.getLong() < 0L != right.getLong() < 0L && left.getLong() < 0L != diff < 0L) {
            throw StandardException.newException("22003", "BIGINT");
        }
        result.setValue(diff);
        return result;
    }

    public NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        long tempResult = left.getLong() * right.getLong();
        if (right.getLong() != 0L && left.getLong() != tempResult / right.getLong()) {
            throw StandardException.newException("22003", "BIGINT");
        }
        result.setValue(tempResult);
        return result;
    }

    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        long longDivisor = divisor.getLong();
        if (longDivisor == 0L) {
            throw StandardException.newException("22012");
        }
        result.setValue(dividend.getLong() / longDivisor);
        return result;
    }

    public NumberDataValue mod(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        long longDivisor = divisor.getLong();
        if (longDivisor == 0L) {
            throw StandardException.newException("22012");
        }
        result.setValue(dividend.getLong() % longDivisor);
        return result;
    }

    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        long operandValue = this.getLong();
        if (operandValue == Long.MIN_VALUE) {
            throw StandardException.newException("22003", "BIGINT");
        }
        result.setValue(-operandValue);
        return result;
    }

    protected boolean isNegative() {
        return !this.isNull() && this.value < 0L;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Long.toString(this.value);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }
}

