/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.jce;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Enumeration;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.crypto.CipherFactory;
import org.apache.derby.iapi.services.crypto.CipherProvider;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.services.jce.JCECipherProvider;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

public final class JCECipherFactory
implements CipherFactory,
PrivilegedExceptionAction {
    private static final String MESSAGE_DIGEST = "MD5";
    private static final String DEFAULT_ALGORITHM = "DES/CBC/NoPadding";
    private static final String DES = "DES";
    private static final String DESede = "DESede";
    private static final String TripleDES = "TripleDES";
    private static final String AES = "AES";
    private static final int BLOCK_LENGTH = 8;
    private static final int AES_IV_LENGTH = 16;
    private int keyLengthBits;
    private int encodedKeyLength;
    private String cryptoAlgorithm;
    private String cryptoAlgorithmShort;
    private String cryptoProvider;
    private String cryptoProviderShort;
    private MessageDigest messageDigest;
    private SecretKey mainSecretKey;
    private byte[] mainIV;
    private Properties persistentProperties;
    private static final int VERIFYKEY_DATALEN = 4096;
    private StorageFile activeFile;
    private int action;
    private String activePerms;

    public JCECipherFactory(boolean create, Properties props, boolean newAttributes) throws StandardException {
        this.init(create, props, newAttributes);
    }

    static String providerErrorName(String cps) {
        return cps == null ? "default" : cps;
    }

    private byte[] generateUniqueBytes() throws StandardException {
        try {
            KeyGenerator keyGen;
            String provider = this.cryptoProviderShort;
            if (provider == null) {
                keyGen = KeyGenerator.getInstance(this.cryptoAlgorithmShort);
            } else {
                if (provider.equals("BouncyCastleProvider")) {
                    provider = "BC";
                }
                keyGen = KeyGenerator.getInstance(this.cryptoAlgorithmShort, provider);
            }
            keyGen.init(this.keyLengthBits);
            SecretKey key = keyGen.generateKey();
            return key.getEncoded();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw StandardException.newException("XBCXC.S", (Object)this.cryptoAlgorithm, (Object)JCECipherFactory.providerErrorName(this.cryptoProviderShort));
        }
        catch (NoSuchProviderException nspe) {
            throw StandardException.newException("XBCXG.S", JCECipherFactory.providerErrorName(this.cryptoProviderShort));
        }
    }

    private String encryptKey(byte[] secretKey, byte[] bootPassword) throws StandardException {
        int muckLength = secretKey.length;
        if (this.cryptoAlgorithmShort.equals(AES)) {
            muckLength = 16;
        }
        byte[] muck = this.getMuckFromBootPassword(bootPassword, muckLength);
        SecretKey key = this.generateKey(muck);
        byte[] IV = this.generateIV(muck);
        CipherProvider tmpCipherProvider = this.createNewCipher(1, key, IV);
        this.encodedKeyLength = secretKey.length;
        secretKey = this.padKey(secretKey, tmpCipherProvider.getEncryptionBlockSize());
        byte[] result = new byte[secretKey.length];
        tmpCipherProvider.encrypt(secretKey, 0, secretKey.length, result, 0);
        return StringUtil.toHexString(result, 0, result.length);
    }

    private byte[] padKey(byte[] secretKey, int blockSizeAlign) {
        byte[] result = secretKey;
        if (secretKey.length % blockSizeAlign != 0) {
            int encryptedLength = secretKey.length + blockSizeAlign - secretKey.length % blockSizeAlign;
            result = new byte[encryptedLength];
            System.arraycopy(secretKey, 0, result, 0, secretKey.length);
        }
        return result;
    }

    private byte[] decryptKey(String encryptedKey, int encodedKeyCharLength, byte[] bootPassword) throws StandardException {
        byte[] secretKey = StringUtil.fromHexString(encryptedKey, 0, encodedKeyCharLength);
        int muckLength = this.cryptoAlgorithmShort.equals(AES) ? 16 : secretKey.length;
        byte[] muck = this.getMuckFromBootPassword(bootPassword, muckLength);
        SecretKey key = this.generateKey(muck);
        byte[] IV = this.generateIV(muck);
        this.createNewCipher(2, key, IV).decrypt(secretKey, 0, secretKey.length, secretKey, 0);
        return secretKey;
    }

    private byte[] getMuckFromBootPassword(byte[] bootPassword, int encodedKeyByteLength) {
        int i;
        int ulength = bootPassword.length;
        byte[] muck = new byte[encodedKeyByteLength];
        int rotation = 0;
        for (i = 0; i < bootPassword.length; ++i) {
            rotation += bootPassword[i];
        }
        for (i = 0; i < encodedKeyByteLength; ++i) {
            muck[i] = (byte)(bootPassword[(i + rotation) % ulength] ^ bootPassword[i % ulength] << 4);
        }
        return muck;
    }

    private SecretKey generateKey(byte[] secretKey) throws StandardException {
        int length = secretKey.length;
        if (length < 8) {
            throw StandardException.newException("XBCX2.S", new Integer(8));
        }
        try {
            if (this.cryptoAlgorithmShort.equals(DES) && DESKeySpec.isWeak(secretKey, 0)) {
                byte[] spice = StringUtil.getAsciiBytes("louDScap");
                for (int i = 0; i < 7; ++i) {
                    secretKey[i] = (byte)(spice[i] << 3 ^ secretKey[i]);
                }
            }
            return new SecretKeySpec(secretKey, this.cryptoAlgorithmShort);
        }
        catch (InvalidKeyException ike) {
            throw StandardException.newException("XBCX0.S", ike);
        }
    }

    private byte[] generateIV(byte[] secretKey) {
        int IVlen = 8;
        byte[] iv = null;
        if (this.cryptoAlgorithmShort.equals(AES)) {
            int i;
            IVlen = 16;
            iv = new byte[IVlen];
            iv[0] = (byte)((secretKey[secretKey.length - 1] << 2 | 0xF) ^ secretKey[0]);
            for (i = 1; i < 8; ++i) {
                iv[i] = (byte)((secretKey[i - 1] << i % 5 | 0xF) ^ secretKey[i]);
            }
            for (i = 8; i < 16; ++i) {
                iv[i] = iv[i - 8];
            }
        } else {
            iv = new byte[8];
            iv[0] = (byte)((secretKey[secretKey.length - 1] << 2 | 0xF) ^ secretKey[0]);
            for (int i = 1; i < 8; ++i) {
                iv[i] = (byte)((secretKey[i - 1] << i % 5 | 0xF) ^ secretKey[i]);
            }
        }
        return iv;
    }

    private int digest(byte[] input) {
        this.messageDigest.reset();
        byte[] digest = this.messageDigest.digest(input);
        byte[] condenseDigest = new byte[2];
        for (int i = 0; i < digest.length; ++i) {
            int n = i % 2;
            condenseDigest[n] = (byte)(condenseDigest[n] ^ digest[i]);
        }
        int retval = condenseDigest[0] & 0xFF | condenseDigest[1] << 8 & 0xFF00;
        return retval;
    }

    public SecureRandom getSecureRandom() {
        return new SecureRandom(this.mainIV);
    }

    public CipherProvider createNewCipher(int mode) throws StandardException {
        return this.createNewCipher(mode, this.mainSecretKey, this.mainIV);
    }

    private CipherProvider createNewCipher(int mode, SecretKey secretKey, byte[] iv) throws StandardException {
        return new JCECipherProvider(mode, secretKey, iv, this.cryptoAlgorithm, this.cryptoProviderShort);
    }

    public void init(boolean create, Properties properties, boolean newAttrs) throws StandardException {
        Throwable t;
        String feedbackMode;
        boolean provider_or_algo_specified = false;
        boolean storeProperties = create;
        this.persistentProperties = new Properties();
        String externalKey = properties.getProperty(newAttrs ? "newEncryptionKey" : "encryptionKey");
        if (externalKey != null) {
            storeProperties = false;
        }
        this.cryptoProvider = properties.getProperty("encryptionProvider");
        if (this.cryptoProvider != null) {
            provider_or_algo_specified = true;
            int dotPos = this.cryptoProvider.lastIndexOf(46);
            this.cryptoProviderShort = dotPos == -1 ? this.cryptoProvider : this.cryptoProvider.substring(dotPos + 1);
        }
        this.cryptoAlgorithm = properties.getProperty("encryptionAlgorithm");
        if (this.cryptoAlgorithm == null) {
            this.cryptoAlgorithm = DEFAULT_ALGORITHM;
        } else {
            provider_or_algo_specified = true;
        }
        if (storeProperties) {
            this.persistentProperties.put("encryptionAlgorithm", this.cryptoAlgorithm);
        }
        int firstSlashPos = this.cryptoAlgorithm.indexOf(47);
        int lastSlashPos = this.cryptoAlgorithm.lastIndexOf(47);
        if (firstSlashPos < 0 || lastSlashPos < 0 || firstSlashPos == lastSlashPos) {
            throw StandardException.newException("XBCXH.S", this.cryptoAlgorithm);
        }
        this.cryptoAlgorithmShort = this.cryptoAlgorithm.substring(0, firstSlashPos);
        if (provider_or_algo_specified) {
            try {
                Class<?> c = Class.forName("javax.crypto.ExemptionMechanism");
            }
            catch (Throwable t2) {
                throw StandardException.newException("XBCXJ.S");
            }
        }
        if (!create && properties.getProperty("encryptionKeyLength") != null) {
            String keyLengths = properties.getProperty("encryptionKeyLength");
            int pos = keyLengths.lastIndexOf(45);
            this.encodedKeyLength = Integer.parseInt(keyLengths.substring(pos + 1));
            if (pos != -1) {
                this.keyLengthBits = Integer.parseInt(keyLengths.substring(0, pos));
            }
        }
        if (externalKey == null && create) {
            this.keyLengthBits = properties.getProperty("encryptionKeyLength") != null ? Integer.parseInt(properties.getProperty("encryptionKeyLength")) : (this.cryptoAlgorithmShort.equals(DES) ? 56 : (this.cryptoAlgorithmShort.equals(DESede) || this.cryptoAlgorithmShort.equals(TripleDES) ? 168 : 128));
        }
        if (!((feedbackMode = this.cryptoAlgorithm.substring(firstSlashPos + 1, lastSlashPos)).equals("CBC") || feedbackMode.equals("CFB") || feedbackMode.equals("ECB") || feedbackMode.equals("OFB"))) {
            throw StandardException.newException("XBCXI.S", feedbackMode);
        }
        String padding = this.cryptoAlgorithm.substring(lastSlashPos + 1, this.cryptoAlgorithm.length());
        if (!padding.equals("NoPadding")) {
            throw StandardException.newException("XBCXB.S", padding);
        }
        try {
            byte[] generatedKey;
            if (this.cryptoProvider != null && Security.getProvider(this.cryptoProviderShort) == null) {
                this.action = 1;
                AccessController.doPrivileged(this);
            }
            this.messageDigest = MessageDigest.getInstance(MESSAGE_DIGEST);
            if (externalKey != null) {
                if (properties.getProperty(newAttrs ? "newBootPassword" : "bootPassword") != null) {
                    throw StandardException.newException("XBM06.D");
                }
                generatedKey = StringUtil.fromHexString(externalKey, 0, externalKey.length());
                if (generatedKey == null) {
                    throw StandardException.newException(externalKey.length() % 2 == 0 ? "XBCXN.S" : "XBCXM.S");
                }
            } else {
                generatedKey = this.handleBootPassword(create, properties, newAttrs);
                if (create || newAttrs) {
                    this.persistentProperties.put("encryptionKeyLength", this.keyLengthBits + "-" + generatedKey.length);
                }
            }
            this.mainSecretKey = this.generateKey(generatedKey);
            this.mainIV = this.generateIV(generatedKey);
            if (create) {
                this.persistentProperties.put("dataEncryption", "true");
                this.persistentProperties.put("data_encrypt_algorithm_version", String.valueOf(1));
                this.persistentProperties.put("log_encrypt_algorithm_version", String.valueOf(1));
            }
            return;
        }
        catch (PrivilegedActionException pae) {
            t = pae.getException();
        }
        catch (NoSuchAlgorithmException nsae) {
            t = nsae;
        }
        catch (SecurityException se) {
            t = se;
        }
        catch (LinkageError le) {
            t = le;
        }
        catch (ClassCastException cce) {
            t = cce;
        }
        throw StandardException.newException("XBM0G.D", t);
    }

    private byte[] handleBootPassword(boolean create, Properties properties, boolean newPasswd) throws StandardException {
        byte[] generatedKey;
        String inputKey = properties.getProperty(newPasswd ? "newBootPassword" : "bootPassword");
        if (inputKey == null) {
            throw StandardException.newException("XBM06.D");
        }
        byte[] bootPassword = StringUtil.getAsciiBytes(inputKey);
        if (bootPassword.length < 8) {
            String messageId = create ? "XBM07.D" : "XBM06.D";
            throw StandardException.newException(messageId);
        }
        if (create || newPasswd) {
            generatedKey = this.generateUniqueBytes();
            this.persistentProperties.put("encryptedBootPassword", this.saveSecretKey(generatedKey, bootPassword));
        } else {
            generatedKey = this.getDatabaseSecretKey(properties, bootPassword, "XBM06.D");
        }
        return generatedKey;
    }

    public void saveProperties(Properties properties) {
        Enumeration<Object> e = this.persistentProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            properties.put(key, this.persistentProperties.get(key));
        }
        this.persistentProperties = null;
    }

    private byte[] getDatabaseSecretKey(Properties properties, byte[] bootPassword, String errorState) throws StandardException {
        String keyString = properties.getProperty("encryptedBootPassword");
        if (keyString == null) {
            throw StandardException.newException(errorState);
        }
        int encodedKeyCharLength = keyString.indexOf(45);
        if (encodedKeyCharLength == -1) {
            throw StandardException.newException(errorState);
        }
        int verifyKey = Integer.parseInt(keyString.substring(encodedKeyCharLength + 1));
        byte[] generatedKey = this.decryptKey(keyString, encodedKeyCharLength, bootPassword);
        int checkKey = this.digest(generatedKey);
        if (checkKey != verifyKey) {
            throw StandardException.newException(errorState);
        }
        if (this.encodedKeyLength != 0) {
            byte[] result = new byte[this.encodedKeyLength];
            System.arraycopy(generatedKey, 0, result, 0, this.encodedKeyLength);
            return result;
        }
        return generatedKey;
    }

    private String saveSecretKey(byte[] secretKey, byte[] bootPassword) throws StandardException {
        String encryptedKey = this.encryptKey(secretKey, bootPassword);
        int verifyKey = this.digest(secretKey);
        return encryptedKey.concat("-" + verifyKey);
    }

    public String changeBootPassword(String changeString, Properties properties, CipherProvider verify) throws StandardException {
        int seperator = changeString.indexOf(44);
        if (seperator == -1) {
            throw StandardException.newException("XBCX7.S");
        }
        String oldBP = changeString.substring(0, seperator).trim();
        byte[] oldBPAscii = StringUtil.getAsciiBytes(oldBP);
        if (oldBPAscii == null || oldBPAscii.length < 8) {
            throw StandardException.newException("XBCXA.S");
        }
        String newBP = changeString.substring(seperator + 1).trim();
        byte[] newBPAscii = StringUtil.getAsciiBytes(newBP);
        if (newBPAscii == null || newBPAscii.length < 8) {
            throw StandardException.newException("XBCX2.S", new Integer(8));
        }
        byte[] generatedKey = this.getDatabaseSecretKey(properties, oldBPAscii, "XBCXA.S");
        byte[] IV = this.generateIV(generatedKey);
        if (!((JCECipherProvider)verify).verifyIV(IV)) {
            throw StandardException.newException("XBCXA.S");
        }
        String newkey = this.saveSecretKey(generatedKey, newBPAscii);
        properties.put("encryptionKeyLength", this.keyLengthBits + "-" + this.encodedKeyLength);
        return this.saveSecretKey(generatedKey, newBPAscii);
    }

    public final Object run() throws StandardException, InstantiationException, IllegalAccessException {
        try {
            switch (this.action) {
                case 1: {
                    Security.addProvider((Provider)Class.forName(this.cryptoProvider).newInstance());
                    break;
                }
                case 2: {
                    return this.activeFile.getRandomAccessFile(this.activePerms);
                }
                case 3: {
                    return this.activeFile.getInputStream();
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw StandardException.newException("XBCXF.S", this.cryptoProvider);
        }
        catch (FileNotFoundException fnfe) {
            throw StandardException.newException("XBCXL.S", this.cryptoProvider);
        }
        return null;
    }

    public void verifyKey(boolean create, StorageFactory sf, Properties properties) throws StandardException {
        if (properties.getProperty("encryptionKey") == null) {
            return;
        }
        InputStream verifyKeyInputStream = null;
        StorageRandomAccessFile verifyKeyFile = null;
        byte[] data = new byte[4096];
        try {
            if (create) {
                this.getSecureRandom().nextBytes(data);
                byte[] checksum = this.getMD5Checksum(data);
                CipherProvider tmpCipherProvider = this.createNewCipher(1, this.mainSecretKey, this.mainIV);
                tmpCipherProvider.encrypt(data, 0, data.length, data, 0);
                verifyKeyFile = this.privAccessFile(sf, "verifyKey.dat", "rw");
                verifyKeyFile.writeInt(checksum.length);
                verifyKeyFile.write(checksum);
                verifyKeyFile.write(data);
                verifyKeyFile.sync(true);
            } else {
                verifyKeyInputStream = this.privAccessGetInputStream(sf, "verifyKey.dat");
                DataInputStream dis = new DataInputStream(verifyKeyInputStream);
                int checksumLen = dis.readInt();
                byte[] originalChecksum = new byte[checksumLen];
                dis.readFully(originalChecksum);
                dis.readFully(data);
                CipherProvider tmpCipherProvider = this.createNewCipher(2, this.mainSecretKey, this.mainIV);
                tmpCipherProvider.decrypt(data, 0, data.length, data, 0);
                byte[] verifyChecksum = this.getMD5Checksum(data);
                if (!MessageDigest.isEqual(originalChecksum, verifyChecksum)) {
                    throw StandardException.newException("XBCXK.S");
                }
            }
        }
        catch (IOException ioe) {
            throw StandardException.newException("XBCXL.S", ioe);
        }
        finally {
            try {
                if (verifyKeyFile != null) {
                    verifyKeyFile.close();
                }
                if (verifyKeyInputStream != null) {
                    verifyKeyInputStream.close();
                }
            }
            catch (IOException ioee) {
                throw StandardException.newException("XBCXL.S", ioee);
            }
        }
    }

    private byte[] getMD5Checksum(byte[] data) throws StandardException {
        try {
            MessageDigest md5 = MessageDigest.getInstance(MESSAGE_DIGEST);
            return md5.digest(data);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw StandardException.newException("XBCXH.S", MESSAGE_DIGEST);
        }
    }

    private StorageRandomAccessFile privAccessFile(StorageFactory storageFactory, String fileName, String filePerms) throws IOException {
        StorageFile verifyKeyFile;
        this.activeFile = verifyKeyFile = storageFactory.newStorageFile("", fileName);
        this.action = 2;
        this.activePerms = filePerms;
        try {
            return (StorageRandomAccessFile)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
    }

    private InputStream privAccessGetInputStream(StorageFactory storageFactory, String fileName) throws StandardException {
        StorageFile verifyKeyFile;
        this.activeFile = verifyKeyFile = storageFactory.newStorageFile("", fileName);
        this.action = 3;
        try {
            return (InputStream)AccessController.doPrivileged(this);
        }
        catch (PrivilegedActionException pae) {
            throw (StandardException)pae.getException();
        }
    }
}

