/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class CurrentDatetimeOperatorNode
extends ValueNode {
    public static final int CURRENT_DATE = 0;
    public static final int CURRENT_TIME = 1;
    public static final int CURRENT_TIMESTAMP = 2;
    private static final int[] jdbcTypeId = new int[]{91, 92, 93};
    private static final String[] methodName = new String[]{"CURRENT DATE", "CURRENT TIME", "CURRENT TIMSTAMP"};
    private int whichType;

    public void init(Object whichType) {
        this.whichType = (Integer)whichType;
        SanityManager.ASSERT(this.whichType >= 0 && this.whichType <= 2);
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.checkReliability(methodName[this.whichType], 1);
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(jdbcTypeId[this.whichType], false));
        return this;
    }

    protected int getOrderableVariantType() {
        return 2;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        switch (this.whichType) {
            case 0: {
                acb.getCurrentDateExpression(mb);
                break;
            }
            case 1: {
                acb.getCurrentTimeExpression(mb);
                break;
            }
            case 2: {
                acb.getCurrentTimestampExpression(mb);
            }
        }
        acb.generateDataValue(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType(), null);
    }

    public String toString() {
        return super.toString() + "method = " + methodName[this.whichType] + "\n";
    }

    protected boolean isEquivalent(ValueNode o) {
        if (this.isSameNodeType(o)) {
            CurrentDatetimeOperatorNode other = (CurrentDatetimeOperatorNode)o;
            return other.whichType == this.whichType;
        }
        return false;
    }
}

