/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.List;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.RoutineAliasInfo;
import org.apache.derby.catalog.types.SynonymAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class CreateAliasConstantAction
extends DDLConstantAction {
    private final String aliasName;
    private final String schemaName;
    private final String javaClassName;
    private final char aliasType;
    private final char nameSpace;
    private final AliasInfo aliasInfo;

    CreateAliasConstantAction(String aliasName, String schemaName, String javaClassName, AliasInfo aliasInfo, char aliasType) {
        this.aliasName = aliasName;
        this.schemaName = schemaName;
        this.javaClassName = javaClassName;
        this.aliasInfo = aliasInfo;
        this.aliasType = aliasType;
        switch (aliasType) {
            case 'P': {
                this.nameSpace = (char)80;
                break;
            }
            case 'F': {
                this.nameSpace = (char)70;
                break;
            }
            case 'S': {
                this.nameSpace = (char)83;
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected value for aliasType (" + aliasType + ")");
                this.nameSpace = '\u0000';
            }
        }
    }

    public String toString() {
        String type = null;
        switch (this.aliasType) {
            case 'P': {
                type = "CREATE PROCEDURE ";
                break;
            }
            case 'F': {
                type = "CREATE FUNCTION ";
                break;
            }
            case 'S': {
                type = "CREATE SYNONYM ";
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected value for aliasType (" + this.aliasType + ")");
            }
        }
        return type + this.aliasName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        SchemaDescriptor sd = DDLConstantAction.getSchemaDescriptorForCreate(dd, activation, this.schemaName);
        UUID aliasID = dd.getUUIDFactory().createUUID();
        AliasDescriptor ads = new AliasDescriptor(dd, aliasID, this.aliasName, sd.getUUID(), this.javaClassName, this.aliasType, this.nameSpace, false, this.aliasInfo, null);
        switch (this.aliasType) {
            case 'F': 
            case 'P': {
                List list = dd.getRoutineList(sd.getUUID().toString(), this.aliasName, this.aliasType);
                for (int i = list.size() - 1; i >= 0; --i) {
                    AliasDescriptor proc = (AliasDescriptor)list.get(i);
                    RoutineAliasInfo procedureInfo = (RoutineAliasInfo)proc.getAliasInfo();
                    int parameterCount = procedureInfo.getParameterCount();
                    if (parameterCount != ((RoutineAliasInfo)this.aliasInfo).getParameterCount()) continue;
                    throw StandardException.newException("X0Y68.S", (Object)ads.getDescriptorType(), (Object)this.aliasName);
                }
                break;
            }
            case 'S': {
                AliasDescriptor nextAD;
                SchemaDescriptor nextSD;
                TableDescriptor targetTD = dd.getTableDescriptor(this.aliasName, sd, tc);
                if (targetTD != null) {
                    throw StandardException.newException("X0Y68.S", (Object)targetTD.getDescriptorType(), (Object)targetTD.getDescriptorName());
                }
                String nextSynTable = ((SynonymAliasInfo)this.aliasInfo).getSynonymTable();
                String nextSynSchema = ((SynonymAliasInfo)this.aliasInfo).getSynonymSchema();
                while ((nextSD = dd.getSchemaDescriptor(nextSynSchema, tc, false)) != null && (nextAD = dd.getAliasDescriptor(nextSD.getUUID().toString(), nextSynTable, this.nameSpace)) != null) {
                    SynonymAliasInfo info = (SynonymAliasInfo)nextAD.getAliasInfo();
                    nextSynTable = info.getSynonymTable();
                    nextSynSchema = info.getSynonymSchema();
                    if (!this.aliasName.equals(nextSynTable) || !this.schemaName.equals(nextSynSchema)) continue;
                    throw StandardException.newException("42916", (Object)this.aliasName, (Object)((SynonymAliasInfo)this.aliasInfo).getSynonymTable());
                }
                if (nextSD != null) {
                    targetTD = dd.getTableDescriptor(nextSynTable, nextSD, tc);
                }
                if (nextSD == null || targetTD == null) {
                    activation.addWarning(StandardException.newWarning("01522", this.aliasName, nextSynSchema + "." + nextSynTable));
                }
                DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
                TableDescriptor td = ddg.newTableDescriptor(this.aliasName, sd, 4, 'R');
                dd.addDescriptor(td, sd, 1, false, tc);
                break;
            }
        }
        dd.addDescriptor(ads, null, 7, false, tc);
    }
}

