/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;

public class RealHashScanStatistics
extends RealNoPutResultSetStatistics {
    public boolean isConstraint;
    public int hashtableSize;
    public int[] hashKeyColumns;
    public String isolationLevel;
    public String lockString;
    public String tableName;
    public String indexName;
    public String nextQualifiers;
    public String scanQualifiers;
    public String startPosition = null;
    public String stopPosition = null;
    public FormatableProperties scanProperties;

    public RealHashScanStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, String tableName, String indexName, boolean isConstraint, int hashtableSize, int[] hashKeyColumns, String scanQualifiers, String nextQualifiers, Properties scanProperties, String startPosition, String stopPosition, String isolationLevel, String lockString, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.tableName = tableName;
        this.indexName = indexName;
        this.isConstraint = isConstraint;
        this.hashtableSize = hashtableSize;
        this.hashKeyColumns = hashKeyColumns;
        this.scanQualifiers = scanQualifiers;
        this.nextQualifiers = nextQualifiers;
        this.scanProperties = new FormatableProperties();
        if (scanProperties != null) {
            Enumeration<Object> e = scanProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                this.scanProperties.put(key, scanProperties.get(key));
            }
        }
        this.startPosition = startPosition;
        this.stopPosition = stopPosition;
        this.isolationLevel = isolationLevel;
        this.lockString = lockString;
    }

    public String getStatementExecutionPlanText(int depth) {
        String hashKeyColumnString;
        Object isolationString = null;
        this.initFormatInfo(depth);
        String header = this.indexName != null ? this.indent + MessageService.getTextMessage("43X51.U", this.tableName, MessageService.getTextMessage(this.isConstraint ? "43X24.U" : "43X25.U"), this.indexName) : this.indent + MessageService.getTextMessage("43X52.U", this.tableName);
        header = header + " " + MessageService.getTextMessage("43X27.U", this.isolationLevel, this.lockString) + ": \n";
        String scanInfo = this.indent + MessageService.getTextMessage("43X28.U") + ": \n" + PropertyUtil.sortProperties(this.scanProperties, this.subIndent);
        if (this.hashKeyColumns.length == 1) {
            hashKeyColumnString = MessageService.getTextMessage("43X53.U") + " " + this.hashKeyColumns[0];
        } else {
            hashKeyColumnString = MessageService.getTextMessage("43X54.U") + " (" + this.hashKeyColumns[0];
            for (int index = 1; index < this.hashKeyColumns.length; ++index) {
                hashKeyColumnString = hashKeyColumnString + "," + this.hashKeyColumns[index];
            }
            hashKeyColumnString = hashKeyColumnString + ")";
        }
        return header + this.indent + MessageService.getTextMessage("43X03.U") + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X31.U") + " = " + this.hashtableSize + "\n" + this.indent + hashKeyColumnString + "\n" + this.indent + MessageService.getTextMessage("43X04.U") + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U") + " = " + this.rowsFiltered + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + (this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U") + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + scanInfo + this.subIndent + MessageService.getTextMessage("43X34.U") + ": \n" + this.startPosition + this.subIndent + MessageService.getTextMessage("43X35.U") + ": \n" + this.stopPosition + this.subIndent + MessageService.getTextMessage("43X36.U") + ":\n" + this.scanQualifiers + "\n" + this.subIndent + MessageService.getTextMessage("43X37.U") + ":\n" + this.nextQualifiers + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    public String getScanStatisticsText(String tableName, int depth) {
        if (tableName == null || tableName.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(depth);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    public String getNodeOn() {
        return MessageService.getTextMessage("43X38.U", this.tableName, this.indexName);
    }

    public String getNodeName() {
        return MessageService.getTextMessage("43X55.U");
    }
}

