/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.LogicalPageOperation;
import org.apache.derby.impl.store.raw.data.PageBasicOperation;

public class LogicalUndoOperation
extends PageBasicOperation
implements Compensation {
    protected int recordId;
    private transient LogicalPageOperation undoOp = null;

    protected LogicalUndoOperation(BasePage page) {
        super(page);
    }

    public LogicalUndoOperation(BasePage page, int recordId, LogicalPageOperation op) {
        super(page);
        this.undoOp = op;
        this.recordId = recordId;
    }

    public LogicalUndoOperation() {
    }

    public int getTypeFormatId() {
        return 104;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeInt(out, this.recordId);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.recordId = CompressedNumber.readInt(in);
    }

    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRinstant, LimitObjectInput in) {
        SanityManager.THROWASSERT("cannot call restore me on PhysicalUndoOperation");
    }

    public void setUndoOp(Undoable op) {
        SanityManager.ASSERT(op instanceof LogicalPageOperation);
        this.undoOp = (LogicalPageOperation)op;
    }

    public final void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        long oldversion = 0L;
        LogInstant oldLogInstant = null;
        oldLogInstant = this.page.getLastLogInstant();
        oldversion = this.page.getPageVersion();
        SanityManager.ASSERT(oldversion == this.getPageVersion());
        SanityManager.ASSERT(oldLogInstant == null || instant == null || oldLogInstant.lessThan(instant));
        this.undoOp.undoMe(xact, this.page, this.recordId, instant, in);
        SanityManager.ASSERT(oldversion < this.page.getPageVersion());
        SanityManager.ASSERT(instant == null || instant.equals(this.page.getLastLogInstant()));
        this.releaseResource(xact);
    }

    public void releaseResource(Transaction xact) {
        if (this.undoOp != null) {
            this.undoOp.releaseResource(xact);
        }
        super.releaseResource(xact);
    }

    public int group() {
        return super.group() | 4 | 0x100;
    }

    public final ByteArray getPreparedLog() {
        return null;
    }

    public String toString() {
        String str = "CLR : (logical undo) " + super.toString() + " undoRecordId = " + this.recordId;
        str = this.undoOp != null ? str + "\n" + this.undoOp.toString() : str + " undo Operation not set";
        return str;
    }
}

