/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Jar {
    public static void doJars(String dbName, Connection conn) throws SQLException {
        String separator = System.getProperty("file.separator");
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT FILENAME, SCHEMAID, GENERATIONID FROM SYS.SYSFILES");
        boolean firstTime = true;
        while (rs.next()) {
            String jarName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(1)));
            String schemaId = rs.getString(2);
            String schemaName = dblook.lookupSchemaId(schemaId);
            if (dblook.isIgnorableSchema(schemaName)) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_JarsHeader");
                Logs.reportMessage("DBLOOK_Jar_Note");
                Logs.reportString("----------------------------------------------\n");
            }
            String genID = rs.getString(3);
            String schemaWithoutQuotes = dblook.stripQuotes(schemaName);
            StringBuffer jarFullName = new StringBuffer(separator);
            jarFullName.append(dblook.stripQuotes(jarName));
            jarFullName.append(".jar.G");
            jarFullName.append(genID);
            StringBuffer oldJarPath = new StringBuffer();
            oldJarPath.append(dbName);
            oldJarPath.append(separator);
            oldJarPath.append("jar");
            oldJarPath.append(separator);
            oldJarPath.append(schemaWithoutQuotes);
            oldJarPath.append(jarFullName);
            String absJarDir = null;
            try {
                File jarDir = new File(System.getProperty("user.dir") + separator + "DBJARS" + separator + schemaWithoutQuotes);
                absJarDir = jarDir.getAbsolutePath();
                jarDir.mkdirs();
                FileInputStream oldJarFile = new FileInputStream(oldJarPath.toString());
                FileOutputStream newJarFile = new FileOutputStream(absJarDir + jarFullName);
                boolean st = false;
                while (oldJarFile.available() != 0) {
                    byte[] bAr = new byte[oldJarFile.available()];
                    oldJarFile.read(bAr);
                    newJarFile.write(bAr);
                }
                newJarFile.close();
                oldJarFile.close();
            }
            catch (Exception e) {
                Logs.debug("DBLOOK_FailedToLoadJar", absJarDir + jarFullName.toString());
                Logs.debug(e);
                firstTime = false;
                continue;
            }
            StringBuffer loadJarString = new StringBuffer();
            loadJarString.append("CALL SQLJ.INSTALL_JAR('file:");
            loadJarString.append(absJarDir);
            loadJarString.append(jarFullName);
            loadJarString.append("', '");
            loadJarString.append(schemaName);
            loadJarString.append(".");
            loadJarString.append(jarName);
            loadJarString.append("', 0)");
            Logs.writeToNewDDL(loadJarString.toString());
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
        stmt.close();
        rs.close();
    }
}

