/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.SharedValueRecordBase;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public final class ArrayRecord
extends SharedValueRecordBase {
    public static final short sid = 545;
    private static final int OPT_ALWAYS_RECALCULATE = 1;
    private static final int OPT_CALCULATE_ON_OPEN = 2;
    private int _options;
    private int _field3notUsed;
    private Ptg[] _formulaTokens;

    public ArrayRecord(RecordInputStream in) {
        super(in);
        this._options = in.readUShort();
        this._field3notUsed = in.readInt();
        int formulaLen = in.readUShort();
        this._formulaTokens = Ptg.readTokens(formulaLen, in);
    }

    public boolean isAlwaysRecalculate() {
        return (this._options & 1) != 0;
    }

    public boolean isCalculateOnOpen() {
        return (this._options & 2) != 0;
    }

    protected int getExtraDataSize() {
        return 8 + Ptg.getEncodedSize(this._formulaTokens);
    }

    protected void serializeExtraData(int offset, byte[] data) {
        int pos = offset;
        LittleEndian.putUShort(data, pos, this._options);
        LittleEndian.putInt(data, pos += 2, this._field3notUsed);
        int tokenSize = Ptg.getEncodedSizeWithoutArrayData(this._formulaTokens);
        LittleEndian.putUShort(data, pos += 4, tokenSize);
        Ptg.serializePtgs(this._formulaTokens, data, pos += 2);
    }

    public short getSid() {
        return 545;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" [ARRAY]\n");
        sb.append(" range=").append(this.getRange().toString()).append("\n");
        sb.append(" options=").append(HexDump.shortToHex(this._options)).append("\n");
        sb.append(" notUsed=").append(HexDump.intToHex(this._field3notUsed)).append("\n");
        sb.append(" formula:").append("\n");
        int i = 0;
        while (i < this._formulaTokens.length) {
            Ptg ptg = this._formulaTokens[i];
            sb.append(ptg.toString()).append(ptg.getRVAType()).append("\n");
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

