/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.compound.DictionaryCompoundWordTokenFilter;
import org.apache.solr.analysis.BaseTokenFilterFactory;
import org.apache.solr.common.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.util.plugin.ResourceLoaderAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryCompoundWordTokenFilterFactory
extends BaseTokenFilterFactory
implements ResourceLoaderAware {
    private CharArraySet dictionary;
    private String dictFile;
    private int minWordSize;
    private int minSubwordSize;
    private int maxSubwordSize;
    private boolean onlyLongestMatch;

    @Override
    public void init(Map<String, String> args) {
        super.init((Map)args);
        this.assureMatchVersion();
        this.dictFile = args.get("dictionary");
        if (null == this.dictFile) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing required parameter: dictionary");
        }
        this.minWordSize = this.getInt("minWordSize", 5);
        this.minSubwordSize = this.getInt("minSubwordSize", 2);
        this.maxSubwordSize = this.getInt("maxSubwordSize", 15);
        this.onlyLongestMatch = this.getBoolean("onlyLongestMatch", true);
    }

    @Override
    public void inform(ResourceLoader loader) {
        try {
            this.dictionary = super.getWordSet(loader, this.dictFile, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public DictionaryCompoundWordTokenFilter create(TokenStream input) {
        return new DictionaryCompoundWordTokenFilter(this.luceneMatchVersion, input, (Set)this.dictionary, this.minWordSize, this.minSubwordSize, this.maxSubwordSize, this.onlyLongestMatch);
    }
}

