/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.ascape.model.Cell;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.CoordinateDiscrete;
import org.ascape.model.space.CoordinateGraph;
import org.ascape.model.space.Discrete;
import org.ascape.model.space.Location;
import org.ascape.model.space.Node;
import org.ascape.util.Conditional;

public class Graph
extends Discrete {
    private static final long serialVersionUID = 1L;
    private HashMap adjacencyMap = new HashMap();

    public Graph() {
    }

    public Graph(CoordinateDiscrete extent) {
        this();
        this.setExtent(extent);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.adjacencyMap.clear();
        for (Node agent : this) {
            agent.setCoordinate(new CoordinateGraph(agent));
            if (this.adjacencyMap.get(agent) != null) continue;
            this.adjacencyMap.put(agent, new ArrayList());
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.adjacencyMap.clear();
    }

    @Override
    public List calculateNeighbors(Node cell) {
        return this.getNeighborsFor(cell);
    }

    @Override
    public Location findNearest(Coordinate origin, Conditional condition, boolean includeOrigin, double distance) {
        return this.findNearestBFS(origin, condition, includeOrigin, distance);
    }

    @Override
    public List findNeighbors(Node location) {
        return this.getNeighborsFor(location);
    }

    @Override
    public Iterator withinIterator(Coordinate origin, Conditional condition, boolean includeSelf, double distance) {
        return this.bfsWithinIterator(((CoordinateGraph)origin).getLocation(), condition, includeSelf, distance);
    }

    @Override
    public Node findCellToward(Node origin, Node target) {
        return this.findCellTowardBFS(origin, target);
    }

    @Override
    public Node findCellAway(Node origin, Node target) {
        return this.findCellAwayBFS(origin, target);
    }

    @Override
    public boolean add(Object o, boolean isParent) {
        this.adjacencyMap.put(o, new ArrayList());
        if (o instanceof Cell) {
            ((Node)o).setCoordinate(new CoordinateGraph((Node)o));
        }
        return super.add(o, isParent);
    }

    public boolean addNeighbor(Node source, Node target, boolean directed) {
        if (!this.contains(source)) {
            throw new RuntimeException("Src agent is not in Graph");
        }
        if (!this.contains(target)) {
            throw new RuntimeException("Target agent is not in Graph");
        }
        boolean added = ((ArrayList)this.adjacencyMap.get(source)).add(target);
        if (!directed) {
            added |= ((ArrayList)this.adjacencyMap.get(target)).add(source);
        }
        return added;
    }

    public boolean addNeighborSafe(Node source, Node target, boolean directed) {
        if (this.adjacencyMap.get(source) == null) {
            this.adjacencyMap.put(source, new ArrayList());
        }
        boolean added = ((List)this.adjacencyMap.get(source)).add(target);
        if (!directed) {
            if (this.adjacencyMap.get(target) == null) {
                this.adjacencyMap.put(target, new ArrayList());
            }
            added |= ((List)this.adjacencyMap.get(target)).add(source);
        }
        return added;
    }

    public void addNeighbor(Node source, Node target) {
        this.addNeighbor(source, target, true);
    }

    public boolean removeNeighbor(Node source, Node target) {
        ArrayList list = (ArrayList)this.adjacencyMap.get(source);
        for (Node neighbor : list) {
            if (neighbor != target) continue;
            list.remove(target);
            return true;
        }
        return false;
    }

    public Iterator neighborIterator(Node source) {
        return this.getNeighborsFor(source).iterator();
    }

    public void clearNeighbors(Node source) {
        for (Object neighbor : this.getNeighborsFor(source)) {
            this.removeNeighbor((Node)neighbor, source);
        }
        this.getNeighborsFor(source).clear();
    }

    public List getNeighborsFor(Node agent) {
        if (this.adjacencyMap == null) {
            return null;
        }
        List result = (List)this.adjacencyMap.get(agent);
        return result != null ? result : Collections.EMPTY_LIST;
    }

    public void replaceNeighbor(Node agent, Node newNeighbor, boolean directed) {
        this.adjacencyMap.remove(agent);
        this.addNeighborSafe(agent, newNeighbor, directed);
    }

    public void setNeighborsFor(Node agent, List neighbors) {
        this.adjacencyMap.put(agent, neighbors);
    }

    @Override
    public boolean remove(Object o) {
        for (Node agent : this) {
            ArrayList list = (ArrayList)this.adjacencyMap.get(agent);
            list.remove(o);
        }
        return super.remove(o);
    }

    public boolean isNeighbor(Node source, Node target) {
        return this.getNeighborsFor(source).contains(target);
    }

    public HashMap getAdjacencyMap() {
        return this.adjacencyMap;
    }

    public void setAdjacencyMap(HashMap adjacencyMap) {
        this.adjacencyMap = adjacencyMap;
    }
}

