/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util;

import java.awt.Image;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;

public class Utility
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int[][][] uniqueSeries = new int[][][]{new int[][]{new int[0]}, new int[][]{{1}}, new int[][]{{1, 2}, {2, 1}}, new int[][]{{1, 2, 3}, {1, 3, 2}, {2, 1, 3}, {2, 3, 1}, {3, 1, 2}, {3, 2, 1}}, new int[][]{{1, 2, 3, 4}, {1, 2, 4, 3}, {1, 3, 2, 4}, {1, 3, 4, 2}, {1, 4, 2, 3}, {1, 4, 3, 2}, {2, 1, 3, 4}, {2, 1, 4, 3}, {2, 3, 1, 4}, {2, 3, 4, 1}, {2, 4, 1, 3}, {2, 4, 3, 1}, {3, 1, 2, 4}, {3, 1, 4, 2}, {3, 2, 1, 4}, {3, 2, 4, 1}, {3, 4, 1, 2}, {3, 4, 2, 1}, {4, 1, 2, 3}, {4, 1, 3, 2}, {4, 2, 1, 3}, {4, 2, 3, 1}, {4, 3, 1, 2}, {4, 3, 2, 1}}};

    public static final int randomInRange(Random random, int low, int high) {
        return random.nextInt(high - low + 1) + low;
    }

    public static final double randomInRange(Random random, double low, double high) {
        return random.nextDouble() * (high - low) + low;
    }

    public static final int randomToLimit(Random random, int limit) {
        return random.nextInt(limit);
    }

    public static final boolean randomIs(Random random) {
        return random.nextBoolean();
    }

    public static void notImplemented() {
        throw new RuntimeException("Method not yet implemented, you should really complain to the developer.");
    }

    public static String formatElapsedMillis(long time) {
        int timeInt = (int)time;
        int mils = timeInt % 1000;
        int secs = (timeInt /= 1000) % 60;
        int mins = (timeInt /= 60) % 60;
        int hours = (timeInt /= 60) % 24;
        if ((timeInt /= 24) == 0) {
            return String.valueOf(Integer.toString(hours)) + ":" + Integer.toString(mins) + ":" + Integer.toString(secs) + "." + Utility.padStringLeftWithZeros(Integer.toString(mils), 3);
        }
        return String.valueOf(Integer.toString(timeInt)) + "d " + Integer.toString(hours) + ":" + Integer.toString(mins) + ":" + Integer.toString(secs) + "." + Utility.padStringLeftWithZeros(Integer.toString(mils), 3);
    }

    private static String removeStartsWith(String source, String startingText) {
        if (source.startsWith(startingText)) {
            return source.substring(startingText.length());
        }
        return source;
    }

    public static String removeQualifiers(String string) {
        string = Utility.removeStartsWith(string, "Minimum ");
        string = Utility.removeStartsWith(string, "Maximum ");
        string = Utility.removeStartsWith(string, "Min ");
        string = Utility.removeStartsWith(string, "Max ");
        return string;
    }

    private static String orderWith(String source, String orderText, String endToken) {
        int occursAt = source.indexOf(orderText);
        if (occursAt >= 0) {
            return String.valueOf(source.substring(0, occursAt)) + source.substring(occursAt + orderText.length()) + endToken;
        }
        return source;
    }

    public static String orderedQualifiers(String string) {
        string = Utility.orderWith(string, "Minimum ", "1");
        string = Utility.orderWith(string, "Maximum ", "2");
        string = Utility.orderWith(string, "Min ", "1");
        string = Utility.orderWith(string, "Max ", "2");
        string = Utility.orderWith(string, "Minimum", "1");
        string = Utility.orderWith(string, "Maximum", "2");
        string = Utility.orderWith(string, "Min", "1");
        string = Utility.orderWith(string, "Max", "2");
        return string;
    }

    public static String padStringRight(String string, int size) {
        while (string.length() < size) {
            string = String.valueOf(string) + ' ';
        }
        if (string.length() > size) {
            string = string.substring(0, size);
        }
        return string;
    }

    public static String padStringLeft(String string, int size) {
        while (string.length() < size) {
            string = String.valueOf(' ') + string;
        }
        if (string.length() > size) {
            string = string.substring(0, size);
        }
        return string;
    }

    public static String padStringLeftWithZeros(String string, int size) {
        while (string.length() < size) {
            string = String.valueOf('0') + string;
        }
        if (string.length() > size) {
            string = string.substring(0, size);
        }
        return string;
    }

    public static String formatToString(double num, int decPlaces) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        if (Math.abs(num) >= 1.0E9) {
            try {
                ((DecimalFormat)nf).applyPattern("0.###E0");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(decPlaces);
        nf.setMaximumFractionDigits(decPlaces);
        return nf.format(num);
    }

    public static String getClassNameOnly(Class c) {
        String className = c.getName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public static double tanh(double x) {
        double absX = Math.abs(x);
        if (absX > 22.0) {
            return x > 0.0 ? 1.0 : -1.0;
        }
        if (absX > 1.0E-6) {
            double expX = Math.exp(x);
            double expMX = Math.exp(-x);
            return (expX - expMX) / (expX + expMX);
        }
        return x;
    }

    public static Image reduceImage(Image image, double reductionFactorHeight, double reductionFactorWidth) {
        int bWidth = (int)((double)image.getWidth(null) / reductionFactorHeight);
        int bHeight = (int)((double)image.getHeight(null) / reductionFactorWidth);
        return image.getScaledInstance(bWidth, bHeight, 4);
    }

    public static Image magnifyImage(Image image, double magnificationFactorHeight, double magnificationFactorWidth) {
        int bWidth = (int)((double)image.getWidth(null) * magnificationFactorHeight);
        int bHeight = (int)((double)image.getHeight(null) * magnificationFactorWidth);
        return image.getScaledInstance(bWidth, bHeight, 4);
    }
}

