/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.draw.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.actf.model.dom.odf.ODFException;
import org.eclipse.actf.model.dom.odf.base.ContentBaseElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.base.impl.ODFElementImpl;
import org.eclipse.actf.model.dom.odf.draw.PageElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.presentation.NotesElement;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PageElementImpl
extends ODFElementImpl
implements PageElement {
    private static final long serialVersionUID = 8198841362223795490L;
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile("./*[(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='rect') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='line') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='polyline') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='polygon') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='regular-polygon') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='path') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='circle') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='ellipse') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='g') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='page-thumbnail') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='measure') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='caption') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='connector') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='custom-shape') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0' and local-name()='scene')]");
    private static final Object EXP2 = xpathService.compile("./*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='page']");
    private static final Object EXP3 = xpathService.compile("./*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:presentation:1.0' and local-name()='notes']");
    private ContentBaseElement contentElement = null;

    protected PageElementImpl(ODFDocument oDFDocument, Element element) {
        super(oDFDocument, element);
    }

    @Override
    public ODFElement createObject(long l, long l2, long l3, long l4) {
        return null;
    }

    @Override
    public int getPageIndex() {
        Object object;
        if (this.odfDoc == null) {
            return -1;
        }
        Element element = this.odfDoc.getDocumentElement();
        if (element instanceof DocumentContentElement) {
            object = ((DocumentContentElement)element).getBodyElement();
            this.contentElement = object.getContent();
        }
        if (this.contentElement == null) {
            return -1;
        }
        object = XPathServiceFactory.newService().evalForNodeList(EXP2, (Node)this.contentElement);
        int n = 0;
        while (n < object.getLength()) {
            if (object.item(n).equals(this)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public String getAttrDrawName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "name");
        }
        return null;
    }

    @Override
    public String getAttrDrawStyleName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "style-name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "style-name");
        }
        return null;
    }

    @Override
    public String getAttrDrawMasterPageName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "master-page-name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "master-page-name");
        }
        return null;
    }

    @Override
    public String getAttrDrawNavOrder() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "nav-order")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "nav-order");
        }
        return null;
    }

    @Override
    public List<ODFElement> getChildNodesInNavOrder() {
        ArrayList<ODFElement> arrayList = new ArrayList<ODFElement>();
        NodeList nodeList = this.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof ODFElement) {
                arrayList.add((ODFElement)nodeList.item(n));
            }
            ++n;
        }
        String string = this.getAttrDrawNavOrder();
        if (string == null) {
            return arrayList;
        }
        Collections.sort(arrayList, new NavOrderComparator());
        return arrayList;
    }

    @Override
    public NodeList getDrawingObjectElements() {
        return xpathService.evalForNodeList(EXP1, (Node)this);
    }

    @Override
    public NotesElement getPresentationNotesElement() {
        NodeList nodeList = xpathService.evalForNodeList(EXP3, (Node)this);
        if (nodeList != null && nodeList.getLength() == 1) {
            return (NotesElement)nodeList.item(0);
        }
        if (nodeList != null && nodeList.getLength() > 1) {
            new ODFException("draw:page has more than one presentation:notes element").printStackTrace();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NavOrderComparator
    implements Comparator<ODFElement> {
        private NavOrderComparator() {
        }

        private int getNavOrder(ODFElement oDFElement, String string) {
            int n;
            String string2 = oDFElement.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "id");
            if (string2 != null && (n = string.indexOf(string2)) >= 0) {
                return n;
            }
            return string.length();
        }

        private int getZOrder(ODFElement oDFElement) {
            Node node = oDFElement.getParentNode();
            if (!(node instanceof PageElement)) {
                return -1;
            }
            int n = 0;
            Node node2 = oDFElement.getPreviousSibling();
            while (node2 != null) {
                if (node2 instanceof ODFElement) {
                    ++n;
                }
                node2 = node2.getPreviousSibling();
            }
            return n;
        }

        @Override
        public int compare(ODFElement oDFElement, ODFElement oDFElement2) {
            int n;
            String string = PageElementImpl.this.getAttrDrawNavOrder();
            if (string != null && (n = this.getNavOrder(oDFElement, string) - this.getNavOrder(oDFElement2, string)) != 0) {
                return n;
            }
            n = this.getZOrder(oDFElement) - this.getZOrder(oDFElement2);
            if (n != 0) {
                return n;
            }
            return 0;
        }
    }
}

