/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.ide;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.ide.IModelWorkbenchListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class ModelManagerListeners {
    private List<IModelWorkbenchListener> manangerListeners = new ArrayList<IModelWorkbenchListener>();

    public synchronized void addModelManagerListener(IModelWorkbenchListener listener) {
        this.manangerListeners.add(listener);
    }

    public synchronized void removeModelManagerListener(IModelWorkbenchListener listener) {
        this.manangerListeners.remove(listener);
    }

    protected synchronized void notifyViewAdded(IViewPart showViewPart) {
        for (IModelWorkbenchListener listener : this.manangerListeners) {
            listener.viewAdded((IWorkbenchPart)showViewPart);
        }
    }

    protected synchronized void notifyViewRemoved(IViewPart showViewPart) {
        for (IModelWorkbenchListener listener : this.manangerListeners) {
            listener.viewRemoved((IWorkbenchPart)showViewPart);
        }
    }

    protected synchronized void notifyModelActivated(IModel model) {
        for (IModelWorkbenchListener listener : this.manangerListeners) {
            listener.modelActivated(model);
        }
    }

    protected synchronized void notifyModelAdded(IModel model) {
        for (IModelWorkbenchListener listener : this.manangerListeners) {
            listener.modelAdded(model);
        }
    }

    protected synchronized void notifyModelRemoved(IModel model) {
        for (IModelWorkbenchListener listener : this.manangerListeners) {
            listener.modelRemoved(model);
        }
    }

    public boolean isListening(IModelWorkbenchListener listener) {
        return this.manangerListeners.contains(listener);
    }
}

