/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ascape.wrap;

import java.util.TooManyListenersException;
import org.ascape.model.Scape;
import org.ascape.model.event.DefaultScapeListener;
import org.ascape.model.event.ScapeEvent;
import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.core.IStateListener;
import org.eclipse.amp.axf.core.LifeCycleState;

public class ModelWrapperScapeListener
extends DefaultScapeListener {
    private static final long serialVersionUID = 1L;
    private IModel model;
    private IStateListener wrapped;

    public ModelWrapperScapeListener(IModel model, Scape scape, ILifeCycleListener wrapped) {
        this.model = model;
        this.scape = scape;
        this.wrapped = wrapped;
        if (model == null) {
            throw new RuntimeException("Model cannot be null.");
        }
        if (scape == null) {
            throw new RuntimeException("Scape cannot be null.");
        }
        if (wrapped == null) {
            throw new RuntimeException("Wrapped listener cannot be null." + wrapped + " for " + scape);
        }
    }

    public void scapeAdded(ScapeEvent scapeEvent) throws TooManyListenersException {
        this.wrapped.stateChange((Object)LifeCycleState.OBSERVED, (Object)this.model);
        super.scapeAdded(scapeEvent);
    }

    public void scapeClosing(ScapeEvent scapeEvent) {
        this.wrapped.stateChange((Object)LifeCycleState.ENDING, (Object)this.model);
        super.scapeClosing(scapeEvent);
    }

    public void scapeInitialized(ScapeEvent scapeEvent) {
        this.wrapped.stateChange((Object)LifeCycleState.INITIALIZE, (Object)this.model);
    }

    public void scapeIterated(ScapeEvent scapeEvent) {
        this.wrapped.stateChange((Object)LifeCycleState.UPDATE, (Object)this.model);
    }

    public void scapeRemoved(ScapeEvent scapeEvent) {
        this.wrapped.stateChange((Object)LifeCycleState.END, (Object)this.model);
        super.scapeRemoved(scapeEvent);
    }

    public void scapeSetup(ScapeEvent scapeEvent) {
        this.wrapped.stateChange((Object)LifeCycleState.CREATE, (Object)this.model);
    }

    public void scapeStarted(ScapeEvent scapeEvent) {
        this.wrapped.stateChange((Object)LifeCycleState.START, (Object)this.model);
    }

    public void scapeStopped(ScapeEvent scapeEvent) {
        this.wrapped.stateChange((Object)LifeCycleState.STOP, (Object)this.model);
    }

    public Scape getScape() {
        return this.scape;
    }

    public boolean isGraphic() {
        return false;
    }

    public boolean isLifeOfScape() {
        return false;
    }

    public String getName() {
        return String.valueOf(this.wrapped.toString()) + " Wrapped";
    }

    public Object clone() {
        ModelWrapperScapeListener clone = (ModelWrapperScapeListener)((Object)super.clone());
        return clone;
    }
}

