/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.MarignPropertyDescriptorProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MarignPropertyDescriptor
extends PropertyDescriptor {
    private static final String ERROR_MESSAGE = Messages.getString((String)"MarignPropertyDescriptor.error.message");
    private static final String ERROR_BOX_TITLE = Messages.getString((String)"MarignPropertyDescriptor.error.title");
    protected CCombo valueCombo;
    protected CCombo unitCombo;
    protected Composite container;
    private String deMesurementValue;
    private String deUnitValue;
    private boolean hasError = false;
    private boolean dirty = false;
    private MarignPropertyDescriptorProvider marignProvider;

    public MarignPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public Control createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        this.container.setLayout((Layout)layout);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarignPropertyDescriptor.this.handleSelectedEvent();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MarignPropertyDescriptor.this.handleSelectedEvent();
            }
        };
        this.valueCombo = new CCombo(this.container, 0x800000);
        this.valueCombo.setVisibleItemCount(30);
        this.valueCombo.addSelectionListener(listener);
        this.valueCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MarignPropertyDescriptor.this.unitCombo.setEnabled(MarignPropertyDescriptor.this.valueCombo.indexOf(MarignPropertyDescriptor.this.valueCombo.getText()) == -1);
                if (MarignPropertyDescriptor.this.unitCombo.isEnabled() && MarignPropertyDescriptor.this.unitCombo.getItemCount() > 0 && (MarignPropertyDescriptor.this.unitCombo.getText() == null || MarignPropertyDescriptor.this.unitCombo.getText().length() == 0) && MarignPropertyDescriptor.this.marignProvider != null) {
                    String unit = MarignPropertyDescriptor.this.marignProvider.getDefaultUnit();
                    if (unit != null) {
                        MarignPropertyDescriptor.this.unitCombo.setText(unit);
                    } else {
                        MarignPropertyDescriptor.this.unitCombo.setText(MarignPropertyDescriptor.this.unitCombo.getItem(0));
                    }
                }
                MarignPropertyDescriptor.this.dirty = true;
            }
        });
        this.valueCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                MarignPropertyDescriptor.this.dirty = false;
            }

            public void focusLost(FocusEvent e) {
                if (!MarignPropertyDescriptor.this.hasError && MarignPropertyDescriptor.this.dirty) {
                    MarignPropertyDescriptor.this.handleSelectedEvent();
                }
            }
        });
        this.unitCombo = new CCombo(this.container, 0x800008);
        this.unitCombo.addSelectionListener(listener);
        GridData data = new GridData();
        data.widthHint = (int)((double)this.unitCombo.computeSize((int)-1, (int)-1).x * 1.5);
        int n = data.widthHint = data.widthHint < 126 ? 126 : data.widthHint;
        if (this.valueCombo.computeSize((int)-1, (int)-1).y < this.unitCombo.computeSize((int)-1, (int)-1).y) {
            data.heightHint = this.unitCombo.computeSize((int)-1, (int)-1).y - 2;
        }
        this.valueCombo.setLayoutData((Object)data);
        this.unitCombo.setVisibleItemCount(30);
        data = new GridData(768);
        this.unitCombo.setLayoutData((Object)data);
        return this.container;
    }

    protected boolean validateDimensionValue() {
        if (this.unitCombo.isEnabled() && this.unitCombo.getSelectionIndex() != -1 && this.getDescriptorProvider() instanceof MarignPropertyDescriptorProvider) {
            return ((MarignPropertyDescriptorProvider)this.getDescriptorProvider()).validateDimensionValue(this.valueCombo.getText(), this.unitCombo.getText());
        }
        return true;
    }

    protected void handleSelectedEvent() {
        if (!this.validateDimensionValue()) {
            this.setError();
            ExceptionUtil.openError((String)ERROR_BOX_TITLE, (String)ERROR_MESSAGE);
            this.load();
            this.clearError();
            return;
        }
        String value = this.valueCombo.getText();
        if (value.equals("")) {
            value = null;
        } else if (this.marignProvider != null) {
            String valueName = this.marignProvider.getValueDisplayName(value);
            value = valueName == null ? String.valueOf(value) + this.marignProvider.getUnitDisplayName(this.unitCombo.getText()) : valueName;
        }
        try {
            this.save(value);
        }
        catch (SemanticException e) {
            this.valueCombo.setText(this.deMesurementValue);
            this.unitCombo.setText(this.deUnitValue);
            WidgetUtil.processError(this.unitCombo.getShell(), (Exception)((Object)e));
        }
        this.dirty = false;
    }

    public Control getControl() {
        return this.container;
    }

    public void load() {
        if (this.marignProvider != null) {
            boolean stateFlag;
            String value;
            this.deMesurementValue = value = this.marignProvider.load().toString();
            if (value == null) {
                this.valueCombo.deselectAll();
                this.valueCombo.setEnabled(false);
                this.unitCombo.deselectAll();
                this.unitCombo.setEnabled(false);
                return;
            }
            boolean bl = stateFlag = value == null == this.valueCombo.getEnabled();
            if (stateFlag) {
                this.valueCombo.setEnabled(value != null);
                this.unitCombo.setEnabled(value != null);
            }
            this.valueCombo.setItems(this.marignProvider.getValueItems());
            this.unitCombo.setItems(this.marignProvider.getUnitItems());
            String valueName = this.marignProvider.getValueName(value);
            if (valueName != null) {
                this.valueCombo.setText(valueName);
                this.deMesurementValue = valueName;
                this.unitCombo.deselectAll();
                this.unitCombo.setEnabled(false);
                return;
            }
            try {
                this.deUnitValue = this.marignProvider.getUnit();
            }
            catch (Exception e) {
                ExceptionUtil.handle((Throwable)e);
            }
            String unitName = this.marignProvider.getUnitName(this.deUnitValue);
            if (unitName != null) {
                this.unitCombo.setText(unitName);
                this.deUnitValue = unitName;
            }
            this.deMesurementValue = this.marignProvider.getMeasureValue();
            this.valueCombo.setText(this.deMesurementValue);
        }
    }

    private void setError() {
        this.hasError = true;
    }

    private void clearError() {
        this.hasError = false;
    }

    public void save(Object obj) throws SemanticException {
        this.getDescriptorProvider().save(obj);
    }

    public void setDescriptorProvider(IDescriptorProvider provider) {
        super.setDescriptorProvider(provider);
        if (provider instanceof MarignPropertyDescriptorProvider) {
            this.marignProvider = (MarignPropertyDescriptorProvider)provider;
        }
    }

    public void setHidden(boolean isHidden) {
        if (this.container != null) {
            WidgetUtil.setExcludeGridData((Control)this.container, isHidden);
        }
    }

    public void setVisible(boolean isVisible) {
        if (this.container != null) {
            this.container.setVisible(isVisible);
        }
    }

    public void setInput(Object handle) {
        this.input = handle;
        this.getDescriptorProvider().setInput(this.input);
    }
}

