/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.script;

import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.script.JSCompletionProcessor;
import org.eclipse.birt.report.designer.internal.ui.script.JSScanner;
import org.eclipse.birt.report.designer.internal.ui.script.JSSyntaxContext;
import org.eclipse.birt.report.designer.internal.ui.script.NonRuleBasedDamagerRepairer;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class JSSourceViewerConfiguration
extends SourceViewerConfiguration {
    private RuleBasedScanner scanner;
    protected JSSyntaxContext context;
    private IPreferenceStore preferenceStore;
    private Color foregroundColor;

    public JSSourceViewerConfiguration() {
        this(new JSSyntaxContext(), (IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.ui.editors"));
    }

    public JSSourceViewerConfiguration(IPreferenceStore preferenceStore) {
        this(new JSSyntaxContext(), preferenceStore);
    }

    public JSSourceViewerConfiguration(JSSyntaxContext context) {
        this(context, (IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.ui.editors"));
    }

    public JSSourceViewerConfiguration(JSSyntaxContext context, IPreferenceStore preferenceStore) {
        this.context = context;
        this.preferenceStore = preferenceStore;
    }

    public static Color getColorByCategory(String categoryColor) {
        return JSSourceViewerConfiguration.getRgbString(categoryColor);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__js_comment", "__js_keyword", "__js_string"};
    }

    protected RuleBasedScanner getDefaultScanner() {
        if (this.scanner == null) {
            this.scanner = new JSScanner();
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.getForegroundColor(this.preferenceStore))));
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getDefaultScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        NonRuleBasedDamagerRepairer commentRepairer = new NonRuleBasedDamagerRepairer(new TextAttribute(JSSourceViewerConfiguration.getColorByCategory("commentColor")));
        reconciler.setDamager((IPresentationDamager)commentRepairer, "__js_comment");
        reconciler.setRepairer((IPresentationRepairer)commentRepairer, "__js_comment");
        NonRuleBasedDamagerRepairer stringRepairer = new NonRuleBasedDamagerRepairer(new TextAttribute(JSSourceViewerConfiguration.getColorByCategory("stringColor")));
        reconciler.setDamager((IPresentationDamager)stringRepairer, "__js_string");
        reconciler.setRepairer((IPresentationRepairer)stringRepairer, "__js_string");
        NonRuleBasedDamagerRepairer keywordRepairer = new NonRuleBasedDamagerRepairer(new TextAttribute(JSSourceViewerConfiguration.getColorByCategory("keywordColor"), null, 1));
        reconciler.setDamager((IPresentationDamager)keywordRepairer, "__js_keyword");
        reconciler.setRepairer((IPresentationRepairer)keywordRepairer, "__js_keyword");
        return reconciler;
    }

    private static Color getRgbString(String name) {
        if ("commentColor".equals(name)) {
            return ReportColorConstants.JSCOMMENTCOLOR;
        }
        if ("stringColor".equals(name)) {
            return ReportColorConstants.JSSTRINGCOLOR;
        }
        if ("keywordColor".equals(name)) {
            return ReportColorConstants.JSKEYWORDCOLOR;
        }
        if ("linenumberColor".equals(name)) {
            return ReportColorConstants.JSLINENUMBERCOLOR;
        }
        return ReportColorConstants.ReportForeground;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)new JSCompletionProcessor(this.context), "__dftl_partition_content_type");
        assistant.enableAutoActivation(true);
        assistant.setAutoActivationDelay(500);
        assistant.setProposalPopupOrientation(10);
        return assistant;
    }

    public void resetScannerColoer() {
        if (this.scanner != null && this.preferenceStore != null) {
            this.scanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.getForegroundColor(this.preferenceStore))));
        }
    }

    private Color getForegroundColor(IPreferenceStore preferenceStore) {
        Color color;
        Color color2 = color = preferenceStore.getBoolean("AbstractTextEditor.Color.Foreground.SystemDefault") ? null : this.createColor(preferenceStore, "AbstractTextEditor.Color.Foreground", Display.getCurrent());
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
        this.foregroundColor = color;
        return color;
    }

    private Color createColor(IPreferenceStore store, String key, Display display) {
        RGB rgb = null;
        if (store.contains(key) && (rgb = store.isDefault(key) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)key) : PreferenceConverter.getColor((IPreferenceStore)store, (String)key)) != null) {
            return new Color((Device)display, rgb);
        }
        return null;
    }

    public void dispose() {
        if (this.foregroundColor != null) {
            this.foregroundColor.dispose();
        }
    }
}

