/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document;

import java.io.IOException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.internal.document.ReportExecutorWrapper;
import org.eclipse.birt.report.engine.internal.document.v3.ReportletExecutorV3;
import org.eclipse.birt.report.engine.internal.document.v4.ReportletExecutorV4;

public class ReportletExecutor
extends ReportExecutorWrapper {
    public ReportletExecutor(ExecutionContext context, long offset) throws BirtException {
        try {
            int version = ReportletExecutor.getVersion(context.getReportDocument());
            switch (version) {
                case 3: {
                    this.executor = new ReportletExecutorV3(context, offset);
                    break;
                }
                case 4: {
                    this.executor = new ReportletExecutorV4(context, offset);
                    break;
                }
                default: {
                    throw new EngineException("Error.UnsupportedDocumentVersionError", version);
                }
            }
        }
        catch (IOException ex) {
            throw new EngineException(ex.getLocalizedMessage(), ex);
        }
    }
}

