/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.css.StyleSheetException;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSessionImpl;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.ModuleImpl;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.namespace.ModuleNameHelper;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.css.CssStyleSheet;
import org.eclipse.birt.report.model.css.StyleSheetLoader;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.elements.TranslationTable;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.ReferenceValue;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.LibraryReader;
import org.eclipse.birt.report.model.util.LibraryUtil;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LayoutModule
extends Module {
    protected TranslationTable translations = new TranslationTable();
    private HashMap<String, IElementPropertyDefn> referencableProperties = null;
    protected String units = null;
    private List<Library> libraries = null;
    private ElementRefValue theme = null;
    protected Exception fatalException;
    private static Logger logger = Logger.getLogger(LayoutModule.class.getName());

    protected LayoutModule(DesignSessionImpl theSession) {
        super(theSession);
        this.nameHelper = new ModuleNameHelper(this);
    }

    @Override
    public StyleElement findNativeStyle(String name) {
        return (StyleElement)this.nameHelper.getNameSpace(0).getElement(name);
    }

    @Override
    public StyleElement findStyle(String name) {
        return (StyleElement)this.resolveElement(null, name, null, MetaDataDictionary.getInstance().getElement("Style"));
    }

    @Override
    public DesignElement findElement(String name) {
        return this.resolveNativeElement(name, 1);
    }

    @Override
    public DesignElement findPage(String name) {
        return this.resolveNativeElement(name, 5);
    }

    @Override
    protected TranslationTable getTranslationTable() {
        return this.translations;
    }

    @Override
    public void addTranslation(Translation translation) {
        this.translations.add(translation);
    }

    @Override
    public boolean dropTranslation(Translation translation) {
        return this.translations.remove(translation);
    }

    @Override
    public Translation findTranslation(String resourceKey, String locale) {
        return this.translations.findTranslation(resourceKey, locale);
    }

    @Override
    public boolean contains(Translation trans) {
        return this.translations.contains(trans);
    }

    @Override
    public List<Translation> getTranslations() {
        return this.translations.getTranslations();
    }

    @Override
    public List<Translation> getTranslations(String resourceKey) {
        return this.translations.getTranslations(resourceKey);
    }

    @Override
    public String[] getTranslationResourceKeys() {
        return this.translations.getResourceKeys();
    }

    @Override
    public ElementPropertyDefn getReferencablePropertyDefn(String structureName) {
        if (this.referencableProperties == null) {
            this.referencableProperties = new HashMap();
            this.referencableProperties.put("ConfigVar", this.getPropertyDefn("configVars"));
            this.referencableProperties.put("EmbeddedImage", this.getPropertyDefn("images"));
            this.referencableProperties.put("CustomColor", this.getPropertyDefn("colorPalette"));
        }
        return (ElementPropertyDefn)this.referencableProperties.get(structureName);
    }

    @Override
    public void semanticCheck(Module module) {
        super.semanticCheck(module);
        if (module instanceof ReportDesign) {
            ContainerSlot slot = module.getSlot(8);
            assert (slot != null);
            int i = slot.getCount() - 1;
            while (i >= 0) {
                TemplateParameterDefinition templateParam = (TemplateParameterDefinition)slot.getContent(i);
                if (templateParam.getClientList().isEmpty()) {
                    NameSpace ns = this.nameHelper.getNameSpace(7);
                    ns.remove(templateParam);
                    module.manageId(templateParam, false);
                    module.remove(templateParam, 8);
                }
                --i;
            }
        }
        this.nameHelper.clear();
    }

    @Override
    public Library loadLibrary(String libraryFileName, String namespace, Map<String, Library> reloadLibs, URL url) throws DesignFileException {
        namespace = StringUtil.trimString(namespace);
        LayoutModule outermostModule = (LayoutModule)this.findOutermostModule();
        Library library = null;
        List<Library> libs = outermostModule.getLibrariesWithNamespace(namespace, Integer.MAX_VALUE);
        if (!libs.isEmpty()) {
            library = libs.get(0);
        }
        if (library != null && reloadLibs.get(library.getNamespace()) != null) {
            return library.contextClone(this);
        }
        if (url == null) {
            DesignParserException ex = new DesignParserException(new String[]{libraryFileName}, "Error.DesignParserException.FILE_NOT_FOUND");
            ArrayList<DesignParserException> exceptionList = new ArrayList<DesignParserException>();
            exceptionList.add(ex);
            throw new DesignFileException(libraryFileName, exceptionList);
        }
        try {
            ModuleOption option = new ModuleOption();
            if (this.options != null && this.options.getOptions().size() > 0) {
                option.setOptions(this.options.getOptions());
            }
            option.setMarkLineNumber(false);
            library = LibraryReader.getInstance().read(this.session, this, url, namespace, url.openStream(), option, reloadLibs);
            library.setLocation(url);
            if (StringUtil.isBlank(namespace)) {
                library.setNamespace(StringUtil.extractFileName(libraryFileName));
            }
            return library;
        }
        catch (IOException iOException) {
            DesignParserException ex = new DesignParserException(new String[]{libraryFileName}, "Error.DesignParserException.FILE_NOT_FOUND");
            ArrayList<DesignParserException> exceptionList = new ArrayList<DesignParserException>();
            exceptionList.add(ex);
            throw new DesignFileException(libraryFileName, exceptionList);
        }
    }

    private List<Library> getLibrariesWithNamespace(String namespace, int level) {
        if (this.libraries == null) {
            return Collections.emptyList();
        }
        List<Library> list = this.getLibraries(level);
        ArrayList<Library> retList = new ArrayList<Library>();
        for (Library library : list) {
            if (!library.getNamespace().equals(namespace)) continue;
            retList.add(library);
        }
        return retList;
    }

    @Override
    public void loadLibrarySilently(IncludedLibrary includeLibrary, Library foundLib, Map<String, Library> reloadLibs, URL url) {
        if (foundLib != null && reloadLibs.get(includeLibrary.getNamespace()) != null) {
            Library cloned = foundLib.contextClone(this);
            this.addLibrary(cloned);
            return;
        }
        Library library = null;
        try {
            library = this.loadLibrary(includeLibrary.getFileName(), includeLibrary.getNamespace(), reloadLibs, url);
            library.setReadOnly();
        }
        catch (DesignFileException e) {
            logger.log(Level.WARNING, e.getMessage(), (Throwable)((Object)e));
            Exception fatalException = ModelUtil.getFirstFatalException(e.getExceptionList());
            library = new Library(this.session, this);
            library.setFatalException(fatalException);
            library.setFileName(includeLibrary.getFileName());
            library.setNamespace(includeLibrary.getNamespace());
            library.setID(library.getNextID());
            library.addElementID(library);
            library.setValid(false);
            library.setAllExceptions(e.getExceptionList());
        }
        this.addLibrary(library);
        LibraryUtil.insertReloadLibs(reloadLibs, library);
    }

    @Override
    public List<Library> getLibraries(int level) {
        if (level <= 0 || this.libraries == null) {
            return Collections.emptyList();
        }
        int newLevel = level - 1;
        if (newLevel == 0) {
            return Collections.unmodifiableList(this.libraries);
        }
        ArrayList<Library> allLibraries = new ArrayList<Library>();
        allLibraries.addAll(this.libraries);
        int i = 0;
        while (i < this.libraries.size()) {
            Library library = this.libraries.get(i);
            allLibraries.addAll(library.getLibraries(newLevel));
            ++i;
        }
        return allLibraries;
    }

    @Override
    public void insertLibrary(Library library, int posn) {
        if (this.libraries == null) {
            this.libraries = new ArrayList<Library>();
        }
        assert (posn >= 0 && posn <= this.libraries.size());
        this.libraries.add(posn, library);
    }

    @Override
    public void addLibrary(Library library) {
        if (this.libraries == null) {
            this.libraries = new ArrayList<Library>();
        }
        this.libraries.add(library);
    }

    @Override
    public int dropLibrary(Library library) {
        assert (this.libraries != null);
        assert (this.libraries.contains(library));
        int posn = this.libraries.indexOf(library);
        this.libraries.remove(library);
        return posn;
    }

    @Override
    public Library getLibraryWithNamespace(String namespace, int level) {
        if (this.libraries == null) {
            return null;
        }
        List<Library> list = this.getLibraries(level);
        for (Library library : list) {
            if (!library.getNamespace().equals(namespace)) continue;
            return library;
        }
        return null;
    }

    @Override
    public List<IncludedLibrary> getIncludedLibraries() {
        List libs = (List)this.getLocalProperty((Module)this, "libraries");
        if (libs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(libs);
    }

    @Override
    public String getUnits() {
        if (!StringUtil.isBlank(this.units)) {
            return this.units;
        }
        String tempUnits = (String)this.getPropertyDefn("units").getDefault();
        if (!StringUtil.isBlank(tempUnits)) {
            return tempUnits;
        }
        return this.getSession().getUnits();
    }

    @Override
    protected Object getIntrinsicProperty(String propName) {
        if ("units".equals(propName)) {
            return this.units;
        }
        if ("theme".equals(propName)) {
            return this.theme;
        }
        return super.getIntrinsicProperty(propName);
    }

    @Override
    protected void setIntrinsicProperty(String propName, Object value) {
        if ("units".equals(propName)) {
            this.units = (String)value;
        } else if ("theme".equals(propName)) {
            ReferenceValueUtil.updateReference(this, this.theme, (ReferenceValue)value, this.getPropertyDefn("theme"));
            this.theme = (ElementRefValue)value;
        } else {
            super.setIntrinsicProperty(propName, value);
        }
    }

    @Override
    public Exception getFatalException() {
        return this.fatalException;
    }

    @Override
    protected void setFatalException(Exception fatalException) {
        this.fatalException = fatalException;
    }

    @Override
    public Theme getTheme() {
        if (this.theme == null) {
            return null;
        }
        return (Theme)this.theme.getElement();
    }

    @Override
    public String getThemeName() {
        if (this.theme == null) {
            return null;
        }
        return this.theme.getName();
    }

    @Override
    public Theme getTheme(Module module) {
        DesignElement focus;
        if (this.theme == null) {
            return null;
        }
        if (this.theme.isResolved()) {
            return (Theme)this.theme.getElement();
        }
        ElementRefValue refValue = this.nameHelper.resolve(null, ReferenceValueUtil.needTheNamespacePrefix(this.theme, this), null, MetaDataDictionary.getInstance().getElement("Theme"));
        Theme target = null;
        if (refValue.isResolved() && (focus = refValue.getElement()) instanceof Theme) {
            target = (Theme)focus;
            this.theme.resolve(target);
            target.addClient(this, "theme");
        }
        return target;
    }

    @Override
    public Library getLibraryByLocation(String theLocation, int level) {
        if (StringUtil.isBlank(theLocation)) {
            return null;
        }
        List<Library> libraries = this.getLibraries(level);
        int i = 0;
        while (i < libraries.size()) {
            Library library = libraries.get(i);
            if (theLocation.equalsIgnoreCase(library.getLocation())) {
                return library;
            }
            if (this.isSameFile(theLocation, library)) {
                return library;
            }
            ++i;
        }
        return null;
    }

    private boolean isSameFile(String theLocation, Library library) {
        URL url_2;
        URL url_1;
        block8: {
            block7: {
                assert (theLocation != null);
                assert (library != null);
                url_1 = null;
                url_1 = new URL(theLocation);
                if ("file".equalsIgnoreCase(url_1.getProtocol())) break block7;
                return false;
            }
            url_2 = new URL(library.getLocation());
            if ("file".equalsIgnoreCase(url_2.getProtocol())) break block8;
            return false;
        }
        try {
            String file_name_1 = url_1.getFile();
            File file_1 = new File(file_name_1);
            String logicalPath_1 = file_1.getCanonicalPath();
            String file_name_2 = url_2.getFile();
            File file_2 = new File(file_name_2);
            String logicalPath_2 = file_2.getCanonicalPath();
            return logicalPath_1 != null && logicalPath_1.equals(logicalPath_2);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public TemplateParameterDefinition findTemplateParameterDefinition(String name) {
        return (TemplateParameterDefinition)this.resolveNativeElement(name, 7);
    }

    @Override
    public boolean isDuplicateNamespace(String namespaceToCheck) {
        LayoutModule rootHost = this;
        while (rootHost instanceof Library && ((Library)rootHost).getHost() != null) {
            rootHost = ((Library)rootHost).getHost();
        }
        List<Library> libraries = ((ModuleImpl)rootHost).getLibraries(Integer.MAX_VALUE);
        for (Library library : libraries) {
            if (!library.getNamespace().equals(namespaceToCheck)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void rename(EmbeddedImage image) {
        if (image == null) {
            return;
        }
        if (StringUtil.isBlank(image.getName())) {
            return;
        }
        List<Object> images = this.getListProperty(this, "images");
        if (images == null) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < images.size()) {
            EmbeddedImage theImage = (EmbeddedImage)images.get(i);
            String name = theImage.getName();
            assert (!names.contains(name));
            names.add(name);
            ++i;
        }
        if (!names.contains(image.getName())) {
            return;
        }
        int index = 0;
        String name = image.getName();
        String baseName = image.getName();
        while (names.contains(name)) {
            name = String.valueOf(baseName) + ++index;
        }
        image.setName(name.trim());
    }

    @Override
    public CssStyleSheet loadCss(String fileName) throws StyleSheetException {
        StyleSheetLoader loader = new StyleSheetLoader();
        CssStyleSheet sheet = loader.load((Module)this, fileName);
        List<CssStyle> styles = sheet.getStyles();
        int i = 0;
        while (styles != null && i < styles.size()) {
            CssStyle style = styles.get(i);
            style.setCssStyleSheet(sheet);
            ++i;
        }
        return sheet;
    }

    @Override
    public CssStyleSheet loadCss(DesignElement container, URL url, String fileName) throws StyleSheetException {
        StyleSheetLoader loader = new StyleSheetLoader();
        CssStyleSheet sheet = loader.load(this, url, fileName);
        sheet.setContainer(container);
        List<CssStyle> styles = sheet.getStyles();
        int i = 0;
        while (styles != null && i < styles.size()) {
            CssStyle style = styles.get(i);
            style.setCssStyleSheet(sheet);
            ++i;
        }
        return sheet;
    }

    @Override
    public void cacheValues() {
        super.cacheValues();
        List<Library> libs = this.getAllLibraries();
        int i = 0;
        while (i < libs.size()) {
            Library lib = libs.get(i);
            lib.nameHelper.cacheValues();
            ++i;
        }
    }

    @Override
    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        LayoutModule module = (LayoutModule)super.doClone(policy);
        module.fatalException = null;
        module.referencableProperties = null;
        module.translations = (TranslationTable)this.translations.clone();
        module.theme = this.theme != null ? new ElementRefValue(this.theme.getLibraryNamespace(), this.theme.getName()) : null;
        if (this.libraries != null) {
            module.libraries = new ArrayList<Library>();
            int i = 0;
            while (i < this.libraries.size()) {
                Library lib = (Library)this.libraries.get(i).doClone(policy);
                lib.setHost(module);
                module.libraries.add(lib);
                ++i;
            }
        } else {
            module.libraries = null;
        }
        module.semanticCheck(module);
        return module;
    }
}

