/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import org.eclipse.bpel.common.ui.details.ButtonIValue;
import org.eclipse.bpel.common.ui.details.IValue;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.Assign;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Copy;
import org.eclipse.bpel.model.From;
import org.eclipse.bpel.model.To;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.AddCopyCommand;
import org.eclipse.bpel.ui.commands.RemoveCopyCommand;
import org.eclipse.bpel.ui.commands.SwapCopyCommand;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.properties.CategorySection;
import org.eclipse.bpel.ui.properties.EditController;
import org.eclipse.bpel.ui.properties.EndpointReferenceAssignCategory;
import org.eclipse.bpel.ui.properties.ExpressionAssignCategory;
import org.eclipse.bpel.ui.properties.IAssignCategory;
import org.eclipse.bpel.ui.properties.LiteralAssignCategory;
import org.eclipse.bpel.ui.properties.OpaqueAssignCategory;
import org.eclipse.bpel.ui.properties.PartnerRoleAssignCategory;
import org.eclipse.bpel.ui.properties.VariableInitializationSection;
import org.eclipse.bpel.ui.properties.VariablePartAssignCategory;
import org.eclipse.bpel.ui.properties.VariablePropertyAssignCategory;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class AssignImplSection
extends BPELPropertySection {
    static String CURRENT_INDEX_PROPERTY = "currentIndex";
    CategorySection fToSection = new CategorySection(this);
    CategorySection fFromSection = new CategorySection(this);
    Copy fCurrentCopy;
    List fCopyList;
    Composite copySelectComposite;
    protected ListViewer fCopyListViewer;
    Button fDeleteCopy;
    Button fMoveUp;
    Button fMoveDown;
    Button fKeepSrcElement;
    Button fIgnoreMissingSourceData;
    EditController fKeepSrcElementController;
    EditController fIgnoreMissingSourceDataController;

    public AssignImplSection() {
        this.fToSection.fAllowed = new IAssignCategory[]{new VariablePartAssignCategory(this), new ExpressionAssignCategory(this), new VariablePropertyAssignCategory(this), new PartnerRoleAssignCategory(this, false)};
        this.fFromSection.fAllowed = new IAssignCategory[]{new VariablePartAssignCategory(this), new ExpressionAssignCategory(this), new LiteralAssignCategory(this), new VariablePropertyAssignCategory(this), new PartnerRoleAssignCategory(this, true), new EndpointReferenceAssignCategory(this), new OpaqueAssignCategory(this)};
    }

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                AssignImplSection.this.adjustCopyRulesList();
                if (n.getFeature() == BPELPackage.eINSTANCE.getAssign_Copy()) {
                    Copy copy = (Copy)n.getNewValue();
                    Assign assign = (Assign)AssignImplSection.this.getModel();
                    if (copy != null) {
                        AssignImplSection.this.selectCopyInList(assign.getCopy().indexOf((Object)copy));
                    }
                }
            }
        }};
    }

    @Override
    protected void addAllAdapters() {
        super.addAllAdapters();
        EList list = ((Assign)this.getInput()).getCopy();
        for (Copy copy : list) {
            this.fAdapters[0].addToObject((Notifier)copy);
            if (copy.getFrom() != null) {
                this.fAdapters[0].addToObject((Notifier)copy.getFrom());
            }
            if (copy.getTo() == null) continue;
            this.fAdapters[0].addToObject((Notifier)copy.getTo());
        }
    }

    protected void createCopySelectWidgets(Composite parent) {
        Composite c = this.copySelectComposite = this.createFlatFormComposite(parent);
        Button insertCopy = this.fWidgetFactory.createButton(c, Messages.AssignImplDetails_New__5, 8);
        this.fDeleteCopy = this.fWidgetFactory.createButton(c, Messages.AssignImplDetails_Delete__6, 8);
        this.fMoveUp = this.fWidgetFactory.createButton(c, "Move Up", 8);
        this.fMoveDown = this.fWidgetFactory.createButton(c, "Move Down", 8);
        this.fCopyList = this.fWidgetFactory.createList(c, 2564);
        int preferredWidth = 200;
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(0, preferredWidth);
        data.top = new FlatFormAttachment(0, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        c.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment(0, 0);
        data.bottom = new FlatFormAttachment((Control)insertCopy, -4);
        this.fCopyList.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(50, 0);
        data.bottom = new FlatFormAttachment((Control)this.fMoveUp, 0);
        insertCopy.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)insertCopy, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.bottom = new FlatFormAttachment((Control)this.fMoveDown, 0);
        this.fDeleteCopy.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(50, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        this.fMoveUp.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)this.fMoveUp, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        this.fMoveDown.setLayoutData((Object)data);
        insertCopy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Copy copy = BPELFactory.eINSTANCE.createCopy();
                AssignImplSection.this.getCommandFramework().execute(AssignImplSection.this.wrapInShowContextCommand((Command)new AddCopyCommand((Assign)AssignImplSection.this.getInput(), copy)));
                AssignImplSection.this.refreshAdapters();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fDeleteCopy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Assign assign = (Assign)AssignImplSection.this.getModel();
                int index = AssignImplSection.this.fCopyList.getSelectionIndex();
                index = index == assign.getCopy().size() - 1 ? index - 1 : index;
                AssignImplSection.this.getCommandFramework().execute(AssignImplSection.this.wrapInShowContextCommand((Command)new RemoveCopyCommand((Assign)AssignImplSection.this.getInput(), AssignImplSection.this.fCurrentCopy)));
                AssignImplSection.this.selectCopyInList(index);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fCopyList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = AssignImplSection.this.fCopyList.getSelectionIndex();
                AssignImplSection.this.selectCopyInList(index);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fMoveUp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Assign assign = (Assign)AssignImplSection.this.getModel();
                int index = AssignImplSection.this.fCopyList.getSelectionIndex();
                AssignImplSection.this.getCommandFramework().execute(AssignImplSection.this.wrapInShowContextCommand((Command)new SwapCopyCommand(assign, index, index - 1)));
                AssignImplSection.this.selectCopyInList(index - 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fMoveDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Assign assign = (Assign)AssignImplSection.this.getModel();
                int index = AssignImplSection.this.fCopyList.getSelectionIndex();
                AssignImplSection.this.getCommandFramework().execute(AssignImplSection.this.wrapInShowContextCommand((Command)new SwapCopyCommand(assign, index, index + 1)));
                AssignImplSection.this.selectCopyInList(index + 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void createCategorySectionWidgets(Composite composite, final CategorySection section, boolean isFrom) {
        section.fLabel = this.fWidgetFactory.createLabel(composite, isFrom ? Messages.AssignImplDetails_From__1 : Messages.AssignImplDetails_To__2);
        section.fCombo = new Combo(composite, 0x800808);
        FlatFormData data = new FlatFormData();
        if (isFrom) {
            data.left = new FlatFormAttachment(0, BPELUtil.calculateLabelWidth((Widget)section.fLabel, 105));
            data.right = new FlatFormAttachment(50, -10);
        } else {
            data.left = new FlatFormAttachment(50, 10 + BPELUtil.calculateLabelWidth((Widget)section.fLabel, 105));
            data.right = new FlatFormAttachment(100, 0);
        }
        data.top = new FlatFormAttachment(0, 0);
        section.fCombo.setLayoutData((Object)data);
        data = new FlatFormData();
        data.left = isFrom ? new FlatFormAttachment(0, 0) : new FlatFormAttachment(50, 10);
        data.right = new FlatFormAttachment((Control)section.fCombo, -10);
        data.top = new FlatFormAttachment((Control)section.fCombo, 0, 0x1000000);
        section.fLabel.setLayoutData((Object)data);
        IAssignCategory[] iAssignCategoryArray = section.fAllowed;
        int n = section.fAllowed.length;
        int n2 = 0;
        while (n2 < n) {
            IAssignCategory category = iAssignCategoryArray[n2];
            if (category.getName() != null) {
                section.fCombo.add(category.getName());
            }
            ++n2;
        }
        section.fCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = section.fCombo.getSelectionIndex();
                AssignImplSection.this.updateCategorySelection(section, index, true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        section.fOuterComposite = this.createFlatFormComposite(composite);
        data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)section.fLabel, 0, 16384);
        data.right = new FlatFormAttachment((Control)section.fCombo, 0, 131072);
        data.top = new FlatFormAttachment((Control)section.fCombo, 4);
        data.bottom = new FlatFormAttachment(100, -25);
        section.fOuterComposite.setLayoutData((Object)data);
        if (isFrom) {
            this.fIgnoreMissingSourceData = this.fWidgetFactory.createButton(composite, Messages.AssignImplDetails_IgnoreMissingSourceData, 32);
            data = new FlatFormData();
            data.right = new FlatFormAttachment(50, -5);
            data.bottom = new FlatFormAttachment(100, 0);
            this.fIgnoreMissingSourceData.setLayoutData((Object)data);
            this.fIgnoreMissingSourceDataController = this.createEditController();
            this.fIgnoreMissingSourceDataController.setFeature((EStructuralFeature)BPELPackage.eINSTANCE.getCopy_IgnoreMissingFromData());
            this.fIgnoreMissingSourceDataController.setViewIValue((IValue)new ButtonIValue(this.fIgnoreMissingSourceData));
            this.fIgnoreMissingSourceDataController.startListeningTo(new Control[]{this.fIgnoreMissingSourceData});
        } else {
            this.fKeepSrcElement = this.fWidgetFactory.createButton(composite, Messages.AssignImplDetails_KeepSrcElementName, 32);
            data = new FlatFormData();
            data.right = new FlatFormAttachment(100, -5);
            data.bottom = new FlatFormAttachment(100, 0);
            this.fKeepSrcElement.setLayoutData((Object)data);
            this.fKeepSrcElementController = this.createEditController();
            this.fKeepSrcElementController.setFeature((EStructuralFeature)BPELPackage.eINSTANCE.getCopy_KeepSrcElementName());
            this.fKeepSrcElementController.setViewIValue((IValue)new ButtonIValue(this.fKeepSrcElement));
            this.fKeepSrcElementController.startListeningTo(new Control[]{this.fKeepSrcElement});
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        this.createCopySelectWidgets(composite);
        Composite mainComposite = this.createFlatFormComposite(composite);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment((Control)this.copySelectComposite, 5);
        data.top = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.bottom = new FlatFormAttachment(100, 0);
        mainComposite.setLayoutData((Object)data);
        this.createCategorySectionWidgets(mainComposite, this.fFromSection, true);
        this.createCategorySectionWidgets(mainComposite, this.fToSection, false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.bpel.ui.property_assign");
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        this.saveUserContextToInput();
        super.basicSetInput(newInput);
        this.adjustCopyRulesList();
        this.restoreUserContextFromInput();
        if (this.fToSection.fCurrent != null) {
            this.fToSection.fCurrent.refresh();
        }
        if (this.fFromSection.fCurrent != null) {
            this.fFromSection.fCurrent.refresh();
        }
    }

    protected void selectCategoriesForInput() {
        IAssignCategory category;
        this.fKeepSrcElementController.setInput((EObject)this.fCurrentCopy);
        this.fIgnoreMissingSourceDataController.setInput((EObject)this.fCurrentCopy);
        if (this.fCurrentCopy == null) {
            this.fToSection.hideCurrent();
            this.fFromSection.hideCurrent();
            this.fKeepSrcElement.setEnabled(false);
            this.fIgnoreMissingSourceData.setEnabled(false);
            return;
        }
        this.fKeepSrcElement.setEnabled(true);
        this.fIgnoreMissingSourceData.setEnabled(true);
        boolean bFound = false;
        IAssignCategory[] iAssignCategoryArray = this.fFromSection.fAllowed;
        int n = this.fFromSection.fAllowed.length;
        int n2 = 0;
        while (n2 < n) {
            category = iAssignCategoryArray[n2];
            if (category.isCategoryForModel((EObject)this.fCurrentCopy.getFrom())) {
                this.updateCategorySelection(this.fFromSection, category, false);
                bFound = true;
                break;
            }
            ++n2;
        }
        if (!bFound || this.fFromSection.fCurrent == null) {
            this.updateCategorySelection(this.fFromSection, 0, false);
        }
        bFound = false;
        iAssignCategoryArray = this.fToSection.fAllowed;
        n = this.fToSection.fAllowed.length;
        n2 = 0;
        while (n2 < n) {
            category = iAssignCategoryArray[n2];
            if (category.isCategoryForModel((EObject)this.fCurrentCopy.getTo())) {
                this.updateCategorySelection(this.fToSection, category, false);
                bFound = true;
                break;
            }
            ++n2;
        }
        if (!bFound || this.fToSection.fCurrent == null) {
            this.updateCategorySelection(this.fToSection, 0, false);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    @Override
    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        if (this.fToSection.fCurrent != null) {
            this.fToSection.fCurrent.aboutToBeHidden();
        }
        if (this.fFromSection.fCurrent != null) {
            this.fFromSection.fCurrent.aboutToBeHidden();
        }
    }

    @Override
    public void aboutToBeShown() {
        super.aboutToBeShown();
        if (this.fToSection.fCurrent != null) {
            this.fToSection.fCurrent.aboutToBeShown();
        }
        if (this.fFromSection.fCurrent != null) {
            this.fFromSection.fCurrent.aboutToBeShown();
        }
    }

    protected void adjustCopyRulesList() {
        Assign assign = (Assign)this.getModel();
        EList copyList = assign.getCopy();
        int sz = copyList.size();
        int idx = this.fCopyList.getSelectionIndex();
        String[] items = new String[sz];
        int i = 0;
        while (i < sz) {
            Copy copy = (Copy)copyList.get(i);
            items[i] = String.valueOf(this.asText(copy.getFrom())) + " to " + this.asText(copy.getTo());
            ++i;
        }
        this.fCopyList.setItems(items);
        if (idx != -1) {
            this.fCopyList.setSelection(idx);
        }
        this.fDeleteCopy.setEnabled(sz > 0);
        this.fToSection.fCombo.setEnabled(sz > 0);
        this.fFromSection.fCombo.setEnabled(sz > 0);
    }

    private String asText(From from) {
        IAssignCategory[] iAssignCategoryArray = this.fFromSection.fAllowed;
        int n = this.fFromSection.fAllowed.length;
        int n2 = 0;
        while (n2 < n) {
            IAssignCategory category = iAssignCategoryArray[n2];
            if (category.isCategoryForModel((EObject)from)) {
                return category.getName();
            }
            ++n2;
        }
        return "?";
    }

    private String asText(To to) {
        IAssignCategory[] iAssignCategoryArray = this.fToSection.fAllowed;
        int n = this.fToSection.fAllowed.length;
        int n2 = 0;
        while (n2 < n) {
            IAssignCategory category = iAssignCategoryArray[n2];
            if (category.isCategoryForModel((EObject)to)) {
                return category.getName();
            }
            ++n2;
        }
        return "?";
    }

    void updateCategorySelection(CategorySection section, int index, boolean bVisual) {
        this.updateCategorySelection(section, section.fAllowed[index], bVisual);
    }

    void updateCategorySelection(CategorySection section, IAssignCategory newCurrent, boolean bVisual) {
        section.hideCurrent();
        section.fCurrent = newCurrent;
        section.ensureCategoryCompositeCreated();
        if (!bVisual) {
            section.updateCombo();
        }
        if (section == this.fToSection) {
            if (bVisual || this.fCurrentCopy.getTo() == null) {
                this.fCurrentCopy.setTo(BPELFactory.eINSTANCE.createTo());
            }
            section.fCurrent.setInput((EObject)this.fCurrentCopy.getTo());
        } else {
            if (bVisual || this.fCurrentCopy.getFrom() == null) {
                this.fCurrentCopy.setFrom(BPELFactory.eINSTANCE.createFrom());
            }
            section.fCurrent.setInput((EObject)this.fCurrentCopy.getFrom());
            if (section.fCurrent instanceof LiteralAssignCategory) {
                VariableInitializationSection.createDefaultInitializer(this.getBPELEditor(), this.fCurrentCopy.getFrom(), this.fCurrentCopy.getTo());
            }
        }
        section.showCurrent();
        section.fCurrent.refresh();
        this.refreshAdapters();
    }

    @Override
    public Object getUserContext() {
        Assign assign = (Assign)this.getModel();
        if (assign == null) {
            return -1;
        }
        return assign.getCopy().indexOf((Object)this.fCurrentCopy);
    }

    @Override
    public void restoreUserContext(Object userContext) {
        int idx = 0;
        if (userContext instanceof Number) {
            Number num = (Number)userContext;
            idx = num.intValue();
        }
        this.selectCopyInList(idx);
    }

    @Override
    public void gotoMarker(IMarker marker) {
        this.refresh();
    }

    private void selectCopyInList(int index) {
        EList list = ((Assign)this.getModel()).getCopy();
        if (index < 0 || index >= list.size()) {
            this.fCurrentCopy = null;
            this.fMoveUp.setEnabled(false);
            this.fMoveDown.setEnabled(false);
        } else {
            this.fCurrentCopy = (Copy)list.get(index);
            this.fCopyList.select(index);
            this.fMoveUp.setEnabled(index > 0);
            this.fMoveDown.setEnabled(index < this.fCopyList.getItemCount() - 1);
        }
        this.selectCategoriesForInput();
    }
}

