/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.language.settings.providers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.IErrorParser2;
import org.eclipse.cdt.core.errorparsers.RegexErrorParser;
import org.eclipse.cdt.core.errorparsers.RegexErrorPattern;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.managedbuilder.language.settings.providers.AbstractLanguageSettingsOutputScanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public abstract class AbstractBuildCommandParser
extends AbstractLanguageSettingsOutputScanner {
    public static final Object JOB_FAMILY_BUILD_COMMAND_PARSER = "org.eclipse.cdt.managedbuilder.AbstractBuildCommandParser";
    private static final String ATTR_PARAMETER = "parameter";
    private static final String ATTR_RESOURCE_SCOPE = "resource-scope";
    private static final String VALUE_FILE_SCOPE = "per-file";
    private static final String VALUE_FOLDER_SCOPE = "per-folder";
    private static final String VALUE_PROJECT_SCOPE = "per-project";
    private static final String LEADING_PATH_PATTERN = "\\S+[/\\\\]";
    private static final Pattern OPTIONS_PATTERN = Pattern.compile("-[^\\s\"']*(\\s*((\".*?\")|('.*?')|([^-\\s][^\\s]+)))?");
    private static final int OPTION_GROUP = 0;
    private static final String[] COMPILER_COMMAND_PATTERN_TEMPLATES = new String[]{"${COMPILER_PATTERN}.*\\s()([^'\"\\s]*\\.${EXTENSIONS_PATTERN})(\\s.*)?[\r\n]*", "${COMPILER_PATTERN}.*\\s(['\"])(.*\\.${EXTENSIONS_PATTERN})\\${COMPILER_GROUPS+1}(\\s.*)?[\r\n]*"};
    private static final int FILE_GROUP = 2;
    private ResourceScope resourceScope = null;

    public String getCompilerPattern() {
        return this.getProperty(ATTR_PARAMETER);
    }

    public void setCompilerPattern(String commandPattern) {
        this.setProperty(ATTR_PARAMETER, commandPattern);
    }

    private String getCompilerPatternExtended() {
        String compilerPattern = this.getCompilerPattern();
        return "\\s*\"?(\\S+[/\\\\])?(" + compilerPattern + ")\"?";
    }

    public ResourceScope getResourceScope() {
        if (this.resourceScope == null) {
            String scopeStr = this.getProperty(ATTR_RESOURCE_SCOPE);
            this.resourceScope = scopeStr.equals(VALUE_FILE_SCOPE) ? ResourceScope.FILE : (scopeStr.equals(VALUE_FOLDER_SCOPE) ? ResourceScope.FOLDER : (scopeStr.equals(VALUE_PROJECT_SCOPE) ? ResourceScope.PROJECT : ResourceScope.FILE));
        }
        return this.resourceScope;
    }

    public void setResourceScope(ResourceScope rcScope) {
        this.resourceScope = rcScope;
        switch (rcScope) {
            case FILE: {
                this.setProperty(ATTR_RESOURCE_SCOPE, VALUE_FILE_SCOPE);
                break;
            }
            case FOLDER: {
                this.setProperty(ATTR_RESOURCE_SCOPE, VALUE_FOLDER_SCOPE);
                break;
            }
            case PROJECT: {
                this.setProperty(ATTR_RESOURCE_SCOPE, VALUE_PROJECT_SCOPE);
                break;
            }
            default: {
                this.setProperty(ATTR_RESOURCE_SCOPE, VALUE_FILE_SCOPE);
            }
        }
    }

    @Override
    protected void setSettingEntries(List<ICLanguageSettingEntry> entries) {
        IResource rc = null;
        switch (this.getResourceScope()) {
            case FILE: {
                rc = this.currentResource;
                break;
            }
            case FOLDER: {
                if (!(this.currentResource instanceof IFile)) break;
                rc = this.currentResource.getParent();
                break;
            }
            case PROJECT: {
                if (this.currentResource == null) break;
                rc = this.currentResource.getProject();
                break;
            }
        }
        this.setSettingEntries(this.currentCfgDescription, rc, this.currentLanguageId, entries);
    }

    private int adjustFileGroup() {
        return AbstractBuildCommandParser.countGroups(this.getCompilerPatternExtended()) + 2;
    }

    private String makePattern(String template) {
        String pattern = template.replace("${COMPILER_PATTERN}", this.getCompilerPatternExtended()).replace("${EXTENSIONS_PATTERN}", this.getPatternFileExtensions()).replace("${COMPILER_GROUPS+1}", new Integer(AbstractBuildCommandParser.countGroups(this.getCompilerPatternExtended()) + 1).toString());
        return pattern;
    }

    @Override
    protected String parseResourceName(String line) {
        if (line == null) {
            return null;
        }
        String[] stringArray = COMPILER_COMMAND_PATTERN_TEMPLATES;
        int n = COMPILER_COMMAND_PATTERN_TEMPLATES.length;
        int n2 = 0;
        while (n2 < n) {
            String template = stringArray[n2];
            String pattern = this.makePattern(template);
            Matcher fileMatcher = Pattern.compile(pattern).matcher(line);
            if (fileMatcher.matches()) {
                int fileGroup = this.adjustFileGroup();
                String sourceFileName = fileMatcher.group(fileGroup);
                return sourceFileName;
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected List<String> parseOptions(String line) {
        if (line == null || this.currentResource == null) {
            return null;
        }
        ArrayList<String> options = new ArrayList<String>();
        Matcher optionMatcher = OPTIONS_PATTERN.matcher(line);
        while (optionMatcher.find()) {
            String option = optionMatcher.group(0);
            if (option == null) continue;
            options.add(option);
        }
        return options;
    }

    private void serializeLanguageSettingsInBackground() {
        ILanguageSettingsProvider wspProvider = LanguageSettingsManager.getWorkspaceProvider((String)this.getId());
        ILanguageSettingsProvider rawProvider = LanguageSettingsManager.getRawProvider((ILanguageSettingsProvider)wspProvider);
        if (rawProvider == this) {
            this.serializeLanguageSettingsInBackground(null);
        } else {
            this.serializeLanguageSettingsInBackground(this.currentCfgDescription);
        }
    }

    @Override
    public void shutdown() {
        this.serializeLanguageSettingsInBackground();
        super.shutdown();
    }

    protected static abstract class AbstractBuildCommandPatternHighlighter
    extends RegexErrorParser
    implements IErrorParser2 {
        public AbstractBuildCommandPatternHighlighter(String parserId) {
            this.init(parserId);
        }

        protected void init(String parserId) {
            AbstractBuildCommandParser buildCommandParser = (AbstractBuildCommandParser)LanguageSettingsManager.getExtensionProviderCopy((String)parserId, (boolean)false);
            if (buildCommandParser != null) {
                String[] stringArray = COMPILER_COMMAND_PATTERN_TEMPLATES;
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String template = stringArray[n2];
                    String pattern = buildCommandParser.makePattern(template);
                    String fileExpr = "$" + buildCommandParser.adjustFileGroup();
                    String descExpr = "$0";
                    this.addPattern(new RegexErrorPattern(pattern, fileExpr, null, descExpr, null, 1, true));
                    ++n2;
                }
            }
        }

        public int getProcessLineBehaviour() {
            return 4;
        }
    }

    public static enum ResourceScope {
        FILE,
        FOLDER,
        PROJECT;

    }
}

